@extends(activeTemplate() . 'layouts.app')

@section('app')
    <div class="relative min-h-screen bg-slate-50 dark:bg-slate-950 flex flex-col items-center justify-center p-6 overflow-hidden transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
            <div
                class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-primary-600/10 rounded-full blur-[120px] animate-pulse-glow">
            </div>
        </div>

        <div class="relative z-10 max-w-2xl w-full text-center">
            {{-- Brand Logo --}}
                <x-theme.ui.logo />

            {{-- Maintenance Content --}}
            <div
                class="rounded-3xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-xl p-8 md:p-12 shadow-xl shadow-slate-200/50 dark:shadow-2xl relative overflow-hidden transition-[border-color,background-color,box-shadow] duration-300">
                <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-primary-500 via-primary-500 to-primary-500">
                </div>

                <h1 class="text-3xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-6 tracking-tight leading-tight transition-colors">
                    {{ __(@$maintenance->data_values->heading) }}
                </h1>

                @if(@$maintenance->data_values->image)
                    <div class="relative mb-8 group">
                        <div
                            class="absolute inset-0 bg-primary-500/20 blur-2xl rounded-full scale-0 group-hover:scale-100 transition-transform duration-700">
                        </div>
                        <img src="{{ getImage(getFilePath('maintenance') . '/' . @$maintenance->data_values->image, getFileSize('maintenance')) }}"
                            alt="@lang('Maintenance Image')"
                            width="192" height="192"
                            loading="lazy"
                            class="mx-auto w-48 h-48 object-contain relative transition-transform duration-500 hover:scale-110">
                    </div>
                @endif

                <div class="text-slate-600 dark:text-slate-300 text-lg leading-relaxed mb-8 prose dark:prose-invert prose-primary max-w-none prose-headings:text-slate-900 dark:prose-headings:text-white prose-a:text-primary-600 dark:prose-a:text-primary-400 prose-strong:text-slate-900 dark:prose-strong:text-white transition-colors">
                    @php echo $maintenance->data_values->description @endphp
                </div>

                {{-- Contact Link --}}
                <div class="pt-8 border-t border-slate-200 dark:border-white/10 transition-colors">
                    <p class="text-sm text-slate-500 dark:text-slate-400">
                        @lang('Need immediate assistance?')
                        <a href="mailto:{{ gs('email_from') }}"
                            class="text-primary-600 dark:text-primary-400 font-bold hover:text-primary-500 dark:hover:text-primary-300 transition-colors">@lang('Contact Support')</a>
                    </p>
                </div>
            </div>

            {{-- Social Links --}}
            <div class="mt-8 flex justify-center gap-6">
                @php
                    $socials = getContent('social_icon.element');
                @endphp
                @foreach($socials as $social)
                    <a href="{{ $social->data_values->url }}" target="_blank" rel="noopener noreferrer"
                        class="w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/5 border border-slate-200 dark:border-white/10 flex items-center justify-center text-slate-500 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-white/10 hover:text-primary-600 dark:hover:text-white hover:border-primary-500/30 transition-[background-color,border-color,color]">
                        @php echo $social->data_values->social_icon @endphp
                    </a>
                @endforeach
            </div>
        </div>
    </div>
@endsection