@extends(activeTemplate() . 'layouts.frontend')

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-100 dark:bg-slate-950 min-h-screen transition-colors duration-300">
        {{-- Background --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-30">
            </div>
            <div class="absolute top-1/4 right-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[100px]"></div>
        </div>

        <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h1 class="text-4xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-4 tracking-tight leading-tight transition-colors">{{ __($title ?? $page->title ?? 'Page') }}
                </h1>
            </div>

            <div class="rounded-3xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 backdrop-blur-sm p-8 md:p-12 shadow-xl shadow-slate-200/50 dark:shadow-none transition-[border-color,background-color,box-shadow] duration-300">
                <div
                    class="prose dark:prose-invert prose-slate max-w-none prose-headings:font-bold prose-headings:text-slate-900 dark:prose-headings:text-white prose-p:text-slate-600 dark:prose-p:text-slate-500 dark:text-slate-400 prose-a:text-primary-600 dark:prose-a:text-primary-400 hover:prose-a:text-primary-500 dark:hover:prose-a:text-primary-300 prose-strong:text-slate-900 dark:prose-strong:text-white prose-ul:text-slate-600 dark:prose-ul:text-slate-500 dark:text-slate-400 prose-ol:text-slate-600 dark:prose-ol:text-slate-500 dark:text-slate-400 transition-colors">
                    @if(isset($content))
                        {!! purify($content) !!}
                    @elseif(isset($page->content))
                        {!! purify(__($page->content)) !!}
                    @else
                        <p>@lang('Content not available.')</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection