<div class="relative overflow-hidden bg-slate-100 dark:bg-slate-900 border-b border-slate-200 dark:border-white/5 transition-colors duration-300">
    {{-- Background --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute top-0 right-0 w-64 h-64 bg-primary-600/5 rounded-full blur-3xl"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 relative z-10">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl sm:text-3xl font-extrabold text-slate-900 dark:text-white tracking-tight leading-tight transition-colors">{{ __($pageTitle) }}</h1>
            </div>

            <nav class="flex" aria-label="Breadcrumb">
                <ol role="list" class="flex items-center gap-3">
                    <li>
                        <a href="{{ route('home') }}" class="text-slate-400 dark:text-slate-500 hover:text-primary-600 dark:hover:text-white transition-colors">
                            <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                            </svg>
                        </a>
                    </li>

                    @if (!request()->routeIs('home'))
                        <li class="flex items-center gap-3">
                            <svg class="w-4 h-4 text-slate-300 dark:text-slate-700" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                            </svg>
                            <span class="text-sm font-bold text-primary-600 dark:text-primary-400">{{ __($pageTitle) }}</span>
                        </li>
                    @endif
                </ol>
            </nav>
        </div>
    </div>
</div>