@php
    $footer = getContent('footer.content', true);
    $footerMenu = \App\Models\Menu::getByLocation('frontend_footer');
    // $socialLinks provided by FooterComposer
    $policyPages = getContent('policy_pages.element', orderById:true);
    
    // Fallback social icons if none in DB
    $socialIcons = [
        'facebook' => 'ph-facebook-logo',
        'twitter' => 'ph-x-logo',
        'instagram' => 'ph-instagram-logo',
        'linkedin' => 'ph-linkedin-logo',
        'youtube' => 'ph-youtube-logo',
        'github' => 'ph-github-logo',
        'discord' => 'ph-discord-logo',
        'reddit' => 'ph-reddit-logo'
    ];
@endphp

<footer class="relative pt-40 sm:pt-36 md:pt-32 lg:pt-28 pb-8 overflow-hidden" style="background-color: var(--footer-bg); color: var(--footer-text);" x-data="{ activeAccordion: null }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-12 items-start">
            
            {{-- Column 1: Branding & Info --}}
            <div class="lg:col-span-4 space-y-8">
                <a href="{{ route('home') }}" class="block">
                    {{-- Footer logo - always white/light logo since footer bg is always dark --}}
                    <img src="{{ siteLogo() }}" 
                         alt="{{ gs('site_name') }}" 
                         class="h-20 sm:h-24 w-auto object-contain object-left"
                         loading="lazy"
                         width="200" height="48">
                    <p class="text-[10px] opacity-70 uppercase tracking-widest mt-2 ml-1">@lang('hosting that simply works')</p>
                </a>

                <p class="text-sm opacity-80 leading-relaxed max-w-sm">
                    {{ __($footer?->data_values?->mission_text ?? 'We\'re on a mission to make life easier for web developers and small businesses. We run our services on top-notch technology and offer 24/7 outstanding fast support.') }}
                </p>
                
                {{-- Social Links --}}
                <div class="flex flex-wrap gap-2">
                    @foreach($socialLinks as $social)
                        <a href="{{ $social->url }}" target="_blank" rel="noopener noreferrer" class="w-10 h-10 rounded-full bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors text-xl overflow-hidden" title="{{ $social->name }}">
                            @if(str_starts_with($social->icon, 'http://') || str_starts_with($social->icon, 'https://'))
                                <img src="{{ $social->icon }}" alt="{{ $social->name }}" width="20" height="20" loading="lazy" class="w-5 h-5 object-contain">
                            @else
                                @php
                                    $nameKey = strtolower($social->name);
                                    // Map common social names to Phosphor icons
                                    $iconClass = $socialIcons[$nameKey] ?? null;
                                    
                                    if (!$iconClass) {
                                        // Dynamic mapping for FA to PH if needed
                                        $iconClass = str_replace(['fab fa-', 'fas fa-', 'far fa-'], 'ph-', $social->icon);
                                        // Ensure ph- prefix exists
                                        if(!str_starts_with($iconClass, 'ph-')) {
                                            $iconClass = 'ph-' . $iconClass;
                                        }
                                    }
                                    
                                    // Add boldness to Phosphor icons as per theme
                                    if(str_starts_with($iconClass, 'ph-') && !str_contains($iconClass, 'ph-bold')) {
                                        $iconClass = 'ph-bold ' . $iconClass;
                                    }

                                    // Ensure ph base class is always there
                                    if(str_starts_with($iconClass, 'ph-') && !str_starts_with($iconClass, 'ph ')) {
                                        $iconClass = 'ph ' . $iconClass;
                                    }
                                @endphp
                                <i class="{{ $iconClass }}"></i>
                            @endif
                        </a>
                    @endforeach
                </div>

                {{-- Payment Icons --}}
                @php
                    $paymentMethods = getContent('payment_methods.element', orderById: true);
                @endphp
                @if($paymentMethods && $paymentMethods->count() > 0)
                    <div class="flex flex-wrap gap-3 pt-6">
                        @foreach($paymentMethods as $method)
                            @php
                                $icon = $method->data_values->icon;
                                $iconPath = (str_starts_with($icon, 'http://') || str_starts_with($icon, 'https://')) 
                                            ? $icon 
                                            : getFilePath('payment_methods') . '/' . $icon;
                            @endphp
                            <div class="h-8 w-12 bg-white rounded flex items-center justify-center p-1 shadow-sm" title="{{ $method->data_values->name }}">
                                <img src="{{ getImage($iconPath) }}" alt="{{ $method->data_values->name }}" width="48" height="32" loading="lazy" class="h-full w-auto object-contain">
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Links Grid --}}
            <div class="lg:col-span-8">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-y-6 lg:gap-x-12 lg:gap-y-12 items-start">
                    @if($footerMenu)
                        @foreach($footerMenu->activeItems as $item)
                            <div class="border-b border-white/10 lg:border-none pb-4 lg:pb-0">
                                {{-- Mobile Header (Collapsible) --}}
                                <button 
                                    @click="activeAccordion === {{ $loop->index }} ? activeAccordion = null : activeAccordion = {{ $loop->index }}"
                                    class="flex items-center justify-between w-full lg:hidden py-2"
                                    :aria-expanded="activeAccordion === {{ $loop->index }}"
                                    aria-controls="footer-links-{{ $loop->index }}"
                                >
                                    <h3 class="text-lg font-bold tracking-tight">{{ __($item->label) }}</h3>
                                    <i class="ph ph-bold ph-plus transition-transform duration-300" :class="activeAccordion === {{ $loop->index }} ? 'rotate-45' : ''" aria-hidden="true"></i>
                                </button>

                                {{-- Desktop Header --}}
                                <h3 class="hidden lg:block text-lg font-bold tracking-tight mb-6">
                                    {{ __($item->label) }}
                                </h3>

                                {{-- Link List --}}
                                <ul 
                                    class="space-y-3 overflow-hidden transition-[background-color,border-color,color] duration-300 max-h-0 opacity-0 lg:!max-h-none lg:opacity-100"
                                    :class="activeAccordion === {{ $loop->index }} ? 'max-h-[500px] opacity-100 pt-4' : 'max-h-0 opacity-0 lg:max-h-none'"
                                    id="footer-links-{{ $loop->index }}"
                                    role="list"
                                >
                                    @foreach($item->children as $child)
                                        <li>
                                            <a href="{{ Str::startsWith($child->url, ['http', 'https', '/', '#', 'mailto:', 'tel:']) ? $child->url : '#' }}" class="text-sm opacity-80 hover:opacity-100 transition-opacity flex items-center group">
                                                {{ __($child->label) }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    @endif
                </div>
            </div>
        </div>

        {{-- Bottom Bar --}}
        <div class="mt-12 pt-6 border-t border-white/10 flex flex-col md:flex-row justify-between items-center gap-6">
            <div class="text-sm opacity-60">
                &copy; {{ date('Y') }} {{ __($footer?->data_values?->copyright_text ?? gs('site_name') . ', Inc. All rights reserved.') }}
            </div>
            
            <div class="flex items-center gap-8 text-sm opacity-80">
                @foreach($policyPages as $policy)
                    <a href="{{ route('policy.pages', ['slug' => \Illuminate\Support\Str::slug($policy->data_values->title)]) }}" class="hover:underline transition-[background-color,border-color,color]">
                        {{ __($policy->data_values->title) }}
                    </a>
                @endforeach
            </div>
        </div>
    </div>

    {{-- Chat Bubble (As seen in image) --}}
    @if(!gs('ticket_livechat_enabled'))
        <div class="fixed bottom-6 right-6 z-[var(--z-popover)]">
            <a href="{{ route('client.support-ticket.create') }}" class="w-14 h-14 bg-primary-600 rounded-full shadow-lg flex items-center justify-center hover:scale-110 transition-transform" aria-label="Open support ticket">
                <i class="ph ph-bold ph-chat-centered-dots text-2xl text-white" aria-hidden="true"></i>
            </a>
        </div>
    @endif
</footer>

<style>
    /* Ensure the social icons use Phosphor correctly */
    [class^="ph-"], [class*=" ph-"] {
        font-family: 'Phosphor' !important;
    }
</style>
