{{-- Salieno Floating Pill Navbar with Border Beam --}}
@php
    $cartCount = app(\App\Services\CartService::class)->getCartCount();
@endphp

@once
@push('script')
<script nonce="{{ csp_nonce() }}">
    document.addEventListener('alpine:init', () => {
        Alpine.store('cart', {
            count: {{ $cartCount }},
            updateCount(newCount) {
                this.count = newCount;
            }
        });
    });
</script>
@endpush
@endonce

<div x-data="{ mobileMenuOpen: false, scrolled: false, hostingOpen: false, domainsOpen: false }"
    x-init="window.addEventListener('scroll', () => { scrolled = window.scrollY > 20 })"
    @keydown.escape.window="mobileMenuOpen = false; hostingOpen = false; domainsOpen = false"
    :class="scrolled ? 'scale-[0.98] top-2 md:top-4' : 'hover:scale-[1.01] top-2 md:top-6'"
    class="fixed left-1/2 -translate-x-1/2 z-[var(--z-fixed)] w-[95%] max-w-6xl transition-[background-color,color] duration-500 ease-[cubic-bezier(0.25,0.1,0.25,1)]">

    {{-- Border Beam Background --}}
    <div
        class="absolute inset-0 rounded-full overflow-hidden pointer-events-none ring-1 ring-black/5 dark:ring-white/10">
        <div
            class="absolute inset-[-200%] animate-spin-slow bg-[conic-gradient(from_90deg_at_50%_50%,transparent_0%,rgba(var(--primary-rgb),0.5)_50%,transparent_100%)] opacity-0 dark:opacity-100">
        </div>
    </div>

    {{-- Inner Background Mask --}}
    <div
        class="absolute inset-[1px] rounded-full bg-white/80 dark:bg-slate-900/80 backdrop-blur-2xl pointer-events-none shadow-xl shadow-primary-500/5">
    </div>

    {{-- Main Navbar Content --}}
    <nav class="relative w-full h-14 md:h-16 rounded-full flex items-center justify-between px-2 sm:px-6 z-10">
        {{-- Logo --}}
        <a href="{{ route('home') }}" class="cursor-pointer flex-shrink-0 pl-2">
            <x-logo />
        </a>

        {{-- Desktop Nav --}}
        <div class="hidden md:flex items-center space-x-1">
            {{-- Hosting Dropdown --}}
            @if(isset($serviceCategories) && $serviceCategories->count() > 0)
                <div class="relative group px-3 py-2 hover:z-50" x-data="{ open: false }" @mouseenter="open = true"
                    @mouseleave="open = false">
                    <button
                        class="flex items-center space-x-1.5 text-sm font-semibold text-slate-600 dark:text-slate-300 group-hover:text-primary-600 dark:group-hover:text-white transition-colors focus:outline-none">
                        <span>@lang('Hosting')</span>
                        <svg class="w-3.5 h-3.5 transition-transform duration-300 group-hover:-rotate-180 opacity-70"
                            fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>

                    {{-- Dropdown Panel --}}
                    <div x-show="open" x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 -translate-y-2"
                        x-transition:enter-end="opacity-100 translate-y-0"
                        x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100"
                        x-transition:leave-end="opacity-0"
                        class="absolute top-full left-1/2 -translate-x-1/2 pt-5 w-[520px] z-[var(--z-dropdown)]">
                        <div
                            class="p-1.5 rounded-2xl bg-white dark:bg-slate-900/95 shadow-2xl backdrop-blur-xl border border-slate-200/50 dark:border-white/10 ring-1 ring-black/5 dark:ring-white/5 overflow-hidden">
                            <div class="relative grid grid-cols-2 gap-2 p-2">
                                <div
                                    class="absolute top-0 right-0 w-64 h-64 bg-primary-500/5 rounded-full blur-3xl pointer-events-none -z-10">
                                </div>

                                @foreach($serviceCategories as $category)
                                    <a href="{{ route('products.category', $category->slug) }}"
                                        class="group/item flex items-start space-x-4 p-3 rounded-xl hover:bg-slate-50 dark:hover:bg-white/5 transition-colors cursor-pointer relative overflow-hidden">
                                        <div
                                            class="relative flex-shrink-0 p-2.5 rounded-xl bg-primary-50 text-primary-600 dark:bg-primary-500/10 dark:text-primary-400 group-hover/item:scale-110 transition-transform duration-300 shadow-sm">
                                            @php
                                                $iconClass = $category->icon;
                                                if (str_contains($iconClass, 'ph-') && !str_contains($iconClass, 'ph ')) {
                                                    $iconClass = 'ph ' . $iconClass;
                                                } elseif (!str_contains($iconClass, 'ph ')) {
                                                    $iconClass = 'ph ph-' . $iconClass;
                                                }
                                            @endphp
                                            <i class="{{ $iconClass }} text-2xl"></i>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <h5
                                                class="text-slate-900 dark:text-white font-bold text-sm group-hover/item:text-primary-600 dark:group-hover/item:text-primary-400 transition-colors truncate">
                                                {{ __($category->name) }}
                                            </h5>
                                            <p class="text-slate-500 dark:text-slate-400 text-xs leading-relaxed line-clamp-2">
                                                {{ __($category->description ?? 'Fast & reliable hosting') }}
                                            </p>
                                        </div>
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            {{-- Domains Dropdown --}}
            <div class="relative group px-3 py-2 hover:z-50" x-data="{ open: false }" @mouseenter="open = true"
                @mouseleave="open = false">
                <button
                    class="flex items-center space-x-1.5 text-sm font-semibold text-slate-600 dark:text-slate-300 group-hover:text-primary-600 dark:group-hover:text-white transition-colors focus:outline-none">
                    <span>@lang('Domains')</span>
                    <svg class="w-3.5 h-3.5 transition-transform duration-300 group-hover:-rotate-180 opacity-70"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                    </svg>
                </button>

                <div x-show="open" x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 -translate-y-2"
                    x-transition:enter-end="opacity-100 translate-y-0"
                    x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0" class="absolute top-full left-1/2 -translate-x-1/2 pt-5 w-64 z-[var(--z-dropdown)]">
                    <div
                        class="p-2 rounded-2xl bg-white dark:bg-slate-900/95 shadow-2xl backdrop-blur-xl border border-slate-200/50 dark:border-white/10 ring-1 ring-black/5 dark:ring-white/5">
                        <div class="space-y-1">
                            <a href="{{ route('domains.index') }}"
                                class="flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-50 dark:hover:bg-white/5 transition-colors group/item">
                                <div
                                    class="p-2 rounded-lg bg-primary-50 text-primary-600 dark:bg-primary-500/10 dark:text-primary-400 group-hover/item:scale-110 transition-transform shadow-sm">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                                    </svg>
                                </div>
                                <span
                                    class="text-slate-900 dark:text-white font-bold text-sm">@lang('Register Domain')</span>
                            </a>
                            <a href="{{ route('domains.transfer') }}"
                                class="flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-50 dark:hover:bg-white/5 transition-colors group/item">
                                <div
                                    class="p-2 rounded-lg bg-primary-50 text-primary-600 dark:bg-primary-500/10 dark:text-primary-400 group-hover/item:scale-110 transition-transform shadow-sm">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
                                    </svg>
                                </div>
                                <span
                                    class="text-slate-900 dark:text-white font-bold text-sm">@lang('Transfer Domain')</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Pricing Link --}}
            <a href="{{ route('pricing') }}"
                @if(request()->routeIs('pricing')) aria-current="page" @endif
                class="px-4 py-2 text-sm font-semibold transition-colors rounded-full {{ request()->routeIs('pricing') ? 'text-primary-600 dark:text-primary-400 bg-primary-50 dark:bg-primary-500/10' : 'text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-100/50 dark:hover:bg-white/5' }}">
                @lang('Pricing')
            </a>

            {{-- Custom Menu Items --}}
            @if(isset($headerMenu) && $headerMenu->hasActiveItems())
                @foreach($headerMenu->activeItems as $item)
                    <a href="{{ $item->getResolvedUrl() }}" target="{{ $item->target }}"
                        @if(url()->current() === $item->getResolvedUrl()) aria-current="page" @endif
                        class="px-4 py-2 text-sm font-semibold transition-colors rounded-full {{ url()->current() === $item->getResolvedUrl() ? 'text-primary-600 dark:text-primary-400 bg-primary-50 dark:bg-primary-500/10' : 'text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-100/50 dark:hover:bg-white/5' }}">
                        {{ __($item->label) }}
                    </a>
                @endforeach
            @endif
        </div>

        {{-- CTA Buttons --}}
        <div class="hidden md:flex items-center space-x-2 pr-1">
            {{-- Theme Toggle --}}
            @if(templateMeta('settings.show_mode_switcher', true))
            <button @click="$store.theme.toggle()"
                class="p-2 text-slate-500 hover:text-slate-900 dark:text-slate-400 dark:hover:text-white transition-colors rounded-full hover:bg-slate-100 dark:hover:bg-white/5"
                aria-label="Toggle dark mode">
                <svg x-show="$store.theme.on" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                <svg x-show="!$store.theme.on" x-cloak class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                </svg>
            </button>
            @endif

            {{-- Cart Icon --}}
            <a href="{{ route('shopping.cart.index') }}"
                class="relative p-2 text-slate-500 hover:text-slate-900 dark:text-slate-400 dark:hover:text-white transition-colors rounded-full hover:bg-slate-100 dark:hover:bg-white/5"
                aria-label="@lang('Shopping cart')">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <template x-if="$store.cart.count > 0">
                    <span
                        class="absolute top-0 right-0 inline-flex items-center justify-center w-4 h-4 text-[10px] font-bold leading-none text-white bg-primary-600 rounded-full"
                        x-text="$store.cart.count > 9 ? '9+' : $store.cart.count"></span>
                </template>
            </a>

            <div class="h-4 w-px bg-slate-200 dark:bg-white/10 mx-2"></div>

            @auth
                <x-theme.btn-primary href="{{ route('client.home') }}" :icon="false" class="rounded-full px-5">@lang('Dashboard')</x-theme.btn-primary>
            @else
                <a href="{{ route('client.login') }}"
                    class="btn-ghost font-semibold text-slate-600 dark:text-slate-300">@lang('Log In')</a>

                <x-theme.btn-primary href="{{ route('client.register') }}" :icon="false" class="rounded-full px-5">@lang('Get Started')</x-theme.btn-primary>
            @endauth
        </div>

        {{-- Mobile Menu Button --}}
        <div class="md:hidden flex items-center space-x-3 pr-2">
            <a href="{{ route('shopping.cart.index') }}"
                class="relative p-2 text-slate-500 hover:text-slate-900 dark:text-slate-400 dark:hover:text-white transition-colors rounded-full"
                aria-label="@lang('Shopping cart')">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <template x-if="$store.cart.count > 0">
                    <span
                        class="absolute top-0 right-0 inline-flex items-center justify-center w-4 h-4 text-[10px] font-bold leading-none text-white bg-primary-600 rounded-full"
                        x-text="$store.cart.count"></span>
                </template>
            </a>

            @if(templateMeta('settings.show_mode_switcher', true))
            <button @click="$store.theme.toggle()"
                class="p-2 text-slate-500 hover:text-slate-900 dark:text-slate-400 dark:hover:text-white transition-colors rounded-full"
                aria-label="Toggle dark mode">
                <svg x-show="$store.theme.on" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                </svg>
                <svg x-show="!$store.theme.on" x-cloak class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                </svg>
            </button>
            @endif

            <button @click="mobileMenuOpen = !mobileMenuOpen"
                class="p-2 rounded-full text-slate-600 dark:text-slate-300 hover:bg-slate-100 dark:hover:bg-white/10 transition-colors"
                aria-label="Toggle mobile menu"
                :aria-expanded="mobileMenuOpen">
                <svg x-show="!mobileMenuOpen" class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16m-7 6h7" />
                </svg>
                <svg x-show="mobileMenuOpen" x-cloak class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
    </nav>

    {{-- Mobile Menu Dropdown --}}
    <div x-show="mobileMenuOpen" x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" x-cloak
        class="absolute top-[64px] md:top-[72px] left-0 w-full animate-fade-in origin-top z-[var(--z-fixed)] px-2">
        <div
            class="rounded-2xl bg-white dark:bg-slate-900 border border-slate-200 dark:border-white/10 shadow-2xl p-4 overflow-hidden backdrop-blur-xl bg-opacity-95 dark:bg-opacity-95">
            <div class="space-y-1">
                @if(isset($serviceCategories) && $serviceCategories->count() > 0)
                    <button @click="hostingOpen = !hostingOpen" 
                        class="w-full flex items-center justify-between px-4 py-3 text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors group">
                        <span>@lang('Hosting')</span>
                        <svg class="w-4 h-4 transition-transform duration-300 transform" :class="hostingOpen ? 'rotate-180 text-primary-500' : 'text-slate-500 dark:text-slate-400'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>
                    
                    <div x-show="hostingOpen" x-collapse x-cloak class="pl-2 pb-2">
                        @foreach($serviceCategories as $category)
                            <a href="{{ route('products.category', $category->slug) }}" @click="mobileMenuOpen = false"
                                class="w-full text-left px-4 py-3 text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors font-medium flex items-center space-x-3">
                                @php
                                    $mobileIconClass = $category->icon;
                                    if (str_contains($mobileIconClass, 'ph-') && !str_contains($mobileIconClass, 'ph ')) {
                                        $mobileIconClass = 'ph ' . $mobileIconClass;
                                    } elseif (!str_contains($mobileIconClass, 'ph ')) {
                                        $mobileIconClass = 'ph ph-' . $mobileIconClass;
                                    }
                                @endphp
                                <i class="{{ $mobileIconClass }} text-lg opacity-80"></i>
                                <span>{{ __($category->name) }}</span>
                            </a>
                        @endforeach
                    </div>
                @endif

                <div class="border-t border-slate-200 dark:border-white/10 my-2"></div>

                <button @click="domainsOpen = !domainsOpen" 
                    class="w-full flex items-center justify-between px-4 py-3 text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-wider hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors group">
                    <span>@lang('Domains')</span>
                    <svg class="w-4 h-4 transition-transform duration-300 transform" :class="domainsOpen ? 'rotate-180 text-primary-500' : 'text-slate-500 dark:text-slate-400'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                    </svg>
                </button>

                <div x-show="domainsOpen" x-collapse x-cloak class="pl-2 pb-2">
                    <a href="{{ route('domains.index') }}" @click="mobileMenuOpen = false"
                        class="w-full text-left px-4 py-3 text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors font-medium flex items-center space-x-3">
                        <svg class="w-4 h-4 opacity-70" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                        </svg>
                        <span>@lang('Register Domain')</span>
                    </a>
                    <a href="{{ route('domains.transfer') }}" @click="mobileMenuOpen = false"
                        class="w-full text-left px-4 py-3 text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors font-medium flex items-center space-x-3">
                        <svg class="w-4 h-4 opacity-70" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
                        </svg>
                        <span>@lang('Transfer Domain')</span>
                    </a>
                </div>
                <a href="{{ route('pricing') }}" @click="mobileMenuOpen = false"
                    class="block w-full text-left px-4 py-3 text-slate-600 dark:text-slate-300 hover:text-primary-600 dark:hover:text-white hover:bg-slate-50 dark:hover:bg-white/5 rounded-xl transition-colors font-medium">@lang('Pricing')</a>
            </div>

            <div class="mt-4 pt-4 border-t border-slate-200 dark:border-white/10">
                @auth
                    <div class="space-y-4">
                        <x-theme.btn-primary href="{{ route('client.home') }}" :icon="false" full>@lang('Dashboard')</x-theme.btn-primary>
                        <form action="{{ route('client.logout') }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="w-full text-center text-xs font-semibold text-slate-500 dark:text-slate-400 hover:text-primary-500 transition-colors">
                                <i class="ph ph-bold ph-sign-out mr-1"></i> @lang('Sign Out')
                            </button>
                        </form>
                    </div>
                @else
                    <div class="grid grid-cols-2 gap-3">
                        <x-theme.btn-secondary href="{{ route('client.login') }}">@lang('Log In')</x-theme.btn-secondary>
                        <x-theme.btn-primary href="{{ route('client.register') }}" :icon="false">@lang('Get Started')</x-theme.btn-primary>
                    </div>
                @endauth
            </div>
        </div>
    </div>
</div>