@extends(activeTemplate() . 'layouts.frontend')

@php
    use App\Services\PricingCalculatorService;
    $pricingCalculator = app(PricingCalculatorService::class);
    $billingCycles = PricingCalculatorService::BILLING_CYCLES;
    
    // Find the longest available cycle in this category for the default view
    $categoryLongestCycle = 'monthly';
    $maxCategoryMonths = 0;
    foreach($products as $p) {
        $pPricing = $pricingCalculator->getProductPricing($p);
        $lpCycle = $pPricing['longest_cycle'] ?? 'monthly';
        $lpMonths = PricingCalculatorService::BILLING_CYCLES[$lpCycle]['months'] ?? 1;
        if ($lpMonths > $maxCategoryMonths) {
            $maxCategoryMonths = $lpMonths;
            $categoryLongestCycle = $lpCycle;
        }
    }
@endphp

@section('content')
    <div class="relative pt-40 pb-24 bg-slate-100 dark:bg-slate-950 min-h-screen overflow-hidden" x-data="pricingPage()">
        {{-- Background Effects --}}
        <div class="absolute inset-0 pointer-events-none">
            <div
                class="absolute inset-0 bg-[linear-gradient(var(--border)_1px,transparent_1px),linear-gradient(90deg,var(--border)_1px,transparent_1px)] bg-[size:50px_50px] opacity-10">
            </div>
            <div
                class="absolute top-0 left-1/2 -translate-x-1/2 w-[800px] h-[600px] bg-primary-600/10 rounded-full blur-[120px] animate-pulse-glow">
            </div>
            <div
                class="absolute bottom-1/4 right-0 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[100px] animate-pulse-glow">
            </div>
        </div>

        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            {{-- Category Header --}}
            <div class="text-center mb-16">
                <a href="{{ route('pricing') }}"
                    class="inline-flex items-center gap-2 text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white mb-6 transition-colors group">
                    <svg class="w-4 h-4 transition-transform group-hover:-translate-x-1" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    @lang('Back to All Categories')
                </a>
                <h1 class="text-4xl sm:text-5xl font-extrabold text-slate-900 dark:text-white mb-6 uppercase tracking-tight leading-tight">
                    {{ __($category->name ?? 'Category') }}
                </h1>
                <p class="text-slate-500 dark:text-slate-400 text-lg max-w-2xl mx-auto leading-relaxed">
                    {{ __($category->description ?? 'Browse our selection of products') }}
                </p>
                <div class="h-1 w-24 bg-gradient-to-r from-primary-600 to-primary-700 mx-auto mt-8 rounded-full"></div>
            </div>

            {{-- Multi-Cycle Billing Navigation --}}
            <div class="flex flex-wrap justify-center mb-16">
                <x-theme.pricing.cycle-switcher
                    :cycles="$billingCycles"
                    :selected="$categoryLongestCycle"
                    style="pills"
                />
            </div>

            {{-- Pricing Note --}}
            <div class="text-center mb-12">
                <div class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-primary-500/10 border border-primary-500/20">
                    <svg class="w-5 h-5 text-primary-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    <span class="text-slate-600 dark:text-slate-300 text-sm font-medium">
                        @lang('All prices shown as monthly equivalents. Longer billing cycles offer better value.')
                    </span>
                </div>
            </div>

            {{-- Product Grid --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                @forelse(($products ?? $category->activeProducts ?? collect()) as $product)
                    @php
                        $pricingData = $pricingCalculator->getProductPricingForJs($product);
                        $productPricing = $pricingCalculator->getProductPricing($product);
                        $ribbon = $product->ribbon;
                        $highlightStyles = $product->highlight_styles;
                        $ctaConfig = $product->cta_config;
                    @endphp

                    <div class="relative group rounded-[2.5rem] p-px transition-[border-color,background-color,opacity] duration-500 hover:-translate-y-2
                        {{ $product->is_recommended ? 'bg-gradient-to-b from-primary-500 via-primary-500 to-primary-700 shadow-2xl shadow-primary-500/20' : 'bg-slate-200 dark:bg-white/10 hover:border-slate-300 dark:hover:border-white/20' }}"
                        x-data='{ pricingData: @json($pricingData) }'>

                        {{-- Custom Highlight Border --}}
                        @if($highlightStyles && $highlightStyles['border'])
                            <div class="absolute inset-0 rounded-[2.5rem] opacity-50" style="box-shadow: 0 0 0 2px {{ $highlightStyles['border'] }}"></div>
                        @endif

                        <div class="h-full bg-white dark:bg-slate-900/40 backdrop-blur-xl rounded-[2.4rem] p-10 overflow-hidden relative flex flex-col border border-slate-200 dark:border-transparent"
                            @if($highlightStyles && $highlightStyles['background'])
                                style="background: linear-gradient(135deg, {{ $highlightStyles['background'] }}15, transparent);"
                            @endif>

                            {{-- Ribbon / Badge --}}
                            @if($ribbon)
                                <div class="absolute {{ $ribbon['position'] === 'top-left' ? 'top-0 left-0 rounded-bl-xl rounded-tr-[2.4rem]' : 'top-0 right-0 rounded-br-xl rounded-tl-[2.4rem]' }}
                                    px-4 py-2 text-[10px] font-extrabold uppercase tracking-[0.2em] shadow-lg z-20"
                                    style="background: {{ $ribbon['color'] === 'primary' ? '#FF5714' : ($ribbon['color'] === 'green' ? '#22c55e' : ($ribbon['color'] === 'orange' ? '#f97316' : ($ribbon['color'] === 'red' ? '#ef4444' : $ribbon['color']))) }}; color: white;">
                                    {{ __($ribbon['text']) }}
                                </div>
                            @elseif($product->is_recommended)
                                <div
                                    class="absolute top-0 left-1/2 -translate-x-1/2 bg-primary-600 text-white text-[10px] font-extrabold px-6 py-1.5 rounded-b-xl uppercase tracking-[0.2em] shadow-lg shadow-primary-500/40 z-20">
                                    @lang('Most Popular')
                                </div>
                            @elseif($product->is_popular)
                                <div
                                    class="absolute top-0 left-1/2 -translate-x-1/2 bg-primary-500 text-white text-[10px] font-extrabold px-6 py-1.5 rounded-b-xl uppercase tracking-[0.2em] shadow-lg shadow-primary-500/40 z-20">
                                    @lang('Popular')
                                </div>
                            @endif

                            {{-- Promo Badge (Discount) --}}
                            @if($productPricing['has_discount'] && $productPricing['promo_badge'])
                                <div class="absolute top-8 {{ $ribbon ? 'left-8' : 'right-8' }} z-20">
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-[10px] font-bold tracking-widest uppercase shadow-lg animate-pulse"
                                        style="background: {{ $productPricing['promo_badge']['color'] === 'red' ? '#ef444420' : '#' . $productPricing['promo_badge']['color'] . '20' }};
                                               color: {{ $productPricing['promo_badge']['color'] === 'red' ? '#ef4444' : '#' . $productPricing['promo_badge']['color'] }};
                                               border: 1px solid {{ $productPricing['promo_badge']['color'] === 'red' ? '#ef444440' : '#' . $productPricing['promo_badge']['color'] . '40' }};">
                                        {{ $productPricing['promo_badge']['text'] }}
                                    </span>
                                </div>
                            @endif

                            {{-- Stock Status --}}
                            @if ($product->stock_control)
                                <div class="absolute top-8 right-8 z-20">
                                    <span
                                        class="inline-flex items-center px-4 py-1.5 rounded-full text-[10px] font-bold tracking-widest uppercase bg-green-500/10 text-green-400 border border-green-500/20 backdrop-blur-md">
                                        {{ $product->stock_quantity }} @lang('In Stock')
                                    </span>
                                </div>
                            @endif

                            <div class="relative z-10 flex-grow {{ ($ribbon || $product->is_recommended || $product->is_popular) ? 'pt-6' : '' }}">
                                <h3
                                    class="text-2xl font-bold text-slate-900 dark:text-white mb-3 group-hover:text-primary-600 dark:group-hover:text-primary-400 transition-colors uppercase tracking-tight">
                                    {{ __($product->name) }}
                                </h3>
                                <p
                                    class="text-slate-500 dark:text-slate-400 text-sm mb-8 h-12 leading-relaxed opacity-80 group-hover:opacity-100 transition-opacity">
                                    {{ Str::limit($product->tagline ?? strip_tags($product->description), 90) }}
                                </p>

                                {{-- Pricing Display --}}
                                <div class="mb-10 min-h-[80px]">
                                    <template x-if="pricingData.prices[billingCycle]">
                                        <div class="flex flex-col">
                                            {{-- Main Price Display (Monthly Equivalent) --}}
                                            <div class="flex items-baseline mb-2">
                                                <span class="text-xs font-bold text-slate-500 dark:text-slate-400 uppercase self-start mt-2 mr-1">{{ gs('cur_sym') }}</span>
                                                <span class="text-5xl font-black tracking-tighter text-slate-900 dark:text-white"
                                                    x-text="pricingData.prices[billingCycle]?.display"></span>
                                                <span class="text-slate-500 dark:text-slate-400 text-sm font-bold uppercase tracking-widest ml-2">/mo</span>
                                            </div>

                                            <div class="flex items-center gap-3">
                                                {{-- Original Price (strikethrough if discounted) --}}
                                                <template x-if="pricingData.prices[billingCycle]?.has_discount">
                                                    <span class="text-slate-500 dark:text-slate-400 text-lg line-through font-medium" 
                                                        x-text="'{{ gs('cur_sym') }}' + pricingData.prices[billingCycle]?.original"></span>
                                                </template>

                                                {{-- Discount Badge - Matching Screenshot --}}
                                                <template x-if="pricingData.prices[billingCycle]?.has_discount">
                                                    <span class="inline-flex items-center px-2 py-0.5 rounded border border-primary-500/30 bg-primary-500/5 text-xs font-bold text-primary-500 uppercase tracking-wider"
                                                        x-text="'SAVE ' + pricingData.prices[billingCycle]?.discount_badge"></span>
                                                </template>
                                            </div>

                                            {{-- Total Cycle Price (subtle) --}}
                                            <div class="mt-4 text-slate-500 dark:text-slate-400 text-[10px] uppercase font-bold tracking-[0.15em] opacity-60" x-show="billingCycle !== 'monthly'">
                                                <span x-text="'Total ' + '{{ gs('cur_sym') }}' + pricingData.prices[billingCycle]?.total + ' ' + billingCycle.replace(/_/g, ' ')"></span>
                                            </div>
                                        </div>
                                    </template>

                                    <template x-if="!pricingData.prices[billingCycle]">
                                        <div class="flex items-baseline py-2">
                                            <span class="text-lg font-bold text-slate-600 dark:text-slate-400 uppercase tracking-[0.2em]">@lang('Not Available')</span>
                                        </div>
                                    </template>

                                    {{-- Setup Fee --}}
                                    <template x-if="pricingData.prices[billingCycle]?.setup_fee">
                                        <div class="mt-2 inline-flex items-center gap-2 group/setup">
                                            <div class="w-1.5 h-1.5 rounded-full bg-primary-500 animate-pulse"></div>
                                            <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest">
                                                + <span x-text="pricingData.prices[billingCycle]?.setup_fee"></span> @lang('Setup Fee')
                                            </span>
                                        </div>
                                    </template>
                                </div>

                                {{-- Features List --}}
                                <div class="space-y-3 mb-10" x-data="{ showAllFeatures: false }">
                                    @php
                                        // Show first 6 features, prioritize those with badges
                                        $featuresWithBadges = $product->features->where('badge_text', '!=', null)->take(3);
                                        $otherFeatures = $product->features->where('badge_text', null)->take(6 - $featuresWithBadges->count());
                                        $displayFeatures = $featuresWithBadges->merge($otherFeatures)->take(6);
                                        $totalFeatures = $product->features->count();
                                    @endphp
                                    
                                    {{-- Always visible features --}}
                                    @foreach($displayFeatures as $feature)
                                        <x-product-feature :feature="$feature" size="sm" />
                                    @endforeach
                                    
                                    {{-- Additional features (hidden by default) --}}
                                    @if($totalFeatures > 6)
                                        <div x-show="showAllFeatures" 
                                             x-transition:enter="transition ease-out duration-300"
                                             x-transition:enter-start="opacity-0 transform -translate-y-2"
                                             x-transition:enter-end="opacity-100 transform translate-y-0"
                                             class="space-y-3 pt-3 border-t border-slate-200 dark:border-white/5">
                                            @foreach($product->features->skip(6) as $feature)
                                                <x-product-feature :feature="$feature" size="sm" />
                                            @endforeach
                                        </div>
                                        
                                        <button @click="showAllFeatures = !showAllFeatures"
                                                class="w-full mt-4 py-2 text-xs font-semibold text-primary-400 hover:text-primary-300 transition-[border-color,background-color,opacity] duration-300 flex items-center justify-center gap-2 group">
                                            <span x-text="showAllFeatures ? '@lang('Show Less')' : '@lang('View All :count Features', ['count' => $totalFeatures])'"></span>
                                            <svg class="w-4 h-4 transition-transform duration-300" 
                                                 :class="showAllFeatures ? 'rotate-180' : ''"
                                                 fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                                            </svg>
                                        </button>
                                    @endif
                                </div>
                            </div>

                            {{-- CTA Button --}}
                            <div class="relative z-10 pt-4 border-t border-slate-200 dark:border-white/5">
                                <a :href="pricingData.prices[billingCycle] ? '{{ route('products.order', [$category->slug, $product->slug]) }}?billing_cycle=' + billingCycle : '#'"
                                    :class="!pricingData.prices[billingCycle] ? 'opacity-20 pointer-events-none grayscale' : ''"
                                    class="w-full h-14 rounded-2xl font-bold text-sm uppercase tracking-[0.2em] transition-[border-color,background-color,opacity] duration-300 active:scale-95 flex items-center justify-center gap-3
                                    {{ $product->is_recommended ? 'bg-white text-slate-900 hover:bg-primary-50 shadow-xl shadow-white/10' : '' }}"
                                    @if(!$product->is_recommended)
                                        style="background: {{ $ctaConfig['color'] === 'primary' ? '#FF5714' : ($ctaConfig['color'] ?: '#FF5714') }}; color: white;"
                                    @endif>
                                    <span>{{ __($ctaConfig['text']) }}</span>
                                    <svg class="w-5 h-5 transition-transform group-hover:translate-x-1" fill="none"
                                        viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                    </svg>
                                </a>
                            </div>

                            {{-- Discount Countdown Timer --}}
                            @if($productPricing['discount_countdown'])
                                <div class="mt-4 p-3 rounded-xl bg-red-500/10 border border-red-500/20 text-center"
                                    x-data="countdownTimer({{ $productPricing['discount_countdown']['end_timestamp'] }})"
                                    x-show="!expired">
                                    <span class="text-[10px] text-red-400 font-bold uppercase tracking-widest">@lang('Offer ends in'):</span>
                                    <div class="flex justify-center gap-2 mt-1 text-slate-900 dark:text-white font-mono text-sm">
                                        <span x-text="days + 'd'"></span>
                                        <span>:</span>
                                        <span x-text="hours + 'h'"></span>
                                        <span>:</span>
                                        <span x-text="minutes + 'm'"></span>
                                        <span>:</span>
                                        <span x-text="seconds + 's'"></span>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="col-span-full py-24 text-center">
                        <div
                            class="w-32 h-32 mx-auto mb-10 rounded-[2.5rem] bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 flex items-center justify-center relative group">
                            <div
                                class="absolute inset-0 bg-primary-600/20 rounded-[2.5rem] blur-2xl opacity-0 group-hover:opacity-100 transition-opacity">
                            </div>
                            <svg class="w-14 h-14 text-slate-600 dark:text-slate-400 relative z-10" fill="none" viewBox="0 0 24 24"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                            </svg>
                        </div>
                        <h3 class="text-3xl font-bold text-slate-900 dark:text-white mb-4 italic">@lang('Empty Sector')</h3>
                        <p class="text-slate-500 dark:text-slate-400 text-lg">@lang('We are currently scanning for new products in this category.')
                        </p>
                    </div>
                @endforelse
            </div>
        </div>
    
        {{-- Product Comparison Section --}}
        @if($products->count() > 1)
            @include(activeTemplate() . 'sections.comparison', ['category' => $category])
        @endif
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div>
            {{-- Pagination --}}
            @if($products instanceof \Illuminate\Pagination\LengthAwarePaginator)
                <div class="mt-20 flex justify-center">
                    <div class="pagination-salieno">
                        {{ paginateLinks($products) }}
                    </div>
                </div>
            @endif

            {{-- Other Categories --}}
            @if(isset($categories) && $categories->count() > 1)
                <div class="mt-24 pt-16 border-t border-slate-200 dark:border-white/10">
                    <h3 class="text-2xl font-bold text-slate-900 dark:text-white text-center mb-8">@lang('Explore Other Categories')</h3>
                    <div class="flex flex-wrap justify-center gap-4">
                        @foreach($categories as $cat)
                            @if($cat->slug !== $category->slug)
                                <a href="{{ route('products.category', $cat->slug) }}"
                                    class="px-6 py-3 rounded-xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 text-slate-700 dark:text-slate-300 hover:bg-primary-600 hover:border-primary-600 hover:text-white transition-[background-color,border-color,color] font-semibold">
                                    {{ __($cat->name) }}
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>

    @push('script')
    <script nonce="{{ csp_nonce() }}">
        function pricingPage() {
            return {
                billingCycle: new URLSearchParams(window.location.search).get('cycle') || '{{ $categoryLongestCycle }}',
            }
        }
    </script>
    @endpush
@endsection
