@extends(activeTemplate() . 'layouts.frontend')


@section('content')
@php
    $initialCycle = request('billing_cycle', 'monthly');
    $initialPrice = $pricingData['cycles'][$initialCycle]['total_price'] ?? $pricingData['cycles']['monthly']['total_price'] ?? 0;
@endphp
<div class="relative pt-32 pb-24 bg-slate-50 dark:bg-slate-950 min-h-screen transition-colors duration-300" 
     x-data="orderPage({
        initialCycle: '{{ $initialCycle }}',
        initialPrice: {{ $initialPrice }},
        initialDomain: '{{ request()->get('domain', '') }}'
     })">
    {{-- Animated Gradient Background --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        {{-- Primary Gradient Blobs --}}
        <div class="absolute top-[-10%] left-[-10%] w-[70vw] h-[70vw] max-w-[600px] max-h-[600px] rounded-full 
                    bg-gradient-to-br from-primary-500/10 dark:from-primary-500/20 via-primary-600/5 dark:via-primary-600/10 to-transparent 
                    blur-[100px] animate-blob"></div>
        <div class="absolute bottom-[-10%] right-[-10%] w-[50vw] h-[50vw] max-w-[500px] max-h-[500px] rounded-full 
                    bg-gradient-to-tl from-primary-500/5 dark:from-primary-500/10 via-primary-500/5 dark:via-primary-500/5 to-transparent 
                    blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
        
        {{-- Grid Lines --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
    </div>

    <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header --}}
        <div class="text-center mb-12">
            <h1 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-3 tracking-tight leading-tight">
                @lang('Configure Your') 
                <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                    {{ __($product->name) }}
                </span>
            </h1>
            <p class="text-slate-600 dark:text-slate-400 text-base max-w-2xl mx-auto">{{ Str::limit($product->tagline ?? $product->description, 120) }}</p>
        </div>

        <form id="order-form" action="{{ route('shopping.cart.add.service') }}" method="POST">
            @csrf
            <input type="hidden" name="item_id" value="{{ $product->id }}">
            <input type="hidden" name="domain_price" :value="selectedDomainPrice">
            <input type="hidden" name="quantity" value="1">
            
            <div class="grid lg:grid-cols-3 gap-8">
                
                {{-- Domain Selection (Conditional) --}}
                @if($product->domain_register)
                <div class="lg:col-span-2 space-y-6" x-show="!domainSelected">
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 backdrop-blur-xl p-6 sm:p-10 shadow-xl shadow-slate-200/50 dark:shadow-none transition-[border-color,background-color,color] ">
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                            <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                <i class="ph ph-bold ph-globe"></i>
                            </span>
                            @lang('Choose a Domain')
                        </h3>
                        
                        {{-- Improved Tabs --}}
                        <div class="flex flex-wrap gap-2 mb-8 p-1.5 bg-slate-100 dark:bg-white/5 rounded-2xl border border-slate-200 dark:border-white/5">
                            <button type="button" @click="domainMode = 'register'; results = []; hasMore = false; cursor = null;" 
                                    :class="domainMode === 'register' ? 'bg-white dark:bg-primary-500 text-primary-600 dark:text-white shadow-md' : 'text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white'"
                                    class="flex-1 min-w-[120px] px-6 py-3 rounded-xl font-bold transition-colors text-sm flex items-center justify-center gap-2">
                                <i class="ph ph-bold ph-plus-circle text-lg"></i>@lang('Register')
                            </button>
                            <button type="button" @click="domainMode = 'transfer'; results = []; hasMore = false; cursor = null;" 
                                    :class="domainMode === 'transfer' ? 'bg-white dark:bg-primary-500 text-primary-600 dark:text-white shadow-md' : 'text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white'"
                                    class="flex-1 min-w-[120px] px-6 py-3 rounded-xl font-bold transition-colors text-sm flex items-center justify-center gap-2">
                                <i class="ph ph-bold ph-arrows-left-right text-lg"></i>@lang('Transfer')
                            </button>
                            <button type="button" @click="domainMode = 'existing'" 
                                    :class="domainMode === 'existing' ? 'bg-white dark:bg-primary-500 text-primary-600 dark:text-white shadow-md' : 'text-slate-500 dark:text-slate-400 hover:text-slate-900 dark:hover:text-white'"
                                    class="flex-1 min-w-[120px] px-6 py-3 rounded-xl font-bold transition-colors text-sm flex items-center justify-center gap-2">
                                <i class="ph ph-bold ph-laptop text-lg"></i>@lang('Use Own')
                            </button>
                        </div>

                        {{-- Register/Transfer Form --}}
                        <div x-show="domainMode === 'register' || domainMode === 'transfer'" class="space-y-6">
                            <div class="flex flex-col sm:flex-row gap-3">
                                <div class="flex-1 relative">
                                    <input type="text" x-model="domainQuery" @keydown.enter.prevent="performSearch()"
                                           placeholder="example.com or keyword" 
                                           class="w-full h-14 bg-slate-100 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-medium">
                                </div>
                                <button type="button" @click="performSearch()" :disabled="loading"
                                        class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] h-14 px-7 py-2.5 text-sm disabled:opacity-50">
                                    <span x-show="!loading" x-text="domainMode === 'register' ? '@lang('Search')' : '@lang('Check Transfer')'"></span>
                                    <i x-show="!loading" class="ph ph-bold ph-magnifying-glass"></i>
                                    <span x-show="loading" class="animate-spin h-5 w-5 border-2 border-white/30 border-t-white rounded-full"></span>
                                </button>
                            </div>

                            {{-- Error State --}}
                            <div x-show="errorMessage" class="pt-6 animate-fade-in">
                                <div class="p-6 rounded-2xl bg-primary-500/5 border border-primary-500/10 text-center">
                                    <div class="w-12 h-12 bg-primary-500/10 text-primary-500 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="ph ph-bold ph-warning-octagon text-2xl"></i>
                                    </div>
                                    <h4 class="text-slate-900 dark:text-white font-bold mb-2">@lang('Something went wrong')</h4>
                                    <p class="text-sm text-slate-500 dark:text-slate-400 mb-6" x-text="errorMessage"></p>
                                    <x-theme.btn-primary type="button" @click="performSearch()" size="sm">
                                        @lang('Retry Search')
                                    </x-theme.btn-primary>
                                </div>
                            </div>

                            {{-- Skeleton Loaders --}}
                            <div x-show="loading && results.length === 0" class="space-y-4 pt-6">
                                <div class="h-32 rounded-3xl bg-slate-100 dark:bg-white/5 animate-shimmer overflow-hidden relative">
                                    <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/10 to-transparent -translate-x-full animate-shimmer-slide"></div>
                                </div>
                                <div class="grid gap-3">
                                    @for($i=0; $i<3; $i++)
                                    <div class="h-24 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 animate-shimmer overflow-hidden relative">
                                        <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/5 to-transparent -translate-x-full animate-shimmer-slide"></div>
                                    </div>
                                    @endfor
                                </div>
                            </div>

                            {{-- Search Results --}}
                            <div x-show="results.length > 0" x-transition class="space-y-6 pt-6">
                                
                                {{-- Featured Result Header --}}
                                <div class="flex items-center gap-2 mb-4">
                                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                                    <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">@lang('Search Results')</span>
                                    <div class="h-px flex-1 bg-slate-200 dark:bg-white/10"></div>
                                </div>

                                {{-- Featured .com Result --}}
                                <template x-for="tld in [results.find(r => r.extension === '.com')]" :key="'featured-com'">
                                    <template x-if="tld">
                                        <div class="relative group overflow-hidden p-6 rounded-3xl bg-gradient-to-br from-primary-600 to-primary-800 text-white shadow-xl shadow-primary-500/20 transition-[border-color,background-color,transform] duration-300 hover:-translate-y-1">
                                            <div class="absolute top-0 right-0 p-4 opacity-10 group-hover:scale-110 transition-transform">
                                                <i class="ph-fill ph-crown text-7xl"></i>
                                            </div>
                                            <div class="relative z-10 flex flex-col sm:flex-row items-center justify-between gap-6">
                                                <div>
                                                    <div class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full bg-white/20 border border-white/30 text-[10px] font-bold uppercase tracking-widest mb-3">
                                                        <i class="ph-fill ph-sparkle text-yellow-400"></i>
                                                        <span>@lang('Most Popular')</span>
                                                    </div>
                                                    <h4 class="text-xl font-bold tracking-tight" x-text="tld.domain"></h4>
                                                    <div class="flex items-center gap-2 mt-2">
                                                        <template x-if="tld.available === true">
                                                            <span class="inline-flex items-center gap-1 text-[10px] font-bold text-green-300">
                                                                <span class="w-1.5 h-1.5 rounded-full bg-green-400 animate-pulse"></span>
                                                                Available
                                                            </span>
                                                        </template>
                                                        <template x-if="tld.available === false">
                                                            <span class="text-[10px] font-bold text-red-200 opacity-80">Unavailable</span>
                                                        </template>
                                                    </div>
                                                </div>
                                                
                                                <div class="flex items-center gap-6">
                                                    <div class="text-right">
                                                        <span class="block text-xl font-bold" x-text="tld.formatted_pricing.registration"></span>
                                                        <span class="text-[10px] font-bold uppercase tracking-widest opacity-70">@lang('per year')</span>
                                                    </div>
                                                    <template x-if="tld.available === true || (domainMode === 'transfer' && tld.available === false)">
                                                        <x-theme.btn-secondary type="button" @click="selectDomain(tld)" class="bg-white dark:bg-white/10 text-primary-900 dark:text-white hover:bg-slate-100 dark:hover:bg-white/20 border-0 shadow-xl">
                                                            @lang('Select')
                                                        </x-theme.btn-secondary>
                                                    </template>
                                                </div>
                                            </div>
                                        </div>
                                    </template>
                                </template>

                                {{-- Other Results List --}}
                                <div class="grid gap-3">
                                    <template x-for="res in results.filter(r => r.extension !== '.com')" :key="res.domain">
                                        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-4 p-5 rounded-2xl border transition-[border-color,background-color,opacity] duration-300"
                                             :class="res.available ? 'bg-white dark:bg-white/5 border-slate-200 dark:border-white/10 hover:border-primary-500/30' : 'bg-slate-50 dark:bg-white/5 border-slate-100 dark:border-white/5 opacity-80'">
                                            <div class="flex items-center gap-4">
                                                <div class="w-11 h-11 rounded-xl flex items-center justify-center text-xl transition-colors"
                                                     :class="res.available ? 'bg-primary-500/10 text-primary-600' : 'bg-slate-200 dark:bg-white/5 text-slate-500 dark:text-slate-400'">
                                                    <i class="ph ph-bold ph-globe"></i>
                                                </div>
                                                <div>
                                                    <span class="font-bold text-lg" :class="res.available ? 'text-slate-900 dark:text-white' : 'text-slate-500 dark:text-slate-400'" x-text="res.domain"></span>
                                                    <div class="flex items-center gap-2 mt-1">
                                                        <template x-if="res.available === true">
                                                            <span class="text-[10px] font-bold uppercase tracking-widest text-green-600 dark:text-green-400">Available</span>
                                                        </template>
                                                        <template x-if="res.available === false">
                                                            <span class="text-[10px] font-bold uppercase tracking-widest text-red-500 dark:text-red-400">Taken</span>
                                                        </template>
                                                        <template x-if="res.available === null">
                                                            <span class="text-[10px] font-bold text-slate-500 dark:text-slate-400 animate-pulse">Checking...</span>
                                                        </template>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="flex items-center justify-between sm:justify-end gap-6 sm:gap-8">
                                                <div class="text-right">
                                                    <span class="block text-xl font-bold" :class="res.available ? 'text-slate-900 dark:text-white' : 'text-slate-500 dark:text-slate-400'" x-text="res.formatted_pricing.registration"></span>
                                                    <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest">@lang('per year')</span>
                                                </div>
                                                <template x-if="res.available === true || (domainMode === 'transfer' && res.available === false)">
                                                    <x-theme.btn-primary type="button" @click="selectDomain(res)" size="sm">
                                                        @lang('Select')
                                                    </x-theme.btn-primary>
                                                </template>
                                            </div>
                                        </div>
                                    </template>
                                </div>
                                
                                {{-- Load More --}}
                                <div x-show="hasMore" class="pt-4 text-center">
                                    <button type="button" @click="loadMore()" :disabled="loadingMore"
                                            class="group relative inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white dark:bg-white/5 hover:bg-slate-50 dark:hover:bg-white/10 text-slate-800 dark:text-white border border-slate-200 dark:border-white/10 shadow-sm transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] overflow-hidden px-7 py-2.5 text-sm mx-auto disabled:opacity-50">
                                        <span class="relative z-10" x-show="!loadingMore">@lang('Show More Extensions')</span>
                                        <span x-show="loadingMore" class="animate-spin h-4 w-4 border-2 border-primary-500/30 border-t-primary-500 rounded-full"></span>
                                    </button>
                                </div>
                            </div>
                         </div>
 
                         {{-- EPP Code for Transfer --}}
                         <div x-show="domainMode === 'transfer'" class="animate-fade-in mt-6 p-6 rounded-2xl bg-primary-500/5 border border-primary-500/10">
                             <label class="block text-sm font-bold text-slate-800 dark:text-slate-200 mb-3 uppercase tracking-wider">@lang('EPP/Auth Code')</label>
                             <div class="relative">
                                 <input type="text" x-model="domainEppCode" placeholder="@lang('Enter domain auth code...')" 
                                        class="w-full h-12 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-4 text-slate-900 dark:text-white focus:border-primary-500 font-medium transition-[border-color,background-color,color] ">
                                 <div class="mt-3 flex items-start gap-2">
                                     <i class="ph ph-info text-primary-500 mt-0.5 text-lg"></i>
                                     <p class="text-xs text-slate-500 dark:text-slate-400 leading-relaxed font-medium">@lang('The EPP code is required to authorize the transfer. You can obtain this from your current registrar.')</p>
                                 </div>
                             </div>
                         </div>

                         {{-- Existing Form --}}
                         <div x-show="domainMode === 'existing'" class="space-y-6">
                            <div class="p-6 rounded-2xl bg-primary-500/5 border border-primary-500/10 transition-[border-color,background-color,color] ">
                                <p class="text-slate-600 dark:text-slate-400 text-sm font-medium mb-6">@lang('If you already have a domain registered elsewhere, enter it below to connect it with this hosting plan.')</p>
                                <div class="flex flex-col sm:flex-row gap-3">
                                    <input type="text" x-model="existingDomain" placeholder="@lang('yourdomain.com')" 
                                           class="flex-1 h-14 bg-white dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 font-medium transition-[border-color,background-color,color] ">
                                    <x-theme.btn-primary type="button" @click="useExistingDomain" :icon="false" class="h-14">
                                        @lang('Use Domain')
                                    </x-theme.btn-primary>
                                </div>
                            </div>
                         </div>
                    </div>
                </div>
                @endif

                <input type="hidden" name="domain" :value="selectedDomainName">
                <input type="hidden" name="domain_id" :value="selectedDomainId">
                <input type="hidden" name="domain_action" :value="domainAction">
                <input type="hidden" name="epp_code" :value="domainEppCode">
                <input type="hidden" name="id_protection" :value="idProtection ? 1 : 0">
                <input type="hidden" name="id_protection_price" :value="idProtectionPrice">

                {{-- Configuration Options --}}
                <div class="lg:col-span-2 space-y-6" @if($product->domain_register) x-show="domainSelected" @endif>
                    
                    {{-- Selected Domain Info --}}
                    @if($product->domain_register)
                    <div class="relative overflow-hidden rounded-3xl bg-gradient-to-r from-primary-600 to-primary-800 p-6 shadow-lg shadow-primary-500/20">
                        <div class="absolute top-0 right-0 p-4 opacity-10">
                            <i class="ph-fill ph-globe text-6xl"></i>
                        </div>
                        <div class="relative z-10 flex justify-between items-center group">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-2xl bg-white/20 flex items-center justify-center text-white ring-4 ring-white/10">
                                    <i class="ph ph-bold ph-check text-2xl"></i>
                                </div>
                                <div class="text-white">
                                    <span class="text-[10px] font-bold uppercase tracking-[0.2em] opacity-80">@lang('Selected Domain')</span>
                                    <span class="block font-bold text-lg tracking-tight" x-text="selectedDomainName"></span>
                                </div>
                            </div>
                            <x-theme.btn-secondary type="button" @click="domainSelected = false" size="sm" class="bg-white/20 hover:bg-white/30 text-white border-0 backdrop-blur-sm">
                                @lang('Change')
                            </x-theme.btn-secondary>
                        </div>
                    </div>
 
                    {{-- ID Protection Option --}}
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 transition-[border-color,background-color,color] " x-show="idProtectionPrice > 0">
                        <label class="flex items-center justify-between cursor-pointer group">
                            <div class="flex items-center gap-5">
                                <div class="w-14 h-14 rounded-2xl bg-primary-500/10 flex items-center justify-center text-primary-500 group-hover:scale-110 transition-[border-color,box-shadow] shadow-inner">
                                    <i class="ph ph-bold ph-shield-check text-3xl"></i>
                                </div>
                                <div>
                                    <h4 class="text-slate-900 dark:text-white font-bold text-lg">@lang('ID Protection')</h4>
                                    <p class="text-xs text-slate-500 dark:text-slate-400 font-medium">@lang('Hide your personal info from the public WHOIS database.')</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-6">
                                <span class="text-slate-900 dark:text-white font-bold text-lg" x-text="'{{ gs("cur_sym") }}' + idProtectionPrice.toFixed(2)"></span>
                                <div class="relative inline-flex items-center h-7 w-12 rounded-full transition-colors focus:outline-none ring-4 ring-slate-100 dark:ring-white/5"
                                     :class="idProtection ? 'bg-primary-600' : 'bg-slate-200 dark:bg-white/10'">
                                    <input type="checkbox" x-model="idProtection" class="sr-only">
                                    <span class="inline-block w-5 h-5 transform bg-white rounded-full transition-transform shadow-md"
                                          :class="idProtection ? 'translate-x-6' : 'translate-x-1'"></span>
                                </div>
                            </div>
                        </label>
                    </div>
                    @endif

                    {{-- Billing Cycle --}}
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 sm:p-10 transition-[border-color,background-color,color] ">
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                            <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                <i class="ph ph-bold ph-calendar-check"></i>
                            </span>
                            @lang('Billing Cycle')
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @php
                                // Build cycles array using discounted prices from PricingCalculatorService
                                $cycles = [];
                                foreach ($pricingData['cycles'] as $cycleKey => $cycleData) {
                                    $cycles[$cycleKey] = [
                                        'label' => $cycleData['label'],
                                        'val' => $cycleData['total_price'], // Use discounted price
                                        'months' => $cycleData['months'],
                                        'has_discount' => $cycleData['has_discount'] ?? false,
                                        'original_price' => $cycleData['original_price'] ?? $cycleData['total_price'],
                                    ];
                                }
                            @endphp
                            @foreach($cycles as $key => $cycle)
                                @if($cycle['val'] > 0 || $product->payment_type == 1)
                                    @php
                                        $monthlyEquiv = $cycle['months'] > 0 ? round($cycle['val'] / $cycle['months'], 2) : $cycle['val'];
                                        $cycleData = $pricingData['cycles'][$key] ?? null;
                                        $savings = null;
                                        if ($cycleData && $key !== 'monthly' && isset($pricingData['cycles']['monthly'])) {
                                            $monthlyCycle = $pricingData['cycles']['monthly'];
                                            $monthlyTotal = $monthlyCycle['monthly_equivalent'] * $cycle['months'];
                                            if ($monthlyTotal > $cycle['val']) {
                                                $savings = round((($monthlyTotal - $cycle['val']) / $monthlyTotal) * 100);
                                            }
                                        }
                                    @endphp
                                <label class="relative cursor-pointer group">
                                    <input type="radio" name="billing_cycle" value="{{ $key }}" 
                                           @if($initialCycle === $key) checked @endif 
                                           @click="selectedCycle = '{{ $key }}'; price = {{ $cycle['val'] }}"
                                           class="sr-only peer">
                                    <div class="h-full p-6 rounded-2xl border-2 transition-[border-color,background-color,opacity] duration-300 flex flex-col items-center text-center
                                                peer-checked:border-primary-500 peer-checked:bg-primary-500/5 peer-checked:ring-4 peer-checked:ring-primary-500/10
                                                border-slate-100 dark:border-white/5 bg-slate-50 dark:bg-white/5 hover:border-primary-500/30">
                                        
                                        <div class="mb-4">
                                            <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-widest mb-1">{{ __($cycle['label']) }}</span>
                                            
                                            @if($cycle['has_discount'] ?? false)
                                                <div class="flex items-center justify-center gap-1.5 mb-1 opacity-60">
                                                    <span class="text-xs font-bold text-slate-500 dark:text-slate-400 line-through">{{ gs('cur_sym') }}{{ number_format($cycle['original_price'] / $cycle['months'], 2) }}</span>
                                                </div>
                                            @endif
                                            
                                            <div class="flex items-baseline justify-center">
                                                <span class="text-slate-500 dark:text-slate-400 dark:text-white/60 font-bold text-sm mr-0.5">{{ gs('cur_sym') }}</span>
                                                <span class="text-2xl font-bold tracking-tight" :class="selectedCycle === '{{ $key }}' ? 'text-primary-600 dark:text-primary-400' : 'text-slate-900 dark:text-white'">{{ number_format($monthlyEquiv, 2) }}</span>
                                                <span class="text-slate-500 dark:text-slate-400 dark:text-white/60 font-bold text-xs ml-0.5">/mo</span>
                                            </div>
                                        </div>
                                        
                                        <div class="mt-auto pt-4 border-t border-slate-200 dark:border-white/10 w-full">
                                            @if($key !== 'monthly')
                                                <span class="block text-[10px] font-bold uppercase tracking-widest text-slate-500 dark:text-slate-400 mb-2">{{ gs('cur_sym') }}{{ number_format($cycle['val'], 2) }} total</span>
                                            @endif
                                            
                                            @if($savings)
                                                <span class="inline-flex px-2 py-1 rounded-full bg-green-500/10 text-green-600 dark:text-green-400 text-[10px] font-bold tracking-widest">
                                                    SAVE {{ $savings }}%
                                                </span>
                                            @else
                                                <span class="inline-flex px-2 py-1 rounded-full bg-slate-200 dark:bg-white/10 text-slate-500 dark:text-slate-400 text-[10px] font-bold tracking-widest opacity-0 peer-checked:opacity-100">
                                                    STAY FLEXIBLE
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                    
                                    {{-- Active Indicator dot --}}
                                    <div x-show="selectedCycle === '{{ $key }}'" class="absolute -top-1 -right-1 w-6 h-6 bg-primary-500 text-white rounded-full flex items-center justify-center shadow-lg shadow-primary-500/30">
                                        <i class="ph ph-bold ph-check text-xs"></i>
                                    </div>
                                </label>
                                @endif
                            @endforeach
                        </div>
                    </div>
                {{-- Addons, Features list, sidebar etc continue... --}}

                    {{-- Addons --}}
                    @if(isset($product->addons) && $product->addons->count() > 0)
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 sm:p-10 transition-[border-color,background-color,color] ">
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                            <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                <i class="ph ph-bold ph-plus-circle"></i>
                            </span>
                            @lang('Optional Addons')
                        </h3>
                        <div class="grid grid-cols-1 gap-4">
                            @foreach($product->addons as $addon)
                                <label class="relative flex items-center justify-between p-5 rounded-2xl border-2 cursor-pointer transition-[border-color,background-color,box-shadow] duration-300 group
                                            bg-slate-50 dark:bg-white/5 border-slate-100 dark:border-white/5 hover:border-primary-500/30
                                            [&:has(input:checked)]:border-primary-500 [&:has(input:checked)]:bg-primary-500/5 [&:has(input:checked)]:ring-4 [&:has(input:checked)]:ring-primary-500/10">
                                    <div class="flex items-center gap-5">
                                        <div class="relative flex items-center justify-center">
                                            <input type="checkbox" name="addons[]" value="{{ $addon->id }}" 
                                                   @change="toggleAddon({{ $addon->id }}, {{ $addon->price }})"
                                                   class="w-6 h-6 rounded-lg bg-white dark:bg-slate-800 border-slate-300 dark:border-slate-700 text-primary-600 focus:ring-primary-500 focus:ring-offset-0 transition-[border-color,box-shadow] outline-none">
                                        </div>
                                        <div>
                                            <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-tight">{{ __($addon->name) }}</span>
                                            <span class="block text-xs text-slate-500 dark:text-slate-400 font-medium">{{ __($addon->description) }}</span>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <span class="block text-slate-900 dark:text-white font-bold text-lg">{{ gs('cur_sym') }}{{ number_format($addon->price, 2) }}</span>
                                        <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest">@lang('per month')</span>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    {{-- Configurable Options --}}
                    @php $configs = $product->productConfigurations; @endphp
                    @if($configs && $configs->count() > 0)
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 sm:p-10 transition-[border-color,background-color,color] ">
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                            <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                <i class="ph ph-bold ph-gear-six"></i>
                            </span>
                            @lang('Configure Services')
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            @foreach ($configs as $config)
                                @php
                                    $group = $config->activeGroup;
                                    $options = $group->activeOptions;
                                @endphp
 
                                @foreach ($options->sortBy('order') as $option)
                                    @php $subOptions = $option->activeSubOptions; @endphp
                                    @if (count($subOptions))
                                        <div class="space-y-3">
                                            <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">{{ __($option->name) }}</label>
                                            <div class="relative group">
                                                <select name="config_options[{{ $option->id }}]" 
                                                        class="appearance-none w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-bold text-sm cursor-pointer">
                                                    @foreach ($subOptions->sortBy('order') as $subOption)
                                                        <option value="{{ $subOption->id }}">
                                                            {{ __($subOption->name) }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none text-slate-500 dark:text-slate-400 group-hover:text-primary-500 transition-colors">
                                                    <i class="ph ph-bold ph-caret-down text-lg"></i>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @endforeach
                        </div>
                    </div>
                    @endif

                    {{-- VPS / Server Configuration --}}
                    @if ($product->product_type == 3)
                    <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 sm:p-10 transition-[border-color,background-color,color] ">
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-6 flex items-center gap-3">
                            <span class="w-9 h-9 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center text-sm">
                                <i class="ph ph-bold ph-terminal-window"></i>
                            </span>
                            @lang('Server Configuration')
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-3">
                                <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('Hostname')</label>
                                <input type="text" name="hostname" placeholder="servername.example.com" required
                                       pattern="^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$"
                                       title="Please enter a valid hostname (e.g. server.example.com)"
                                       class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-bold text-sm">
                            </div>
                            <div class="space-y-3">
                                <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('Root Password')</label>
                                <input type="password" name="password" placeholder="*******" required
                                       minlength="8" x-model="password"
                                       title="Password must be at least 8 characters long"
                                       class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-bold text-sm">
                                
                                {{-- Password Strength Meter --}}
                                <div class="mt-2 space-y-1.5" x-show="password">
                                    <div class="flex justify-between items-center text-[10px] font-black uppercase tracking-widest">
                                        <span :class="passwordStrength < 50 ? 'text-primary-500' : (passwordStrength < 100 ? 'text-amber-500' : 'text-green-500')"
                                              x-text="passwordStrength < 50 ? '@lang('Weak')' : (passwordStrength < 100 ? '@lang('Fair')' : '@lang('Strong')')"></span>
                                        <span class="text-slate-500 dark:text-slate-400" x-text="passwordStrength + '%'"></span>
                                    </div>
                                    <div class="h-1.5 w-full bg-slate-100 dark:bg-white/5 rounded-full overflow-hidden">
                                        <div class="h-full transition-[border-color,background-color,box-shadow] duration-500"
                                            :style="'width: ' + passwordStrength + '%'"
                                            :class="passwordStrength < 50 ? 'bg-primary-500' : (passwordStrength < 100 ? 'bg-amber-500' : 'bg-green-500')"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="space-y-3">
                                <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('NS1 Prefix')</label>
                                <input type="text" name="ns1" placeholder="ns1" required
                                       pattern="^[a-zA-Z0-9\-]+$"
                                       title="Please enter a valid prefix (alphanumeric and hyphens only)"
                                       class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-bold text-sm">
                            </div>
                            <div class="space-y-3">
                                <label class="block text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('NS2 Prefix')</label>
                                <input type="text" name="ns2" placeholder="ns2" required
                                       pattern="^[a-zA-Z0-9\-]+$"
                                       title="Please enter a valid prefix (alphanumeric and hyphens only)"
                                       class="w-full h-14 bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/10 rounded-xl px-5 text-slate-900 dark:text-white focus:border-primary-500 focus:ring-0 transition-colors font-bold text-sm">
                            </div>
                        </div>
                    </div>
                    @endif

                    {{-- Features List --}}
                    @if($product->features->count() > 0)
                        <div class="rounded-3xl bg-white dark:bg-slate-900/50 border border-slate-200 dark:border-white/10 p-6 sm:p-10 transition-[border-color,background-color,color] ">
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-8 flex items-center gap-3">
                                <span class="w-10 h-10 rounded-xl bg-primary-500/10 text-primary-600 flex items-center justify-center">
                                    <i class="ph ph-bold ph-shield-check"></i>
                                </span>
                                @lang('Included Features')
                                <span class="ml-auto px-3 py-1 bg-slate-100 dark:bg-white/5 rounded-full text-[10px] font-bold uppercase tracking-widest text-slate-500 dark:text-slate-400">{{ $product->features->count() }} @lang('features')</span>
                            </h3>
                            
                            
                            @if(count($groupedFeatures) > 1)
                                {{-- Grouped display --}}
                                <div class="space-y-4" x-data="{ openGroups: ['{{ array_key_first($groupedFeatures) }}'] }">
                                    @foreach($groupedFeatures as $groupKey => $group)
                                        <div class="border border-slate-200 dark:border-white/5 rounded-2xl overflow-hidden bg-slate-50/50 dark:bg-white/5">
                                            <button type="button" @click="openGroups.includes('{{ $groupKey }}') ? openGroups = openGroups.filter(g => g !== '{{ $groupKey }}') : openGroups.push('{{ $groupKey }}')"
                                                    class="w-full px-5 py-4 hover:bg-slate-100 dark:hover:bg-white/5 transition-[border-color,background-color,color] flex items-center justify-between group">
                                                <div class="flex items-center gap-3">
                                                    <i class="ph ph-bold ph-circles-four text-primary-500 text-lg"></i>
                                                    <span class="font-bold text-slate-900 dark:text-white text-sm uppercase tracking-tight">{{ $group['name'] }}</span>
                                                    <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold">({{ count($group['features']) }})</span>
                                                </div>
                                                <i class="ph ph-bold ph-caret-down text-slate-500 dark:text-slate-400 transition-transform duration-300"
                                                   :class="openGroups.includes('{{ $groupKey }}') ? 'rotate-180' : ''"></i>
                                            </button>
                                            <div x-show="openGroups.includes('{{ $groupKey }}')"
                                                 x-transition:enter="transition ease-out duration-300"
                                                 x-transition:enter-start="opacity-0 max-h-0"
                                                 x-transition:enter-end="opacity-100 max-h-screen"
                                                 class="p-5 grid grid-cols-1 md:grid-cols-2 gap-3 border-t border-slate-200 dark:border-white/5">
                                                @foreach($group['features'] as $feature)
                                                    <x-product-feature :feature="$feature" />
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                {{-- Simple list if no grouping --}}
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    @foreach($product->features as $feature)
                                        <x-product-feature :feature="$feature" />
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    @endif
                </div>

                {{-- Order Summary Sidebar --}}
                <div class="lg:col-span-1">
                    <div class="sticky top-32">
                        {{-- Card Decoration Glow --}}
                        <div class="absolute -inset-4 bg-gradient-to-r from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-primary-800/10 dark:to-primary-800/20 rounded-[2rem] blur-2xl opacity-60 pointer-events-none"></div>

                        <div class="relative overflow-hidden rounded-[2rem] bg-white dark:bg-slate-900/80 backdrop-blur-xl border border-slate-200 dark:border-white/10 shadow-2xl shadow-slate-200/50 dark:shadow-none p-8 transition-[border-color,background-color,box-shadow] duration-500">
                            
                            {{-- Header --}}
                            <div class="mb-6">
                                <h3 class="text-sm font-bold text-slate-900 dark:text-white mb-2 text-center uppercase tracking-[0.2em]">@lang('Your Order')</h3>
                                <div class="w-10 h-0.5 bg-primary-500 mx-auto rounded-full"></div>
                            </div>

                            <div class="space-y-6 mb-8">
                                {{-- Base Service --}}
                                <div class="flex justify-between items-center gap-3 p-4 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5">
                                    <div class="flex items-center gap-3 min-w-0">
                                        <div class="w-8 h-8 rounded-lg bg-primary-500 text-white flex items-center justify-center text-sm shrink-0">
                                            <i class="ph ph-bold ph-lightning"></i>
                                        </div>
                                        <div class="min-w-0">
                                            <span class="block text-slate-900 dark:text-white font-bold text-xs uppercase tracking-tight truncate">{{ __($product->name) }}</span>
                                            <span class="block text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase" x-text="'Cycle: ' + selectedCycle"></span>
                                        </div>
                                    </div>
                                    <span class="text-slate-900 dark:text-white font-bold text-sm whitespace-nowrap shrink-0" x-text="'{{ gs('cur_sym') }}' + price.toFixed(2)"></span>
                                </div>

                                {{-- Domain Addon --}}
                                <template x-if="domainSelected && selectedDomainName">
                                    <div class="flex justify-between items-start gap-4 p-4 rounded-2xl bg-green-500/5 border border-green-500/10 animate-fade-in">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 rounded-lg bg-green-500 text-white flex items-center justify-center text-sm">
                                                <i class="ph ph-bold ph-globe"></i>
                                            </div>
                                            <div>
                                                <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-tight" x-text="selectedDomainName"></span>
                                                <span class="block text-[10px] text-green-600 dark:text-green-500 font-bold uppercase tracking-widest">Included</span>
                                            </div>
                                        </div>
                                        <span class="text-slate-900 dark:text-white font-bold text-sm" x-text="'{{ gs('cur_sym') }}' + selectedDomainPrice.toFixed(2)"></span>
                                    </div>
                                </template>

                                {{-- ID Protection --}}
                                <template x-if="idProtection">
                                    <div class="flex justify-between items-start gap-4 p-4 rounded-2xl bg-primary-500/5 border border-primary-500/10 animate-fade-in">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 rounded-lg bg-primary-500 text-white flex items-center justify-center text-sm">
                                                <i class="ph ph-bold ph-shield-check"></i>
                                            </div>
                                            <div>
                                                <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-tight">@lang('WHOIS Privacy')</span>
                                                <span class="block text-[10px] text-primary-600 dark:text-primary-500 font-bold uppercase tracking-widest">Enabled</span>
                                            </div>
                                        </div>
                                        <span class="text-slate-900 dark:text-white font-bold text-sm" x-text="'{{ gs('cur_sym') }}' + idProtectionPrice.toFixed(2)"></span>
                                    </div>
                                </template>

                                {{-- Selected Addons --}}
                                <template x-for="addonId in selectedAddons" :key="addonId">
                                    <div class="flex justify-between items-start gap-4 p-4 rounded-2xl bg-primary-500/5 border border-primary-500/10 animate-fade-in">
                                        <div class="flex items-center gap-3">
                                            <div class="w-8 h-8 rounded-lg bg-primary-500 text-white flex items-center justify-center text-sm">
                                                <i class="ph ph-bold ph-plus"></i>
                                            </div>
                                            <div>
                                                <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-tight">@lang('Optional Addon')</span>
                                                <span class="block text-[10px] text-primary-600 dark:text-primary-500 font-bold uppercase tracking-widest">Selected</span>
                                            </div>
                                        </div>
                                        <span class="text-slate-900 dark:text-white font-bold text-sm" x-text="'{{ gs('cur_sym') }}' + addonPrices[addonId].toFixed(2)"></span>
                                    </div>
                                </template>

                                {{-- Setup Fee --}}
                                @if($product->setup_fee ?? 0)
                                <div class="flex justify-between items-start gap-4 p-4 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-slate-200 dark:bg-white/10 text-slate-600 dark:text-slate-400 flex items-center justify-center text-sm">
                                            <i class="ph ph-bold ph-wrench"></i>
                                        </div>
                                        <div>
                                            <span class="block text-slate-900 dark:text-white font-bold text-sm uppercase tracking-tight">@lang('Setup Fee')</span>
                                            <span class="block text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-widest">One-time</span>
                                        </div>
                                    </div>
                                    <span class="text-slate-900 dark:text-white font-bold text-sm">{{ gs('cur_sym') }}{{ number_format($product->setup_fee, 2) }}</span>
                                </div>
                                @endif
                            </div>

                            {{-- Grand Total --}}
                            <div class="pt-5 border-t border-slate-200 dark:border-white/10 mb-6">
                                <div class="flex justify-between items-center mb-1">
                                    <span class="text-slate-500 dark:text-slate-400 font-bold text-[10px] uppercase tracking-[0.2em]">@lang('Total Due')</span>
                                    <span class="text-primary-500 font-bold text-[10px] uppercase tracking-widest">@lang('Live')</span>
                                </div>
                                <div class="flex items-baseline gap-0.5">
                                    <span class="text-slate-500 dark:text-slate-400 dark:text-white/60 font-bold text-lg">{{ gs('cur_sym') }}</span>
                                    <span class="text-3xl font-bold text-slate-900 dark:text-white tracking-tighter" 
                                          x-text="(price + {{ $product->setup_fee ?? 0 }} + selectedDomainPrice + (idProtection ? idProtectionPrice : 0) + addonsTotal).toFixed(2)"></span>
                                </div>
                            </div>

                            {{-- Checkout Button --}}
                            <button type="submit" 
                                    :disabled="{{ $product->domain_register ? 'true' : 'false' }} && !domainSelected"
                                    class="group w-full inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-6 py-3 text-sm disabled:opacity-50 disabled:grayscale">
                                @lang('Continue')
                                <svg class="w-3.5 h-3.5 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                </svg>
                            </button>

                            <p class="text-center text-[10px] text-slate-500 dark:text-slate-400 mt-6 font-bold uppercase tracking-[0.2em] flex items-center justify-center gap-2">
                                <i class="ph ph-bold ph-shield-check text-green-500 text-sm"></i> @lang('SSL SECURED CHECKOUT')
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    {{-- Mobile Fixed Bottom Summary Bar (visible only on mobile/tablet where sidebar scrolls away) --}}
    <div class="fixed bottom-0 left-0 right-0 z-50 lg:hidden transform transition-transform duration-300"
         x-show="true"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="translate-y-full"
         x-transition:enter-end="translate-y-0">
        <div class="bg-white/95 dark:bg-slate-900/95 backdrop-blur-xl border-t border-slate-200 dark:border-white/10 shadow-[0_-4px_20px_rgba(0,0,0,0.1)] dark:shadow-[0_-4px_20px_rgba(0,0,0,0.3)] px-4 sm:px-6 py-3.5 safe-area-bottom">
            <div class="flex items-center justify-between gap-4 max-w-5xl mx-auto">
                <div>
                    <span class="block text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-[0.15em]">@lang('Total Due')</span>
                    <div class="flex items-baseline gap-0.5">
                        <span class="text-slate-500 dark:text-slate-400 dark:text-white/60 font-bold text-sm">{{ gs('cur_sym') }}</span>
                        <span class="text-2xl font-bold text-slate-900 dark:text-white tracking-tighter" 
                              x-text="(price + {{ $product->setup_fee ?? 0 }} + selectedDomainPrice + (idProtection ? idProtectionPrice : 0) + addonsTotal).toFixed(2)"></span>
                    </div>
                </div>
                <button type="submit" form="order-form"
                        :disabled="{{ $product->domain_register ? 'true' : 'false' }} && !domainSelected"
                        class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-7 py-2.5 text-sm disabled:opacity-50 disabled:grayscale">
                    @lang('Continue')
                    <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                    </svg>
                </button>
            </div>
        </div>
    </div>
</div>

@endsection
