@php
    $bottomCta = getContent('bottom_cta.content', true);
@endphp

{{-- Zero-Height Floating Container --}}
<div class="relative z-50 h-0 px-4 sm:px-6 md:px-10">
    <div class="max-w-7xl mx-auto -translate-y-1/4 sm:-translate-y-1/3 lg:-translate-y-1/2">
        {{-- The Card Itself --}}
        <div class="bg-white dark:bg-slate-900/40 backdrop-blur-xl border border-slate-200 dark:border-white/10 px-5 sm:px-6 md:px-10 lg:px-14 py-5 sm:py-8 md:py-10 rounded-2xl shadow-[0_30px_70px_-15px_rgba(0,0,0,0.1)] dark:shadow-[0_40px_80px_-20px_rgba(0,0,0,0.6)] flex flex-col lg:flex-row items-center justify-between gap-4 sm:gap-8 lg:gap-14 transition-[border-color,background-color,box-shadow,transform] duration-300">
            
            {{-- Heading --}}
            <h2 class="text-xl sm:text-2xl md:text-3xl font-bold text-slate-900 dark:text-white leading-tight tracking-tight text-center lg:text-left max-w-xl break-words">
                @php
                    $heading = __(@$bottomCta->data_values->heading ?? 'Get Worry-Free Web Hosting Today!');
                    // Highlight with Theme Color
                    $heading = str_replace('Worry-Free', '<span class="text-primary-600 dark:text-primary-400">Worry-Free</span>', $heading);
                @endphp
                {!! purify($heading) !!}
            </h2>

            {{-- Action Group --}}
            <div class="flex flex-col sm:flex-row items-center gap-4 sm:gap-8 lg:gap-12 shrink-0">
                {{-- Chat Link --}}
                <a href="{{ @$bottomCta->data_values->chat_link ?? '#' }}" class="text-primary-600 dark:text-primary-400 font-bold hover:text-primary-700 dark:hover:text-primary-300 transition-colors tracking-wide flex items-center group/chat">
                    <i class="ph ph-bold ph-chat-centered-dots mr-2 text-lg sm:text-2xl group-hover/chat:scale-110 transition-transform"></i>
                    <span class="text-xs sm:text-sm lg:text-base border-b-2 border-transparent group-hover/chat:border-primary-500/30 transition-[border-color,background-color,color]">{{ __(@$bottomCta->data_values->chat_text ?? 'Chat with an Expert') }}</span>
                </a>

                {{-- Primary CTA Button --}}
                <x-theme.btn-primary href="{{ @$bottomCta->data_values->button_link ?? '#' }}">
                    {{ __(@$bottomCta->data_values->button_text ?? 'Get Started') }}
                </x-theme.btn-primary>
            </div>
        </div>
    </div>
</div>
