@php
    use App\Services\PricingCalculatorService;
    $pricingCalculator = app(PricingCalculatorService::class);
    $categoriesContent = getContent('categories.content', true);
@endphp

<section class="relative py-12 lg:py-20 bg-slate-50 dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Background Decor - Astral Atmosphere --}}
    <div class="absolute inset-0 pointer-events-none">
        <div
            class="absolute top-1/2 left-1/4 w-[400px] h-[400px] bg-primary-600/5 rounded-full blur-[120px] animate-pulse-glow">
        </div>
        <div class="absolute bottom-0 right-1/4 w-[350px] h-[350px] bg-primary-600/5 rounded-full blur-[100px]"
            style="animation-delay: 2s;"></div>
        <div
            class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-20">
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-12">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {!! purify(__(@$categoriesContent->data_values->heading ?? 'Hosting Plans for <span class="text-transparent bg-clip-text bg-gradient-to-r from-primary-600 to-primary-400">Every Website</span>')) !!}
            </h2>
            <p class="text-slate-600 dark:text-slate-400 text-lg max-w-3xl mx-auto leading-relaxed transition-colors">
                {{ __(@$categoriesContent->data_values->subheading ?? 'From budget-friendly shared hosting to powerful virtual private servers, there\'s a solution for your website.') }}
            </p>
        </div>

        @php
            $displayCategories = $serviceCategories->take(4);
            $gridCols = 'lg:grid-cols-4';
        @endphp

        <div class="relative">
            <div class="flex flex-nowrap overflow-x-auto pb-4 snap-x snap-mandatory gap-6 lg:gap-8 scrollbar-hidden -mx-4 px-4 sm:mx-0 sm:px-0 lg:grid {{ $gridCols }} lg:overflow-visible lg:pb-0">
            @if(isset($displayCategories) && $displayCategories->count() > 0)
                @foreach($displayCategories as $category)
                    @php
                        $firstProduct = $category->activeProducts->first();
                        $pricingData = null;
                        if ($firstProduct) {
                            $pricingData = $pricingCalculator->getProductPricing($firstProduct);
                            $lCycle = $pricingData['longest_cycle'];
                            $priceInfo = $pricingData['cycles'][$lCycle];
                        }
                        
                        if (!empty($category->icon)) {
                            $iconClass = $category->icon;
                        } else {
                            $categoryIcons = [
                                'shared' => 'ph-share-network',
                                'wordpress' => 'ph-wordpress-logo',
                                'vps' => 'ph-hard-drives',
                                'dedicated' => 'ph-cpu',
                                'reseller' => 'ph-storefront',
                                'email' => 'ph-envelope-simple',
                                'cloud' => 'ph-cloud',
                                'domain' => 'ph-globe',
                            ];
                            $categorySlug = strtolower($category->slug);
                            $iconClass = 'ph-server';
                            foreach ($categoryIcons as $key => $icon) {
                                if (str_contains($categorySlug, $key)) {
                                    $iconClass = $icon;
                                    break;
                                }
                            }
                        }
                    @endphp
                    <div
                        class="flex-shrink-0 w-[85%] sm:w-[calc(50%-1rem)] snap-center lg:w-auto group relative bg-white dark:bg-slate-900/40 backdrop-blur-xl rounded-2xl p-6 border border-slate-200 dark:border-white/5 hover:border-primary-500/30 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-1 flex flex-col items-center text-center overflow-hidden shadow-lg dark:shadow-xl">
                        <div
                            class="absolute top-0 right-0 -mt-10 -mr-10 w-32 h-32 bg-primary-500/10 rounded-full blur-3xl opacity-0 group-hover:opacity-100 transition-opacity duration-700">
                        </div>

                        {{-- Phosphor Icon --}}
                        <div class="relative w-14 h-14 mb-5 rounded-xl bg-gradient-to-br from-primary-500/10 to-primary-700/10 border border-primary-500/20 flex items-center justify-center group-hover:scale-110 group-hover:rotate-6 transition-[border-color,background-color,box-shadow,transform] duration-500 shadow-md shadow-primary-500/10">
                            @php
                                if (str_contains($iconClass, 'ph-') && !str_contains($iconClass, 'ph ')) {
                                    $iconClass = 'ph ' . $iconClass;
                                } elseif (!str_contains($iconClass, 'ph ')) {
                                    $iconClass = 'ph-' . $iconClass;
                                }
                            @endphp
                            <i class="{{ $iconClass }} text-3xl text-primary-500 group-hover:text-primary-500 transition-colors duration-500"></i>
                        </div>

                        <h3
                            class="text-xl font-bold text-slate-900 dark:text-white mb-4 group-hover:text-primary-500 dark:group-hover:text-primary-400 transition-colors tracking-tight">
                            {{ __($category->name) }}</h3>
                        <p class="text-slate-600 dark:text-slate-400 text-sm leading-relaxed mb-6 flex-1">
                            {{ __($category->description ?? 'Fast, reliable hosting for your websites.') }}</p>

                        <div class="w-full pt-5 border-t border-slate-100 dark:border-white/5 mb-5 transition-colors">
                            <p class="text-[10px] text-slate-400 dark:text-slate-500 uppercase tracking-[0.2em] font-bold mb-2">
                                @lang('Starting at')</p>
                            @if($pricingData)
                                <div class="flex flex-col items-center">
                                    <div class="flex items-center justify-center gap-1">
                                        <span class="text-primary-500 font-bold text-lg self-start mt-1">{{ gs('cur_sym') }}</span>
                                        <span class="text-3xl font-extrabold text-slate-900 dark:text-white tracking-tight transition-colors">
                                            {{ showAmount($priceInfo['discounted_monthly'], 2, true, false, false) }}
                                        </span>
                                        <span class="text-slate-400 dark:text-slate-500 text-sm font-medium ml-1 transition-colors">/mo</span>
                                    </div>
                                    
                                    @if($priceInfo['has_discount'])
                                        <div class="flex items-center gap-2 mt-1">
                                            <span class="text-slate-400 dark:text-slate-500 text-sm line-through transition-colors">{{ $priceInfo['original_monthly_formatted'] }}</span>
                                            <span class="px-1.5 py-0.5 rounded border border-primary-500/30 bg-primary-500/5 text-[10px] font-bold text-primary-500 uppercase">
                                                SAVE -{{ $priceInfo['discount_percentage'] }}%
                                            </span>
                                        </div>
                                    @endif
                                </div>
                            @else
                                <div class="flex items-center justify-center gap-1">
                                    <span class="text-primary-500 font-bold text-lg self-start mt-1">{{ gs('cur_sym') }}</span>
                                    <span class="text-3xl font-extrabold text-slate-900 dark:text-white tracking-tight transition-colors">1.99</span>
                                    <span class="text-slate-400 dark:text-slate-500 text-sm font-medium ml-1 transition-colors">/mo</span>
                                </div>
                            @endif
                        </div>

                        <x-theme.btn-primary href="{{ route('products.category', $category->slug) }}" full>
                            @lang('Browse Products')
                        </x-theme.btn-primary>
                    </div>
                @endforeach
            @else
                {{-- Fallback Static Categories --}}
                @php
                    $defaultCategories = [
                        ['title' => 'Shared Hosting', 'desc' => 'Get Your Website Up and Running Easily and Affordably with Our Hosting Solutions.', 'price' => '1.99', 'slug' => 'shared'],
                        ['title' => 'WordPress Hosting', 'desc' => 'Power Your WordPress Website with Fast, Reliable, and Secure Hosting Solutions.', 'price' => '1.99', 'slug' => 'wordpress'],
                        ['title' => 'Reseller Hosting', 'desc' => 'Effortlessly Manage Multiple Websites and Earn Extra Income with WHM.', 'price' => '5.99', 'slug' => 'reseller'],
                        ['title' => 'Email Hosting', 'desc' => 'Easy, affordable email hosting that matches your domain.', 'price' => '2.99', 'slug' => 'email'],
                    ];
                @endphp
                @foreach($defaultCategories as $index => $cat)
                    @php
                        $fallbackIcons = [
                            'Shared Hosting' => 'ph-share-network',
                            'WordPress Hosting' => 'ph-wordpress-logo',
                            'Reseller Hosting' => 'ph-storefront',
                            'Email Hosting' => 'ph-envelope-simple',
                        ];
                        $fIconName = $fallbackIcons[$cat['title']] ?? 'ph-server';
                    @endphp
                    <div
                        class="group relative bg-white dark:bg-slate-900/40 backdrop-blur-xl rounded-2xl p-6 border border-slate-200 dark:border-white/5 hover:border-primary-500/30 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-1 flex flex-col items-center text-center overflow-hidden shadow-lg dark:shadow-xl">
                        <div
                            class="absolute top-0 right-0 -mt-10 -mr-10 w-32 h-32 bg-primary-500/10 rounded-full blur-3xl opacity-0 group-hover:opacity-100 transition-opacity duration-700">
                        </div>

                        {{-- Phosphor Icon --}}
                        <div class="relative w-14 h-14 mb-5 rounded-xl bg-gradient-to-br from-primary-500/10 to-primary-700/10 border border-primary-500/20 flex items-center justify-center group-hover:scale-110 group-hover:rotate-6 transition-[border-color,background-color,box-shadow,transform] duration-500 shadow-md shadow-primary-500/10">
                            <i class="ph {{ $fIconName }} text-3xl text-primary-500 group-hover:text-primary-500 transition-colors duration-500"></i>
                        </div>

                        <h3
                            class="text-xl font-bold text-slate-900 dark:text-white mb-4 group-hover:text-primary-500 dark:group-hover:text-primary-400 transition-colors tracking-tight">
                            {{ __($cat['title']) }}</h3>
                        <p class="text-slate-600 dark:text-slate-400 text-sm leading-relaxed mb-6 flex-1 transition-colors">{{ __($cat['desc']) }}</p>

                        <div class="w-full pt-5 border-t border-slate-100 dark:border-white/5 mb-5 transition-colors">
                            <p class="text-[10px] text-slate-400 dark:text-slate-500 uppercase tracking-[0.2em] font-bold mb-2">
                                @lang('Starting at')</p>
                            <div class="flex items-center justify-center gap-1">
                                <span class="text-primary-500 font-bold text-lg self-start mt-1">{{ gs('cur_sym') }}</span>
                                <span class="text-3xl font-extrabold text-slate-900 dark:text-white tracking-tight transition-colors">{{ $cat['price'] }}</span>
                                <span class="text-slate-400 dark:text-slate-500 text-sm font-medium ml-1 transition-colors">/mo</span>
                            </div>
                        </div>

                        <x-theme.btn-primary href="{{ route('pricing') }}" full>
                            @lang('Browse Products')
                        </x-theme.btn-primary>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</section>