@php
    use App\Services\PricingCalculatorService;
    $pricingCalculator = app(PricingCalculatorService::class);
    $billingCycles = PricingCalculatorService::BILLING_CYCLES;

    // Use the category passed from composer or fallback
    if (!isset($category) || !$category) {
        return;
    }

    $activeProducts = $category->activeProducts()->with('pricing')->get();
    $longestCycle = $pricingCalculator->getGlobalLongestCycle($activeProducts);

    $pricingContent = getContent('pricing.content', true);
@endphp

<section id="pricing" class="relative py-24 lg:py-32 bg-slate-50 dark:bg-slate-950 transition-colors duration-500" x-data="{
    billingCycle: '{{ $longestCycle }}'
}">
    {{-- Ambient Background --}}
    <div class="absolute inset-0 pointer-events-none overflow-hidden">
        <div class="absolute top-[-20%] right-[-10%] w-[600px] h-[600px] bg-gradient-to-br from-primary-500/8 via-primary-600/5 to-transparent rounded-full blur-[120px] animate-blob"></div>
        <div class="absolute bottom-[-20%] left-[-10%] w-[500px] h-[500px] bg-gradient-to-tr from-primary-500/6 via-primary-500/3 to-transparent rounded-full blur-[100px] animate-blob" style="animation-delay: 3s;"></div>
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.02)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.015)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.015)_1px,transparent_1px)] bg-[size:64px_64px] [mask-image:radial-gradient(ellipse_60%_60%_at_50%_50%,black_20%,transparent_100%)]"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Header --}}
        <div class="text-center mb-16 lg:mb-20">
            <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-6">
                <span class="w-1.5 h-1.5 rounded-full bg-primary-500 animate-pulse"></span>
                <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-primary-600 dark:text-primary-400">@lang('Transparent Pricing')</span>
            </div>
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __($category->name) }} @lang('Plans')
            </h2>
            <p class="text-lg text-slate-500 dark:text-slate-400 max-w-2xl mx-auto leading-relaxed font-medium">
                {{ __($category->short_description ?? 'Choose from our range of optimized solutions designed to scale with your business.') }}
            </p>

            {{-- Billing Cycle Switcher --}}
            <div class="mt-10 w-full overflow-hidden">
                <x-theme.pricing.cycle-switcher 
                    :cycles="$billingCycles" 
                    :selected="$longestCycle"
                    class="justify-center"
                />
            </div>
        </div>

        {{-- Pricing Grid --}}
        <div class="flex flex-col lg:grid lg:grid-cols-3 gap-6 lg:gap-8 lg:items-start">
            @foreach($activeProducts as $product)
                @php
                    $pricingData = $pricingCalculator->getProductPricingForJs($product);
                    $isRecommended = $product->is_recommended;
                    $stickyTop = 80 + ($loop->index * 16);
                @endphp

                <div class="group relative {{ $isRecommended ? 'lg:-mt-4 lg:mb-4' : '' }} sticky lg:relative z-[{{ 10 + $loop->index }}]"
                     x-data='{ pricing: @json($pricingData) }'
                     style="top: {{ $stickyTop }}px;"
                >
                    
                    {{-- Glow effect for recommended --}}
                    @if($isRecommended)
                        <div class="absolute -inset-1 bg-gradient-to-b from-primary-500/30 via-primary-500/10 to-primary-600/20 rounded-[2rem] blur-xl opacity-60 group-hover:opacity-80 transition-opacity duration-700"></div>
                    @endif

                    <div class="relative h-full flex flex-col rounded-[1.75rem] transition-all duration-500 group-hover:-translate-y-1 overflow-hidden
                        {{ $isRecommended 
                            ? 'bg-gradient-to-b from-slate-900 via-slate-900 to-slate-950 dark:from-slate-800 dark:via-slate-850 dark:to-slate-900 border-2 border-primary-500/50 shadow-2xl shadow-primary-500/10' 
                            : 'bg-white dark:bg-slate-900 border border-slate-200/80 dark:border-white/[0.08] shadow-xl shadow-slate-200/40 dark:shadow-none hover:border-primary-500/30 dark:hover:border-primary-500/20 hover:shadow-primary-500/5' 
                        }}">
                        
                        {{-- Inner glow effect --}}
                        <div class="absolute inset-0 pointer-events-none">
                            @if($isRecommended)
                                <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[80%] h-32 bg-gradient-to-b from-primary-500/20 to-transparent blur-2xl"></div>
                                <div class="absolute bottom-0 left-1/2 -translate-x-1/2 w-[60%] h-20 bg-gradient-to-t from-primary-500/10 to-transparent blur-2xl"></div>
                            @else
                                <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[70%] h-24 bg-gradient-to-b from-primary-500/0 dark:from-primary-500/10 to-transparent blur-2xl transition-opacity duration-500 opacity-0 dark:opacity-100 group-hover:opacity-100"></div>
                            @endif
                        </div>
                        
                        {{-- Recommended badge --}}
                        @if($isRecommended)
                            <div class="absolute -top-4 left-1/2 -translate-x-1/2 z-20">
                                <div class="relative px-5 py-1.5 rounded-full bg-gradient-to-r from-primary-500 to-primary-600 shadow-lg shadow-primary-500/30">
                                    <span class="relative text-[10px] font-black uppercase tracking-[0.2em] text-white">@lang('Most Popular')</span>
                                </div>
                            </div>
                        @endif

                        {{-- Card top accent line --}}
                        <div class="absolute top-0 inset-x-0 h-px bg-gradient-to-r from-transparent {{ $isRecommended ? 'via-primary-400' : 'via-slate-300 dark:via-white/10' }} to-transparent"></div>

                        <div class="p-8 pb-0">
                            {{-- Plan Name + Description --}}
                            <div class="mb-8">
                                <h3 class="text-lg font-bold uppercase tracking-widest mb-2 {{ $isRecommended ? 'text-white' : 'text-slate-900 dark:text-white' }}">
                                    {{ __($product->name) }}
                                </h3>
                                <p class="text-sm font-medium leading-relaxed {{ $isRecommended ? 'text-slate-400' : 'text-slate-500 dark:text-slate-400' }}">
                                    {{ Str::limit($product->tagline ?? $product->description, 100) }}
                                </p>
                            </div>

                            {{-- Price Block --}}
                            <div class="mb-8 min-h-[90px]">
                                <template x-if="pricing.prices[billingCycle]">
                                    <div>
                                        <div class="flex items-baseline gap-1">
                                            <span class="text-lg font-bold {{ $isRecommended ? 'text-slate-400' : 'text-slate-400 dark:text-slate-500' }}">{{ gs('cur_sym') }}</span>
                                            <span class="text-5xl font-extrabold tracking-tighter {{ $isRecommended ? 'text-white' : 'text-slate-900 dark:text-white' }}" x-text="pricing.prices[billingCycle].display_raw"></span>
                                            <span class="text-sm font-bold uppercase tracking-widest {{ $isRecommended ? 'text-slate-500 dark:text-slate-400' : 'text-slate-400' }}">/mo</span>
                                        </div>
                                        
                                        <div class="mt-3 flex items-center gap-3" x-show="pricing.prices[billingCycle].has_discount">
                                            <span class="text-sm line-through font-medium {{ $isRecommended ? 'text-slate-500 dark:text-slate-400' : 'text-slate-400' }}" x-text="pricing.prices[billingCycle].original_raw"></span>
                                            <span class="px-2.5 py-1 rounded-lg text-[10px] font-black uppercase tracking-widest {{ $isRecommended ? 'bg-primary-500/20 text-primary-300' : 'bg-green-500/10 text-green-600 dark:text-green-400' }}">
                                                @lang('SAVE') <span x-text="pricing.prices[billingCycle].discount_badge"></span>
                                            </span>
                                        </div>
                                    </div>
                                </template>
                            </div>

                            {{-- CTA Button --}}
                            <div class="mb-8">
                                <a :href="pricing.prices[billingCycle] ? '{{ route('products.order', [$category->slug, $product->slug]) }}?billing_cycle=' + billingCycle : '{{ route('contact') }}'" 
                                   class="group/btn w-full h-12 rounded-xl font-bold text-sm transition-all duration-300 flex items-center justify-center gap-2 bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 hover:scale-[1.02] active:scale-[0.98]">
                                    <span x-text="pricing.prices[billingCycle] ? '{{ __('Get Started') }}' : '{{ __('Contact Sales') }}'"></span>
                                    <svg class="w-4 h-4 group-hover/btn:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                    </svg>
                                </a>
                            </div>
                        </div>

                        {{-- Features --}}
                        <div class="px-8 pb-8 pt-6 border-t {{ $isRecommended ? 'border-white/10' : 'border-slate-100 dark:border-white/5' }}">
                            <p class="text-[10px] font-bold uppercase tracking-[0.2em] mb-5 {{ $isRecommended ? 'text-slate-500 dark:text-slate-400' : 'text-slate-400' }}">@lang('What\'s included')</p>
                            <div class="space-y-3.5">
                                @foreach($product->features->take(8) as $feature)
                                    <div class="flex items-center gap-3 group/feat">
                                        @if($feature->type === 'excluded')
                                            <div class="flex-shrink-0 w-5 h-5 rounded-full {{ $isRecommended ? 'bg-white/5 text-slate-600' : 'bg-slate-100 dark:bg-white/5 text-slate-300 dark:text-slate-600' }} flex items-center justify-center">
                                                <i class="ph ph-x text-[10px] font-bold"></i>
                                            </div>
                                            <span class="text-sm font-medium line-through {{ $isRecommended ? 'text-slate-600' : 'text-slate-400 dark:text-slate-500' }}">
                                                {{ \App\Helpers\FeatureHelper::getCombinedValue($feature) }}
                                            </span>
                                        @else
                                            <div class="flex-shrink-0 w-5 h-5 rounded-full {{ $isRecommended ? 'bg-primary-500/20 text-primary-400' : 'bg-primary-500/10 text-primary-500' }} flex items-center justify-center transition-colors group-hover/feat:bg-primary-500 group-hover/feat:text-white">
                                                <i class="ph ph-check text-[10px] font-bold"></i>
                                            </div>
                                            <span class="text-sm font-medium {{ $isRecommended ? 'text-slate-300' : 'text-slate-600 dark:text-slate-300' }}">
                                                {{ \App\Helpers\FeatureHelper::getCombinedValue($feature) }}
                                            </span>
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
