@php
    $ctaContent = getContent('cta.content', true);
@endphp

<section class="relative py-12 lg:py-20 bg-white dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Background Effects --}}
    <div class="absolute inset-0 pointer-events-none">
        <div
            class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[400px] h-[400px] bg-primary-600/5 dark:bg-primary-600/20 rounded-full blur-[150px] animate-pulse-glow">
        </div>
        <div
            class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.02)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:40px_40px] opacity-30 dark:opacity-30">
        </div>
    </div>

    <div class="relative z-10 max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div
            class="relative bg-gradient-to-br from-primary-50 dark:from-primary-600/20 via-white dark:via-slate-950/80 to-primary-50 dark:to-primary-600/20 border border-slate-200 dark:border-white/10 rounded-2xl p-6 lg:p-10 text-center overflow-hidden backdrop-blur-lg shadow-xl shadow-slate-200/50 dark:shadow-primary-500/10 transition-[border-color,background-color,box-shadow,transform] duration-300">
            {{-- Inner Glow --}}
            <div
                class="absolute top-0 left-1/4 w-[300px] h-[300px] bg-primary-500/10 dark:bg-primary-500/30 rounded-full blur-[100px] pointer-events-none">
            </div>
            <div
                class="absolute bottom-0 right-1/4 w-[200px] h-[200px] bg-primary-500/5 dark:bg-primary-500/20 rounded-full blur-[80px] pointer-events-none">
            </div>

            <div class="relative z-10">
                <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                    {{ __(@$ctaContent->data_values->heading ?? 'Ready to Launch Your Digital Empire?') }}
                </h2>
                <p class="text-slate-600 dark:text-slate-300 text-base max-w-2xl mx-auto mb-8 leading-relaxed">
                    {{ __(@$ctaContent->data_values->subheading ?? 'Join thousands of businesses already powered by our infrastructure. Get started in seconds, not hours.') }}
                </p>

                <div class="flex flex-col sm:flex-row gap-5 justify-center items-center">
                    <x-theme.btn-primary href="{{ @$ctaContent->data_values->button_url ?? route('client.register') }}">
                        {{ __(@$ctaContent->data_values->button_text ?? 'Start Free Trial') }}
                    </x-theme.btn-primary>
                    <x-theme.btn-secondary href="{{ route('pricing') }}">
                        <i class="ph ph-bold ph-chart-bar text-xl"></i>
                        @lang('Compare Plans')
                    </x-theme.btn-secondary>
                </div>

                {{-- Trust Indicators --}}
                <div
                    class="mt-8 pt-6 border-t border-slate-100 dark:border-white/10 flex flex-wrap justify-center items-center gap-5 text-sm text-slate-500 dark:text-slate-400">
                    <span class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        @lang('No Credit Card Required')
                    </span>
                    <span class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        @lang('Deploy in 60 Seconds')
                    </span>
                    <span class="flex items-center gap-2">
                        <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                        </svg>
                        @lang('Cancel Anytime')
                    </span>
                </div>
            </div>
        </div>
    </div>
</section>