@php
    $domainContent = getContent('domain.content', true);
@endphp

<section class="relative pt-28 pb-20 bg-surface-offwhite dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Animated Background Pattern --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute inset-0 bg-[url('{{ getImage('assets/images/frontend/noise.svg') }}')] opacity-[0.03] dark:opacity-20 mix-blend-soft-light"></div>
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.02)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:50px_50px] opacity-100"></div>
        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-[700px] h-[400px] bg-gradient-to-b from-primary-500/10 dark:from-primary-600/20 via-primary-500/5 dark:via-primary-600/5 to-transparent rounded-full blur-[120px] opacity-50"></div>
        <div class="absolute -bottom-24 -right-24 w-96 h-96 bg-primary-500/5 dark:bg-primary-600/10 rounded-full blur-[100px]"></div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-6 lg:px-8">
        {{-- Header Section --}}
        <div class="text-center max-w-4xl mx-auto mb-10 animate-fade-in-up">
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight leading-tight">
                {{ __(@$domainContent->data_values->heading ?? 'Search and Buy a Domain') }}
            </h2>
            <p class="text-lg sm:text-xl text-slate-500 dark:text-slate-400 font-medium leading-relaxed max-w-2xl mx-auto">
                {{ __(@$domainContent->data_values->subheading ?? 'Grab the domain you’ve been looking for') }}
            </p>
        </div>

        {{-- Main Search Card --}}
        <div class="max-w-5xl mx-auto" x-data="tldPricingList()" x-init="init()">
            <div class="relative group">
                {{-- Card Glow Effect --}}
                <div class="absolute -inset-1 bg-gradient-to-r from-primary-500/20 to-primary-500/20 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition duration-1000"></div>
                
                <div class="relative bg-white dark:bg-slate-900/40 backdrop-blur-xl border border-slate-200 dark:border-white/10 rounded-2xl p-4 md:p-6 shadow-lg dark:shadow-xl shadow-slate-200/50 dark:shadow-black/50 overflow-hidden transition-[border-color,background-color,box-shadow,transform] duration-300">
                    {{-- Search Form --}}
                    <div class="relative z-20">
                        <div class="flex flex-col md:flex-row gap-4">
                            <div class="relative flex-1">
                                <div class="absolute inset-y-0 left-0 pl-6 flex items-center pointer-events-none">
                                    <i class="ph ph-bold ph-magnifying-glass text-2xl text-primary-500 dark:text-primary-400 group-focus-within:text-primary-500 transition-colors"></i>
                                </div>
                                <input type="text" x-model="searchQuery" @input="handleSearch()" @keydown.enter.prevent="loadInitialResults()"
                                       placeholder="{{ __(@$domainContent->data_values->input_placeholder ?? 'Search for a keyword') }}"
                                       class="w-full h-12 pl-14 pr-6 bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white text-base font-medium placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:ring-2 focus:ring-primary-500/30 dark:focus:ring-primary-500/50 focus:border-primary-500 transition-[border-color,background-color,color]">
                            </div>
                            <button type="button" @click="loadInitialResults()"
                                    class="h-12 px-8 bg-primary-600 hover:bg-primary-700 text-white font-bold text-sm rounded-xl shadow-lg shadow-primary-500/30 transition-[background-color,color,transform] hover:scale-[1.02] active:scale-95 flex items-center justify-center gap-2">
                                <span x-show="!loading">{{ __(@$domainContent->data_values->button_text ?? 'Search') }}</span>
                                <template x-if="loading">
                                    <div class="animate-spin h-5 w-5 border-2 border-white/30 border-t-white rounded-full"></div>
                                </template>
                            </button>
                        </div>
                    </div>
                    
                    {{-- Dynamic Categories Grid --}}
                    @if($realCategories->count() > 0)
                        <div class="mt-8 pt-8 border-t border-slate-100 dark:border-white/10 pb-4">
                            <div class="flex gap-4 overflow-x-auto scrollbar-hide pb-2 md:flex-wrap md:justify-center md:overflow-visible">
                                @foreach($realCategories as $cat)
                                    <button type="button" 
                                       @click="filterByCategory({{ $cat->id }})"
                                       class="flex flex-col items-center group/cat focus:outline-none shrink-0 min-w-[60px]">
                                        <div :class="categoryId == {{ $cat->id }} ? 'bg-primary-600 scale-110 shadow-primary-500/20' : 'bg-slate-100 dark:bg-primary-600 shadow-slate-200/50 dark:shadow-primary-900/40'"
                                             class="w-12 h-12 md:w-14 md:h-14 rounded-xl md:rounded-2xl flex items-center justify-center mb-3 transition-[background-color,transform] duration-300 group-hover/cat:bg-primary-600 group-hover/cat:scale-110 group-hover/cat:rotate-3 shadow-lg">
                                            <i class="{{ $cat->icon ?: 'ph-duotone ph-star' }} text-2xl transition-transform group-hover/cat:scale-110"
                                               :class="categoryId == {{ $cat->id }} ? 'text-white' : 'text-slate-600 dark:text-white group-hover/cat:text-white'"></i>
                                        </div>
                                        <span :class="categoryId == {{ $cat->id }} ? 'text-primary-600 dark:text-white' : 'text-slate-500 dark:text-slate-400'"
                                              class="text-xs font-bold uppercase tracking-widest transition-colors group-hover/cat:text-primary-600 dark:group-hover/cat:text-white text-center">
                                            {{ __($cat->name) }}
                                        </span>
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif

                    {{-- Error State --}}
                    <div x-show="errorMessage" class="mt-8 pt-8 border-t border-slate-100 dark:border-white/10 animate-fade-in">
                        <div class="p-8 rounded-2xl bg-primary-500/5 border border-primary-500/10 text-center">
                            <div class="w-16 h-16 bg-primary-500/10 text-primary-500 rounded-full flex items-center justify-center mx-auto mb-6">
                                <i class="ph ph-bold ph-warning-octagon text-3xl"></i>
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-2">@lang('Something went wrong')</h3>
                            <p class="text-slate-500 dark:text-slate-400 mb-8 max-w-md mx-auto" x-text="errorMessage"></p>
                            <x-theme.btn-primary type="button" @click="loadInitialResults()" :icon="false">
                                @lang('Retry Search')
                            </x-theme.btn-primary>
                        </div>
                    </div>

                    {{-- Skeleton Loaders --}}
                    <div x-show="loading && results.length === 0" class="mt-8 pt-8 border-t border-slate-100 dark:border-white/10 space-y-8 animate-fade-in">
                        <div class="h-48 rounded-2xl bg-slate-100 dark:bg-white/5 animate-shimmer overflow-hidden relative">
                            <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/10 to-transparent -translate-x-full animate-shimmer-slide"></div>
                        </div>
                        <div class="bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/5 rounded-2xl overflow-hidden">
                            <div class="space-y-px divide-y divide-slate-100 dark:divide-white/5">
                                @for($i=0; $i<5; $i++)
                                <div class="h-20 bg-white/50 dark:bg-transparent relative overflow-hidden">
                                     <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/5 to-transparent -translate-x-full animate-shimmer-slide"></div>
                                </div>
                                @endfor
                            </div>
                        </div>
                    </div>

                    {{-- SEARCH RESULTS AREA (INSIDE CARD) --}}
                    <div x-show="isSearchActive && results.length > 0" 
                         x-transition:enter="transition ease-out duration-300"
                         x-transition:enter-start="opacity-0"
                         x-transition:enter-end="opacity-100"
                         class="mt-8 pt-8 border-t border-slate-100 dark:border-white/10 space-y-8 pb-4">
                        
                        {{-- Featured .com Result --}}
                        <template x-for="tld in [results.find(r => r.extension === '.com')]" :key="'featured-com'">
                            <template x-if="tld">
                                <div class="relative overflow-hidden p-6 rounded-2xl bg-gradient-to-br from-primary-600 to-primary-800 text-white shadow-xl shadow-primary-500/30">
                                    <div class="absolute top-0 right-0 p-8 opacity-10">
                                        <i class="ph-fill ph-star text-6xl"></i>
                                    </div>
                                    <div class="relative z-10 flex flex-col md:flex-row items-center justify-between gap-8">
                                        <div class="flex-1 text-center md:text-left">
                                            <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-white/10 border border-white/20 text-[10px] font-bold uppercase tracking-widest mb-4">
                                                <i class="ph-fill ph-crown text-primary-400"></i>
                                                <span>Featured Extension</span>
                                            </div>
                                            <h2 class="text-2xl sm:text-3xl font-bold tracking-tight mb-2" x-text="tld.domain"></h2>
                                            <div class="flex flex-wrap items-center justify-center md:justify-start gap-4">
                                                <template x-if="tld.available === true">
                                                    <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-xl bg-green-500/20 border border-green-500/30 text-green-400 font-bold text-sm">
                                                        <i class="ph ph-bold ph-check"></i>
                                                        Available
                                                    </span>
                                                </template>
                                                <template x-if="tld.available === false">
                                                    <span class="inline-flex items-center gap-2 px-4 py-1.5 rounded-xl bg-red-500/20 border border-red-500/30 text-red-200 font-bold text-sm">
                                                        <i class="ph ph-bold ph-x"></i>
                                                        Unavailable
                                                    </span>
                                                </template>
                                            </div>
                                        </div>
                                        
                                        <div class="flex flex-col items-center md:items-end gap-4 min-w-[200px]">
                                            <template x-if="tld.available === true">
                                                <div class="text-center md:text-right">
                                                    <div class="text-3xl font-extrabold" x-text="tld.formatted_pricing.registration"></div>
                                                    <div class="text-sm font-medium opacity-70">per year</div>
                                                    <button @click="addToCart(tld)" 
                                                        class="mt-4 w-full md:w-auto px-7 py-2.5 bg-white dark:bg-white/10 text-primary-950 dark:text-white hover:bg-primary-600 hover:text-white font-bold rounded-xl shadow-lg transition-[background-color,color,transform] hover:scale-[1.05] active:scale-95 flex items-center justify-center gap-2">
                                                        <span>Register Now</span>
                                                        <i class="ph ph-bold ph-arrow-right"></i>
                                                    </button>
                                                </div>
                                            </template>
                                            <template x-if="tld.available === false">
                                                <div class="text-center md:text-right opacity-50">
                                                    <div class="text-3xl font-extrabold line-through" x-text="tld.formatted_pricing.registration"></div>
                                                    <span class="text-sm font-bold uppercase tracking-widest text-red-200">Already Taken</span>
                                                </div>
                                            </template>
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </template>

                        {{-- Results Header / Filter Status --}}
                        <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 px-2">
                            <div>
                                <h3 class="text-xl font-bold text-slate-900 dark:text-white px-2">
                                    <span x-show="!categoryId">Other Extensions</span>
                                    <span x-show="categoryId" x-text="'Results for ' + (categories.find(c => c.id == categoryId)?.name || 'Category')"></span>
                                </h3>
                                <p class="text-[10px] text-slate-500 dark:text-slate-400 font-bold uppercase tracking-[0.2em] px-2 mt-1" x-text="results.length + ' Extensions Listed'"></p>
                            </div>
                            
                            {{-- Quick Clear --}}
                            <button x-show="categoryId" @click="filterByCategory(null)" 
                                    class="text-[10px] font-bold uppercase tracking-widest text-primary-600 dark:text-primary-400 hover:text-primary-700 dark:hover:text-primary-300 flex items-center gap-2 px-2 transition-colors">
                                <i class="ph ph-bold ph-x"></i>
                                <span>Show all categories</span>
                            </button>
                        </div>

                        {{-- Flat Results Table --}}
                        <div class="bg-slate-50 dark:bg-black/20 border border-slate-200 dark:border-white/5 rounded-2xl overflow-hidden shadow-inner transition-colors duration-300">
                            <div class="overflow-x-auto">
                                <table class="w-full text-left border-collapse">
                                    <tbody class="divide-y divide-slate-200 dark:divide-white/5">
                                        <template x-for="(tld, index) in results" :key="`hero-tld-${index}-${tld.id}`">
                                            <tr class="group/tr hover:bg-white dark:hover:bg-white/[0.01] transition-colors">
                                                <td class="px-6 py-5">
                                                    <div class="flex items-center gap-4">
                                                        <div class="w-10 h-10 rounded-xl bg-white dark:bg-white/5 flex items-center justify-center text-primary-600 dark:text-primary-400 group-hover/tr:text-primary-500 transition-colors shadow-sm border border-slate-100 dark:border-transparent">
                                                            <i class="ph ph-bold ph-globe"></i>
                                                        </div>
                                                        <span class="text-base font-bold text-slate-900 dark:text-white group-hover/tr:text-primary-600 transition-colors" x-text="tld.domain"></span>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-5 hidden md:table-cell">
                                                    <span class="text-[10px] font-bold uppercase tracking-widest px-2.5 py-1 rounded-lg bg-primary-50 dark:bg-primary-500/10 text-primary-600 dark:text-primary-400 border border-primary-100 dark:border-white/10" x-text="tld.category_name || 'General'"></span>
                                                </td>
                                                <td class="px-6 py-5">
                                                    <div class="flex flex-col">
                                                        <template x-if="tld.available === true">
                                                            <div class="flex items-baseline gap-1">
                                                                <span class="text-base font-bold text-slate-900 dark:text-white" x-text="tld.formatted_pricing.registration"></span>
                                                                <span class="text-[10px] text-slate-500 dark:text-slate-400 font-bold">/yr</span>
                                                            </div>
                                                        </template>
                                                        <template x-if="tld.available === false">
                                                            <span class="text-[10px] font-bold uppercase tracking-widest text-red-500 bg-red-50 dark:bg-red-500/10 px-2 py-1 rounded-lg">Taken</span>
                                                        </template>
                                                        <template x-if="tld.available === null">
                                                            <span class="text-[10px] font-bold uppercase tracking-widest text-slate-500 dark:text-slate-400 animate-pulse">Checking...</span>
                                                        </template>
                                                    </div>
                                                </td>
                                                <td class="px-6 py-5 text-right">
                                                    <template x-if="tld.available === true">
                                                        <button @click="addToCart(tld)" 
                                                                class="h-11 px-6 bg-primary-600 hover:bg-primary-700 text-white text-xs font-bold rounded-lg shadow-md shadow-primary-500/20 transition-[background-color,color,transform] active:scale-95 group/btn flex items-center gap-2 ml-auto">
                                                            <span>Add</span>
                                                            <i class="ph ph-plus-bold group-hover/btn:rotate-90 transition-transform"></i>
                                                        </button>
                                                    </template>
                                                    <template x-if="tld.available === false">
                                                        <div class="flex items-center gap-2 text-slate-500 dark:text-slate-400 ml-auto justify-end">
                                                            <i class="ph ph-prohibit-bold text-lg"></i>
                                                        </div>
                                                    </template>
                                                </td>
                                            </tr>
                                        </template>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        {{-- Load More --}}
                        <div x-show="hasMore" class="pt-4 text-center">
                            <button @click="loadMore()" :disabled="loadingMore"
                                    class="h-10 px-8 bg-white dark:bg-white/5 hover:bg-slate-50 dark:hover:bg-white/10 text-slate-900 dark:text-white text-xs font-bold rounded-xl border border-slate-200 dark:border-white/10 shadow-sm transition-[background-color,border-color,color,transform] flex items-center gap-3 mx-auto active:scale-95 disabled:opacity-50">
                                <span x-show="!loadingMore">Show More Results</span>
                                <template x-if="loadingMore">
                                    <div class="animate-spin h-4 w-4 border-2 border-primary-500/30 border-t-primary-500 rounded-full"></div>
                                </template>
                            </button>
                        </div>
                    </div>

                    {{-- Empty State --}}
                    <div x-show="isSearchActive && results.length === 0 && !loading" class="mt-8 pt-8 border-t border-slate-100 dark:border-white/10 text-center py-20 animate-fade-in">
                        <i class="ph ph-bold ph-magnifying-glass text-4xl text-slate-300 dark:text-slate-600 mb-4 opacity-50"></i>
                        <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-2">No domains found</h3>
                        <p class="text-slate-500 dark:text-slate-400 text-sm">Try a different keyword or active category.</p>
                        <button @click="clearFilters()" class="mt-6 text-primary-600 dark:text-primary-400 font-bold hover:underline">Clear all filters</button>
                    </div>
                </div>
            </div>
        </div>

        {{-- Post-Search Secondary Action --}}
        <div class="mt-12 text-center animate-fade-in-up delay-300" x-show="!isSearchActive">
            <p class="text-slate-500 dark:text-slate-400 font-medium tracking-tight">
                {{ __(@$domainContent->data_values->transfer_text_prefix ?? 'Already bought domain?') }}
                <a href="{{ @$domainContent->data_values->transfer_url ?? route('domains.transfer') }}" 
                   class="ml-1 text-primary-600 dark:text-white hover:text-primary-600 dark:hover:text-primary-400 font-bold underline decoration-primary-500/50 underline-offset-8 transition-colors">
                    {{ __(@$domainContent->data_values->transfer_text_cta ?? 'Transfer it') }}
                </a>
            </p>
        </div>
        </div>

        <script nonce="{{ csp_nonce() }}">
        function tldPricingList() {
            return {
                searchQuery: '',
                categoryId: null,
                results: [],
                categories: [],
                cursor: null,
                loading: false,
                loadingMore: false,
                hasMore: true,
                total: 0,
                searchTimeout: null,
                isSearchActive: false,
                errorMessage: '',
                
                init() {
                    // Initialize categories from server-side rendered categories if needed
                    // or let the first fetch handle it
                },
                
                async loadInitialResults() {
                    if (!this.searchQuery.trim()) return;
                    this.loading = true;
                    this.results = [];
                    this.cursor = null;
                    this.errorMessage = '';
                    await this.fetchResults();
                    this.loading = false;
                    this.isSearchActive = true;
                },
                
                async loadMore() {
                    if (!this.hasMore || this.loadingMore) return;
                    this.loadingMore = true;
                    await this.fetchResults();
                    this.loadingMore = false;
                },
                
                get groupedResults() {
                    return this.results.reduce((groups, result) => {
                        const catId = result.category_id || 0;
                        if (!groups[catId]) groups[catId] = [];
                        groups[catId].push(result);
                        return groups;
                    }, {});
                },

                get visibleCategories() {
                    const grouped = this.groupedResults;
                    return this.categories.filter(cat => grouped[cat.id] && grouped[cat.id].length > 0);
                },
                
                async fetchResults() {
                    try {
                        const csrfToken = document.querySelector('meta[name="csrf-token"]').content;
                        const response = await fetch('/api/domains/search', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': csrfToken,
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                query: this.searchQuery,
                                category_id: this.categoryId,
                                cursor: this.cursor,
                                limit: 45
                            })
                        });

                        if (!response.ok) throw new Error('Search failed. Please try again.');
                        
                        const data = await response.json();
                        if (data.success) {
                            this.results = [...this.results, ...data.data];
                            this.categories = data.categories;
                            this.cursor = data.meta.next_cursor;
                            this.hasMore = data.meta.has_more;
                            this.total = data.meta.total;
                        } else {
                            this.errorMessage = data.message || 'Search failed. Please try again.';
                        }
                    } catch (error) {
                        console.error('Search error:', error);
                        this.errorMessage = 'Network error or service unavailable. Check your connection.';
                    }
                },

                handleSearch() {
                    clearTimeout(this.searchTimeout);
                    this.searchTimeout = setTimeout(() => {
                        if (this.searchQuery.trim().length > 0) {
                            this.loadInitialResults();
                        } else {
                            this.isSearchActive = false;
                            this.results = [];
                        }
                    }, 500);
                },

                filterByCategory(id) {
                    if (this.categoryId == id) {
                        this.categoryId = null;
                    } else {
                        this.categoryId = id;
                    }
                    this.loadInitialResults();
                },

                clearFilters() {
                    this.categoryId = null;
                    this.searchQuery = '';
                    this.isSearchActive = false;
                    this.results = [];
                },

                async addToCart(tld) {
                    try {
                        const csrfToken = document.querySelector('meta[name="csrf-token"]').content;
                        const response = await fetch('{{ route('shopping.cart.add.domain') }}', {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': csrfToken,
                                'Accept': 'application/json'
                            },
                            body: JSON.stringify({
                                domain: tld.domain,
                                action: 'register',
                                reg_period: 1,
                                domain_setup_id: tld.id
                            })
                        });

                        const data = await response.json();
                        if (data.success) {
                            // Show success message or redirect
                            if (data.redirect) {
                                window.location.href = data.redirect;
                            } else {
                                notify('success', data.message || 'Added to cart!');
                                if (window.Alpine && Alpine.store('cart')) {
                                    Alpine.store('cart').updateCount(data.cart_count || (Alpine.store('cart').count + 1));
                                }
                            }
                        } else {
                            notify('error', data.message || 'Failed to add to cart');
                        }
                    } catch (error) {
                        console.error('Add to cart error:', error);
                        notify('error', 'An error occurred. Please try again.');
                    }
                }
            };
        }
        </script>
    </div>
</section>

@push('style')
<style>
    .scrollbar-hide::-webkit-scrollbar { display: none; }
    .scrollbar-hide { -ms-overflow-style: none; scrollbar-width: none; }
    .delay-300 { animation-delay: 0.3s; }
</style>
@endpush
