@php
    $featuresContent = getContent('domain_features.content', true);
    $featuresElements = getContent('domain_features.element');
@endphp

<section class="py-20 lg:py-28 bg-white dark:bg-slate-950 px-6 transition-colors duration-300">
    <div class="max-w-7xl mx-auto">
        {{-- Section Header --}}
        <div class="text-center mb-10 md:mb-12 animate-fade-in-up">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight leading-tight">
                {{ __(@$featuresContent->data_values->heading ?? 'Why Buy Domains at Salieno?') }}
            </h2>
            @if(@$featuresContent->data_values->subheading)
                <p class="text-slate-600 dark:text-slate-400 text-lg leading-relaxed max-w-3xl mx-auto">
                    {{ __(@$featuresContent->data_values->subheading) }}
                </p>
            @endif
        </div>

        {{-- Features Grid --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-10 gap-y-10">
            @if($featuresElements && count($featuresElements) > 0)
                @foreach($featuresElements as $item)
                    <div class="group flex flex-col items-start text-left">
                        {{-- Icon --}}
                        <div class="mb-6">
                            @php
                                $icon = $item->data_values->icon ?? 'ph-bold ph-check';
                                if (!str_contains($icon, 'ph ')) {
                                    $icon = 'ph ' . $icon;
                                }
                            @endphp
                            <i class="{{ $icon }} text-2xl text-primary-500 transition-colors"></i>
                        </div>
                        
                        {{-- Title --}}
                        <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 tracking-tight">
                            {{ __($item->data_values->title) }}
                        </h4>
                        
                        {{-- Description --}}
                        <p class="text-slate-500 dark:text-slate-400 leading-relaxed text-sm font-medium">
                            {{ __($item->data_values->description) }}
                        </p>
                    </div>
                @endforeach
            @else
                {{-- Fallback Demo content based on the user image --}}
                @php
                    $demoFeatures = [
                        ['title' => 'Domain locking', 'description' => 'Lock your domain to prevent unauthorized transfers of your domain names.', 'icon' => 'ph-bold ph-bookmark-simple'],
                        ['title' => 'Great renewal rates', 'description' => 'When it\'s time to renew your domain, you\'ll never have to worry about breaking the bank.', 'icon' => 'ph-bold ph-currency-dollar-simple'],
                        ['title' => 'Auto-renewal', 'description' => 'You\'ll never lose your domain (even if you forget) thanks to our auto-renewal option.', 'icon' => 'ph-bold ph-arrows-counter-clockwise'],
                        ['title' => 'Easy management', 'description' => 'Manage your domain with an easy-to-use control panel and dashboard.', 'icon' => 'ph-bold ph-globe'],
                        ['title' => 'Whois privacy protection', 'description' => 'Need some privacy? We\'ll protect your personal info from the WHOIS database for a small fee.', 'icon' => 'ph-bold ph-lock-key'],
                        ['title' => 'Low prices & huge selection', 'description' => 'Register your domain for a low price and choose from a wide selection of extensions.', 'icon' => 'ph-bold ph-cursor-click'],
                    ];
                @endphp
                @foreach($demoFeatures as $feature)
                    <div class="group flex flex-col items-start text-left">
                        {{-- Icon --}}
                        <div class="mb-6">
                            <i class="ph {{ str_contains($feature['icon'], 'ph-') && !str_contains($feature['icon'], 'ph ') ? $feature['icon'] : $feature['icon'] }} text-2xl text-primary-500 transition-colors"></i>
                        </div>
                        
                        {{-- Title --}}
                        <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 tracking-tight">
                            {{ __($feature['title']) }}
                        </h4>
                        
                        {{-- Description --}}
                        <p class="text-slate-500 dark:text-slate-400 leading-relaxed text-sm font-medium">
                            {{ __($feature['description']) }}
                        </p>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</section>
