@php
    $tipsContent = getContent('domain_tips.content', true);
    $tipsElements = getContent('domain_tips.element');
@endphp

<section class="py-20 lg:py-28 bg-surface-offwhite dark:bg-slate-950 px-6 transition-colors duration-300">
    <div class="max-w-7xl mx-auto">
        {{-- Section Header --}}
        <div class="text-center mb-12 animate-fade-in-up">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight leading-tight max-w-4xl mx-auto">
                {{ __(@$tipsContent->data_values->heading ?? '5 Things To Remember Before You Buy Domains') }}
            </h2>
        </div>

        {{-- Tips Grid --}}
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 gap-6">
            @php
                $tips = ($tipsElements && count($tipsElements) > 0) ? $tipsElements : null;
                $demoTips = [
                    ['title' => 'Stay simple', 'description' => 'Don\'t get complicated. An easy-to-remember domain is always best.'],
                    ['title' => 'Keep it on-brand', 'description' => 'Stay true to your brand. Be distinct but choose a domain your audience will recognize.'],
                    ['title' => 'Act now', 'description' => 'Don\'t wait until it\'s too late. That perfect domain could be gone by tomorrow.'],
                    ['title' => 'Drop the hyphens', 'description' => 'Just because the internet is high-tech doesn\'t mean your domain name should be.'],
                    ['title' => 'Consider your options', 'description' => 'Grab similar domain names to protect your brand: .net, .org, .co, or even .photo.'],
                ];
                $displayItems = $tips ? $tips->toArray() : $demoTips;
            @endphp

            @foreach($displayItems as $index => $item)
                @php
                    $title = is_array($item) ? $item['title'] : $item->data_values->title;
                    $desc = is_array($item) ? $item['description'] : $item->data_values->description;
                @endphp
                
                {{-- Card --}}
                <div class="group relative bg-white dark:bg-white/5 rounded-xl border border-slate-200 dark:border-white/10 p-6 text-center overflow-hidden hover:shadow-lg transition-shadow duration-300 h-full flex flex-col items-center">
                    
                    {{-- Watermark Number (Inside Card) --}}
                    <div class="absolute -top-6 left-1/2 -translate-x-1/2 text-[80px] leading-none font-extrabold text-slate-100 dark:text-white/[0.03] select-none pointer-events-none z-0">
                        {{ sprintf("%02d", $index + 1) }}
                    </div>

                    {{-- Content --}}
                    <div class="relative z-10 pt-16 flex flex-col h-full"> 
                        <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 leading-tight">
                            {{ __($title) }}
                        </h4>
                        <p class="text-slate-500 dark:text-slate-400 text-sm leading-relaxed font-medium mt-auto">
                            {{ __($desc) }}
                        </p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
