@php
    $domainTransfer = getContent('domain_transfer.content', true);
    $hero = getContent('hero.content', true);
@endphp

<section class="relative py-20 lg:py-28 overflow-hidden bg-slate-100 dark:bg-slate-950 transition-colors duration-500">
    
    {{-- Background Effects --}}
    <div class="absolute inset-0 z-0">
        {{-- Gradient Blobs --}}
        <div class="absolute top-0 left-0 w-full h-full">
            <div class="absolute top-[-20%] left-[-10%] w-[80vw] h-[80vw] max-w-[800px] max-h-[800px] rounded-full 
                        bg-gradient-to-br from-primary-500/10 dark:from-primary-500/20 via-primary-600/10 dark:via-primary-600/20 to-transparent 
                        blur-[100px] animate-blob"></div>
            <div class="absolute bottom-[-20%] right-[-10%] w-[60vw] h-[60vw] max-w-[600px] max-h-[600px] rounded-full 
                        bg-gradient-to-tl from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-transparent 
                        blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
        </div>
        
        {{-- Technical Grid --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>

        {{-- Grain Overlay --}}
        <div class="absolute inset-0 bg-[url('{{ @$hero->data_values->link }}')] opacity-[0.03] dark:opacity-10 mix-blend-soft-light"></div>
    </div>

    <div class="container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        
        {{-- Header --}}
        <div class="text-center mb-16 max-w-3xl mx-auto">
            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __(@$domainTransfer->data_values->heading ?? 'Transfer your domain') }}
            </h2>
            <p class="text-lg text-slate-600 dark:text-slate-400 leading-relaxed">
                {{ __(@$domainTransfer->data_values->subheading ?? 'Move your domain to our high-frequency infrastructure and enjoy lower renewal rates, expert support, and seamless management.') }}
            </p>
        </div>

        {{-- Transfer Form Card --}}
        <div class="max-w-4xl mx-auto">
            <div class="relative rounded-2xl bg-white dark:bg-slate-900/40 border border-slate-200 dark:border-white/10 backdrop-blur-xl shadow-xl shadow-slate-200/50 dark:shadow-none overflow-hidden">
                <div class="p-5 sm:p-6 md:p-8">
                    <form action="{{ route('shopping.cart.add.domain') }}" method="POST" class="space-y-6">
                        @csrf
                        <input type="hidden" name="action" value="transfer">
                        <input type="hidden" name="reg_period" value="1">

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            {{-- Domain Name Input --}}
                            <div class="space-y-2">
                                <label class="block text-sm font-medium text-slate-700 dark:text-slate-300">
                                    @lang('Domain name')
                                </label>
                                <div class="relative group">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none transition-colors group-focus-within:text-primary-500 text-slate-400 dark:text-slate-500">
                                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                                        </svg>
                                    </div>
                                    <input type="text" name="domain" required placeholder="example.com"
                                        class="w-full pl-12 pr-4 h-12 bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-600 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500 transition-[border-color,background-color,color]">
                                </div>
                            </div>

                            {{-- EPP Code Input --}}
                            <div class="space-y-2">
                                <label class="block text-sm font-medium text-slate-700 dark:text-slate-300">
                                    @lang('Auth/EPP code')
                                </label>
                                <div class="relative group">
                                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none transition-colors group-focus-within:text-primary-500 text-slate-400 dark:text-slate-500">
                                        <svg class="w-5 h-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                        </svg>
                                    </div>
                                    <input type="text" name="epp_code"
                                        placeholder="@lang('Authorization code from current registrar')"
                                        class="w-full pl-12 pr-4 h-12 bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-600 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500 transition-[border-color,background-color,color]">
                                </div>
                            </div>
                        </div>

                        {{-- Submit Button --}}
                        <div class="pt-2">
                            <x-theme.btn-primary type="submit" full>
                                @lang('Start transfer')
                            </x-theme.btn-primary>
                        </div>
                    </form>

                    {{-- Benefits --}}
                    <div class="mt-8 pt-6 border-t border-slate-200 dark:border-white/10">
                        <div class="grid grid-cols-1 sm:grid-cols-3 gap-6">
                            <div class="flex flex-col items-center sm:items-start text-center sm:text-left gap-3">
                                <div class="w-10 h-10 rounded-xl bg-primary-500/10 flex items-center justify-center flex-shrink-0 text-primary-500">
                                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="text-lg text-slate-900 dark:text-white font-bold mb-1">@lang('One year extra')</h4>
                                    <p class="text-sm text-slate-600 dark:text-slate-400 leading-relaxed">
                                        @lang('Most transfers add a full year to your current expiration date automatically.')
                                    </p>
                                </div>
                            </div>
                            
                            <div class="flex flex-col items-center sm:items-start text-center sm:text-left gap-3">
                                <div class="w-10 h-10 rounded-xl bg-primary-500/10 flex items-center justify-center flex-shrink-0 text-primary-500">
                                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 10V3L4 14h7v7l9-11h-7z" />
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="text-lg text-slate-900 dark:text-white font-bold mb-1">@lang('Zero downtime')</h4>
                                    <p class="text-sm text-slate-600 dark:text-slate-400 leading-relaxed">
                                        @lang('Your website and emails stay live throughout the entire migration process.')
                                    </p>
                                </div>
                            </div>
                            
                            <div class="flex flex-col items-center sm:items-start text-center sm:text-left gap-3">
                                <div class="w-10 h-10 rounded-xl bg-primary-500/10 flex items-center justify-center flex-shrink-0 text-primary-500">
                                    <svg class="w-6 h-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                    </svg>
                                </div>
                                <div>
                                    <h4 class="text-lg text-slate-900 dark:text-white font-bold mb-1">@lang('Locked pricing')</h4>
                                    <p class="text-sm text-slate-600 dark:text-slate-400 leading-relaxed">
                                        @lang('Avoid hidden fees with our transparent, competitive domain renewal rates.')
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Note --}}
            <div class="mt-8 text-center">
                <p class="text-sm text-slate-500 dark:text-slate-400">
                    @lang('* Note: Some TLDs require the domain to be at least 60 days old before it can be transferred.')
                </p>
            </div>
        </div>
    </div>
</section>
