@php
    $faqService = app(\App\Services\FaqService::class);
    $metadata = $faqService->getSectionMetadata($key ?? 'faq');
    $faqs = $faqService->getFaqsForContext($key ?? 'faq', page: $page ?? null, category: $category ?? null);
    
    $title = $metadata['title'];
    $subtitle = $metadata['subtitle'];
@endphp

<section class="relative py-12 lg:py-20 bg-white dark:bg-slate-950 transition-colors duration-300">
    {{-- Decorative backgrounds --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute bottom-0 right-0 w-[350px] h-[350px] bg-primary-500/5 rounded-full blur-[100px]"></div>
    </div>

    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __($title) }}
            </h2>
            <p class="text-lg text-slate-500 dark:text-slate-400 max-w-2xl mx-auto leading-relaxed">
                {{ __($subtitle) }}
            </p>
        </div>

        <div class="space-y-4" x-data="{ active: 0 }">
            @foreach($faqs as $index => $item)
                @php
                    $q = is_object($item) ? @$item->data_values->question : @$item['question'];
                    $a = is_object($item) ? @$item->data_values->answer : @$item['answer'];
                @endphp
                <div class="group rounded-xl border-2 transition-[border-color,background-color,box-shadow,transform] duration-300 overflow-hidden"
                     :class="active === {{ $index }} ? 'border-primary-500/50 bg-primary-500/[0.03] shadow-xl shadow-primary-500/5' : 'border-slate-100 dark:border-white/5 bg-white dark:bg-slate-900 shadow-sm hover:border-primary-500/30'">
                    
                    <button @click="active === {{ $index }} ? active = null : active = {{ $index }}"
                            class="flex justify-between items-center w-full text-left px-6 py-4 sm:py-5"
                            :aria-expanded="active === {{ $index }}"
                            aria-controls="faq-panel-{{ $index }}"
                            id="faq-trigger-{{ $index }}">
                        <span class="text-base sm:text-lg font-bold text-slate-900 dark:text-white pr-8 transition-colors"
                              :class="active === {{ $index }} ? 'text-primary-600' : 'group-hover:text-primary-500'">
                            {{ __($q) }}
                        </span>
                        
                        <div class="flex-shrink-0 w-8 h-8 rounded-full flex items-center justify-center transition-[border-color,background-color,box-shadow,transform] duration-300"
                             :class="active === {{ $index }} ? 'bg-primary-600 text-white rotate-180' : 'bg-slate-100 dark:bg-white/5 text-slate-500 dark:text-slate-400'">
                            <i class="ph ph-caret-down font-bold transition-transform" aria-hidden="true"></i>
                        </div>
                    </button>
                    
                    <div x-show="active === {{ $index }}"
                         x-collapse
                         x-cloak
                         id="faq-panel-{{ $index }}"
                         role="region"
                         aria-labelledby="faq-trigger-{{ $index }}">
                        <div class="px-6 pb-6 text-sm text-slate-600 dark:text-slate-400 leading-relaxed font-medium">
                            {!! purify(__($a)) !!}
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

