@php
    $featuresContent = getContent('features.content', true);
    $featuresElements = getContent('features.element');
@endphp

<section class="relative py-12 lg:py-20 bg-white dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Astral Background --}}
    <div class="absolute inset-0 pointer-events-none">
        {{-- Deep Space Gradient --}}
        <div class="absolute inset-0 bg-gradient-to-b from-transparent via-slate-100/50 dark:via-surface-dark to-transparent"></div>

        {{-- Nebula Glows --}}
        <div
            class="absolute top-0 left-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[120px] mix-blend-screen animate-pulse-glow">
        </div>
        <div class="absolute bottom-0 right-1/4 w-[500px] h-[500px] bg-primary-600/10 rounded-full blur-[120px] mix-blend-screen animate-pulse-glow"
            style="animation-delay: 2s;"></div>

        {{-- Grid Mesh --}}
        <div
            class="absolute inset-0 bg-[linear-gradient(var(--border)_1px,transparent_1px),linear-gradient(90deg,var(--border)_1px,transparent_1px)] bg-[size:100px_100px] [mask-image:radial-gradient(ellipse_at_center,black,transparent_80%)] opacity-30 dark:opacity-100">
        </div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        <div class="text-center mb-12">
            <span
                class="text-primary-500 font-bold tracking-widest uppercase text-sm mb-2 block">
                {{ __(@$featuresContent->data_values->heading ?? 'Interstellar Performance') }}
            </span>
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __(@$featuresContent->data_values->subheading ?? 'Why Choose ' . (gs('site_name') ?? 'salieno') . '?') }}
            </h2>
            <p class="text-slate-500 dark:text-slate-400 max-w-2xl mx-auto text-lg leading-relaxed">
                {{ __(@$featuresContent->data_values->description ?? 'Engineered for the future. We provide the warp-speed infrastructure you need to scale beyond the horizon.') }}
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @if($featuresElements && count($featuresElements) > 0)
                @foreach($featuresElements as $feature)
                    <div class="group relative p-6 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/5 hover:bg-slate-100 dark:hover:bg-white/10 hover:border-primary-500/30 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-1 backdrop-blur-sm overflow-hidden">
                        <div class="absolute top-0 right-0 -mt-10 -mr-10 w-32 h-32 bg-primary-500/20 rounded-full blur-3xl group-hover:bg-primary-500/30 transition-colors opacity-0 group-hover:opacity-100 duration-500"></div>
                        <div class="relative z-10">
                            <div class="w-14 h-14 bg-gradient-to-br from-slate-100 dark:from-slate-800 to-slate-200 dark:to-black border border-slate-200 dark:border-white/10 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 group-hover:rotate-3 transition-transform duration-500 shadow-lg shadow-slate-200/50 dark:shadow-black/50">
                                <i class="ph {{ str_contains($feature->data_values->icon ?? 'ph-rocket-launch', 'ph-') ? ($feature->data_values->icon ?? 'ph-rocket-launch') : 'ph-' . ($feature->data_values->icon ?? 'ph-rocket-launch') }} text-2xl text-primary-400 group-hover:text-primary-400 transition-colors duration-300"></i>
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-3 group-hover:text-primary-600 dark:group-hover:text-primary-200 transition-colors">
                                {{ __($feature->data_values->title) }}</h3>
                            <p class="text-slate-500 dark:text-slate-400 leading-relaxed group-hover:text-slate-700 dark:group-hover:text-slate-300 transition-colors">
                                {{ __($feature->data_values->description) }}</p>
                        </div>
                    </div>
                @endforeach
            @else
                @php
                    $fallbackFeatures = [
                        ['icon' => 'ph-zap', 'title' => 'Warp Speed Connectivity', 'desc' => 'Powered by NVMe SSDs and LiteSpeed for instant data transmission.'],
                        ['icon' => 'ph-shield', 'title' => 'Nebula Shield', 'desc' => 'AI-driven DDoS mitigation ensures your orbit remains undisturbed.'],
                        ['icon' => 'ph-lock', 'title' => 'Ironclad Encryption', 'desc' => 'Free SSL certificates auto-deployed to secure your data transmission.'],
                        ['icon' => 'ph-globe', 'title' => 'Galactic Presence', 'desc' => 'Deploy instantly across 10+ strategic locations worldwide.'],
                        ['icon' => 'ph-server', 'title' => 'Mission Critical Uptime', 'desc' => 'Redundant power and network architecture guarantees 99.99% availability.'],
                        ['icon' => 'ph-headset', 'title' => '24/7 Command Center', 'desc' => 'Expert engineers ready to assist you from our global support stations.'],
                    ];
                @endphp
                @foreach($fallbackFeatures as $feature)
                    <div class="group relative p-6 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-200 dark:border-white/5 hover:bg-slate-100 dark:hover:bg-white/10 hover:border-primary-500/30 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-2 backdrop-blur-sm overflow-hidden">
                        <div class="absolute top-0 right-0 -mt-10 -mr-10 w-32 h-32 bg-primary-500/20 rounded-full blur-3xl group-hover:bg-primary-500/30 transition-colors opacity-0 group-hover:opacity-100 duration-500"></div>
                        <div class="relative z-10">
                            <div class="w-14 h-14 bg-gradient-to-br from-slate-100 dark:from-slate-800 to-slate-200 dark:to-black border border-slate-200 dark:border-white/10 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 group-hover:rotate-3 transition-transform duration-500 shadow-lg shadow-slate-200/50 dark:shadow-black/50">
                                <i class="ph {{ $feature['icon'] }} text-2xl text-primary-400 group-hover:text-primary-400 transition-colors duration-300"></i>
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-3 group-hover:text-primary-600 dark:group-hover:text-primary-200 transition-colors">
                                {{ __($feature['title']) }}</h3>
                            <p class="text-slate-500 dark:text-slate-400 leading-relaxed group-hover:text-slate-700 dark:group-hover:text-slate-300 transition-colors">
                                {{ __($feature['desc']) }}</p>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</section>