{{-- Salieno Hero Section with Server Rack Illustration --}}
@php
    $hero = getContent('hero.content', true);
@endphp

<div
    class="relative overflow-hidden pt-28 pb-8 md:pt-36 md:pb-12 lg:pt-32 lg:pb-0 bg-slate-50 dark:bg-slate-950 transition-colors duration-300 flex flex-col justify-center min-h-fit md:min-h-[500px] lg:min-h-[600px]">

    {{-- Artistic Background - Salieno Theme --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none" aria-hidden="true">
        {{-- Grain Overlay --}}
        <div
            class="absolute inset-0 bg-[url('{{ clean_url(@$hero->data_values->link) }}')] opacity-20 mix-blend-soft-light">
        </div>

        {{-- Technical Grid Pattern with Mask --}}
        <div
            class="absolute inset-0 bg-[linear-gradient(to_right,#80808012_1px,transparent_1px),linear-gradient(to_bottom,#80808012_1px,transparent_1px)] bg-[size:4rem_4rem] [mask-image:radial-gradient(ellipse_60%_50%_at_50%_0%,#000_70%,transparent_100%)]">
        </div>

        {{-- Blinking Stars --}}
        <div class="absolute inset-0 pointer-events-none">
            @for ($i = 0; $i < 24; $i++)
                @php
                    $top = (($i * 13) % 80);
                    $left = (($i * 17) % 100);
                    $size = (($i % 3) + 1);
                    $opacity = ((($i * 5) % 50) + 20) / 100;
                    $duration = (($i % 4) + 2);
                    $delay = ($i % 6);
                @endphp
                <div class="absolute rounded-full bg-slate-300 dark:bg-white animate-pulse"
                    style="top: {{ $top }}%; left: {{ $left }}%; width: {{ $size }}px; height: {{ $size }}px; opacity: {{ $opacity }}; animation-duration: {{ $duration }}s; animation-delay: {{ $delay }}s;">
                </div>
            @endfor
        </div>

        {{-- Shooting Stars --}}
        <div class="absolute inset-0 pointer-events-none">
            <div class="absolute top-0 right-[-10%] w-[300px] h-[300px] rotate-[30deg]">
                <div class="absolute top-0 left-1/2 w-[3px] h-[150px] bg-gradient-to-b from-transparent via-slate-400 dark:via-white to-transparent animate-shooting-star opacity-0"
                    style="animation-duration: 4s; animation-delay: 1s;"></div>
                <div class="absolute top-10 left-1/3 w-[2px] h-[100px] bg-gradient-to-b from-transparent via-primary-300 to-transparent animate-shooting-star opacity-0"
                    style="animation-duration: 6s; animation-delay: 5s;"></div>
            </div>
        </div>

        {{-- Flying Jet --}}
        <div class="absolute w-24 h-24 z-0 animate-jet-fly pointer-events-none">
            <svg viewBox="0 0 24 24" fill="currentColor"
                class="text-slate-300 dark:text-slate-600 w-full h-full drop-shadow-[0_0_10px_rgba(var(--primary-rgb),0.6)]">
                <path d="M12 2L2 22L12 18L22 22L12 2Z" fill="currentColor" />
                <path d="M12 6L8 20L12 17L16 20L12 6Z" fill="var(--svg-mid)" opacity="0.3" />
            </svg>
            <div
                class="absolute bottom-0 left-1/2 -translate-x-1/2 w-2 h-16 bg-gradient-to-t from-transparent via-primary-400 to-primary-700 opacity-60 blur-md transform rotate-180 origin-top">
            </div>
        </div>

        {{-- The Sun / Light Source --}}
        <div class="absolute -top-[15%] -right-[5%] w-[500px] h-[500px] pointer-events-none opacity-60 lg:opacity-100">
            <div
                class="absolute inset-0 bg-primary-500/10 dark:bg-primary-500/20 rounded-full blur-[100px] mix-blend-screen animate-pulse-glow">
            </div>
            <div
                class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[1200px] h-[1200px] bg-[conic-gradient(from_0deg,transparent_0deg,rgba(var(--primary-rgb),0.05)_20deg,transparent_40deg,rgba(var(--primary-rgb),0.05)_60deg,transparent_80deg)] animate-spin-very-slow opacity-50 dark:opacity-30">
            </div>
        </div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        <div class="grid lg:grid-cols-2 gap-12 lg:gap-8 items-center">

            {{-- Left Column: Text & CTA --}}
            <div class="flex flex-col items-center lg:items-start text-center lg:text-left relative">
                
                {{-- Refined Promotional Chip --}}
                <div class="inline-flex items-center space-x-3 bg-primary-500/10 border border-primary-500/30 rounded-full px-4 py-2 mb-6 lg:mb-8 backdrop-blur-md shadow-lg shadow-primary-500/5 group relative z-20">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-primary-500 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-primary-500"></span>
                    </span>
                    <span class="text-[10px] sm:text-xs font-bold uppercase tracking-wider flex items-center gap-2">
                        <span class="text-primary-500 font-bold whitespace-nowrap">{{ __(@$hero->data_values->promo_bar_badge ?? 'New Year Sale!') }}</span>
                        <span class="w-1 h-1 rounded-full bg-slate-400 opacity-50"></span>
                        <span class="text-slate-600 dark:text-slate-300 truncate max-w-[180px] sm:max-w-none">{{ __(@$hero->data_values->promo_bar_text ?? 'Save Up to 81% + 2 Months Free') }}</span>
                    </span>
                </div>

                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-5 leading-tight">
                    {!! purify(__($hero->data_values->heading ?? 'Launch the New Year on Better Hosting')) !!}
                </h2>

                {{-- Feature List --}}
                <div class="flex flex-col gap-4 mb-6 lg:mb-8 relative z-20 w-full sm:w-auto">
                    @foreach(['feature_1' => '24/7 real human support — no AI chatbots', 'feature_2' => 'Free domain included', 'feature_3' => 'Easy migration, done for you'] as $key => $default)
                        <div class="flex items-center justify-center lg:justify-start gap-3">
                            <div class="flex-shrink-0 w-5 h-5 sm:w-6 sm:h-6 rounded-full bg-green-500/20 flex items-center justify-center">
                                <svg class="w-3 h-3 sm:w-4 sm:h-4 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                            <span class="text-sm sm:text-base text-slate-600 dark:text-slate-300 font-medium">
                                {{ __(@$hero->data_values->$key ?? $default) }}
                            </span>
                        </div>
                    @endforeach
                </div>

                {{-- Offer Line --}}
                <p class="text-base sm:text-lg text-slate-900 dark:text-white font-medium mb-8 relative z-20">
                    {{ __(@$hero->data_values->offer_text ?? 'New Year offer: $2.49/mo + 2 extra months!') }}
                </p>

                <div class="flex flex-col items-center lg:items-start gap-4 mb-4 relative z-20 w-full sm:w-auto">
                    <x-theme.btn-primary href="{{ @$hero->data_values->primary_button_link ?? route('pricing') }}" class="w-full sm:w-auto" :icon="false">
                        {{ __(@$hero->data_values->primary_button_text ?? 'View Plans') }}
                    </x-theme.btn-primary>
                    <p class="text-[10px] sm:text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest pl-1 opacity-70">
                        {{ __(@$hero->data_values->guarantee_text ?? '45-day Money-back guarantee') }}
                    </p>
                </div>
            </div>

            {{-- Right Column: Server Illustration --}}
            <div class="relative hidden lg:block perspective-1000">
                {{-- Animated background glow --}}
                <div
                    class="absolute inset-0 bg-gradient-to-tr from-primary-400/20 to-primary-500/20 rounded-full blur-[80px] animate-pulse-glow">
                </div>

                <svg viewBox="0 0 500 500" class="relative z-10 w-full h-full drop-shadow-xl max-w-lg mx-auto"
                    xmlns="http://www.w3.org/2000/svg">
                    <defs>
                        <linearGradient id="serverBody" x1="0%" y1="0%" x2="100%" y2="0%">
                            <stop offset="0%" stop-color="var(--svg-mid)" />
                            <stop offset="50%" stop-color="var(--svg-light)" />
                            <stop offset="100%" stop-color="var(--svg-dark)" />
                        </linearGradient>
                        <linearGradient id="serverFace" x1="0%" y1="0%" x2="0%" y2="100%">
                            <stop offset="0%" stop-color="var(--svg-light)" />
                            <stop offset="100%" stop-color="var(--svg-mid)" />
                        </linearGradient>
                        <linearGradient id="highlight" x1="0%" y1="0%" x2="100%" y2="100%">
                            <stop offset="0%" class="text-primary-500" stop-color="currentColor" />
                            <stop offset="100%" class="text-primary-500" stop-color="currentColor" />
                        </linearGradient>
                        <filter id="neonGlow" x="-50%" y="-50%" width="200%" height="200%">
                            <feGaussianBlur stdDeviation="4" result="coloredBlur" />
                            <feMerge>
                                <feMergeNode in="coloredBlur" />
                                <feMergeNode in="SourceGraphic" />
                            </feMerge>
                        </filter>
                    </defs>

                    {{-- Platform/Base --}}
                    <ellipse cx="250" cy="440" rx="180" ry="20" fill="#000" opacity="0.3" filter="url(#neonGlow)" />

                    {{-- Main Rack Chassis --}}
                    <path d="M130 80 L370 80 L370 420 L130 420 Z" fill="var(--svg-dark)" stroke="var(--svg-light)" stroke-width="2" />

                    {{-- Server Units --}}
                    @for ($i = 0; $i < 6; $i++)
                        <g transform="translate(140, {{ 100 + $i * 52 }})">
                            <rect x="0" y="0" width="220" height="42" rx="2" fill="url(#serverFace)" stroke="var(--svg-muted)"
                                stroke-width="1" />
                            @for ($j = 0; $j < 12; $j++)
                                <rect x="{{ 15 + $j * 10 }}" y="10" width="4" height="22" fill="var(--svg-dark)" opacity="0.5" />
                            @endfor
                            <rect x="180" y="5" width="30" height="32" rx="2" fill="var(--svg-dark)" />
                            <circle cx="188" cy="15" r="2.5" fill="#10b981" class="animate-pulse" />
                            <circle cx="188" cy="27" r="2.5" fill="#3b82f6" />
                            <circle cx="200" cy="15" r="2.5" fill="#f59e0b"
                                class="{{ $i % 3 === 0 ? 'animate-pulse' : '' }}" />
                        </g>
                    @endfor

                    {{-- Active Unit Highlight --}}
                    <g transform="translate(135, 252)">
                        <rect x="-5" y="-5" width="230" height="52" rx="4" fill="none" stroke="url(#highlight)"
                            stroke-width="3" filter="url(#neonGlow)" opacity="0.7" />
                    </g>

                    {{-- Floating Particles --}}
                    <circle cx="400" cy="150" r="6" class="fill-primary-500 animate-bounce"
                        style="animation-duration: 3s" />
                    <circle cx="100" cy="300" r="4" class="fill-primary-500 animate-bounce"
                        style="animation-duration: 4s; animation-delay: 1s" />

                    {{-- Connection Lines --}}
                    <path d="M370 250 L440 200 L440 80" fill="none" class="stroke-primary-500" stroke-width="2"
                        stroke-dasharray="5,5" opacity="0.5" />
                    <path d="M130 250 L60 300 L60 400" fill="none" class="stroke-primary-500" stroke-width="2"
                        stroke-dasharray="5,5" opacity="0.5" />

                    {{-- Glass Overlay Reflection --}}
                    <path d="M130 80 L250 80 L130 420 Z" fill="white" opacity="0.03" />
                </svg>
            </div>
        </div>
    </div>

    {{-- Smooth Gradient Fade Transition --}}
    <div class="absolute bottom-0 left-0 right-0 h-32 bg-gradient-to-b from-transparent via-slate-50/50 dark:via-slate-950/50 to-slate-50 dark:to-slate-950 pointer-events-none z-10"></div>
</div>

{{-- Smooth Transition Overlay for Next Section --}}
<div class="relative -mt-16 h-16 bg-gradient-to-b from-slate-50 dark:from-slate-950 to-transparent pointer-events-none z-20"></div>