{{-- Salieno Homepage Hero 1 - Mobile-First Bold Asymmetric Design with Real Products --}}
@php
    use App\Services\PricingCalculatorService;
    use App\Helpers\FeatureHelper;
    
    $hero = getContent('hero_1.content', true);
    $pricingCalculator = app(PricingCalculatorService::class);
    
    // Fetch a random active product
    $product = \App\Models\Product::active()
        ->with(['features', 'pricing', 'category'])
        ->inRandomOrder()
        ->first();
    
    // Get product pricing data
    $pricingData = $product ? $pricingCalculator->getProductPricingForJs($product) : null;
    $productPricing = $product ? $pricingCalculator->getProductPricing($product) : null;
    $bestCycle = $productPricing['longest_cycle'] ?? 'monthly';
    $categorySlug = $product && $product->category ? $product->category->slug : 'shared';
@endphp

<section class="relative flex flex-col justify-center overflow-hidden bg-slate-100 dark:bg-slate-950 transition-colors duration-300 lg:min-h-[640px]">
    
    {{-- Animated Gradient Background --}}
    <div class="absolute inset-0 z-0">
        {{-- Primary Gradient Blob --}}
        <div class="absolute top-0 left-0 w-full h-full">
            <div class="absolute top-[-20%] left-[-10%] w-[70vw] h-[70vw] max-w-[600px] max-h-[600px] rounded-full 
                        bg-gradient-to-br from-primary-500/20 dark:from-primary-500/30 via-primary-600/10 dark:via-primary-600/20 to-transparent 
                        blur-[80px] animate-blob"></div>
            <div class="absolute bottom-[-20%] right-[-10%] w-[50vw] h-[50vw] max-w-[500px] max-h-[500px] rounded-full 
                        bg-gradient-to-tl from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-transparent 
                        blur-[60px] animate-blob" style="animation-delay: 2s;"></div>
        </div>
        
        {{-- Grid Lines --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
    </div>

    <div class="relative z-10 w-full max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 sm:py-28 lg:pt-36 lg:pb-32">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 lg:gap-8 items-center">
            
            {{-- Left Content - Takes 7 columns on desktop --}}
            <div class="lg:col-span-7 flex flex-col items-center lg:items-start text-center lg:text-left">
                
                {{-- Animated Badge --}}
                <div class="group inline-flex items-center gap-2 sm:gap-3 mb-5 sm:mb-6 cursor-pointer">
                    <div class="relative">
                        <div class="absolute inset-0 bg-primary-500 rounded-full blur-md opacity-30 dark:opacity-50 group-hover:opacity-60 dark:group-hover:opacity-100 transition-opacity"></div>
                        <div class="relative flex items-center gap-2 px-3 py-1.5 sm:px-4 sm:py-2 rounded-full bg-primary-500/10 dark:bg-primary-500/10 border border-primary-500/30 backdrop-blur-sm">
                            <span class="relative flex h-2 w-2">
                                <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-primary-400 opacity-75"></span>
                                <span class="relative inline-flex rounded-full h-2 w-2 bg-primary-500"></span>
                            </span>
                            <span class="text-[10px] sm:text-xs font-bold uppercase tracking-wider text-primary-600 dark:text-primary-400">
                                {{ __(@$hero->data_values->promo_bar_badge ?? 'Limited Time Offer') }}
                            </span>
                        </div>
                    </div>
                    <span class="text-slate-500 dark:text-slate-500 text-xs sm:text-sm line-clamp-1">
                        {{ __(@$hero->data_values->promo_bar_text ?? 'Save up to 81% this month') }}
                    </span>
                </div>

                {{-- Main Headline with Gradient Text --}}
                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold tracking-tight leading-tight mb-5">
                    <span class="text-slate-900 dark:text-white">
                        {!! purify(__(@$hero->data_values->heading_line1 ?? 'Your Website')) !!}
                    </span>
                    <br class="hidden sm:block">
                    <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                        {!! purify(__(@$hero->data_values->heading_line2 ?? 'Deserves Better')) !!}
                    </span>
                </h2>

                {{-- Subheadline --}}
                <p class="text-sm sm:text-base lg:text-lg text-slate-600 dark:text-slate-400 max-w-xl mb-6 sm:mb-8 leading-relaxed">
                    {{ __(@$hero->data_values->subheading ?? 'Lightning-fast hosting with 99.99% uptime. We migrate your site for free and provide 24/7 human support.') }}
                </p>

                {{-- CTA Buttons --}}
                <div class="flex flex-col sm:flex-row gap-3 mb-8 sm:mb-10 w-full sm:w-auto">
                    <x-theme.btn-primary href="{{ @$hero->data_values->cta_primary_link ?? route('pricing') }}" class="w-full sm:w-auto">
                        {{ __(@$hero->data_values->cta_primary_text ?? 'Get Started') }}
                    </x-theme.btn-primary>
                    <x-theme.btn-secondary href="{{ @$hero->data_values->cta_secondary_link ?? '#pricing' }}" class="w-full sm:w-auto">
                        {{ __(@$hero->data_values->cta_secondary_text ?? 'View Plans') }}
                    </x-theme.btn-secondary>
                </div>

                {{-- Trust Metrics Row --}}
                <div class="flex items-center justify-center lg:justify-start gap-4 sm:gap-6 lg:gap-10 text-sm">
                    <div class="flex flex-col items-center lg:items-start">
                        <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">{{ @$hero->data_values->metric_1_value ?? '50K+' }}</span>
                        <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">{{ @$hero->data_values->metric_1_label ?? 'Active Sites' }}</span>
                    </div>
                    <div class="w-px h-8 bg-slate-200 dark:bg-white/10 hidden sm:block"></div>
                    <div class="flex flex-col items-center lg:items-start">
                        <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">{{ @$hero->data_values->metric_2_value ?? '99.99%' }}</span>
                        <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">{{ @$hero->data_values->metric_2_label ?? 'Uptime SLA' }}</span>
                    </div>
                    <div class="w-px h-8 bg-slate-200 dark:bg-white/10 hidden sm:block"></div>
                    <div class="flex flex-col items-center lg:items-start">
                        <span class="text-xl sm:text-2xl font-extrabold text-slate-900 dark:text-white">{{ @$hero->data_values->metric_3_value ?? '24/7' }}</span>
                        <span class="text-slate-500 dark:text-slate-400 text-[10px] sm:text-xs uppercase tracking-wider">{{ @$hero->data_values->metric_3_label ?? 'Human Support' }}</span>
                    </div>
                </div>
            </div>

            {{-- Right Column - Price Card --}}
            <div class="lg:col-span-5 flex justify-center lg:justify-end mt-4 lg:mt-0">
                @if($product && $pricingData)
                <div class="relative w-full max-w-sm group" x-data='{ 
                    billingCycle: "{{ $bestCycle }}",
                    pricingData: @json($pricingData)
                }'>
                    {{-- Card Decoration --}}
                    <div class="absolute -inset-3 sm:-inset-4 bg-gradient-to-r from-primary-500/10 dark:from-primary-500/20 via-primary-500/5 dark:via-primary-500/10 to-primary-500/10 dark:to-primary-500/20 rounded-2xl blur-2xl opacity-60 group-hover:opacity-100 transition-opacity"></div>
                    
                    {{-- The Card --}}
                    <div class="relative bg-white dark:bg-slate-900/90 backdrop-blur-xl border border-slate-200 dark:border-white/10 rounded-2xl p-5 sm:p-6 shadow-xl shadow-slate-200/50 dark:shadow-none overflow-hidden transition-[border-color,background-color,box-shadow,transform] duration-500 group-hover:-translate-y-1">
                        
                        {{-- Ribbon if recommended --}}
                        @if($product->is_recommended)
                        <div class="absolute top-0 right-0 bg-primary-500 text-white text-[10px] font-bold px-3 py-1 rounded-bl-xl uppercase tracking-widest shadow-lg">
                            @lang('Most Popular')
                        </div>
                        @endif

                        <div class="relative z-10">
                            {{-- Header --}}
                            <div class="mb-5 sm:mb-6">
                                <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-1.5">{{ __($product->name) }}</h3>
                                <p class="text-slate-500 dark:text-slate-400 text-xs sm:text-sm leading-snug">
                                    {{ Str::limit($product->tagline ?? $product->description, 60) }}
                                </p>
                            </div>

                            {{-- Pricing --}}
                            <div class="mb-5 sm:mb-6 min-h-[60px]" x-show="pricingData.prices[billingCycle]">
                                <div class="flex items-baseline mb-1">
                                    <span class="text-3xl font-extrabold tracking-tight text-slate-900 dark:text-white"
                                          x-text="pricingData.prices[billingCycle]?.display"></span>
                                    <span class="text-slate-500 dark:text-slate-400 ml-1.5 font-medium text-base leading-none">/mo</span>
                                </div>
                                <div class="flex items-center gap-2 mt-1.5">
                                    <template x-if="pricingData.prices[billingCycle]?.has_discount">
                                        <span class="text-slate-500 dark:text-slate-400 line-through text-xs sm:text-sm font-medium" 
                                              x-text="pricingData.prices[billingCycle]?.original"></span>
                                    </template>
                                    <template x-if="pricingData.prices[billingCycle]?.has_discount">
                                        <span class="inline-flex items-center px-1.5 py-0.5 rounded bg-primary-500/10 text-[10px] font-bold text-primary-600 dark:text-primary-500 uppercase tracking-wider"
                                              x-text="'SAVE ' + pricingData.prices[billingCycle]?.discount_badge"></span>
                                    </template>
                                </div>
                            </div>

                            {{-- Features --}}
                            <div class="space-y-3 mb-5 sm:mb-6">
                                @foreach($product->features->take(5) as $feature)
                                <div class="flex items-center text-sm">
                                    <div class="mr-2.5 flex-shrink-0 w-5 h-5 rounded-full bg-primary-500/10 text-primary-600 flex items-center justify-center">
                                        <svg class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="3">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7" />
                                        </svg>
                                    </div>
                                    <span class="text-slate-600 dark:text-slate-300 font-medium text-xs sm:text-sm">{{ FeatureHelper::getCombinedValue($feature) }}</span>
                                </div>
                                @endforeach
                            </div>

                            {{-- CTA Button --}}
                            <a :href="pricingData.prices[billingCycle] ? '{{ route('products.category', $categorySlug) }}' : '#'"
                               class="w-full h-11 rounded-xl bg-slate-900 dark:bg-primary-500 hover:bg-black dark:hover:bg-primary-600 text-white font-bold text-sm shadow-lg transition-[background-color,color,transform] duration-200 active:scale-95 flex items-center justify-center gap-2">
                                {{ __($product->cta_config['text'] ?? 'Get Started') }}
                                <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                </svg>
                            </a>

                            <p class="text-center text-[10px] text-slate-400 dark:text-slate-500 mt-3 font-bold uppercase tracking-widest">
                                {{ __(@$hero->data_values->guarantee_text ?? '45-Day Money Back Guarantee') }}
                            </p>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Modern Wave Divider --}}
    <div class="absolute bottom-0 left-0 right-0 z-20 overflow-hidden">
        <div class="absolute bottom-0 left-0 right-0 h-16 bg-gradient-to-b from-transparent to-slate-100/30 dark:to-slate-950/30 pointer-events-none"></div>
        
        <svg class="relative w-full h-10 sm:h-16 lg:h-24 drop-shadow-xl" viewBox="0 0 1440 74" preserveAspectRatio="none">
            <defs>
                <linearGradient id="waveGradient" x1="0%" y1="0%" x2="0%" y2="100%">
                <stop offset="0%" class="text-slate-50 dark:text-slate-950" stop-color="currentColor" stop-opacity="0.8"/>
                <stop offset="100%" class="text-slate-50 dark:text-slate-950" stop-color="currentColor" stop-opacity="1"/>
                </linearGradient>
                
                <filter id="waveGlow">
                    <feGaussianBlur stdDeviation="2" result="coloredBlur"/>
                    <feMerge>
                        <feMergeNode in="coloredBlur"/>
                        <feMergeNode in="SourceGraphic"/>
                    </feMerge>
                </filter>
            </defs>
            
            <path d="M0,0 C480,74 960,74 1440,0 L1440,74 L0,74 Z" 
                  fill="url(#waveGradient)" 
                  filter="url(#waveGlow)"
                  class="transition-[border-color,background-color,box-shadow,transform] duration-700">
            </path>
            
            <path d="M0,10 C480,84 960,84 1440,10 L1440,74 L0,74 Z" 
                  class="fill-slate-50 dark:fill-slate-950 opacity-50">
            </path>
        </svg>
    </div>
</section>