@php
    $howItWorksContent = getContent('how_it_works.content', true);
    $howItWorksElements = getContent('how_it_works.element');
@endphp

<section class="relative py-20 lg:py-28 bg-slate-50 dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Background Elements --}}
    <div class="absolute top-0 left-0 w-full h-full pointer-events-none">
        <div class="absolute top-1/2 left-1/4 w-96 h-96 bg-primary-900/20 rounded-full blur-[100px]"></div>
        <div
            class="absolute bottom-0 right-0 w-full h-[1px] bg-gradient-to-r from-transparent via-primary-500/20 to-transparent">
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-12">
            <span
                class="text-primary-600 dark:text-primary-400 font-bold tracking-widest uppercase text-sm mb-2 block">
                {{ __(@$howItWorksContent->data_values->heading ?? 'Mission Sequence') }}
            </span>
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __(@$howItWorksContent->data_values->subheading ?? 'Launch in T-Minus 60 Seconds') }}
            </h2>
            <p class="text-slate-500 dark:text-slate-400 max-w-2xl mx-auto text-lg transition-colors">
                {{ __(@$howItWorksContent->data_values->description ?? 'Our automated provisioning system deploys your infrastructure instantly. No waiting, no manual configuration.') }}
            </p>
        </div>

        <div class="relative grid grid-cols-1 md:grid-cols-3 gap-8">
            {{-- Connection Line (Desktop) --}}
            <div
                class="hidden md:block absolute top-1/2 left-0 w-full h-0.5 bg-gradient-to-r from-transparent via-primary-500/30 to-transparent -translate-y-1/2 z-0">
            </div>

            @if($howItWorksElements && count($howItWorksElements) > 0)
                @foreach($howItWorksElements as $step)
                    <div class="relative z-10 group">
                        <div class="relative bg-white dark:bg-slate-900/80 backdrop-blur-md border border-slate-200 dark:border-white/10 rounded-2xl p-6 hover:border-primary-500/50 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-1 shadow-lg shadow-slate-200/50 dark:shadow-black/50">
                            <div class="w-16 h-16 mx-auto mb-5 relative flex items-center justify-center">
                                <div class="absolute inset-0 bg-primary-500/20 rounded-full blur-xl group-hover:bg-primary-500/40 transition-[border-color,background-color,box-shadow,transform] duration-500"></div>
                                <span class="text-2xl font-bold text-primary-500 dark:text-primary-400 relative z-10">{{ $step->data_values->number }}</span>
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-3 text-center transition-colors">
                                {{ __($step->data_values->title) }}</h3>
                            <p class="text-slate-500 dark:text-slate-400 text-center text-sm leading-relaxed transition-colors">{{ __($step->data_values->description) }}</p>
                        </div>
                    </div>
                @endforeach
            @else
                @php
                    $fallbackSteps = [
                        ['num' => 1, 'title' => 'Select Configuration', 'desc' => 'Choose from our high-frequency compute plans designed for speed.'],
                        ['num' => 2, 'title' => 'Auto-Deploy', 'desc' => 'Our AI-driven orchestration system provisions your instance instantly.'],
                        ['num' => 3, 'title' => 'Manage & Scale', 'desc' => 'Access your dashboard to monitor metrics and scale resources on demand.'],
                    ];
                @endphp

                @foreach($fallbackSteps as $step)
                    <div class="relative z-10 group">
                        <div
                            class="relative bg-white dark:bg-slate-900/80 backdrop-blur-md border border-slate-200 dark:border-white/10 rounded-2xl p-6 hover:border-primary-500/50 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-1 shadow-lg shadow-slate-200/50 dark:shadow-black/50">
                            <div class="w-16 h-16 mx-auto mb-5 relative">
                                <div class="absolute inset-0 bg-primary-500/20 rounded-full blur-xl group-hover:bg-primary-500/40 transition-[border-color,background-color,box-shadow,transform] duration-500"></div>
                                @if($step['num'] === 1)
                                    <svg viewBox="0 0 100 100" class="w-full h-full relative z-10" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <path d="M50 25 L80 40 L50 55 L20 40 Z" fill="rgba(var(--primary), 0.1)" stroke="var(--primary)" class="text-primary-400" />
                                        <path d="M20 40 L20 70 L50 85 L50 55" stroke="var(--primary)" />
                                        <path d="M80 40 L80 70 L50 85" stroke="var(--primary)" />
                                    </svg>
                                @elseif($step['num'] === 2)
                                    <svg viewBox="0 0 100 100" class="w-full h-full relative z-10" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <circle cx="50" cy="50" r="35" stroke="var(--primary)" stroke-opacity="0.2" stroke-dasharray="10 5" class="animate-spin-very-slow" />
                                        <path d="M50 75 L50 30" stroke="var(--primary)" stroke-width="4" />
                                        <path d="M50 30 L40 40 M50 30 L60 40" stroke="var(--primary)" stroke-width="3" />
                                    </svg>
                                @else
                                    <svg viewBox="0 0 100 100" class="w-full h-full relative z-10" fill="none" stroke="currentColor" stroke-width="1.5">
                                        <circle cx="50" cy="50" r="15" fill="#10b981" fill-opacity="0.2" stroke="#10b981" />
                                        <ellipse cx="50" cy="50" rx="35" ry="15" transform="rotate(-15 50 50)" stroke="var(--primary)" stroke-opacity="0.5" />
                                        <ellipse cx="50" cy="50" rx="35" ry="15" transform="rotate(45 50 50)" stroke="var(--primary)" stroke-opacity="0.5" />
                                    </svg>
                                @endif
                            </div>
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-3 text-center transition-colors">{{ $step['num'] }}. {{ __($step['title']) }}</h3>
                            <p class="text-slate-500 dark:text-slate-400 text-center text-sm leading-relaxed transition-colors">{{ __($step['desc']) }}</p>
                        </div>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</section>