@php
    $kbContent = getContent('kb.content', true);
@endphp

<div class="relative overflow-hidden py-20 bg-slate-50 dark:bg-slate-950 transition-colors duration-300">
    {{-- Artistic Background - Adaptive Theme --}}
    <div class="absolute inset-0 z-0 overflow-hidden pointer-events-none">
        {{-- Technical Grid Pattern --}}
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,0.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,0.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,0.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,0.02)_1px,transparent_1px)] bg-[size:4rem_4rem] [mask-image:radial-gradient(ellipse_60%_50%_at_50%_0%,#000_70%,transparent_100%)]">
        </div>

        {{-- Accent Glows --}}
        <div class="absolute top-0 right-1/4 w-[350px] h-[350px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[100px] animate-pulse-glow"></div>
        <div class="absolute bottom-0 left-1/4 w-[300px] h-[300px] bg-primary-500/5 dark:bg-primary-500/10 rounded-full blur-[80px]"></div>
    </div>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Header & Search --}}
        <div class="max-w-4xl mx-auto text-center mb-12">
            <div class="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary-500/10 border border-primary-500/20 mb-6">
                <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-primary-500">@lang('Intelligence Core')</span>
            </div>

            <h2 class="text-3xl sm:text-4xl font-extrabold tracking-tight text-slate-900 dark:text-white mb-5 leading-tight">
                {{ __(@$kbContent->data_values->heading ?? 'Knowledge Base') }}
            </h2>
            
            <div class="relative group max-w-2xl mx-auto">
                {{-- Refined Galactic Search --}}
                <div class="absolute inset-y-0 left-0 pl-7 flex items-center pointer-events-none">
                    <i class="ph ph-bold ph-magnifying-glass text-2xl text-slate-500 dark:text-slate-400 group-focus-within:text-primary-500 transition-colors"></i>
                </div>
                
                <input type="text" id="sectionSearchInput" placeholder="@lang('Search knowledge logs')..."
                    class="w-full h-14 pl-14 pr-12 bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 rounded-xl text-slate-900 dark:text-white placeholder-slate-400 dark:placeholder-slate-500 focus:outline-none focus:ring-4 focus:ring-primary-500/10 focus:border-primary-500/50 backdrop-blur-2xl transition-[border-color,box-shadow] font-medium text-base shadow-lg shadow-slate-200/50 dark:shadow-none">
                
                <div id="sectionSearchLoader" class="absolute right-7 top-1/2 -translate-y-1/2 hidden">
                    <i class="ph ph-bold ph-circle-notch animate-spin text-2xl text-primary-500"></i>
                </div>
            </div>
        </div>

        {{-- Dynamic Search Results Area --}}
        <div id="sectionSearchResults" class="hidden mb-16">
            <div class="flex items-center justify-between gap-5 mb-8">
                <div class="flex items-center gap-5">
                    <div class="h-10 w-1.5 bg-primary-500 rounded-full"></div>
                    <h2 class="text-2xl font-bold text-slate-900 dark:text-white tracking-tight uppercase">@lang('Found Intelligence')</h2>
                </div>
                <button type="button" id="clearSectionSearch" class="text-[10px] font-bold uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400 hover:text-primary-500 transition-colors">@lang('Reset Search')</button>
            </div>
            <div id="sectionResultsContent"></div>
        </div>

        <div id="sectionMainKbContent">
            {{-- Categories Section --}}
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-16">
                @foreach ($categories as $category)
                    <div class="group relative p-6 rounded-2xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/5 hover:border-primary-500/30 transition-[border-color,background-color,box-shadow,transform] duration-700 shadow-lg shadow-slate-200/30 dark:shadow-none hover:-translate-y-1 overflow-hidden">
                        {{-- Hover Interior Glow --}}
                        <div class="absolute -right-20 -bottom-20 w-64 h-64 bg-primary-500/5 rounded-full blur-3xl group-hover:bg-primary-500/10 transition-colors"></div>

                        <div class="relative">
                            <div class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/10 flex items-center justify-center text-primary-500 mb-6 group-hover:scale-110 group-hover:bg-primary-500 group-hover:text-white transition-[border-color,background-color,box-shadow] duration-500 shadow-inner">
                                <i class="{{ $category->icon ?: 'ph-duotone ph-folder' }} text-2xl"></i>
                            </div>

                            <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-3 group-hover:text-primary-500 transition-colors leading-tight tracking-tight">
                                <a href="{{ route('kb.category', $category->slug) }}">{{ __($category->name) }}</a>
                            </h3>

                            <p class="text-slate-500 dark:text-slate-400 mb-6 line-clamp-2 font-medium leading-relaxed text-sm">
                                {{ __($category->description) }}
                            </p>

                            <a href="{{ route('kb.category', $category->slug) }}"
                                class="inline-flex items-center gap-2 text-primary-500 font-bold uppercase text-[10px] tracking-[0.2em] hover:text-slate-900 dark:hover:text-white transition-colors group/link px-4 py-1.5 rounded-full border border-primary-500/20 hover:bg-primary-500/20">
                                @lang('Enter Sector')
                                <i class="ph ph-bold ph-arrow-right group-hover/link:translate-x-1 transition-transform"></i>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- Popular Resources --}}
            @if ($popularArticles->count() > 0)
                <div class="pt-12 border-t border-slate-100 dark:border-white/10">
                    <div class="flex items-center gap-4 mb-10">
                        <div class="h-8 w-1.5 bg-primary-500 rounded-full shadow-lg shadow-primary-500/40"></div>
                        <h2 class="text-2xl font-bold text-slate-900 dark:text-white tracking-tight uppercase">@lang('High-Priority Logs')</h2>
                    </div>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach ($popularArticles as $article)
                            <a href="{{ route('kb.article', $article->slug) }}"
                                class="flex items-center gap-5 p-5 rounded-xl bg-white dark:bg-white/[0.03] border border-slate-100 dark:border-white/10 hover:border-primary-500/30 hover:bg-slate-50 dark:hover:bg-white/[0.08] transition-[border-color,background-color,color] group shadow-sm">
                                <div class="w-10 h-10 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:bg-primary-500 group-hover:text-white transition-[border-color,background-color,box-shadow] duration-500 shadow-inner">
                                    <i class="ph-duotone ph-article text-xl"></i>
                                </div>
                                <span class="text-slate-700 dark:text-slate-300 font-medium group-hover:text-slate-900 dark:group-hover:text-white transition-colors text-base tracking-tight">{{ __($article->title) }}</span>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<script nonce="{{ csp_nonce() }}">
    document.addEventListener('DOMContentLoaded', function() {
        let searchTimer;
        const searchInput = document.getElementById('sectionSearchInput');
        const searchResults = document.getElementById('sectionSearchResults');
        const resultsContent = document.getElementById('sectionResultsContent');
        const mainKbContent = document.getElementById('sectionMainKbContent');
        const loader = document.getElementById('sectionSearchLoader');
        const clearBtn = document.getElementById('clearSectionSearch');

        if (!searchInput) return;

        searchInput.addEventListener('input', function() {
            clearTimeout(searchTimer);
            const query = this.value;

            if (query.length < 2) {
                searchResults.classList.add('hidden');
                mainKbContent.classList.remove('hidden');
                return;
            }

            searchTimer = setTimeout(() => {
                executeSearch(query);
            }, 300);
        });

        clearBtn.addEventListener('click', function() {
            searchInput.value = '';
            searchInput.dispatchEvent(new Event('input'));
        });

        function executeSearch(query) {
            loader.classList.remove('hidden');
            fetch(`{{ route('kb.search.ajax') }}?q=${encodeURIComponent(query)}`)
                .then(response => response.json())
                .then(data => {
                    resultsContent.innerHTML = data.html;
                    searchResults.classList.remove('hidden');
                    mainKbContent.classList.add('hidden');
                    loader.classList.add('hidden');
                })
                .catch(() => {
                    loader.classList.add('hidden');
                });
        }
    });
</script>
