@php
    $migration = getContent('migration.content', true);
@endphp

<section class="relative py-20 lg:py-28 bg-slate-50 dark:bg-slate-950 transition-colors duration-300">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Header --}}
        <div class="text-center mb-12 max-w-4xl mx-auto">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __(@$migration->data_values->heading ?? 'The Hassle-Free Way to Migrate Your Website From Any Web Host') }}
            </h2>
        </div>

        <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            
            {{-- Left Side: Interactive Migration Illustration --}}
            <div class="relative hidden lg:block h-[400px]">
                {{-- Paper Plane Path SVG --}}
                <svg class="absolute inset-0 w-full h-full pointer-events-none overflow-visible" viewBox="0 0 500 400" fill="none">
                    <path id="planePath" d="M150,250 C200,150 300,150 350,250" stroke="currentColor" stroke-width="2" stroke-dasharray="8 8" class="text-slate-300 dark:text-white/10" />
                    
                    {{-- Flying Planes --}}
                    @for($i = 0; $i < 3; $i++)
                        <g class="animate-plane-fly" style="animation-delay: {{ $i * 1.5 }}s; offset-path: path('M150,250 C200,100 300,100 350,250');">
                             <path d="M-8,-4 L8,0 L-8,4 L-4,0 Z" fill="var(--primary)" />
                        </g>
                    @endfor
                </svg>

                {{-- Source Box (The Old Host) --}}
                <div class="absolute bottom-20 left-10 group">
                    <div class="relative w-40 h-40 bg-primary-500 rounded-2xl transform rotate-12 shadow-xl transition-transform group-hover:scale-105 duration-500">
                        <div class="absolute inset-0 bg-black/10 rounded-2xl"></div>
                        <div class="absolute top-4 left-4 right-4 h-4 bg-white/20 rounded-full"></div>
                        <div class="absolute top-12 left-4 right-8 h-3 bg-white/10 rounded-full"></div>
                        <i class="ph ph-bold ph-hard-drive absolute bottom-6 right-6 text-white/30 text-4xl"></i>
                    </div>
                    <div class="absolute -bottom-8 left-1/2 -translate-x-1/2 whitespace-nowrap text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">@lang('Current Host')</div>
                </div>

                {{-- Destination Box (salieno) --}}
                <div class="absolute bottom-20 right-10 group">
                    <div class="relative w-48 h-48 bg-green-500 rounded-2xl transform -rotate-12 shadow-[0_30px_60px_rgba(34,197,94,0.3)] transition-transform group-hover:scale-110 duration-500 border-4 border-white/20">
                         {{-- Inner Glow --}}
                        <div class="absolute inset-0 bg-[radial-gradient(circle_at_top_left,rgba(255,255,255,0.3),transparent)] rounded-xl"></div>
                        <div class="absolute inset-4 border-2 border-dashed border-white/30 rounded-2xl flex items-center justify-center">
                            <i class="ph ph-bold ph-rocket-launch text-white text-5xl animate-bounce"></i>
                        </div>
                    </div>
                    {{-- Highlight Ring --}}
                    <div class="absolute -inset-4 border-2 border-green-500/20 rounded-2xl animate-ping" style="animation-duration: 3s"></div>
                     <div class="absolute -bottom-8 left-1/2 -translate-x-1/2 whitespace-nowrap text-xs font-bold text-green-500 uppercase tracking-widest">@lang('Salieno')</div>
                </div>
            </div>

            {{-- Right Side: Steps Grid --}}
            <div class="space-y-8">
                <div class="text-center lg:text-left mb-8">
                    <p class="text-lg sm:text-xl text-slate-600 dark:text-slate-400 leading-relaxed max-w-xl mx-auto lg:mx-0">
                        {{ __(@$migration->data_values->description ?? 'Migrating your website is easier than you think. Save time and money by taking advantage of salieno\'s free and fast migration service. Kick back with a cold one, and let us do the work. It will take less than an hour with zero downtime.') }}
                    </p>
                </div>

                <div class="grid sm:grid-cols-2 gap-x-10 gap-y-10">
                    @php
                        $steps = [
                            ['title' => @$migration->data_values->step_1_title ?? 'Sign up', 'desc' => @$migration->data_values->step_1_desc ?? 'Head to our Plans & Pricing and choose the hosting plan that suits your needs.', 'icon' => 'ph-shopping-bag'],
                            ['title' => @$migration->data_values->step_2_title ?? 'Submit migration request', 'desc' => @$migration->data_values->step_2_desc ?? 'Log into your account and submit your free migration request.', 'icon' => 'ph-paper-plane-tilt'],
                            ['title' => @$migration->data_values->step_3_title ?? 'Migration ongoing', 'desc' => @$migration->data_values->step_3_desc ?? 'From there, one of our Migration experts will move your site(s) to us.', 'icon' => 'ph-path'],
                            ['title' => @$migration->data_values->step_4_title ?? 'Migration complete', 'desc' => @$migration->data_values->step_4_desc ?? 'That\'s it, your site(s) will be migrated right away!', 'icon' => 'ph-check-square-offset'],
                        ];
                    @endphp

                    @foreach($steps as $step)
                        <div class="relative group text-center sm:text-left px-4 sm:px-0">
                            {{-- Icon --}}
                            <div class="w-14 h-14 bg-primary-500/10 rounded-2xl flex items-center justify-center mb-6 mx-auto sm:mx-0 group-hover:bg-primary-600 group-hover:rotate-[15deg] transition-[border-color,background-color,box-shadow,transform] duration-300">
                                <i class="ph ph-bold {{ $step['icon'] }} text-primary-600 group-hover:text-white text-xl"></i>
                            </div>
                            <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-2 group-hover:text-primary-600 transition-colors">
                                {{ __($step['title']) }}
                            </h3>
                            <p class="text-slate-600 dark:text-slate-400 text-sm leading-relaxed">
                                {{ __($step['desc']) }}
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>

        </div>
    </div>

</section>
