@php
    // $pricingCalculator, $billingCycles, $allProducts, $globalLongestCycle provided by PricingComposer
    $pricingConfigPath = resource_path('data/pricing-config.json');
    $pricingConfig = file_exists($pricingConfigPath) ? json_decode(file_get_contents($pricingConfigPath), true) : [];
@endphp

@php
    $pricingContent = getContent('pricing.content', true);
@endphp

<section id="pricing" class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 overflow-hidden transition-colors duration-300" x-data="{
    billingCycle: '{{ $globalLongestCycle }}',
    category: '{{ isset($serviceCategories) && $serviceCategories->first() ? $serviceCategories->first()->slug : 'shared' }}'
}">
    {{-- Decorative backgrounds --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute top-0 right-0 w-[400px] h-[400px] bg-primary-500/5 rounded-full blur-[120px]"></div>
        <div class="absolute bottom-0 left-0 w-[400px] h-[400px] bg-primary-500/5 rounded-full blur-[120px]"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center mb-10 lg:mb-14">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __(@$pricingContent->data_values->heading ?? 'Powering Your Ambition with Performance Hosting') }}
            </h2>
            <p class="text-lg sm:text-xl text-slate-500 dark:text-slate-400 max-w-2xl mx-auto leading-relaxed">
                {{ __(@$pricingContent->data_values->subheading ?? 'Choose from our range of cloud-optimized hosting solutions designed to scale with your business.') }}
            </p>

            {{-- Billing Cycle Switcher --}}
            <div class="mt-8 flex justify-center">
                <x-theme.pricing.cycle-switcher 
                    :cycles="$billingCycles" 
                    :selected="$globalLongestCycle"
                />
            </div>
        </div>

        {{-- Pricing Grid --}}
        @if(isset($serviceCategories) && $serviceCategories->count() > 0)
            @foreach($serviceCategories as $cat)
                <div x-show="category === '{{ $cat->slug }}'" x-transition:enter="transition ease-out duration-500"
                    x-transition:enter-start="opacity-0 translate-y-12" x-transition:enter-end="opacity-100 translate-y-0">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 lg:gap-10 items-stretch">
                        @foreach($cat->activeProducts->take(3) as $product)
                            @php
                                $pricingData = $pricingCalculator->getProductPricingForJs($product);
                                $isRecommended = $product->is_recommended;
                            @endphp

                            <div class="group relative" x-data='{ pricing: @json($pricingData) }'>
                                {{-- Plan Card --}}
                                <div class="relative h-full flex flex-col p-6 sm:p-8 rounded-2xl bg-white dark:bg-slate-900 border-2 transition-[border-color,background-color,box-shadow,transform] duration-500 {{ $isRecommended ? 'border-primary-500 shadow-xl shadow-primary-500/10' : 'border-slate-100 dark:border-white/5 hover:border-primary-500/30 shadow-lg shadow-slate-200/50 dark:shadow-none' }} group-hover:-translate-y-1">
                                    
                                    {{-- Popular Badge --}}
                                    @if($isRecommended)
                                        <div class="absolute -top-4 left-1/2 -translate-x-1/2 px-5 py-1.5 rounded-full bg-primary-600 text-white text-[10px] font-bold uppercase tracking-[0.2em] shadow-lg">
                                            @lang('MOST POPULAR')
                                        </div>
                                    @endif

                                    {{-- Plan Info --}}
                                    <div class="mb-6 text-center lg:text-left">
                                        <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-2 uppercase tracking-tight">
                                            {{ __($product->name) }}
                                        </h3>
                                        <p class="text-sm text-slate-500 dark:text-slate-400 font-medium">
                                            {{ Str::limit($product->tagline ?? $product->description, 60) }}
                                        </p>
                                    </div>

                                    {{-- Price --}}
                                    <div class="mb-6 text-center lg:text-left flex flex-col items-center lg:items-start min-h-[80px]">
                                        <template x-if="pricing.prices[billingCycle]">
                                            <div class="flex flex-col">
                                                <div class="flex items-baseline gap-1">
                                                    <span class="text-xl font-bold text-slate-900 dark:text-white">{{ gs('cur_sym') }}</span>
                                                    <span class="text-3xl font-extrabold tracking-tight text-slate-900 dark:text-white" x-text="pricing.prices[billingCycle].display_raw"></span>
                                                    <span class="text-slate-500 dark:text-slate-400 font-bold text-lg uppercase">/mo</span>
                                                </div>
                                                
                                                <div class="mt-2 flex items-center gap-3" x-show="pricing.prices[billingCycle].has_discount">
                                                    <span class="text-base text-slate-500 dark:text-slate-400 line-through font-medium" x-text="pricing.prices[billingCycle].original_raw"></span>
                                                    <span class="px-2 py-0.5 rounded-lg bg-primary-500/10 text-primary-600 dark:text-primary-400 text-xs font-bold">
                                                        @lang('SAVE') <span x-text="pricing.prices[billingCycle].discount_badge"></span>
                                                    </span>
                                                </div>
                                            </div>
                                        </template>
                                        <template x-if="!pricing.prices[billingCycle]">
                                            <div class="h-full flex items-center">
                                                <span class="text-slate-300 dark:text-slate-700 font-bold uppercase tracking-widest text-base">@lang('Not Available')</span>
                                            </div>
                                        </template>
                                    </div>

                                    {{-- CTA --}}
                                    <div class="mb-6">
                                        <a :href="pricing.prices[billingCycle] ? '{{ route('products.category', $cat->slug) }}' : '{{ route('contact') }}'" 
                                        class="w-full h-11 rounded-xl font-bold text-sm transition-[background-color,color,transform] duration-300 flex items-center justify-center gap-2 shadow-md {{ $isRecommended ? 'bg-primary-600 hover:bg-primary-700 text-white shadow-primary-500/20' : 'bg-slate-100 dark:bg-white/5 text-slate-900 dark:text-white hover:bg-primary-600 hover:text-white' }}"
                                        :class="!pricing.prices[billingCycle] && 'opacity-80 grayscale-[0.5]'">
                                            <span x-text="pricing.prices[billingCycle] ? '{{ __('Get Started') }}' : '{{ __('Contact Sales') }}'"></span>
                                            <i class="ph ph-arrow-right font-bold"></i>
                                        </a>
                                    </div>

                                    {{-- Features --}}
                                    <div class="space-y-3 pt-6 border-t border-slate-100 dark:border-white/5">
                                        @foreach($product->features->take(6) as $feature)
                                            <div class="flex items-center gap-4 group/feat">
                                                <div class="flex-shrink-0 w-6 h-6 rounded-full {{ $isRecommended ? 'bg-primary-500/10 text-primary-600' : 'bg-slate-100 dark:bg-white/5 text-slate-500 dark:text-slate-400' }} flex items-center justify-center transition-colors group-hover/feat:bg-primary-500 group-hover/feat:text-white">
                                                    @if($feature->type === 'excluded')
                                                        <i class="ph ph-x text-xs font-bold"></i>
                                                    @else
                                                        <i class="ph ph-check text-xs font-bold"></i>
                                                    @endif
                                                </div>
                                                <span class="text-sm font-bold {{ $feature->type === 'excluded' ? 'text-slate-400 opacity-60 line-through' : 'text-slate-600 dark:text-slate-300' }}">
                                                    {{ \App\Helpers\FeatureHelper::getCombinedValue($feature) }}
                                                </span>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    {{-- View All Button --}}
                    <div class="text-center mt-8">
                        <x-theme.btn-secondary href="{{ route('products.category', $cat->slug) }}" :icon="true">
                            @lang('View All') {{ __($cat->name) }} @lang('Plans')
                        </x-theme.btn-secondary>
                    </div>
                </div>
            @endforeach
        @endif

        {{-- Guarantee Bar --}}
        <div class="mt-12 py-6 px-8 rounded-2xl bg-slate-50 dark:bg-white/5 border border-dashed border-slate-200 dark:border-white/10 flex flex-col sm:flex-row items-center justify-center gap-5">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 rounded-full bg-primary-500/10 flex items-center justify-center text-primary-600 dark:text-primary-400">
                    <i class="ph ph-shield-check text-2xl font-bold"></i>
                </div>
                <span class="text-base font-bold text-slate-900 dark:text-white uppercase tracking-tight">{{ __(@$pricingContent->data_values->guarantee_text ?? '30-Day Money-Back Guarantee') }}</span>
            </div>
            <div class="hidden sm:block h-8 w-px bg-slate-200 dark:bg-white/10"></div>
            <div class="flex flex-wrap justify-center gap-x-8 gap-y-4">
                @php
                    $globalFeatures = ['99.9% Uptime SLA', 'Free Weekly Backups', '24/7 Expert Support', 'Enterprise Security'];
                @endphp
                @foreach($globalFeatures as $gFeat)
                    <div class="flex items-center gap-2 text-sm font-bold text-slate-500 dark:text-slate-400">
                        <i class="ph ph-sparkle text-primary-500"></i>
                        <span>{{ __($gFeat) }}</span>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
        @else
            {{-- Fallback Static Pricing --}}
            @php
                $staticProducts = [
                    ['name' => 'Nebula Starter', 'desc' => 'Perfect for personal blogs', 'monthly' => 5.99, 'features' => ['1 Website', '10GB NVMe Storage', 'Unlimited Bandwidth', 'Free SSL']],
                    ['name' => 'Galaxy Pro', 'desc' => 'For growing businesses', 'monthly' => 12.99, 'highlight' => true, 'features' => ['Unlimited Websites', '50GB NVMe Storage', 'Unlimited Bandwidth', 'Free Domain', 'Priority Support']],
                    ['name' => 'Cosmos Enterprise', 'desc' => 'Maximum performance', 'monthly' => 24.99, 'features' => ['Dedicated IP', '100GB NVMe Storage', 'Advanced Security', 'Free Migration']],
                ];
            @endphp
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 items-start">
                @foreach($staticProducts as $product)
                    <div
                        class="relative group rounded-2xl p-1 transition-[border-color,background-color,box-shadow,transform] duration-500 hover:-translate-y-2 {{ isset($product['highlight']) ? 'bg-gradient-to-b from-primary-500 via-primary-500 to-primary-700 shadow-xl shadow-primary-500/20' : 'bg-slate-200/50 dark:bg-white/5 border border-slate-200 dark:border-white/10' }}">
                        <div class="h-full bg-white dark:bg-slate-900/90 backdrop-blur-xl rounded-2xl p-6 overflow-hidden relative shadow-xl shadow-slate-200/50 dark:shadow-none">
                            @if(isset($product['highlight']))
                                <div
                                    class="absolute top-0 left-1/2 -translate-x-1/2 bg-primary-600 text-white text-[10px] font-bold px-3 py-1 rounded-b-lg uppercase tracking-widest shadow-lg shadow-primary-500/40 z-20">
                                    @lang('Most Popular')
                                </div>
                            @endif

                            <div class="relative z-10">
                                <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-2">{{ $product['name'] }}</h3>
                                <p class="text-slate-500 dark:text-slate-400 text-sm mb-6 h-10">{{ $product['desc'] }}</p>

                                <div class="flex items-baseline mb-8">
                                    <span class="text-xs font-bold text-slate-500 dark:text-slate-400 uppercase self-start mt-2 mr-1">{{ gs('cur_sym') }}</span>
                                    <span class="text-3xl font-extrabold text-slate-900 dark:text-white"
                                        x-text="billingCycle === 'monthly' ? '{{ number_format($product['monthly'], 2) }}' : ({{ $product['monthly'] }} * 0.8).toFixed(2)">
                                        {{ number_format($product['monthly'], 2) }}
                                    </span>
                                    <span class="text-slate-500 dark:text-slate-400 ml-2 font-medium">/mo</span>
                                </div>

                                <a href="{{ route('pricing') }}"
                                    class="w-full mb-8 h-12 rounded-xl font-bold flex items-center justify-center gap-2 {{ isset($product['highlight']) ? 'bg-primary-600 text-white' : 'bg-slate-100 text-slate-900 dark:bg-primary-600 dark:text-white' }}">
                                    @lang('Deploy Now')
                                    <svg class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 10V3L4 14h7v7l9-11h-7z" />
                                    </svg>
                                </a>

                                <div class="space-y-4">
                                    @foreach($product['features'] as $feature)
                                        <div class="flex items-start text-sm">
                                            <div
                                                class="mr-3 mt-0.5 w-5 h-5 rounded-full flex items-center justify-center bg-slate-100 text-slate-500 dark:bg-slate-800 dark:text-slate-400">
                                                <svg class="w-3 h-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M5 13l4 4L19 7" />
                                                </svg>
                                            </div>
                                            <span class="text-slate-600 dark:text-slate-300">{{ $feature }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</section>


