@php
    $reasonsContent = getContent('reasons.content', true);
    $reasonsElements = getContent('reasons.element');
@endphp

<section class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16 px-4">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight max-w-4xl mx-auto">
                {{ __(@$reasonsContent->data_values->heading ?? 'Need Even More Reasons To Choose salieno?') }}
            </h2>
            <p class="text-lg sm:text-xl text-slate-600 dark:text-slate-400 max-w-3xl mx-auto leading-relaxed">
                {{ __(@$reasonsContent->data_values->subheading ?? 'You\'ll get a free domain name, along with the best hosting and customer service. Every hosting plan we offer also comes with a money-back guarantee and an uptime guarantee.') }}
            </p>
        </div>

        {{-- Features Grid --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 lg:gap-x-12 lg:gap-y-12">
            @if(count($reasonsElements) > 0)
                @foreach($reasonsElements as $item)
                    <div class="group text-center">
                        {{-- Icon Container --}}
                        <div class="relative w-16 h-16 mx-auto mb-6 transition-transform duration-500 group-hover:scale-110 flex items-center justify-center">
                            {{-- Glow effect --}}
                            <div class="absolute inset-0 bg-primary-500/10 dark:bg-primary-500/20 rounded-2xl blur-xl opacity-0 group-hover:opacity-100 transition-opacity"></div>
                            
                            {{-- Icon Shape --}}
                            <div class="relative w-14 h-14 bg-primary-500/5 dark:bg-white/5 rounded-2xl flex items-center justify-center group-hover:bg-primary-600 transition-[border-color,background-color,box-shadow,transform] duration-300">
                                @php
                                    $icon = @$item->data_values->icon;
                                @endphp
                                @if(str_contains($icon, 'ph-'))
                                    <i class="ph {{ str_contains($icon, 'ph-') ? $icon : 'ph-' . $icon }} text-primary-600 group-hover:text-white text-2xl"></i>
                                @elseif(str_contains($icon, 'fa-'))
                                    <i class="ph ph-star text-primary-600 group-hover:text-white text-2xl"></i>
                                @else
                                    <img src="{{ filter_var($icon, FILTER_VALIDATE_URL) ? $icon : getImage(getFilePath('reasons').'/'.$icon) }}" 
                                         alt="{{ $item->data_values->title }}" loading="lazy" width="40" height="40" class="w-10 h-10 object-contain">
                                @endif
                            </div>
                        </div>

                        {{-- Text Content --}}
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-2 group-hover:text-primary-600 transition-colors break-words px-2">
                            {{ __($item->data_values->title) }}
                        </h3>
                        <p class="text-sm sm:text-base text-slate-600 dark:text-slate-400 leading-relaxed px-2">
                            {{ __($item->data_values->description) }}
                        </p>
                    </div>
                @endforeach
            @else
                {{-- Fallback Demo content based on the user image --}}
                @php
                    $demoFeatures = [
                        ['title' => '45 Days Money-Back Guarantee', 'desc' => 'If you\'re not completely happy within your first 45 days with us, we\'ll refund your money: no hassle, no questions, no worry.', 'icon' => 'ph-hand-coins'],
                        ['title' => 'Easy to Use Hosting', 'desc' => 'Web hosting should be easy to use. Log in to your account, and you\'ll see just how easy it is to get started with many cPanel tools just a click away.', 'icon' => 'ph-cursor-click'],
                        ['title' => '99.99% Uptime Guarantee', 'desc' => 'Uptime is a lot better than downtime. That\'s why you\'ll never have to worry about your website going down again with our 99.99% uptime guarantee.', 'icon' => 'ph-chart-line-up'],
                        ['title' => 'Free SSL Certificate', 'desc' => 'Keep your data encrypted, secure, and out of the hands of bad guys. All of our web hosting plans come with a free Let\'s Encrypt SSL certificate.', 'icon' => 'ph-shield-check'],
                        ['title' => 'Free Domain', 'desc' => 'Get your first year of domain registration on us when you choose 36-month billing cycle plans. This offer covers the most popular domain extensions.', 'icon' => 'ph-globe'],
                        ['title' => 'Reliable Cloud Platform', 'desc' => 'Rest assured that our cloud hosting infrastructure will ensure your information and data is always safely hosted in the cloud against any failure.', 'icon' => 'ph-cloud'],
                    ];
                @endphp
                @foreach($demoFeatures as $feature)
                    <div class="group text-center">
                        <div class="w-14 h-14 bg-primary-500/10 rounded-2xl flex items-center justify-center mx-auto mb-6 group-hover:bg-primary-600 transition-[border-color,background-color,box-shadow,transform] duration-300">
                             <i class="ph {{ $feature['icon'] }} text-primary-600 group-hover:text-white text-2xl"></i>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-2">
                            {{ __($feature['title']) }}
                        </h3>
                        <p class="text-slate-600 dark:text-slate-400 leading-relaxed">
                            {{ __($feature['desc']) }}
                        </p>
                    </div>
                @endforeach
            @endif
        </div>
    </div>
</section>
