@php
    $reasonsContent = getContent('reasons_for_reseller.content', true);
    $reasonsElements = getContent('reasons_for_reseller.element', false, null, true);
    $reasonsJson = json_decode(file_get_contents(resource_path('data/reasons-for-reseller.json')), true);

    $heading = @$reasonsContent->data_values->heading ?? $reasonsJson['heading'];
    
    // For tabs, we merge CMS elements with JSON structure to preserve map/points logic if elements are simple text
    $tabs = count($reasonsElements) > 0 ? $reasonsElements : $reasonsJson['tabs'];
    $locations = $reasonsJson['locations']; // Keep map locations in JSON for now
@endphp

<section class="py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300 overflow-hidden" x-data="{ activeTab: 'data_centers' }">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Heading --}}
        <div class="text-center mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __($heading) }}
            </h2>
        </div>

        {{-- Tab Switcher --}}
        @php
            $tabItems = [];
            $tabIndex = 0;
            foreach ($tabs as $tab) {
                $tabData = is_object($tab) ? $tab->data_values : (object)$tab;
                $tabId = property_exists($tabData, 'id') ? $tabData->id : (isset($tab['id']) ? $tab['id'] : 'tab_'.$tabIndex);
                $tabItems[$tabId] = $tabData->label;
                $tabIndex++;
            }
        @endphp
        <x-theme.ui.tabs :tabs="$tabItems" model="activeTab" size="lg" class="mb-12" />

        {{-- Tab Content --}}
        @foreach($tabs as $tab)
            @php
                $tabData = is_object($tab) ? $tab->data_values : (object)$tab;
                $tabId = property_exists($tabData, 'id') ? $tabData->id : (isset($tab['id']) ? $tab['id'] : 'tab_'.$loop->index);
                // Handle points array/object
                $points = property_exists($tabData, 'points') ? $tabData->points : (isset($tab['points']) ? $tab['points'] : []);
            @endphp
            <div x-show="activeTab === '{{ $tabId }}'" 
                 x-transition:enter="transition ease-out duration-500"
                 x-transition:enter-start="opacity-0 translate-y-8"
                 x-transition:enter-end="opacity-100 translate-y-0"
                 class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
                
                {{-- Left Side: Text Content --}}
                <div class="space-y-8">
                    <div>
                        <h3 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white mb-3 leading-tight">
                            {{ __($tabData->title) }}
                        </h3>
                        <p class="text-base text-slate-500 dark:text-slate-400 leading-relaxed font-medium">
                            {{ __($tabData->description) }}
                        </p>
                    </div>

                    <div class="space-y-6">
                        @foreach($points as $point)
                            @php $p = (object)$point; @endphp
                            <div class="group">
                                <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 group-hover:text-primary-600 transition-colors">
                                    {{ __($p->title) }}
                                </h4>
                                <p class="text-slate-500 dark:text-slate-400 text-sm leading-relaxed">
                                    {{ __($p->desc) }}
                                </p>
                            </div>
                        @endforeach
                    </div>

                   
                </div>

                {{-- Right Side: Illustration --}}
                <div class="relative">
                    @if($tabId === 'data_centers')
                        {{-- World Map --}}
                        <div class="relative w-full aspect-[16/10] flex items-center justify-center">
                            {{-- High-Quality Dotted World Map SVG --}}
                            <div class="relative w-full h-full">
                                <svg viewBox="0 0 1000 500" class="w-full h-full fill-slate-300 dark:fill-white/10" id="world-map">
                                    <circle cx="500" cy="250" r="230" fill="url(#mapGrad)" opacity="0.05" class="animate-pulse" />
                                    <defs>
                                        <radialGradient id="mapGrad" cx="50%" cy="50%" r="50%">
                                            <stop offset="0%" stop-color="var(--primary)" />
                                            <stop offset="100%" stop-color="transparent" />
                                        </radialGradient>
                                        {{-- Professional Pin Symbol --}}
                                        <symbol id="map-pin">
                                            <filter id="pinShadow" x="-20%" y="-20%" width="140%" height="140%">
                                                <feDropShadow dx="0" dy="2" stdDeviation="2" flood-opacity="0.3"/>
                                            </filter>
                                            <g filter="url(#pinShadow)">
                                                <path d="M0 0 C-4 -4 -6 -8 -6 -10 A6 6 0 1 1 6 -10 C6 -8 4 -4 0 0 Z" fill="currentColor" />
                                                <circle cx="0" cy="-10" r="2.5" fill="white" />
                                            </g>
                                        </symbol>
                                    </defs>
                                    
                                    {{-- Dotted World Map Path --}}
                                    <g opacity="0.4">
                                        @php
                                            // Array to generate a simple dotted world representation
                                            $dots = [
                                                ['r' => 150, 'c' => 200], ['r' => 160, 'c' => 220], ['r' => 170, 'c' => 210],
                                                ['r' => 180, 'c' => 230], ['r' => 190, 'c' => 250], ['r' => 200, 'c' => 280],
                                                ['r' => 210, 'c' => 310], ['r' => 220, 'c' => 450], ['r' => 240, 'c' => 480],
                                                ['r' => 260, 'c' => 500], ['r' => 280, 'c' => 520], ['r' => 300, 'c' => 680],
                                                ['r' => 320, 'c' => 780], ['r' => 340, 'c' => 850], ['r' => 360, 'c' => 500],
                                                ['r' => 380, 'c' => 480], ['r' => 400, 'c' => 250], ['r' => 420, 'c' => 220]
                                            ];
                                        @endphp
                                        @foreach(range(0, 1000, 18) as $x)
                                            @foreach(range(0, 500, 18) as $y)
                                                @php
                                                    // This is a pseudo-random dot pattern that roughly resembles continents
                                                    $visible = (
                                                        ($x > 100 && $x < 350 && $y > 100 && $y < 350) || // N. America
                                                        ($x > 150 && $x < 300 && $y > 300 && $y < 450) || // S. America
                                                        ($x > 450 && $x < 550 && $y > 80 && $y < 250) || // Europe
                                                        ($x > 450 && $x < 650 && $y > 220 && $y < 450) || // Africa
                                                        ($x > 600 && $x < 900 && $y > 100 && $y < 350) || // Asia
                                                        ($x > 750 && $x < 950 && $y > 350 && $y < 480)    // Australia
                                                    );
                                                @endphp
                                                @if($visible)
                                                    <circle cx="{{ $x }}" cy="{{ $y }}" r="1.5" fill="currentColor" />
                                                @endif
                                            @endforeach
                                        @endforeach
                                    </g>
                                </svg>

                                {{-- Location Pins (Absolute Positioned) --}}
                                @foreach($locations as $loc)
                                    <div class="absolute group/marker" style="top: {{ $loc['top'] }}; left: {{ $loc['left'] }}; transform: translate(-50%, -100%);">
                                        {{-- Pulse Effect --}}
                                        <div class="absolute top-full left-1/2 -translate-x-1/2 -translate-y-1/2 w-8 h-8 rounded-full animate-ping opacity-20 pointer-events-none" style="background: {{ $loc['color'] }};"></div>
                                        
                                        {{-- Design Pin --}}
                                        <div class="relative flex flex-col items-center">
                                            <svg width="24" height="32" viewBox="-12 -32 24 32" class="mb-2">
                                                <use href="#map-pin" style="color: {{ $loc['color'] }};" />
                                            </svg>
                                            
                                            {{-- Label (Matching Image) --}}
                                            <div class="px-2.5 py-1 rounded-md text-[10px] font-bold uppercase tracking-widest text-white shadow-xl opacity-0 group-hover/marker:opacity-100 transition-[opacity,transform] duration-300 translate-y-2 group-hover/marker:translate-y-0 whitespace-nowrap z-20 pointer-events-none"
                                                 style="background: {{ $loc['color'] }}; border: 1px solid rgba(255,255,255,0.2);">
                                                {{ $loc['name'] }}
                                            </div>
                                            
                                            {{-- Persistent Label --}}
                                            <div class="mt-1 px-2 py-0.5 rounded bg-white dark:bg-slate-800 border-2 border-slate-100 dark:border-white/5 text-[8px] font-bold uppercase tracking-tight text-slate-500 dark:text-slate-400 whitespace-nowrap shadow-sm">
                                                {{ $loc['name'] }}
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                    @else
                        {{-- Management Illustration (Secondary Tab) --}}
                        <div class="relative bg-slate-50 dark:bg-white/5 rounded-2xl p-8 overflow-hidden">
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                                <div class="h-28 rounded-2xl bg-white dark:bg-slate-800 shadow-lg p-5 flex flex-col justify-between">
                                    <div class="w-10 h-10 rounded-xl bg-primary-600/10 text-primary-600 flex items-center justify-center">
                                        <i class="ph ph-shield-check text-xl"></i>
                                    </div>
                                    <div class="h-1.5 w-full bg-slate-100 dark:bg-white/5 rounded-full"></div>
                                </div>
                                <div class="h-40 rounded-2xl bg-primary-600 shadow-xl shadow-primary-500/30 p-6 flex flex-col justify-between text-white">
                                    <i class="ph ph-chart-line text-3xl opacity-40"></i>
                                    <div class="text-2xl font-extrabold">99.9%</div>
                                </div>
                                <div class="col-span-2 h-28 rounded-2xl bg-white dark:bg-slate-800 shadow-lg p-6 flex items-center gap-5">
                                    <div class="w-12 h-12 rounded-xl bg-primary-500/10 text-primary-500 flex items-center justify-center">
                                        <i class="ph ph-users-three text-2xl"></i>
                                    </div>
                                    <div class="space-y-3 flex-1">
                                        <div class="h-2 w-1/2 bg-slate-200 dark:bg-white/10 rounded-full"></div>
                                        <div class="h-1.5 w-full bg-slate-100 dark:bg-white/10 rounded-full"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @endforeach
    </div>
</section>
