@php
    $resellerFeaturesContent = getContent('reseller_hosting_features.content', true);
    $resellerFeaturesElements = getContent('reseller_hosting_features.element', false, null, true);
    $resellerJson = json_decode(file_get_contents(resource_path('data/reseller-hosting-features.json')), true);

    $heading = @$resellerFeaturesContent->data_values->heading ?? $resellerJson['heading'];
    $platformHeading = @$resellerFeaturesContent->data_values->platform_heading ?? $resellerJson['platform_heading'];
    $platformDescription = @$resellerFeaturesContent->data_values->platform_description ?? $resellerJson['platform_description'];
    
    $features = count($resellerFeaturesElements) > 0 ? $resellerFeaturesElements : $resellerJson['features'];

    // Advanced Configurability Tokens
    $accent = @$resellerFeaturesContent->data_values->accent_color ?: 'primary';
    $bgStyle = @$resellerFeaturesContent->data_values->bg_style ?: 'white';
    $illuType = @$resellerFeaturesContent->data_values->illustration_type ?: 'svg';
    $imgUrl = @$resellerFeaturesContent->data_values->image_url;

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-500', 'bg-text' => 'bg-primary-600', 'text' => 'text-primary-600', 'badge' => 'bg-primary-500/10', 'glow' => 'bg-primary-500/5'],
        'orange'  => ['bg' => 'bg-primary-500', 'bg-text' => 'bg-primary-600', 'text' => 'text-primary-600', 'badge' => 'bg-primary-500/10', 'glow' => 'bg-primary-500/5'],
        'rose'    => ['bg' => 'bg-primary-500', 'bg-text' => 'bg-primary-600', 'text' => 'text-primary-600', 'badge' => 'bg-primary-500/10', 'glow' => 'bg-primary-500/5'],
        'indigo'  => ['bg' => 'bg-primary-500', 'bg-text' => 'bg-primary-600', 'text' => 'text-primary-600', 'badge' => 'bg-primary-500/10', 'glow' => 'bg-primary-500/5'],
        'blue'    => ['bg' => 'bg-primary-500', 'bg-text' => 'bg-primary-600', 'text' => 'text-primary-600', 'badge' => 'bg-primary-500/10', 'glow' => 'bg-primary-500/5'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];

    $sectionBg = $bgStyle === 'slate' ? 'bg-slate-50 dark:bg-slate-900 border-y border-slate-100 dark:border-white/5' : 'bg-white dark:bg-slate-950';
@endphp

<section class="py-20 lg:py-28 {{ $sectionBg }} transition-colors duration-300">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Heading --}}
        <div class="text-center mb-12">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __($heading) }}
            </h2>
        </div>

        {{-- Top Section: Illustration & Text --}}
        <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center mb-12 lg:mb-16">
            {{-- Left Content --}}
            <div class="order-2 lg:order-1">
                <h3 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white mb-3 leading-tight">
                    {{ __($platformHeading) }}
                </h3>
                <p class="text-base text-slate-600 dark:text-slate-400 leading-relaxed mb-6">
                    {{ __($platformDescription) }}
                </p>
            </div>

            {{-- ILLUSTRATION AREA --}}
            <div class="order-1 lg:order-2 relative group">
                @if($illuType === 'image' && $imgUrl)
                    <div class="relative group">
                        <div class="absolute -inset-10 {{ $style['glow'] }} rounded-full blur-[80px] opacity-60"></div>
                        <img src="{{ getImage(getFilePath('reseller_hosting_features').'/'.$imgUrl) }}" alt="Platform Illustration" loading="lazy" width="600" height="400" class="relative z-10 w-full h-auto rounded-2xl shadow-xl">
                    </div>
                @elseif($illuType === 'svg')
                <div class="relative">
                    {{-- Glow background --}}
                    <div class="absolute -inset-10 {{ $style['glow'] }} rounded-full blur-[80px] opacity-60"></div>
                    
                    <svg viewBox="0 0 500 400" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto relative z-10" id="reseller-platform-svg" style="--primary: currentColor;" class="{{ $style['text'] }}">
                        <defs>
                            <filter id="soft-shadow" x="-20%" y="-20%" width="140%" height="140%">
                                <feDropShadow dx="0" dy="10" stdDeviation="15" flood-opacity="0.1"/>
                            </filter>
                            <linearGradient id="gauge-grad" x1="0%" y1="0%" x2="100%" y2="0%">
                                <stop offset="0%" stop-color="#ef4444" />
                                <stop offset="50%" stop-color="#f59e0b" />
                                <stop offset="100%" stop-color="#10b981" />
                            </linearGradient>
                        </defs>

                        {{-- Main Dashboard Frame --}}
                        <g filter="url(#soft-shadow)">
                            <rect x="50" y="50" width="350" height="250" rx="20" fill="white" class="dark:fill-slate-800" />
                            {{-- Dashboard Header --}}
                            <path d="M50 70 q0 -20 20 -20 h310 q20 0 20 20 v30 h-350 z" fill="currentColor" opacity="0.1" />
                            <rect x="70" y="65" width="50" height="8" rx="4" fill="currentColor" opacity="0.5" />
                            {{-- Sidebar dots --}}
                            <circle cx="350" cy="70" r="3" fill="var(--svg-subtle)" class="dark:fill-white/10" />
                            <circle cx="365" cy="70" r="3" fill="var(--svg-subtle)" class="dark:fill-white/10" />
                            <circle cx="380" cy="70" r="3" fill="var(--svg-subtle)" class="dark:fill-white/10" />
                        </g>

                        {{-- Your Brand Tag --}}
                        <g transform="translate(65, 60)">
                            <rect width="60" height="18" rx="9" fill="var(--svg-mid)" />
                            <text x="30" y="12" text-anchor="middle" font-size="6" font-weight="900" fill="white" class="uppercase tracking-widest">Your Brand</text>
                        </g>

                        {{-- Dashboard Sections --}}
                        <rect x="235" y="110" width="140" height="60" rx="12" fill="var(--svg-surface)" class="dark:fill-white/5" />
                        <rect x="235" y="180" width="65" height="100" rx="12" fill="#fff7ed" class="dark:fill-primary-500/5 text-primary-500" stroke="currentColor" stroke-opacity="0.1" />
                        <rect x="310" y="180" width="65" height="100" rx="12" fill="#f0f9ff" class="dark:fill-primary-500/5 text-primary-500" stroke="currentColor" stroke-opacity="0.1" />

                        {{-- SPEEDOMETER (Central Element) --}}
                        <g transform="translate(225, 140)" filter="url(#soft-shadow)">
                            <circle r="70" fill="white" class="dark:fill-slate-900" />
                            {{-- Gauge Arc --}}
                            <path d="M-50 20 A55 55 0 1 1 50 20" fill="none" stroke="url(#gauge-grad)" stroke-width="12" stroke-linecap="round" />
                            {{-- Needle --}}
                            <g transform="rotate(45)">
                                <path d="M0 0 L-2 -50 L0 -55 L2 -50 Z" fill="var(--svg-mid)" class="dark:fill-white" />
                                <circle r="6" fill="var(--svg-mid)" class="dark:fill-white" />
                            </g>
                        </g>

                        {{-- BRIEFCASE (Floating Element) --}}
                        <g transform="translate(140, 240)" filter="url(#soft-shadow)" class="svg-float">
                            <rect width="110" height="90" rx="15" fill="#10B981" />
                            {{-- Handle --}}
                            <path d="M35 0 q0 -10 10 -10 h20 q10 0 10 10 v10 h-40 z" fill="#059669" />
                            {{-- Dollar sign --}}
                            <text x="55" y="60" text-anchor="middle" font-size="40" font-weight="900" fill="white">$</text>
                        </g>

                        {{-- CLIENT NODES A&B --}}
                        <g transform="translate(360, 150)" class="svg-float-alt">
                            <rect width="60" height="70" rx="12" fill="white" filter="url(#soft-shadow)" class="dark:fill-slate-800" />
                            <text x="30" y="45" text-anchor="middle" font-size="28" font-weight="900" fill="#10B981" opacity="0.6">A</text>
                        </g>
                        <g transform="translate(360, 240)" class="svg-float" style="animation-delay: 1.5s">
                            <rect width="60" height="70" rx="12" fill="white" filter="url(#soft-shadow)" class="dark:fill-slate-800" />
                            <text x="30" y="45" text-anchor="middle" font-size="28" font-weight="900" fill="#3B82F6" opacity="0.6">B</text>
                        </g>
                    </svg>
                </div>
                @endif
            </div>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-x-10 gap-y-10">
            @foreach($features as $feature)
                @php
                    $featureData = is_object($feature) ? $feature->data_values : (object)$feature;
                @endphp
                <div class="group">
                    <div class="w-12 h-12 rounded-xl {{ $style['badge'] }} flex items-center justify-center mb-6 group-hover:{{ $style['bg'] }} group-hover:text-white transition-[border-color,background-color,box-shadow,transform] duration-300">
                        <i class="ph {{ $featureData->icon }} {{ $style['text'] }} group-hover:text-white text-2xl font-bold"></i>
                    </div>
                    <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 group-hover:{{ $style['text'] }} transition-colors">
                        {{ __($featureData->title) }}
                    </h4>
                    <p class="text-slate-600 dark:text-slate-400 text-sm leading-relaxed">
                        {{ __($featureData->description) }}
                    </p>
                </div>
            @endforeach
        </div>
    </div>
</section>
