@php
    $salienoContent = getContent('reseller_hosting_salieno.content', true);
    $salienoElements = getContent('reseller_hosting_salieno.element', false, null, true);
    $salienoJson = json_decode(file_get_contents(resource_path('data/reseller-hosting-salieno.json')), true);

    $headingStart = @$salienoContent->data_values->heading_start ?? $salienoJson['heading_start'];
    $headingEnd = @$salienoContent->data_values->heading_end ?? $salienoJson['heading_end'];
    $buttonText = @$salienoContent->data_values->button_text ?? $salienoJson['button_text'];
    $buttonUrl = @$salienoContent->data_values->button_url ?? $salienoJson['button_url'];

    // Specific Images
    $screenshot1 = getImage(getFilePath('reseller_hosting_salieno') . '/' . @$salienoContent->data_values->screenshot_1);
    if(!$screenshot1 || str_contains($screenshot1, 'default')) $screenshot1 = $salienoJson['screenshot_1'];
    
    $screenshot2 = getImage(getFilePath('reseller_hosting_salieno') . '/' . @$salienoContent->data_values->screenshot_2);
    if(!$screenshot2 || str_contains($screenshot2, 'default')) $screenshot2 = $salienoJson['screenshot_2'];
    
    $screenshot3 = getImage(getFilePath('reseller_hosting_salieno') . '/' . @$salienoContent->data_values->screenshot_3);
    if(!$screenshot3 || str_contains($screenshot3, 'default')) $screenshot3 = $salienoJson['screenshot_3'];
    
    $screenshot4 = getImage(getFilePath('reseller_hosting_salieno') . '/' . @$salienoContent->data_values->screenshot_4);
    if(!$screenshot4 || str_contains($screenshot4, 'default')) $screenshot4 = $salienoJson['screenshot_4'];
    
    $features = count($salienoElements) > 0 ? $salienoElements : $salienoJson['features'];
@endphp

<section class="py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                {{ __($headingStart) }} <br class="hidden sm:block">
                <span class="text-primary-600 dark:text-primary-500">{{ __($headingEnd) }}</span>
            </h2>
        </div>

        <div class="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            {{-- Left Content: Features Grid --}}
            <div class="grid sm:grid-cols-2 gap-x-10 gap-y-10">
                @foreach($features as $feature)
                    @php
                        $featureData = is_object($feature) ? $feature->data_values : (object)$feature;
                    @endphp
                    <div class="group">
                        <div class="w-12 h-12 rounded-xl bg-primary-500/10 flex items-center justify-center mb-6 group-hover:bg-primary-500 group-hover:text-white transition-[border-color,background-color,box-shadow,transform] duration-300">
                            <i class="ph {{ $featureData->icon }} text-primary-500 group-hover:text-white text-2xl font-bold"></i>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 dark:text-white mb-3 transition-colors group-hover:text-primary-500">
                            {{ __($featureData->title) }}
                        </h3>
                        <p class="text-sm text-slate-500 dark:text-slate-400 leading-relaxed">
                            {{ __($featureData->description) }}
                        </p>
                    </div>
                @endforeach
            </div>

            {{-- Right Content: Screenshots Gallery --}}
            <div class="relative group/gallery">
                {{-- Decorative background glow --}}
                <div class="absolute -inset-10 bg-primary-500/5 rounded-full blur-[100px] opacity-60"></div>
                
                <div class="grid grid-cols-2 gap-4 lg:gap-6 items-start relative z-10">
                    <div class="space-y-4 lg:space-y-6">
                        <div class="rounded-2xl overflow-hidden shadow-xl shadow-slate-200/50 dark:shadow-none border border-slate-100 dark:border-white/5 transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="{{ $screenshot1 }}" alt="Dashboard 1" loading="lazy" width="400" height="250" class="w-full h-auto">
                        </div>
                        <div class="rounded-2xl overflow-hidden shadow-xl shadow-slate-200/50 dark:shadow-none border border-slate-100 dark:border-white/5 transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="{{ $screenshot3 }}" alt="Dashboard 3" loading="lazy" width="400" height="250" class="w-full h-auto">
                        </div>
                    </div>
                    <div class="space-y-4 lg:space-y-6 pt-12 lg:pt-20">
                        <div class="rounded-2xl overflow-hidden shadow-xl shadow-slate-200/50 dark:shadow-none border border-slate-100 dark:border-white/5 transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="{{ $screenshot2 }}" alt="Dashboard 2" loading="lazy" width="400" height="250" class="w-full h-auto">
                        </div>
                        <div class="rounded-2xl overflow-hidden shadow-xl shadow-slate-200/50 dark:shadow-none border border-slate-100 dark:border-white/5 transform hover:scale-[1.02] transition-transform duration-500">
                            <img src="{{ $screenshot4 }}" alt="Dashboard 4" loading="lazy" width="400" height="250" class="w-full h-auto">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Bottom CTA --}}
        <div class="mt-12 lg:mt-16 text-center">
            <x-theme.btn-primary href="{{ $buttonUrl }}">
                {{ __($buttonText) }}
            </x-theme.btn-primary>
        </div>
    </div>
</section>
