@php
    $setupContent = getContent('reseller_hosting_setup.content', true);
    $setupElements = getContent('reseller_hosting_setup.element', false, null, true);
    $setupJson = json_decode(file_get_contents(resource_path('data/reseller-hosting-setup.json')), true);

    $heading = @$setupContent->data_values->heading ?? $setupJson['heading'];
    $subheading = @$setupContent->data_values->subheading ?? $setupJson['subheading'];
    $buttonText = @$setupContent->data_values->button_text ?? $setupJson['button_text'];
    $buttonUrl = @$setupContent->data_values->button_url ?? $setupJson['button_url'];
    
    $steps = count($setupElements) > 0 ? $setupElements : $setupJson['steps'];

    // Advanced Configurability Tokens
    $accent = @$setupContent->data_values->accent_color ?: 'primary';
    $bgStyle = @$setupContent->data_values->bg_style ?: 'slate';

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/50', 'shadow' => 'shadow-primary-500/25'],
        'orange'  => ['bg' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/50', 'shadow' => 'shadow-primary-500/25'],
        'rose'    => ['bg' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/50', 'shadow' => 'shadow-primary-500/25'],
        'indigo'  => ['bg' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/50', 'shadow' => 'shadow-primary-500/25'],
        'blue'    => ['bg' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/50', 'shadow' => 'shadow-primary-500/25'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];

    $sectionBg = $bgStyle === 'slate' ? 'bg-slate-50 dark:bg-slate-950' : 'bg-white dark:bg-slate-900';
@endphp

<section class="py-20 lg:py-28 {{ $sectionBg }} transition-colors duration-300">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Section Header --}}
        <div class="text-center max-w-4xl mx-auto mb-12">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white leading-tight tracking-tight mb-5">
                {{ __($heading) }}
            </h2>
            <p class="text-base sm:text-lg text-slate-500 dark:text-slate-400 leading-relaxed font-medium">
                {{ __($subheading) }}
            </p>
        </div>

        {{-- Steps Grid --}}
        <div class="relative">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 lg:gap-12 items-start relative z-10">
                @foreach($steps as $index => $step)
                    @php
                        $stepData = is_object($step) ? $step->data_values : (object)$step;
                    @endphp
                    <div class="relative flex flex-col items-center lg:items-start text-center lg:text-left group">
                        {{-- Background Number (Matching Image) --}}
                        <div class="absolute -top-12 left-1/2 lg:left-0 -translate-x-1/2 lg:translate-x-10 text-6xl sm:text-7xl font-extrabold text-slate-200 dark:text-white/5 select-none pointer-events-none transition-transform duration-500 group-hover:-translate-y-2">
                            {{ $stepData->number }}
                        </div>

                        {{-- Card --}}
                        <div class="relative w-full aspect-[4/3] flex items-center justify-center p-6 rounded-2xl bg-white dark:bg-slate-900 border-2 border-slate-100 dark:border-white/5 shadow-lg shadow-slate-200/50 dark:shadow-none mb-6 mt-12 transition-[border-color,box-shadow,transform] duration-300 group-hover:{{ str_replace(['shadow-', '/25'], ['border-', '/50'], $style['shadow']) }} group-hover:-translate-y-1">
                            <h3 class="text-xl font-bold text-slate-900 dark:text-white leading-tight transition-colors duration-300 group-hover:{{ $style['text'] }}">
                                {{ __($stepData->title) }}
                            </h3>
                        </div>

                        {{-- Description --}}
                        <p class="text-sm text-slate-500 dark:text-slate-400 leading-relaxed px-4 lg:px-0">
                            {{ __($stepData->description) }}
                        </p>

                        {{-- Arrow (Hidden on mobile/tablet, shown on desktop) --}}
                        @if(!$loop->last)
                            <div class="hidden lg:flex absolute top-1/2 -right-8 translate-x-1/2 -translate-y-1/2 text-slate-300 dark:text-white/10">
                                <i class="ph ph-arrow-right text-2xl font-bold"></i>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Bottom CTA --}}
        <div class="mt-12 text-center">
            <a href="{{ $buttonUrl }}" 
               class="inline-flex items-center justify-center h-11 px-7 {{ $style['bg'] }} hover:{{ $style['bg-700'] }} text-white font-bold text-sm rounded-xl {{ $style['shadow'] }} transition-[background-color,color,transform] duration-300 active:scale-95">
                {{ __($buttonText) }}
            </a>
        </div>
    </div>
</section>
