{{-- Salieno Shared Hosting Banner - Final Corrected Version --}}
@php
    $banner = getContent('shared_hosting_banner.content', true);
    $hero = getContent('hero.content', true);
    
    // Logic for Price
    $manualPrice = @$banner->data_values->price_value;
    
    if(!$manualPrice) {
        $cheapestProduct = \App\Models\Product::active()
            ->whereHas('category', function($q) { $q->where('slug', 'shared'); })
            ->with(['pricing'])
            ->get()
            ->min(function($p) {
                return $p->pricing ? min(array_filter([
                    $p->pricing->monthly, $p->pricing->quarterly, $p->pricing->semi_annually,
                    $p->pricing->annually, $p->pricing->biennially, $p->pricing->triennially
                ], fn($v) => $v > 0)) : null;
            });
        $startsAt = $cheapestProduct ? number_format($cheapestProduct, 2) : '2.49';
    } else {
        $startsAt = $manualPrice;
    }

    // Advanced Configurability Tokens
    $accent = @$banner->data_values->accent_color ?: 'primary';
    $bgStyle = @$banner->data_values->bg_style ?: 'blobs';
    $illuType = @$banner->data_values->illustration_type ?: 'svg';
    $imgUrl = @$banner->data_values->image_url;
    $showPrice = @$banner->data_values->show_pricing !== 'false' && @$banner->data_values->price_value !== 'hide';

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'orange'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'rose'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'indigo'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-400/20'],
        'blue'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];
@endphp

<section class="relative py-20 lg:py-28 overflow-hidden bg-slate-100 dark:bg-slate-950 transition-colors duration-500">
    
    {{-- SYNCED BACKGROUND --}}
    <div class="absolute inset-0 z-0">
        @if($bgStyle === 'blobs')
        {{-- Primary Gradient Blobs --}}
        <div class="absolute top-0 left-0 w-full h-full">
            <div class="absolute top-[-20%] left-[-10%] w-[80vw] h-[80vw] max-w-[800px] max-h-[800px] rounded-full 
                        bg-gradient-to-br {{ $style['glow'] }} dark:{{ $style['glow'] }} via-primary-600/10 dark:via-primary-600/20 to-transparent 
                        blur-[100px] animate-blob"></div>
            <div class="absolute bottom-[-20%] right-[-10%] w-[60vw] h-[60vw] max-w-[600px] max-h-[600px] rounded-full 
                        bg-gradient-to-tl {{ $style['glow'] }} dark:{{ $style['glow'] }} via-primary-500/5 dark:via-primary-500/10 to-transparent 
                        blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
        </div>
        @endif
        
        {{-- Technical Grid DNA --}}
        @if($bgStyle === 'grid' || $bgStyle === 'blobs')
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
        @endif

        {{-- Hero DNA: Grain Overlay --}}
        <div class="absolute inset-0 bg-[url('{{ @$hero->data_values->link }}')] opacity-[0.05] dark:opacity-10 mix-blend-soft-light"></div>

        {{-- Starfield (Only in dark mode for better contrast) --}}
        <div class="absolute inset-0 hidden dark:block">
            @for ($i = 0; $i < 20; $i++)
                <div class="absolute rounded-full bg-white animate-pulse"
                    style="top: {{ rand(0, 100) }}%; left: {{ rand(0, 100) }}%; width: {{ rand(1, 2) }}px; height: {{ rand(1, 2) }}px; opacity: {{ (rand(10, 40) / 100) }}; animation-duration: {{ rand(3, 8) }}s;">
                </div>
            @endfor
        </div>
    </div>

    <div class="container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 lg:gap-16 items-center">
            
            {{-- Content Section - 7 Columns for optimal visual breathing room --}}
            <div class="lg:col-span-7 flex flex-col items-center lg:items-start text-center lg:text-left">
                
                {{-- Elite Live Badge --}}
                <div class="group inline-flex items-center gap-3 mb-8 cursor-pointer">
                    <div class="relative">
                        <div class="absolute inset-0 {{ $style['bg'] }} rounded-full blur-md opacity-20 dark:opacity-40 group-hover:opacity-60 transition-opacity"></div>
                        <div class="relative flex items-center gap-2 px-4 py-1.5 rounded-full {{ $style['bg'] }}/10 border {{ $style['border'] }} backdrop-blur-sm">
                            <span class="relative flex h-1.5 w-1.5">
                                <span class="animate-ping absolute inline-flex h-full w-full rounded-full {{ str_replace('500','400',$style['bg']) }} opacity-75"></span>
                                <span class="relative inline-flex rounded-full h-1.5 w-1.5 {{ $style['bg'] }}"></span>
                            </span>
                            <span class="text-[10px] font-bold uppercase tracking-[0.3em] {{ $style['text'] }} dark:text-primary-400">
                                {{ __(@$banner->data_values->promo_badge ?? 'Shared Hosting Live') }}
                            </span>
                        </div>
                    </div>
                </div>

                {{-- Headline --}}
                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight transition-colors duration-300">
                    <span>{{ __(@$banner->data_values->heading ?? 'Fastest Hosting for') }}</span>
                    <br class="hidden sm:block">
                    <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                        {{ __(@$banner->data_values->heading_gradient ?? 'Every Shared Goal') }}
                    </span>
                </h2>
                
                <p class="text-base sm:text-lg text-slate-600 dark:text-slate-400 mb-8 leading-relaxed max-w-xl transition-colors duration-300">
                    {{ __(@$banner->data_values->subheading ?? 'Our modern infrastructure ensures your sites stay lightning-fast, and with shared resources, scaling your online presence has never been more affordable.') }}
                </p>

                <div class="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-5 mb-8 w-full sm:w-auto">
                    {{-- Elite CTA --}}
                    <x-theme.btn-primary href="{{ @$banner->data_values->button_url ?? route('products.category', 'shared') }}" class="w-full sm:w-auto">
                        {{ __(@$banner->data_values->button_text ?? 'See All Plans') }}
                    </x-theme.btn-primary>

                    {{-- Slim Glass Pricing --}}
                    @if($showPrice)
                    <div class="flex flex-col items-center sm:items-start p-3 px-6 rounded-xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 shadow-sm dark:shadow-none backdrop-blur-md transition-colors duration-300">
                        <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500 mb-0.5">
                            {{ __(@$banner->data_values->starts_at_text ?? 'Starts at only') }}
                        </span>
                        <div class="flex items-baseline gap-1">
                            <span class="text-[10px] font-bold {{ $style['text'] }} opacity-60">{{ gs('cur_sym') }}</span>
                            <span class="text-2xl font-extrabold text-slate-900 dark:text-white">
                                {{ str_replace(gs('cur_sym'), '', $startsAt) }}
                            </span>
                            <span class="text-slate-400 dark:text-slate-500 text-[10px] font-bold uppercase tracking-widest ml-1">{{ __(@$banner->data_values->price_suffix ?? '/mo') }}</span>
                        </div>
                    </div>
                    @endif
                </div>

                {{-- Trust Markers --}}
                <div class="flex items-center gap-4 text-slate-500 dark:text-slate-400 font-bold text-xs uppercase tracking-[0.2em]">
                    <div class="flex -space-x-2">
                        @for($i=0; $i<3; $i++)
                            <div class="w-6 h-6 rounded-full border-2 border-white dark:border-slate-950 bg-slate-100 dark:bg-slate-900 flex items-center justify-center transition-colors duration-300 shadow-sm">
                                <svg class="w-3 h-3 text-primary-500" fill="currentColor" viewBox="0 0 16 16"><path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"/></svg>
                            </div>
                        @endfor
                    </div>
                    <span class="opacity-80">{{ __(@$banner->data_values->trust_text ?? '45-Day Satisfaction Guarantee') }}</span>
                </div>
            </div>

            {{-- SHARED ILLUSTRATION AREA --}}
            <div class="hidden lg:block lg:col-span-5 relative">
                @if($illuType === 'image' && $imgUrl)
                    <div class="relative group">
                        <div class="absolute -inset-10 {{ str_replace('bg-','from-',$style['bg']) }}/10 rounded-full blur-[100px] opacity-40"></div>
                        <img src="{{ getImage(getFilePath('shared_hosting_banner').'/'.$imgUrl) }}" alt="Shared Illustration" loading="lazy" width="600" height="400" class="relative z-10 w-full h-auto rounded-2xl shadow-xl">
                    </div>
                @elseif($illuType === 'svg')
                <div class="relative group">
                    {{-- Ambient Glow --}}
                    <div class="absolute inset-0 bg-gradient-to-br {{ $style['glow'] }} via-primary-400/20 to-primary-800/20 rounded-full blur-[80px] opacity-60 group-hover:opacity-80 transition-opacity duration-700"></div>
                    
                    <svg viewBox="0 0 500 500" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto relative z-10" style="--primary: currentColor;" class="{{ $style['text'] }}">
                        <defs>
                            <linearGradient id="mainGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="currentColor" />
                                <stop offset="100%" stop-color="#8B5CF6" />
                            </linearGradient>
                            <filter id="softShadow" x="-20%" y="-20%" width="140%" height="140%">
                                <feDropShadow dx="0" dy="20" stdDeviation="15" flood-opacity="0.1"/>
                            </filter>
                        </defs>

                        {{-- Background Glow --}}
                        <circle cx="250" cy="250" r="180" fill="url(#mainGrad)" opacity="0.05" class="animate-pulse" />
                        
                        {{-- Isometric Server Base --}}
                        <g transform="translate(150, 200)" filter="url(#softShadow)" class="svg-float">
                            {{-- Server Rack Shape --}}
                            <path d="M0 50 L100 0 L200 50 L100 100 Z" fill="var(--svg-mid)" opacity="0.9"/>
                            <path d="M0 50 L0 150 L100 200 L100 100 Z" fill="var(--svg-dark)"/>
                            <path d="M100 100 L100 200 L200 150 L200 50 Z" fill="var(--svg-light)"/>
                            
                            {{-- Server Glow Lines --}}
                            <g opacity="0.8">
                                @for($i=0; $i<4; $i++)
                                    <path d="M10 {{ 70 + $i*25 }} L90 {{ 110 + $i*25 }}" stroke="currentColor" stroke-width="2" class="svg-pulse" style="animation-delay: {{ $i*0.5 }}s"/>
                                    <circle cx="110" cy="{{ 110 + $i*25 }}" r="2" fill="#10B981" class="animate-ping" style="animation-duration: 3s; animation-delay: {{ $i*1 }}s"/>
                                @endfor
                            </g>

                            {{-- Top Panel Details --}}
                            <path d="M40 30 L100 0 L160 30 L100 60 Z" fill="white" opacity="0.05"/>
                        </g>

                        {{-- Floating Browser Nodes --}}
                        <g class="svg-float-alt">
                            {{-- Node 1 --}}
                            <rect x="300" y="80" width="120" height="90" rx="15" fill="white" filter="url(#softShadow)" class="dark:fill-slate-800"/>
                            <rect x="310" y="90" width="100" height="12" rx="4" fill="var(--svg-surface)" class="dark:fill-slate-700"/>
                            <circle cx="318" cy="96" r="3" fill="#FF5F57"/>
                            <rect x="310" y="115" width="80" height="30" rx="6" fill="currentColor" opacity="0.1"/>
                            <path d="M310 115 Q340 100 370 115" stroke="currentColor" fill="none" opacity="0.4"/>
                        </g>

                        <g class="svg-float" style="animation-delay: 1s">
                            {{-- Node 2 --}}
                            <rect x="40" y="320" width="110" height="80" rx="15" fill="white" filter="url(#softShadow)" class="dark:fill-slate-800"/>
                            <rect x="50" y="330" width="90" height="10" rx="4" fill="var(--svg-surface)" class="dark:fill-slate-700"/>
                            <circle cx="130" cy="335" r="3" fill="#10B981"/>
                            <rect x="50" y="350" width="40" height="30" rx="6" fill="#0EA5E9" opacity="0.1"/>
                            <rect x="95" y="350" width="45" height="30" rx="6" fill="#F59E0B" opacity="0.1"/>
                        </g>

                        {{-- Connection Lines --}}
                        <g stroke="currentColor" stroke-width="2" stroke-dasharray="8 8" opacity="0.2" fill="none">
                            <path d="M250 250 Q300 180 350 170" class="svg-dash"/>
                            <path d="M250 280 Q150 320 100 320" class="svg-dash"/>
                        </g>

                        {{-- Animated Particles --}}
                        @for($i=0; $i<6; $i++)
                            <circle r="{{ rand(2,4) }}" fill="currentColor" opacity="0.3" class="svg-pulse">
                                <animate attributeName="cx" from="{{ rand(100,400) }}" to="{{ rand(100,400) }}" dur="{{ rand(5,10) }}s" repeatCount="indefinite" />
                                <animate attributeName="cy" from="{{ rand(100,400) }}" to="{{ rand(100,400) }}" dur="{{ rand(5,10) }}s" repeatCount="indefinite" />
                            </circle>
                        @endfor
                    </svg>
                </div>
                @endif
            </div>
            </div>

        </div>
    </div>
</section>

