{{-- Shared Hosting Features Section --}}
@php
    $configPath = resource_path('data/shared-hosting-features.json');
    $config = json_decode(file_get_contents($configPath), true);
    
    if (!$config['enabled']) {
        return;
    }
@endphp

<section class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300">
    {{-- Decorative Background Elements --}}
    <div class="absolute inset-0 pointer-events-none overflow-hidden">
        <div class="absolute -top-24 -right-24 w-96 h-96 bg-primary-500/5 rounded-full blur-[100px]"></div>
        <div class="absolute -bottom-24 -left-24 w-96 h-96 bg-primary-500/5 rounded-full blur-[100px]"></div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight">
                {{ __($config['title']) }}
            </h2>
            @if(isset($config['subtitle']))
                <p class="text-lg sm:text-xl text-slate-600 dark:text-slate-400 max-w-3xl mx-auto leading-relaxed">
                    {{ __($config['subtitle']) }}
                </p>
            @endif
        </div>

        {{-- Features Grid - 3 Columns on Desktop, 1 on Mobile --}}
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-y-10 gap-x-8 lg:gap-x-10">
            @foreach($config['features'] as $feature)
                <div class="group text-center flex flex-col items-center">
                    {{-- Icon Container --}}
                    <x-feature-icon 
                        :icon="$feature['icon']" 
                    />

                    {{-- Text Content --}}
                    <div class="max-w-xs">
                        <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 transition-colors group-hover:text-primary-500 underline-offset-8 decoration-primary-500/30">
                            {{ __($feature['title']) }}
                        </h4>
                        <p class="text-base text-slate-600 dark:text-slate-400 leading-relaxed font-medium">
                            {{ __($feature['description']) }}
                        </p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

