@php
    $supportCta = getContent('support_cta.content', true);
@endphp

<section class="relative pt-16 pb-32 bg-surface-offwhite dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Subtle Background Effects --}}
    <div class="absolute inset-0 pointer-events-none opacity-50">
        <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg%20viewBox%3D%220%200%20200%20200%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%3E%3Cfilter%20id%3D%22n%22%3E%3CfeTurbulence%20type%3D%22fractalNoise%22%20baseFrequency%3D%220.65%22%20numOctaves%3D%223%22%20stitchTiles%3D%22stitch%22%2F%3E%3C%2Ffilter%3E%3Crect%20width%3D%22100%25%22%20height%3D%22100%25%22%20filter%3D%22url(%23n)%22%2F%3E%3C%2Fsvg%3E')] opacity-[0.03] dark:opacity-10 mix-blend-soft-light"></div>
        <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[400px] h-[300px] bg-primary-600/[0.05] dark:bg-primary-600/10 rounded-full blur-[100px] mix-blend-screen"></div>
    </div>

    <div class="relative z-10 max-w-4xl mx-auto px-6 text-center">
        {{-- Section Pattern Heading --}}
        <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight leading-tight">
            {!! purify(__(@$supportCta->data_values->heading ?? 'Got Questions? We Have Answers!')) !!}
        </h2>
        
        {{-- Section Pattern Subheading --}}
        <p class="text-slate-500 dark:text-slate-400 text-base sm:text-lg max-w-2xl mx-auto mb-10 font-medium leading-relaxed opacity-90">
            {{ __(@$supportCta->data_values->subheading ?? 'Get started by reaching out to our awesome support team today!') }}
        </p>
        
        {{-- Standard Action Button --}}
        <div class="flex justify-center">
            <x-theme.btn-primary href="{{ @$supportCta->data_values->button_url ?? '#' }}" :icon="false">
                {{ __(@$supportCta->data_values->button_text ?? 'Chat With Us') }}
                <i class="ph ph-bold ph-chat-centered-dots"></i>
            </x-theme.btn-primary>
        </div>
    </div>
</section>
