@php
    $testimonialContent = getContent('testimonials.content', true);
    $testimonialElements = getContent('testimonials.element');
@endphp

<section class="relative py-12 lg:py-20 bg-white dark:bg-slate-950 overflow-hidden transition-colors duration-300">
    {{-- Background Decoration --}}
    <div class="absolute inset-0 pointer-events-none opacity-30 dark:opacity-20">
        <div class="absolute top-0 left-1/4 w-[400px] h-[400px] bg-primary-500/10 rounded-full blur-[120px]"></div>
        <div class="absolute bottom-0 right-1/4 w-[400px] h-[400px] bg-primary-500/10 rounded-full blur-[120px]"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Section Header --}}
        <div class="text-center mb-10 lg:mb-14">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __(@$testimonialContent->data_values->heading ?? 'Trusted by the Owners of 150,000+ Websites') }}
            </h2>
            <p class="text-lg sm:text-xl text-slate-600 dark:text-slate-400 max-w-2xl mx-auto transition-colors">
                {{ __(@$testimonialContent->data_values->subheading ?? 'Check out what these customers have to say about us on Twitter') }}
            </p>
        </div>

        {{-- Testimonials Carousel --}}
        <div @mouseenter="stopAutoplay()" 
             @mouseleave="startAutoplay()"
             @keydown.left="prev()"
             @keydown.right="next()"
             @touchstart="touchStartX = $event.touches[0].clientX"
             @touchend="if (touchStartX - $event.changedTouches[0].clientX > 50) next(); if (touchStartX - $event.changedTouches[0].clientX < -50) prev();"
             x-data="{ 
                active: 0, 
                count: {{ count($testimonialElements) > 0 ? count($testimonialElements) : 3 }},
                autoplayInterval: null,
                touchStartX: 0,
                init() { this.startAutoplay() },
                startAutoplay() {
                    this.autoplayInterval = setInterval(() => { this.next() }, 5000)
                },
                stopAutoplay() {
                    clearInterval(this.autoplayInterval)
                },
                next() { this.active = (this.active + 1) % this.count },
                prev() { this.active = (this.active - 1 + this.count) % this.count }
            }" 
            class="relative max-w-5xl mx-auto"
            tabindex="0"
            role="region"
            aria-label="@lang('Customer testimonials')">
            
            {{-- Static Card Frame --}}
            <div class="relative group">
                {{-- Glowing Backdrop --}}
                <div class="absolute -inset-1 bg-gradient-to-r from-primary-500 to-primary-700 rounded-2xl blur-xl opacity-20 group-hover:opacity-30 transition duration-1000"></div>
                
                {{-- The Card Container --}}
                <div class="relative rounded-2xl overflow-hidden shadow-xl border border-slate-200 dark:border-white/10 flex items-center justify-center">
                    {{-- Skewed Background --}}
                    <div class="absolute inset-0 bg-primary-600 dark:bg-primary-900/50 transform -skew-y-2 origin-center scale-110"></div>
                    
                    {{-- Carousel Content Container --}}
                    <div class="relative w-full p-6 md:p-10" aria-live="polite">
                        @if(count($testimonialElements) > 0)
                            @foreach($testimonialElements as $item)
                                <div x-show="active === {{ $loop->index }}" 
                                     x-transition:enter="transition ease-out duration-700 delay-200" 
                                     x-transition:enter-start="opacity-0 translate-y-8" 
                                     x-transition:enter-end="opacity-100 translate-y-0"
                                     x-transition:leave="transition ease-in duration-300 absolute inset-0 flex flex-col items-center justify-center" 
                                     x-transition:leave-start="opacity-100 translate-y-0" 
                                     x-transition:leave-end="opacity-0 -translate-y-8"
                                     class="w-full text-center">
                                    
                                    {{-- Twitter Icon --}}
                                    <div class="mb-6 block">
                                        <i class="ph ph-bold ph-twitter-logo text-white text-3xl opacity-80"></i>
                                    </div>

                                    {{-- Quote --}}
                                    <blockquote class="text-lg sm:text-2xl font-medium text-white mb-8 leading-relaxed italic px-4 max-w-3xl mx-auto">
                                        "{{ __($item->data_values->quote) }}"
                                    </blockquote>

                                    {{-- Author Info --}}
                                    <div class="flex flex-col items-center">
                                        <div class="relative mb-4 group/avatar">
                                            <div class="absolute -inset-1 bg-white rounded-full opacity-20 group-hover/avatar:opacity-40 transition animate-pulse"></div>
                                            @php
                                                $userImage = @$item->data_values->image;
                                                $imageSrc = filter_var($userImage, FILTER_VALIDATE_URL) ? $userImage : getImage(getFilePath('testimonial').'/'.$userImage);
                                            @endphp
                                            <img src="{{ $imageSrc }}" alt="{{ $item->data_values->name }}" loading="lazy" width="64" height="64" class="relative w-16 h-16 rounded-full object-cover border-2 border-white/50 shadow-lg">
                                        </div>
                                        <h3 class="text-lg font-bold text-white mb-1">
                                            {{ __($item->data_values->name) }}
                                        </h3>
                                        <p class="text-primary-200 font-bold mb-2">
                                            {{ __($item->data_values->designation) }}
                                        </p>
                                        <a href="{{ $item->data_values->link }}" target="_blank" rel="noopener noreferrer" class="text-xs text-white/50 hover:text-white transition-colors tracking-widest uppercase font-bold">
                                            {{ $item->data_values->link }}
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            {{-- Fallback Slides Same Logic --}}
                            @for($i = 0; $i < 3; $i++)
                                <div x-show="active === {{ $i }}" 
                                     x-transition:enter="transition ease-out duration-700 delay-200" 
                                     x-transition:enter-start="opacity-0 translate-y-8" 
                                     x-transition:enter-end="opacity-100 translate-y-0"
                                     x-transition:leave="transition ease-in duration-300 absolute inset-0 flex flex-col items-center justify-center" 
                                     class="w-full text-center text-white">
                                    <div class="mb-8">
                                        <i class="ph ph-bold ph-twitter-logo text-white text-4xl opacity-80"></i>
                                    </div>
                                    <p class="text-xl sm:text-2xl font-medium mb-12 italic">
                                        @lang('The customer service here is the best I\'ve experienced. They have been invariably responsive, patient, and helpful.')
                                    </p>
                                    <div class="flex flex-col items-center">
                                        <div class="w-16 h-16 rounded-full border-2 border-white/30 mb-4 bg-white/10 flex items-center justify-center overflow-hidden">
                                            <svg class="w-8 h-8 text-white/40" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/>
                                            </svg>
                                        </div>
                                        <h3 class="text-lg font-bold">@lang('John Doe')</h3>
                                        <p class="text-primary-200 text-sm">@lang('@johndoe')</p>
                                    </div>
                                </div>
                            @endfor
                        @endif
                    </div>

                    {{-- Decorative Blobs (Permanent) --}}
                    <div class="absolute -top-20 -right-20 w-64 h-64 bg-white/5 rounded-full blur-3xl"></div>
                    <div class="absolute -bottom-20 -left-20 w-64 h-64 bg-primary-500/10 rounded-full blur-3xl"></div>
                </div>

                {{-- Navigation Arrows (Inside card on mobile, outside on lg+) --}}
                <div class="absolute inset-y-0 left-2 lg:-left-6 flex items-center z-30">
                    <button @click="prev()" aria-label="@lang('Previous Testimonial')" class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 text-slate-900 dark:text-white shadow-lg hover:scale-110 active:scale-95 transition-[background-color,border-color,color] focus:outline-none border border-slate-100 dark:border-white/10 flex items-center justify-center group/btn">
                        <i class="ph ph-bold ph-arrow-left group-hover/btn:-translate-x-1 transition-transform"></i>
                    </button>
                </div>
                <div class="absolute inset-y-0 right-2 lg:-right-6 flex items-center z-30">
                    <button @click="next()" aria-label="@lang('Next Testimonial')" class="w-10 h-10 rounded-xl bg-white dark:bg-slate-800 text-slate-900 dark:text-white shadow-lg hover:scale-110 active:scale-95 transition-[background-color,border-color,color] focus:outline-none border border-slate-100 dark:border-white/10 flex items-center justify-center group/btn">
                        <i class="ph ph-bold ph-arrow-right group-hover/btn:translate-x-1 transition-transform"></i>
                    </button>
                </div>
            </div>

            {{-- Pagination Dots --}}
            <div class="flex justify-center mt-8 space-x-2">
                <template x-for="i in count" :key="i">
                    <button @click="active = i - 1" 
                            :aria-label="'@lang('Go to slide') ' + i"
                            :class="active === i - 1 ? 'w-10 bg-primary-500' : 'w-6 bg-slate-300 dark:bg-white/10 hover:bg-slate-400'"
                            class="h-6 rounded-full transition-[width,background-color] duration-300 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2">
                    </button>
                </template>
            </div>
        </div>
    </div>
</section>

