@php
    $configPath = resource_path('data/vps-addons.json');
    $configJson = json_decode(file_get_contents($configPath), true);
    $addonContent = getContent('vps_addons.content', true);
    
    // Unified content source
    $title = @$addonContent->data_values->heading ?? str_replace(':site_name', gs('site_name'), $configJson['title']);
    $subtitle = @$addonContent->data_values->subheading ?? $configJson['subtitle'];
    $buttonText = @$addonContent->data_values->button_text ?? $configJson['button_text'];
    $buttonUrl = @$addonContent->data_values->button_url ?? $configJson['button_url'];

    // Advanced Configurability Tokens
    $accent = @$addonContent->data_values->accent_color ?: 'primary';
    $bgStyle = @$addonContent->data_values->bg_style ?: 'blobs';
    $illuType = @$addonContent->data_values->illustration_type ?: 'svg';
    $imgUrl = @$addonContent->data_values->image_url;

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/30', 'glow' => 'bg-primary-500/10'],
        'orange'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/30', 'glow' => 'bg-primary-500/10'],
        'rose'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/30', 'glow' => 'bg-primary-500/10'],
        'indigo'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/30', 'glow' => 'bg-primary-500/10'],
        'blue'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/30', 'glow' => 'bg-primary-500/10'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];
@endphp

<section class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300 overflow-hidden" x-data="{ activeAddon: '{{ $configJson['addons'][0]['id'] }}' }">
    {{-- Decorative Background --}}
    @if($bgStyle === 'blobs')
    <div class="absolute top-0 right-0 -translate-y-1/2 translate-x-1/2 w-[600px] h-[600px] {{ str_replace('bg-','bg-',$style['bg']) }}/5 rounded-full blur-[120px] pointer-events-none"></div>
    @endif

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        {{-- Section Header --}}
        <div class="text-center max-w-3xl mx-auto mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight">
                {{ __($title) }}
            </h2>
            <p class="text-lg text-slate-600 dark:text-slate-400 leading-relaxed">
                {{ __($configJson['subtitle']) }}
            </p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-16 items-center">
            {{-- Left Side: Accordion List --}}
            <div class="order-2 lg:order-1 space-y-3">
                @foreach($configJson['addons'] as $addon)
                    <div 
                        class="group bg-slate-50 dark:bg-white/5 rounded-xl border transition-[border-color,background-color,box-shadow,transform] duration-300"
                        :class="activeAddon === '{{ $addon['id'] }}' ? '{{ $style['border'] }}' : 'border-slate-100 dark:border-white/5 hover:border-slate-200 dark:hover:border-white/10 shadow-sm hover:shadow-md'"
                    >
                        <button 
                            @click="activeAddon === '{{ $addon['id'] }}' ? activeAddon = null : activeAddon = '{{ $addon['id'] }}'"
                            class="w-full flex items-center justify-between p-4 sm:p-5 text-left"
                        >
                            <div class="flex items-center gap-4 sm:gap-5">
                                <div 
                                    class="w-10 h-10 rounded-lg flex items-center justify-center transition-colors duration-300"
                                    :class="activeAddon === '{{ $addon['id'] }}' ? '{{ $style['bg-600'] }} text-white' : 'bg-white dark:bg-slate-800 text-slate-400 dark:text-slate-500'"
                                >
                                    @php
                                        $icon = $addon['icon'];
                                        if (str_contains($icon, 'ph-') && !str_contains($icon, 'ph ')) {
                                            $icon = 'ph ' . $icon;
                                        } elseif (!str_contains($icon, 'ph ')) {
                                            $icon = 'ph-bold ph-' . $icon;
                                        }
                                    @endphp
                                    <i class="{{ $icon }} text-xl leading-none"></i>
                                </div>
                                <span 
                                    class="text-base sm:text-lg font-bold transition-colors duration-300"
                                    :class="activeAddon === '{{ $addon['id'] }}' ? '{{ $style['text'] }} dark:{{ str_replace('600','500',$style['text']) }}' : 'text-slate-900 dark:text-white'"
                                >
                                    {{ __($addon['title']) }}
                                </span>
                            </div>
                            <div 
                                class="w-6 h-6 rounded-md flex items-center justify-center transition-[border-color,background-color,box-shadow,transform] duration-300"
                                :class="activeAddon === '{{ $addon['id'] }}' ? '{{ $style['bg'] }}/10 {{ $style['text'] }} rotate-180' : 'bg-slate-200/50 dark:bg-white/5 text-slate-500 dark:text-slate-400'"
                            >
                                <i class="ph ph-minus text-xs" x-show="activeAddon === '{{ $addon['id'] }}'" x-cloak></i>
                                <i class="ph ph-plus text-xs" x-show="activeAddon !== '{{ $addon['id'] }}'" x-cloak></i>
                            </div>
                        </button>

                        <div 
                            x-show="activeAddon === '{{ $addon['id'] }}'"
                            x-collapse
                            x-cloak
                        >
                            <div class="px-4 sm:px-5 pb-5 pt-0 ml-14 sm:ml-15">
                                <p class="text-base text-slate-600 dark:text-slate-400 leading-relaxed mb-4">
                                    {{ __($addon['description']) }}
                                </p>
                                <a href="{{ $addon['link_url'] }}" class="inline-flex items-center text-base {{ $style['text'] }} dark:{{ str_replace('600','500',$style['text']) }} font-bold hover:underline decoration-2 underline-offset-4 group/link">
                                    {{ __($addon['link_text']) }}
                                    <i class="ph ph-arrow-right ml-2 group-hover/link:translate-x-1 transition-transform"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            {{-- ILLUSTRATION AREA --}}
            <div class="order-1 lg:order-2">
                @if($illuType === 'image' && $imgUrl)
                    <div class="relative group">
                        <div class="absolute -inset-10 {{ $style['glow'] }} rounded-full blur-[100px] opacity-40"></div>
                        <img src="{{ getImage(getFilePath('vps_addons').'/'.$imgUrl) }}" alt="Addons Illustration" loading="lazy" width="600" height="400" class="relative z-10 w-full h-auto rounded-2xl shadow-xl">
                    </div>
                @elseif($illuType === 'svg')
                <div class="relative">
                    {{-- Large Glow --}}
                    <div class="absolute -inset-10 {{ $style['glow'] }} dark:bg-primary-500/5 rounded-full blur-[100px] animate-pulse"></div>
                    
                    {{-- Custom Addons Illustration --}}
                    <div class="relative bg-slate-50 dark:bg-slate-900 rounded-2xl p-6 sm:p-8 shadow-xl border border-slate-200 dark:border-white/10 overflow-hidden hover:scale-[1.02] transition-transform duration-700">
                        <svg viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto drop-shadow-xl {{ $style['text'] }}">
                            <defs>
                                <linearGradient id="lockGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                    <stop offset="0%" stop-color="#f97316" />
                                    <stop offset="100%" stop-color="#ea580c" />
                                </linearGradient>
                                <filter id="softShadow" x="-20%" y="-20%" width="140%" height="140%">
                                    <feDropShadow dx="0" dy="8" stdDeviation="12" flood-opacity="0.15"/>
                                </filter>
                            </defs>

                            {{-- Background Frame / Dashboard --}}
                            <rect x="50" y="40" width="320" height="220" rx="20" fill="currentColor" opacity="0.1" />
                            <rect x="50" y="40" width="320" height="40" rx="20" fill="currentColor" />
                            <circle cx="75" cy="60" r="10" fill="white" opacity="0.2" />
                            <rect x="300" y="55" width="40" height="8" rx="4" fill="white" opacity="0.2" />
                            <rect x="250" y="55" width="40" height="8" rx="4" fill="white" opacity="0.2" />
                            
                            {{-- Content Area --}}
                            <rect x="50" y="80" width="320" height="180" rx="20" fill="white" class="dark:fill-slate-800" />
                            
                            {{-- Server Rack Elements --}}
                            <g transform="translate(260, 100)">
                                <rect width="90" height="30" rx="6" fill="var(--svg-surface)" class="dark:fill-white/5" />
                                <rect x="10" y="12" width="5" height="5" rx="2.5" fill="var(--svg-subtle)" class="dark:fill-white/20" />
                                <rect x="20" y="14" width="50" height="3" rx="1.5" fill="var(--svg-subtle)" class="dark:fill-white/20" />
                            </g>
                            <g transform="translate(260, 140)">
                                <rect width="90" height="30" rx="6" fill="currentColor" opacity="0.1" />
                                <rect x="10" y="12" width="5" height="5" rx="2.5" fill="currentColor" />
                                <rect x="20" y="14" width="50" height="3" rx="1.5" fill="currentColor" opacity="0.4" />
                            </g>
                            <g transform="translate(260, 180)">
                                <rect width="90" height="30" rx="6" fill="currentColor" />
                                <rect x="10" y="12" width="5" height="5" rx="2.5" fill="white" />
                                <rect x="20" y="14" width="50" height="3" rx="1.5" fill="white" opacity="0.4" />
                            </g>
                            <g transform="translate(260, 220)">
                                <rect width="90" height="30" rx="6" fill="currentColor" />
                                <rect x="10" y="12" width="5" height="5" rx="2.5" fill="white" />
                                <rect x="20" y="14" width="50" height="3" rx="1.5" fill="white" opacity="0.4" />
                            </g>

                            {{-- Statistics / User --}}
                            <circle cx="110" cy="130" r="25" fill="#fef3c7" class="dark:fill-primary-500/10" />
                            <circle cx="180" cy="130" r="25" fill="none" stroke="currentColor" stroke-width="6" stroke-dasharray="157" stroke-dashoffset="40" />
                            <text x="180" y="135" text-anchor="middle" font-size="12" font-weight="900" fill="currentColor">75%</text>

                            {{-- Detailed Lines --}}
                            <rect x="110" y="180" width="120" height="4" rx="2" fill="var(--svg-surface)" class="dark:fill-white/5" />
                            <rect x="110" y="195" width="100" height="4" rx="2" fill="var(--svg-surface)" class="dark:fill-white/5" />
                            <rect x="110" y="210" width="130" height="4" rx="2" fill="var(--svg-surface)" class="dark:fill-white/5" />

                            {{-- THE LOCK (Main Object) --}}
                            <g transform="translate(30, 130)" filter="url(#softShadow)">
                                {{-- Lock Shackle --}}
                                <path d="M40 50 V30 C40 10 120 10 120 30 V50" fill="none" stroke="var(--svg-muted)" stroke-width="12" stroke-linecap="round" class="dark:stroke-slate-300" />
                                {{-- Lock Body --}}
                                <rect y="50" width="160" height="130" rx="20" fill="url(#lockGrad)" />
                                {{-- Keyhole --}}
                                <circle cx="80" cy="115" r="10" fill="white" />
                                <path d="M75 125 L85 125 L88 150 L72 150 Z" fill="white" />
                            </g>
                        </svg>

                        {{-- Floating Badge --}}
                        <div class="absolute top-1/4 right-8 bg-white dark:bg-slate-800 p-3 rounded-2xl shadow-xl border border-slate-100 dark:border-white/5 animate-bounce" style="animation-duration: 4s;">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-green-500/10 flex items-center justify-center text-green-500">
                                    <i class="ph ph-bold ph-shield-check text-2xl"></i>
                                </div>
                                <div class="flex flex-col">
                                    <span class="text-xs font-bold uppercase text-slate-500 dark:text-slate-400 tracking-widest leading-none">Status</span>
                                    <span class="text-sm font-bold text-slate-900 dark:text-white">Active</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
            </div>
        </div>

        {{-- Bottom CTA --}}
        <div class="mt-12 lg:mt-16 text-center">
            <a href="{{ $buttonUrl }}" 
               class="inline-flex items-center justify-center px-7 py-2.5 {{ $style['bg-600'] }} hover:{{ $style['bg-700'] }} text-white font-bold text-sm rounded-xl shadow-lg shadow-primary-500/30 transition-[background-color,color,transform] duration-300 active:scale-95 group">
                {{ __($buttonText) }}
                <i class="ph ph-bold ph-arrow-right ml-3 group-hover:translate-x-2 transition-transform"></i>
            </a>
        </div>
    </div>
</section>
