{{-- Salieno VPS Hosting Banner --}}
@php
    $banner = getContent('vps_banner.content', true);
    $hero = getContent('hero.content', true);
    
    // Logic for Price (optional integration with products)
    $manualPrice = @$banner->data_values->price_value;
    
    if(!$manualPrice) {
        $cheapestProduct = \App\Models\Product::active()
            ->whereHas('category', function($q) { $q->where('slug', 'vps'); })
            ->with(['pricing'])
            ->get()
            ->min(function($p) {
                return $p->pricing ? min(array_filter([
                    $p->pricing->monthly, $p->pricing->quarterly, $p->pricing->semi_annually,
                    $p->pricing->annually, $p->pricing->biennially, $p->pricing->triennially
                ], fn($v) => $v > 0)) : null;
            });
        $startsAt = $cheapestProduct ? number_format($cheapestProduct, 2) : '29.95';
    } else {
        $startsAt = $manualPrice;
    }

    // Advanced Configurability Tokens
    $accent = @$banner->data_values->accent_color ?: 'primary';
    $bgStyle = @$banner->data_values->bg_style ?: 'blobs';
    $illuType = @$banner->data_values->illustration_type ?: 'svg';
    $imgUrl = @$banner->data_values->image_url;
    $showPrice = @$banner->data_values->show_pricing !== 'false' && @$banner->data_values->price_value !== 'hide';

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-500', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'orange'  => ['bg' => 'bg-primary-500', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'rose'    => ['bg' => 'bg-primary-500', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
        'indigo'  => ['bg' => 'bg-primary-500', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-400/20'],
        'blue'    => ['bg' => 'bg-primary-500', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'from-primary-500/20'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];
@endphp

<section class="relative py-20 lg:py-28 overflow-hidden bg-slate-100 dark:bg-slate-950 transition-colors duration-500">
    
    {{-- SYNCED BACKGROUND --}}
    <div class="absolute inset-0 z-0">
        {{-- Primary Gradient Blobs --}}
        @if($bgStyle === 'blobs')
        <div class="absolute top-0 left-0 w-full h-full">
            <div class="absolute top-[-20%] left-[-10%] w-[80vw] h-[80vw] max-w-[800px] max-h-[800px] rounded-full 
                        bg-gradient-to-br {{ $style['glow'] }} dark:{{ $style['glow'] }} via-primary-600/10 dark:via-primary-600/20 to-transparent 
                        blur-[100px] animate-blob"></div>
            <div class="absolute bottom-[-20%] right-[-10%] w-[60vw] h-[60vw] max-w-[600px] max-h-[600px] rounded-full 
                        bg-gradient-to-tl {{ $style['glow'] }} dark:{{ $style['glow'] }} via-primary-500/5 dark:via-primary-500/10 to-transparent 
                        blur-[80px] animate-blob" style="animation-delay: 2s;"></div>
        </div>
        @endif
        
        {{-- Technical Grid DNA --}}
        @if($bgStyle === 'grid' || $bgStyle === 'blobs')
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
        @endif

        {{-- Starfield (Only in dark mode) --}}
        <div class="absolute inset-0 hidden dark:block">
            @for ($i = 0; $i < 20; $i++)
                <div class="absolute rounded-full bg-white animate-pulse"
                    style="top: {{ rand(0, 100) }}%; left: {{ rand(0, 100) }}%; width: {{ rand(1, 2) }}px; height: {{ rand(1, 2) }}px; opacity: {{ (rand(10, 40) / 100) }}; animation-duration: {{ rand(3, 8) }}s;">
                </div>
            @endfor
        </div>
    </div>

    <div class="container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 lg:gap-16 items-center">
            
            {{-- Content Section --}}
            <div class="lg:col-span-7 flex flex-col items-center lg:items-start text-center lg:text-left">
                
                {{-- Live Badge --}}
                <div class="group inline-flex items-center gap-3 mb-8 cursor-pointer">
                    <div class="relative">
                        <div class="absolute inset-0 {{ $style['bg'] }} rounded-full blur-md opacity-20 dark:opacity-40 group-hover:opacity-60 transition-opacity"></div>
                        <div class="relative flex items-center gap-2 px-4 py-1.5 rounded-full {{ $style['bg'] }}/10 border {{ $style['border'] }} backdrop-blur-sm">
                            <span class="relative flex h-1.5 w-1.5">
                                <span class="animate-ping absolute inline-flex h-full w-full rounded-full {{ str_replace('500','400',$style['bg']) }} opacity-75"></span>
                                <span class="relative inline-flex rounded-full h-1.5 w-1.5 {{ $style['bg'] }}"></span>
                            </span>
                            <span class="text-xs font-bold uppercase tracking-[0.3em] {{ $style['text'] }} dark:text-primary-400">
                                {{ __(@$banner->data_values->promo_badge ?? 'VPS Hosting Live') }}
                            </span>
                        </div>
                    </div>
                </div>

                {{-- Headline --}}
                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                    <span>{{ __(@$banner->data_values->heading ?? 'Managed') }}</span>
                    <br class="hidden sm:block">
                    <span class="bg-gradient-to-r from-primary-500 via-primary-600 to-primary-800 bg-clip-text text-transparent">
                        {{ __(@$banner->data_values->heading_gradient ?? 'VPS Hosting') }}
                    </span>
                </h2>
                
                <p class="text-base text-slate-600 dark:text-slate-400 mb-6 leading-relaxed max-w-xl">
                    {{ __(@$banner->data_values->subheading ?? 'Our managed VPS Hosting solution eliminates troubleshooting and server management worries and lets you focus on what matters most: growing your business!') }}
                </p>

                <div class="flex items-center gap-3 mb-8 p-3 rounded-xl bg-white/40 dark:bg-white/5 border border-white dark:border-white/10 backdrop-blur-sm">
                    <div class="w-10 h-10 rounded-xl {{ $style['bg'] }}/10 flex items-center justify-center {{ $style['text'] }}">
                        <i class="ph ph-bold ph-gift text-xl"></i>
                    </div>
                    <p class="text-sm font-bold text-slate-700 dark:text-slate-300">
                        {!! purify(__(@$banner->data_values->promo_text ?? 'Get <strong>one month free</strong> on 12-month plans.')) !!}
                    </p>
                </div>

                <div class="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-5 mb-8 w-full sm:w-auto">
                    {{-- CTA --}}
                    <x-theme.btn-primary href="{{ @$banner->data_values->button_url ?? '#pricing' }}" class="w-full sm:w-auto">
                        {{ __(@$banner->data_values->button_text ?? 'View Plans & Pricing') }}
                    </x-theme.btn-primary>

                    {{-- Pricing (Optional) --}}
                    @if(@$banner->data_values->price_value != 'hide')
                    <div class="flex flex-col items-center sm:items-start p-3 px-6 rounded-xl bg-white dark:bg-white/5 border border-slate-200 dark:border-white/10 shadow-sm dark:shadow-none backdrop-blur-md">
                        <span class="text-[10px] font-bold uppercase tracking-[0.2em] text-slate-400 dark:text-slate-500 mb-0.5">
                            {{ __(@$banner->data_values->starts_at_text ?? 'Starts at only') }}
                        </span>
                        <div class="flex items-baseline gap-1">
                            <span class="text-[10px] font-bold text-slate-900 dark:text-white opacity-60">{{ gs('cur_sym') }}</span>
                            <span class="text-2xl font-extrabold text-slate-900 dark:text-white">
                                {{ str_replace(gs('cur_sym'), '', $startsAt) }}
                            </span>
                            <span class="text-slate-400 dark:text-slate-500 text-[10px] font-bold uppercase tracking-widest ml-1">{{ __(@$banner->data_values->price_suffix ?? '/mo') }}</span>
                        </div>
                    </div>
                    @endif
                </div>

                {{-- Guarantee --}}
                <div class="flex items-center gap-3 text-slate-500 dark:text-slate-400 font-bold text-xs uppercase tracking-[0.2em]">
                    <div class="w-6 h-6 rounded-full bg-green-500/10 flex items-center justify-center text-green-500">
                        <i class="ph ph-bold ph-shield-check"></i>
                    </div>
                    <span>{{ __(@$banner->data_values->trust_text ?? '7-Day Money Back Guarantee') }}</span>
                </div>
            </div>

            {{-- VPS ILLUSTRATION AREA --}}
            <div class="hidden lg:block lg:col-span-5 relative">
                @if($illuType === 'image' && $imgUrl)
                    <div class="relative group">
                        <div class="absolute -inset-10 bg-gradient-to-br {{ $style['glow'] }} rounded-full blur-[100px] opacity-40"></div>
                        <img src="{{ getImage(getFilePath('vps_banner').'/'.$imgUrl) }}" alt="VPS Illustration" loading="lazy" width="600" height="400" class="relative z-10 w-full h-auto rounded-2xl shadow-xl">
                    </div>
                @elseif($illuType === 'svg')
                <div class="relative group">
                    {{-- Ambient Dynamic Glow --}}
                    <div class="absolute inset-0 bg-gradient-to-br {{ $style['glow'] }} via-primary-400/10 to-transparent rounded-full blur-[100px] opacity-60 group-hover:opacity-80 transition-opacity duration-700"></div>
                    
                    <svg viewBox="0 0 500 500" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto relative z-10 drop-shadow-[0_35px_35px_rgba(0,0,0,0.25)]" class="{{ $style['text'] }}">
                        <defs>
                            <linearGradient id="serverFrontGrad" x1="0%" y1="0%" x2="0%" y2="100%">
                                <stop offset="0%" stop-color="currentColor" stop-opacity="0.05" />
                                <stop offset="100%" stop-color="currentColor" stop-opacity="0.02" />
                            </linearGradient>
                            <linearGradient id="accentGlow" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="currentColor" />
                                <stop offset="100%" stop-color="currentColor" stop-opacity="0.5" />
                            </linearGradient>
                        </defs>

                        {{-- Main Isometric Server Body --}}
                        <g transform="translate(80, 100)">
                            {{-- Top Face --}}
                            <path d="M170 0 L340 85 L170 170 L0 85 Z" fill="currentColor" fill-opacity="0.05" stroke="currentColor" stroke-width="1" stroke-opacity="0.1" />
                            
                            {{-- Right Side Face --}}
                            <path d="M340 85 L340 235 L170 320 L170 170 Z" fill="currentColor" fill-opacity="0.1" stroke="currentColor" stroke-width="1" stroke-opacity="0.1" />
                            
                            {{-- Front Face (The Display Panel) --}}
                            <path d="M0 85 L170 170 L170 320 L0 235 Z" fill="white" class="dark:fill-slate-900" stroke="currentColor" stroke-width="2" stroke-opacity="0.05" />
                            
                            {{-- Glass Faceplate Inner --}}
                            <path d="M15 95 L155 165 L155 305 L15 235 Z" fill="url(#serverFrontGrad)" stroke="currentColor" stroke-width="1" stroke-opacity="0.1" />

                            {{-- Hardware Details / Drive Bays --}}
                            @for($i=0; $i<5; $i++)
                                <g transform="translate(0, {{ $i * 35 }})">
                                    <path d="M25 110 L145 170 L145 185 L25 125 Z" fill="currentColor" fill-opacity="0.05" />
                                    <circle cx="35" cy="118" r="1.5" fill="currentColor" fill-opacity="0.4" />
                                    <rect x="135" y="165" width="4" height="10" transform="skewY(26.5)" fill="currentColor" fill-opacity="0.2" />
                                </g>
                            @endfor

                            {{-- Status LED Bar --}}
                            <g transform="translate(20, 100)">
                                @for($j=0; $j<12; $j++)
                                    <circle cx="{{ $j * 10 }}" cy="{{ $j * 5 }}" r="2" fill="currentColor" class="animate-pulse" style="animation-delay: {{ $j * 0.1 }}s">
                                        <animate attributeName="opacity" values="0.2;1;0.2" dur="2s" repeatCount="indefinite" begin="{{ $j * 0.1 }}s" />
                                    </circle>
                                @endfor
                            </g>
                        </g>

                        {{-- Floating Tech Elements for Depth --}}
                        <g class="vps-float" style="animation-duration: 4s;">
                            <rect x="380" y="100" width="60" height="80" rx="15" fill="white" class="dark:fill-slate-800" fill-opacity="0.9" filter="url(#vpsSoftShadow)" />
                            <circle cx="410" cy="130" r="15" fill="currentColor" fill-opacity="0.1" />
                            <circle cx="410" cy="130" r="6" fill="currentColor" />
                            <rect x="395" y="155" width="30" height="4" rx="2" fill="currentColor" fill-opacity="0.2" />
                        </g>

                        <g class="vps-float-alt" style="animation-duration: 5s; animation-delay: 1s;">
                            <rect x="40" y="320" width="100" height="60" rx="15" fill="white" class="dark:fill-slate-800" fill-opacity="0.9" filter="url(#vpsSoftShadow)" />
                            <path d="M65 350 L115 350" stroke="currentColor" stroke-width="4" stroke-linecap="round" stroke-opacity="0.2" />
                            <path d="M65 350 L90 350" stroke="currentColor" stroke-width="4" stroke-linecap="round" />
                            <circle cx="65" cy="350" r="4" fill="currentColor" />
                        </g>

                        {{-- Final Premium Touches: Connecting Lines --}}
                        <g opacity="0.1" class="dark:opacity-20">
                            <path d="M250 100 L380 140" stroke="currentColor" stroke-width="1" stroke-dasharray="4 4" />
                            <path d="M170 420 L100 380" stroke="currentColor" stroke-width="1" stroke-dasharray="4 4" />
                        </g>
                    </svg>
                </div>
                @endif
            </div>
            </div>

        </div>
    </div>
</section>

