@php
    $vpsComparisonContent = getContent('vps_comparison.content', true);
    $configPath = resource_path('data/vps-comparison.json');
    $config = json_decode(file_get_contents($configPath), true);
    
    // Unified content source
    $title = @$vpsComparisonContent->data_values->heading ?? str_replace(':site_name', gs('site_name'), $config['title']);
    $subtitle = @$vpsComparisonContent->data_values->subheading ?? str_replace(':site_name', gs('site_name'), $config['subtitle']);
    $managedTitle = str_replace(':site_name', gs('site_name'), $config['managed']['title']);

    // Dynamic Product Fetching (Managed VPS)
    $productSlug = @$vpsComparisonContent->data_values->product_slug ?: 'vps-starter';
    $product = \App\Models\Product::where('slug', $productSlug)->with(['pricing', 'features'])->first();

    if ($product) {
        $config['managed']['subtitle'] = $product->name;
        $config['managed']['pricing']['total'] = getAmount($product->pricing->monthly, 2);
        
        // Map features if they exist in DB, otherwise keep fallback
        if ($product->features->count() > 0) {
            $config['managed']['features'] = $product->features->pluck('name')->toArray();
        }

        if ($product->pricing->isDiscountActive()) {
            $config['managed']['pricing']['discount_label'] = $product->pricing->promo_badge_text ?: 'Now ' . $product->pricing->discount_value . '% Off!';
        }
    }

    // Advanced Configurability Tokens
    $accent = @$vpsComparisonContent->data_values->accent_color ?: 'primary';
    $bgStyle = @$vpsComparisonContent->data_values->bg_style ?: 'slate';

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-600', 'bg-900' => 'bg-primary-900', 'text' => 'text-primary-500', 'border' => 'border-primary-500/10', 'glow' => 'bg-primary-500/5', 'shadow' => 'shadow-primary-500/10'],
        'orange'  => ['bg' => 'bg-primary-600', 'bg-900' => 'bg-primary-900', 'text' => 'text-primary-500', 'border' => 'border-primary-500/10', 'glow' => 'bg-primary-500/5', 'shadow' => 'shadow-primary-500/10'],
        'rose'    => ['bg' => 'bg-primary-600', 'bg-900' => 'bg-primary-900', 'text' => 'text-primary-500', 'border' => 'border-primary-500/10', 'glow' => 'bg-primary-500/5', 'shadow' => 'shadow-primary-500/10'],
        'indigo'  => ['bg' => 'bg-primary-600', 'bg-900' => 'bg-primary-900', 'text' => 'text-primary-500', 'border' => 'border-primary-500/10', 'glow' => 'bg-primary-500/5', 'shadow' => 'shadow-primary-500/10'],
        'blue'    => ['bg' => 'bg-primary-600', 'bg-900' => 'bg-primary-900', 'text' => 'text-primary-500', 'border' => 'border-primary-500/10', 'glow' => 'bg-primary-500/5', 'shadow' => 'shadow-primary-500/10'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];

    $sectionBg = $bgStyle === 'slate' ? 'bg-slate-50 dark:bg-slate-950' : 'bg-white dark:bg-slate-900';
@endphp

<section class="relative py-20 lg:py-28 {{ $sectionBg }} transition-colors duration-300 overflow-hidden">
    {{-- Decorative backgrounds --}}
    @if($bgStyle === 'blobs' || $bgStyle === 'slate')
    <div class="absolute top-0 left-1/4 -translate-y-1/2 w-96 h-96 {{ str_replace('shadow-','bg-',$style['shadow']) }}/5 rounded-full blur-[100px] pointer-events-none"></div>
    @endif

    <div class="relative max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        {{-- Section Header --}}
        <div class="text-center max-w-2xl mx-auto mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight">
                {{ __($title) }}
            </h2>
            <p class="text-lg text-slate-600 dark:text-slate-400 leading-relaxed font-medium">
                {{ __($subtitle) }}
            </p>
        </div>

        <div class="relative grid grid-cols-1 lg:grid-cols-12 gap-8 lg:gap-12 items-start">
            
            {{-- Left Side: Managed VPS Card --}}
            <div class="lg:col-span-5 relative z-20">
                <div class="{{ $style['bg'] }} dark:{{ $style['bg-900'] }} rounded-2xl rounded-bl-3xl p-5 sm:p-6 {{ $style['shadow'] }} text-white relative overflow-hidden group border-[0.5px] border-white/10">
                    {{-- Decorative Internal Glow --}}
                    <div class="absolute -top-20 -right-20 w-64 h-64 bg-white/10 rounded-full blur-3xl group-hover:scale-110 transition-transform duration-700"></div>

                    <div class="relative z-10">
                        <div class="flex items-center gap-4 mb-8">
                            <div class="w-10 h-10 bg-white/20 backdrop-blur-md rounded-lg flex items-center justify-center">
                                <i class="ph ph-bold ph-lightning text-xl"></i>
                            </div>
                            <h3 class="text-xl font-bold leading-tight">
                                {{ __($managedTitle) }}
                            </h3>
                        </div>

                        <div class="mb-8">
                            <span class="text-xs font-bold uppercase tracking-[0.2em] opacity-60 mb-1 block">Plan</span>
                            <h4 class="text-lg font-bold">{{ __($config['managed']['subtitle']) }}</h4>
                        </div>

                        <ul class="space-y-3 mb-8">
                            @foreach($config['managed']['features'] as $feature)
                                <li class="flex items-center gap-3">
                                    <div class="flex-shrink-0 w-5 h-5 bg-green-500/20 rounded-full flex items-center justify-center border border-green-500/30">
                                        <i class="ph ph-bold ph-check text-green-400 text-[10px]"></i>
                                    </div>
                                    <span class="text-base font-bold text-white/90">{{ __($feature) }}</span>
                                </li>
                            @endforeach
                        </ul>

                        <hr class="border-white/10 mb-8">

                        <div class="flex flex-wrap items-end gap-3 mb-8">
                            <div class="flex flex-col">
                                <span class="text-xs font-bold uppercase tracking-widest opacity-60">Total Cost</span>
                                <div class="flex items-baseline gap-1">
                                    <span class="text-2xl sm:text-3xl font-extrabold">{{ $config['managed']['pricing']['currency'] }}{{ $config['managed']['pricing']['total'] }}</span>
                                    <span class="text-sm opacity-60 font-bold">{{ $config['managed']['pricing']['suffix'] }}</span>
                                </div>
                            </div>
                            <div class="mb-1">
                                <span class="px-2 py-0.5 bg-primary-500 text-xs font-bold rounded-full uppercase tracking-tight shadow-lg shadow-primary-500/30">
                                    {{ __($config['managed']['pricing']['discount_label']) }}
                                </span>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                            <x-theme.btn-primary href="{{ $config['managed']['button_primary']['url'] }}" size="sm">
                                {{ __($config['managed']['button_primary']['text']) }}
                            </x-theme.btn-primary>
                            <x-theme.btn-secondary href="{{ $config['managed']['button_secondary']['url'] }}" class="bg-white/10 hover:bg-white/20 border-white/10 text-white dark:text-white dark:bg-white/10 dark:hover:bg-white/20 dark:border-white/10">
                                {{ __($config['managed']['button_secondary']['text']) }}
                            </x-theme.btn-secondary>
                        </div>
                    </div>
                </div>

                {{-- VS Badge --}}
                <div class="absolute top-1/2 -right-4 lg:-right-6 -translate-y-1/2 z-30">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-primary-500 rounded-xl rotate-45 flex items-center justify-center shadow-xl shadow-primary-500/30 border-2 border-white dark:border-slate-950">
                        <span class="text-lg sm:text-xl font-bold text-white italic -rotate-45">VS</span>
                    </div>
                </div>
            </div>

            {{-- Right Side: Comparison Cards --}}
            <div class="lg:col-span-7 lg:pl-4 pt-4 lg:pt-0">
                <div class="space-y-4">
                    {{-- Base Provider Card --}}
                    <div class="bg-white dark:bg-slate-900 border-[0.5px] border-slate-200 dark:border-white/10 rounded-2xl p-4 sm:p-6 flex items-center justify-between transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 rounded-xl bg-primary-500/10 flex items-center justify-center text-primary-500 flex-shrink-0">
                                <i class="ph ph-bold ph-hard-drive text-2xl"></i>
                            </div>
                            <div>
                                <h4 class="text-lg font-bold text-slate-900 dark:text-white">{{ __($config['comparison_list']['title']) }}</h4>
                                <p class="text-xs text-slate-500 dark:text-slate-400 font-medium leading-tight">{{ __($config['comparison_list']['description']) }}</p>
                            </div>
                        </div>
                        <div class="text-right ml-4">
                            <span class="text-lg font-extrabold text-slate-900 dark:text-white">${{ $config['comparison_list']['cost'] }}</span>
                            <span class="text-[10px] font-bold text-slate-500 dark:text-slate-400">{{ $config['comparison_list']['suffix'] }}</span>
                        </div>
                    </div>

                    {{-- Addons Loop --}}
                    @foreach($config['comparison_list']['addons'] as $addon)
                        <div class="bg-white dark:bg-slate-900 border-[0.5px] border-slate-200 dark:border-white/10 rounded-2xl p-4 sm:p-6 flex items-center justify-between transition-colors group hover:{{ str_replace('/10','/30',$style['border']) }}">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-xl bg-slate-50 dark:bg-white/5 flex items-center justify-center text-slate-500 dark:text-slate-400 group-hover:{{ $style['text'] }} transition-colors flex-shrink-0">
                                    <i class="ph {{ str_contains($addon['icon'], 'ph-') ? $addon['icon'] : 'ph-' . $addon['icon'] }} text-2xl"></i>
                                </div>
                                <div>
                                    <h4 class="text-lg font-bold text-slate-900 dark:text-white">{{ __($addon['title']) }}</h4>
                                    <p class="text-xs text-slate-500 dark:text-slate-400 font-medium leading-tight">{{ __($addon['description']) }}</p>
                                </div>
                            </div>
                            <div class="text-right ml-4 flex flex-col">
                                <span class="text-base font-bold text-slate-900 dark:text-white">
                                    @if(is_numeric($addon['cost'])) ${{ $addon['cost'] }} @else {{ __($addon['cost']) }} @endif
                                </span>
                                 <span class="text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest leading-none">{{ $addon['suffix'] }}</span>
                            </div>
                        </div>
                    @endforeach

                    {{-- Final Total Footer --}}
                    <div class="pt-6 text-right">
                        <div class="flex flex-col items-end">
                            <div class="flex items-baseline gap-2">
                                <span class="text-xs font-bold text-slate-500 dark:text-slate-400 uppercase tracking-widest">{{ __($config['comparison_list']['total_cost']['label']) }}</span>
                                <span class="text-2xl sm:text-3xl font-extrabold text-slate-900 dark:text-white">${{ $config['comparison_list']['total_cost']['cost'] }}</span>
                                <span class="text-sm font-bold text-slate-500 dark:text-slate-400">{{ $config['comparison_list']['total_cost']['suffix'] }}</span>
                            </div>
                            <p class="text-sm font-bold text-slate-500 dark:text-slate-400 mb-4 leading-relaxed">
                                {{ __($config['comparison_list']['total_cost']['note_annual']) }}
                            </p>
                            <p class="max-w-[320px] text-xs text-slate-500 dark:text-slate-400 leading-relaxed italic border-t border-slate-200 dark:border-white/10 pt-3">
                                {{ __($config['comparison_list']['total_cost']['final_note']) }}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
