@php
    $configPath = resource_path('data/why-choose-shared.json');
    $config = json_decode(file_get_contents($configPath), true);
    
    if (!$config['enabled']) {
        return;
    }

    $siteName = gs('site_name') ?? 'salieno';
    $title = str_replace(':site_name', $siteName, $config['title']);
@endphp

<section class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300" x-data="{ activeTab: '{{ $config['tabs'][0]['id'] }}' }">
    {{-- Background Grains/Patterns --}}
    <div class="absolute inset-0 pointer-events-none opacity-20 dark:opacity-10">
        <div class="absolute inset-0 bg-[radial-gradient(var(--primary)_0.5px,transparent_0.5px)] bg-[size:24px_24px] [mask-image:radial-gradient(ellipse_at_center,black,transparent_80%)]"></div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight">
                {{ __($title) }}
            </h2>

            {{-- Tabs Navigation --}}
            @php
                $tabItems = [];
                foreach ($config['tabs'] as $tab) {
                    $tabItems[$tab['id']] = $tab['label'];
                }
            @endphp
            <x-theme.ui.tabs :tabs="$tabItems" model="activeTab" />
        </div>

        {{-- Tabs Content --}}
        @foreach($config['tabs'] as $tab)
            <div 
                x-show="activeTab === '{{ $tab['id'] }}'" 
                x-transition:enter="transition ease-out duration-500"
                x-transition:enter-start="opacity-0 translate-y-8"
                x-transition:enter-end="opacity-100 translate-y-0"
                class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-16 items-center"
            >
                {{-- Left Content --}}
                <div class="order-2 lg:order-1 space-y-8">
                    <div class="space-y-6">
                        <h3 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white leading-tight">
                            {{ __($tab['heading']) }}
                        </h3>
                        <p class="text-lg text-slate-600 dark:text-slate-400 leading-relaxed">
                            {{ __($tab['description']) }}
                        </p>
                    </div>

                    <div class="space-y-6">
                        @foreach($tab['features'] as $feature)
                            <div class="group">
                                <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 transition-colors group-hover:text-primary-600">
                                    {{ __($feature['title']) }}
                                </h4>
                                <p class="text-slate-600 dark:text-slate-400 group-hover:text-slate-900 dark:group-hover:text-slate-200 transition-colors leading-relaxed">
                                    {{ __($feature['description']) }}
                                </p>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Right Illustration --}}
                <div class="order-1 lg:order-2">
                    <div class="relative group">
                        {{-- Soft Glow --}}
                        <div class="absolute -inset-4 bg-primary-500/10 dark:bg-primary-500/5 rounded-2xl blur-3xl group-hover:bg-primary-500/20 transition-[border-color,background-color,box-shadow,transform] duration-700"></div>
                        
                        {{-- Mockup --}}
                        <div class="relative bg-slate-50 dark:bg-slate-900 rounded-2xl p-5 sm:p-6 shadow-xl border border-slate-200 dark:border-white/10 overflow-hidden transform group-hover:rotate-1 group-hover:scale-[1.02] transition-[border-color,background-color,box-shadow,transform] duration-500">
                            {{-- Minimal Browser UI --}}
                            <div class="flex gap-2 mb-6 items-center">
                                <div class="w-3 h-3 rounded-full bg-red-400/50"></div>
                                <div class="w-3 h-3 rounded-full bg-yellow-400/50"></div>
                                <div class="w-3 h-3 rounded-full bg-green-400/50"></div>
                                <div class="ml-4 h-4 w-1/2 bg-slate-200 dark:bg-white/5 rounded-full"></div>
                            </div>

                            @if($tab['id'] === 'builder')
                                {{-- Builder Mockup --}}
                                <div class="space-y-4">
                                    <div class="h-32 rounded-2xl bg-primary-600 flex items-center justify-center text-white overflow-hidden relative shadow-lg">
                                        <div class="absolute inset-0 bg-gradient-to-br from-white/10 to-transparent"></div>
                                        <span class="text-xl font-bold relative z-10">Welcome to my website</span>
                                        {{-- Drag handle dots --}}
                                        <div class="absolute left-2 top-1/2 -translate-y-1/2 flex flex-col gap-1">
                                            @for($i=0; $i<6; $i++) <div class="w-1 h-1 rounded-full bg-white/30"></div> @endfor
                                        </div>
                                    </div>
                                    <div class="grid grid-cols-2 gap-4">
                                        <div class="h-24 rounded-2xl bg-primary-400/20 border-2 border-dashed border-primary-400/40 flex items-center justify-center group-hover:border-primary-400 transition-colors">
                                            <i class="ph ph-image text-primary-400 text-3xl"></i>
                                        </div>
                                        <div class="h-24 rounded-2xl bg-teal-400/20 border-2 border-dashed border-teal-400/40 flex items-center justify-center group-hover:border-teal-400 transition-colors">
                                            <i class="ph ph-text-aa text-teal-400 text-3xl"></i>
                                        </div>
                                    </div>
                                    <div class="h-12 w-3/4 mx-auto rounded-xl bg-slate-200 dark:bg-white/10"></div>
                                </div>
                            @elseif($tab['id'] === 'performance')
                                {{-- Performance Mockup --}}
                                <div class="flex flex-col items-center justify-center py-4 space-y-6">
                                    <div class="relative w-40 h-40">
                                        <svg class="w-full h-full transform -rotate-90" viewBox="0 0 100 100">
                                            <circle cx="50" cy="50" r="45" fill="none" stroke="currentColor" stroke-width="8" class="text-slate-200 dark:text-white/5"></circle>
                                            <circle cx="50" cy="50" r="45" fill="none" stroke="currentColor" stroke-width="8" stroke-dasharray="282.7" stroke-dashoffset="28.2" class="text-primary-500 animate-pulse"></circle>
                                        </svg>
                                        <div class="absolute inset-0 flex flex-col items-center justify-center">
                                            <span class="text-2xl font-extrabold text-slate-900 dark:text-white">99%</span>
                                            <span class="text-xs font-bold text-primary-500 uppercase tracking-widest">Score</span>
                                        </div>
                                    </div>
                                    <div class="w-full space-y-3">
                                        <div class="h-2 w-full bg-slate-200 dark:bg-white/5 rounded-full overflow-hidden">
                                            <div class="h-full w-[95%] bg-teal-500"></div>
                                        </div>
                                        <div class="h-2 w-full bg-slate-200 dark:bg-white/5 rounded-full overflow-hidden">
                                            <div class="h-full w-[88%] bg-primary-500"></div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                {{-- Modern Control Panel Mockup --}}
                                <div class="relative w-full aspect-[4/3] flex items-center justify-center">
                                    {{-- Background Glass Frame --}}
                                    <div class="absolute inset-0 bg-slate-200/20 dark:bg-white/5 rounded-xl border-2 border-slate-100 dark:border-white/10 overflow-hidden">
                                        {{-- Sidebar --}}
                                        <div class="absolute left-0 top-0 bottom-0 w-16 bg-white dark:bg-slate-800 border-r border-slate-100 dark:border-white/5 flex flex-col items-center py-6 gap-6">
                                            <div class="w-8 h-8 rounded-lg bg-primary-600"></div>
                                            @for($i=0; $i<4; $i++)
                                                <div class="w-8 h-8 rounded-lg bg-slate-100 dark:bg-white/5"></div>
                                            @endfor
                                        </div>
                                        {{-- Header --}}
                                        <div class="absolute top-0 right-0 left-16 h-12 bg-white/50 dark:bg-slate-800/50 backdrop-blur-md border-b border-slate-100 dark:border-white/5 flex items-center px-6 justify-between">
                                            <div class="w-32 h-2 bg-slate-200 dark:bg-white/10 rounded-full"></div>
                                            <div class="flex gap-3">
                                                <div class="w-6 h-6 rounded-full bg-slate-200 dark:bg-white/10"></div>
                                                <div class="w-6 h-6 rounded-full bg-slate-200 dark:bg-white/10"></div>
                                            </div>
                                        </div>
                                        
                                        {{-- Dashboard Content --}}
                                        <div class="absolute inset-0 top-12 left-16 p-6">
                                            <div class="grid grid-cols-2 gap-4 h-full">
                                                <div class="space-y-4">
                                                    <div class="h-24 rounded-2xl bg-white dark:bg-slate-800 shadow-sm border border-slate-100 dark:border-white/5 p-4 flex items-center gap-4">
                                                        <div class="w-12 h-12 rounded-xl bg-primary-500/10 flex items-center justify-center text-primary-500">
                                                            <i class="ph ph-envelope-simple text-2xl font-bold"></i>
                                                        </div>
                                                        <div class="space-y-2 flex-1">
                                                            <div class="h-2 w-2/3 bg-slate-200 dark:bg-white/10 rounded-full"></div>
                                                            <div class="h-1.5 w-1/3 bg-slate-100 dark:bg-white/5 rounded-full"></div>
                                                        </div>
                                                    </div>
                                                    <div class="h-24 rounded-2xl bg-white dark:bg-slate-800 shadow-sm border border-slate-100 dark:border-white/5 p-4 flex items-center gap-4">
                                                        <div class="w-12 h-12 rounded-xl bg-teal-500/10 flex items-center justify-center text-teal-500">
                                                            <i class="ph ph-shield-check text-2xl font-bold"></i>
                                                        </div>
                                                        <div class="space-y-2 flex-1">
                                                            <div class="h-2 w-1/2 bg-slate-200 dark:bg-white/10 rounded-full"></div>
                                                            <div class="h-1.5 w-1/4 bg-slate-100 dark:bg-white/5 rounded-full"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="rounded-2xl bg-primary-600 p-6 flex flex-col justify-between text-white relative overflow-hidden shadow-xl">
                                                    <div class="relative z-10">
                                                        <h5 class="text-xs font-bold uppercase tracking-widest opacity-80 mb-1">Live Traffic</h5>
                                                        <div class="text-xl font-extrabold">1.2k</div>
                                                    </div>
                                                    {{-- Wave SVG --}}
                                                    <svg class="absolute bottom-0 left-0 w-full h-1/2 opacity-30" viewBox="0 0 100 40" preserveAspectRatio="none">
                                                        <path d="M0,40 L0,20 Q25,10 50,20 T100,20 L100,40 Z" fill="white"></path>
                                                    </svg>
                                                    <i class="ph ph-chart-line-up absolute top-4 right-4 text-3xl opacity-20"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Dynamic Floating Elements --}}
                                    <div class="absolute -top-4 -right-4 w-28 h-28 bg-white dark:bg-slate-800 rounded-2xl shadow-xl p-4 border border-slate-100 dark:border-white/5 animate-bounce" style="animation-duration: 4s;">
                                        <div class="w-full h-full flex flex-col items-center justify-center gap-2">
                                            <div class="w-10 h-10 rounded-full bg-primary-600/10 flex items-center justify-center text-primary-600">
                                                <i class="ph ph-gear-six text-2xl font-bold animate-spin-slow"></i>
                                            </div>
                                            <span class="text-[10px] font-bold uppercase text-slate-500 dark:text-slate-400 tracking-tight">@lang('Tools Ready')</span>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</section>
