@php
    $whyUs = getContent('why_choose_us.content', true);
@endphp

<section class="relative py-14 lg:py-20 bg-white dark:bg-slate-950 overflow-hidden transition-colors duration-300" x-data="{ activeTab: 1 }">
    {{-- Decorative Background --}}
    <div class="absolute inset-0 pointer-events-none">
        <div class="absolute top-0 right-0 w-[250px] lg:w-[350px] h-[250px] lg:h-[350px] bg-primary-500/5 rounded-full blur-[80px] lg:blur-[120px]"></div>
        <div class="absolute bottom-0 left-0 w-[250px] lg:w-[350px] h-[250px] lg:h-[350px] bg-primary-500/5 rounded-full blur-[80px] lg:blur-[120px]"></div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight transition-colors">
                {{ __(@$whyUs->data_values->main_heading ?? 'Why salieno?') }}
            </h2>

            {{-- Tab Switcher --}}
            @php
                $pillTabs = [
                    1 => @$whyUs->data_values->tab_1_title ?? '24/7 Award-winning Support',
                    2 => @$whyUs->data_values->tab_2_title ?? 'Worldwide Server Locations',
                ];
            @endphp
            <x-theme.ui.tabs :tabs="$pillTabs" model="activeTab" style="underline" size="sm" />
        </div>

        {{-- Content Area --}}
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-16 items-center">
            
            {{-- Left Side: Text Content --}}
            <div x-show="activeTab === 1" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 lg:-translate-x-8 translate-y-4 lg:translate-y-0" x-transition:enter-end="opacity-100 translate-x-0 translate-y-0" class="space-y-8 order-1">
                <div class="text-center lg:text-left">
                    <h3 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white mb-3 leading-tight transition-colors">
                        {{ __(@$whyUs->data_values->content_heading ?? 'Get struggle-free support when you need it') }}
                    </h3>
                    <p class="text-base sm:text-lg text-slate-600 dark:text-slate-400 leading-relaxed transition-colors">
                        {{ __(@$whyUs->data_values->content_description ?? 'With over 20+ years of experience in hosting, our team is here to help 24 hours a day.') }}
                    </p>
                </div>

                <div class="space-y-6 sm:space-y-8">
                    @php
                        $features = [
                            ['title' => @$whyUs->data_values->feature_1_title ?? 'Support that cares', 'desc' => @$whyUs->data_values->feature_1_desc ?? "Our skilled and friendly support team will solve even the most complex technical issues that the other guys can't."],
                            ['title' => @$whyUs->data_values->feature_2_title ?? 'Get Your Issue Solved Fast', 'desc' => @$whyUs->data_values->feature_2_desc ?? "Forget the back and forth of dealing with support. Our team will solve your issue the first time around so you can get back to work fast."],
                            ['title' => @$whyUs->data_values->feature_3_title ?? 'Forget About Wait Times', 'desc' => @$whyUs->data_values->feature_3_desc ?? "With instant live chat and first reply times of 10 minutes for tickets, you won't have to wait long for answers or help."],
                        ];
                    @endphp

                    @foreach($features as $f)
                        <div class="group text-center lg:text-left">
                            <h3 class="text-lg font-bold text-slate-900 dark:text-white mb-2 transition-colors group-hover:text-primary-600">
                                {{ __($f['title']) }}
                            </h3>
                            <p class="text-sm sm:text-base text-slate-600 dark:text-slate-400 transition-colors leading-relaxed">
                                {{ __($f['desc']) }}
                            </p>
                        </div>
                    @endforeach
                </div>

                <div class="flex justify-center lg:justify-start">
                    <a href="{{ @$whyUs->data_values->link ?? '#' }}" class="inline-flex items-center text-primary-800 dark:text-primary-400 font-bold hover:gap-2 transition-[border-color,background-color,color] underline decoration-primary-500/30 underline-offset-4 hover:decoration-primary-500">
                        <span>{{ __(@$whyUs->data_values->link_text ?? 'Learn More') }}</span>
                        <svg class="w-5 h-5 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                    </a>
                </div>
            </div>

            {{-- Tab 2 Content (Server Locations) --}}
            <div x-show="activeTab === 2" x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0 lg:translate-x-8 translate-y-4 lg:translate-y-0" x-transition:enter-end="opacity-100 translate-x-0 translate-y-0" class="space-y-8 order-1">
               <div class="text-center lg:text-left">
                    <h3 class="text-2xl sm:text-3xl font-bold text-slate-900 dark:text-white mb-3 leading-tight transition-colors">
                        @lang('Global reach, local speeds')
                    </h3>
                    <p class="text-base sm:text-lg text-slate-600 dark:text-slate-400 leading-relaxed transition-colors">
                        @lang('Experience lightning-fast performance across the globe with our strategically positioned data centers.')
                    </p>
                </div>
                
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    @foreach(['North America', 'Europe', 'Asia Pacific', 'Australia', 'South America', 'Africa'] as $location)
                         <div class="flex items-center gap-3 p-4 rounded-2xl bg-slate-50 dark:bg-white/5 border border-slate-100 dark:border-white/5 transition-colors">
                            <div class="w-8 h-8 rounded-full bg-primary-500/10 flex items-center justify-center">
                                <i class="ph ph-bold ph-globe-hemisphere-west text-primary-600 text-xs"></i>
                            </div>
                            <span class="font-bold text-slate-900 dark:text-white">{{ $location }}</span>
                         </div>
                    @endforeach
                </div>
            </div>

            {{-- Right Side: Illustration --}}
            <div class="relative order-2 lg:order-2 px-4 sm:px-8 lg:px-0 hidden lg:block">
                {{-- Chat Interface Illustration --}}
                <div class="relative bg-slate-100 dark:bg-slate-900 rounded-2xl p-3 sm:p-4 shadow-xl overflow-hidden border border-slate-200 dark:border-white/10 group max-w-[500px] mx-auto lg:max-w-none">
                    {{-- Header Bar --}}
                    <div class="flex items-center justify-between px-4 sm:px-6 py-3 sm:py-4 border-b border-slate-200 dark:border-white/5 mb-4 sm:mb-6">
                        <div class="flex space-x-1.5 sm:space-x-2">
                            <div class="w-2.5 h-2.5 sm:w-3 h-3 rounded-full bg-red-400"></div>
                            <div class="w-2.5 h-2.5 sm:w-3 h-3 rounded-full bg-yellow-400"></div>
                            <div class="w-2.5 h-2.5 sm:w-3 h-3 rounded-full bg-green-400"></div>
                        </div>
                        <div class="w-20 sm:w-32 h-2.5 sm:h-3 bg-slate-200 dark:bg-white/10 rounded-full"></div>
                    </div>

                    {{-- Chat Bubbles --}}
                    <div class="space-y-4 sm:space-y-6 pb-16 sm:pb-20">
                        {{-- Support Bubble --}}
                        <div class="flex items-start space-x-2 sm:space-x-3 max-w-[85%] sm:max-w-[80%] animate-fade-in" style="animation-delay: 0.2s">
                             <div class="w-8 h-8 sm:w-10 sm:h-10 rounded-full bg-primary-500/10 flex items-center justify-center flex-shrink-0 animate-bounce" style="animation-duration: 3s">
                                <i class="ph ph-bold ph-headset text-primary-600 text-xs sm:text-base"></i>
                            </div>
                            <div class="bg-primary-600 text-white p-3 sm:p-4 rounded-2xl rounded-tl-none shadow-lg shadow-primary-500/20 text-xs sm:text-sm font-medium">
                                @lang('Hello! How can I help you today?')
                            </div>
                        </div>

                        {{-- User Bubble --}}
                        <div class="flex items-start space-x-2 sm:space-x-3 max-w-[85%] sm:max-w-[80%] ml-auto flex-row-reverse space-x-reverse animate-fade-in" style="animation-delay: 1s">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 rounded-full bg-primary-500/10 flex items-center justify-center flex-shrink-0">
                                <i class="ph ph-bold ph-user text-primary-500 text-xs sm:text-base"></i>
                            </div>
                            <div class="bg-white dark:bg-slate-800 text-slate-900 dark:text-white p-3 sm:p-4 rounded-2xl rounded-tr-none shadow-xl border border-slate-100 dark:border-white/5 text-xs sm:text-sm font-medium">
                                @lang('Hi! I am having trouble migrating my site.')
                            </div>
                        </div>

                        {{-- Support Response --}}
                        <div class="flex items-start space-x-2 sm:space-x-3 max-w-[90%] sm:max-w-[85%] animate-fade-in" style="animation-delay: 2s">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 rounded-full bg-primary-500/10 flex items-center justify-center flex-shrink-0">
                                <i class="ph ph-bold ph-headset text-primary-600 text-xs sm:text-base"></i>
                            </div>
                            <div class="bg-primary-600 text-white p-3 sm:p-4 rounded-2xl rounded-tl-none shadow-lg shadow-primary-500/20 text-xs sm:text-sm font-medium">
                                @lang('No problem! Our team can handle the migration for you for free. Just share your details.')
                            </div>
                        </div>
                    </div>

                    {{-- Floating Chip --}}
                    <div class="absolute bottom-4 sm:bottom-6 right-4 sm:right-6 w-12 h-12 sm:w-16 sm:h-16 rounded-full bg-primary-600 flex items-center justify-center shadow-xl animate-pulse cursor-pointer hover:scale-110 transition-transform">
                        <i class="ph ph-bold ph-chat-centered-dots text-white text-lg sm:text-2xl"></i>
                    </div>

                    {{-- Glowing Blobs --}}
                    <div class="absolute -top-10 sm:-top-20 -right-10 sm:-right-20 w-32 sm:w-64 h-32 sm:h-64 bg-primary-500/20 rounded-full blur-[40px] sm:blur-[80px] group-hover:scale-125 transition-transform duration-1000"></div>
                </div>
            </div>
        </div>
    </div>
</section>
