@php
    $configPath = resource_path('data/why-choose-vps.json');
    $config = json_decode(file_get_contents($configPath), true);
    
    if (!$config['enabled']) {
        return;
    }

    $siteName = gs('site_name') ?? 'salieno';
    $title = str_replace(':site_name', $siteName, $config['title']);
@endphp

<section class="relative py-20 lg:py-28 bg-white dark:bg-slate-950 transition-colors duration-300" x-data="{ activeTab: '{{ $config['tabs'][0]['id'] }}' }">
    {{-- Background Grains/Patterns --}}
    <div class="absolute inset-0 pointer-events-none opacity-20 dark:opacity-10">
        <div class="absolute inset-0 bg-[radial-gradient(var(--primary)_0.5px,transparent_0.5px)] bg-[size:24px_24px] [mask-image:radial-gradient(ellipse_at_center,black,transparent:80%)]"></div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 z-10">
        {{-- Section Header --}}
        <div class="text-center mb-12 lg:mb-16">
            <h2 class="text-3xl sm:text-4xl font-extrabold text-slate-900 dark:text-white mb-5 tracking-tight">
                {{ __($title) }}
            </h2>

            {{-- Tabs Navigation --}}
            @php
                $tabItems = [];
                foreach ($config['tabs'] as $tab) {
                    $tabItems[$tab['id']] = $tab['label'];
                }
            @endphp
            <x-theme.ui.tabs :tabs="$tabItems" model="activeTab" />
        </div>

        {{-- Tabs Content --}}
        @foreach($config['tabs'] as $tab)
            <div 
                x-show="activeTab === '{{ $tab['id'] }}'" 
                x-transition:enter="transition ease-out duration-500"
                x-transition:enter-start="opacity-0 translate-y-8"
                x-transition:enter-end="opacity-100 translate-y-0"
                class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-16 items-center"
            >
                {{-- Left Content --}}
                <div class="order-2 lg:order-1 space-y-8">
                    <div class="space-y-6">
                        <h3 class="text-xl font-bold text-slate-900 dark:text-white leading-tight">
                            {{ __($tab['heading']) }}
                        </h3>
                        <p class="text-base text-slate-600 dark:text-slate-400 leading-relaxed">
                            {{ __($tab['description']) }}
                        </p>
                    </div>

                    <div class="space-y-6">
                        @foreach($tab['features'] as $feature)
                            <div class="group">
                                <h4 class="text-lg font-bold text-slate-900 dark:text-white mb-2 transition-colors group-hover:text-primary-600">
                                    {{ __($feature['title']) }}
                                </h4>
                                <p class="text-sm text-slate-600 dark:text-slate-400 group-hover:text-slate-900 dark:group-hover:text-slate-200 transition-colors leading-relaxed">
                                    {{ __($feature['description']) }}
                                </p>
                            </div>
                        @endforeach
                    </div>
                </div>

                {{-- Right Illustration (SVGs) --}}
                <div class="order-1 lg:order-2">
                    <div class="relative group">
                        {{-- Soft Glow --}}
                        <div class="absolute -inset-4 bg-primary-500/10 dark:bg-primary-500/5 rounded-2xl blur-3xl group-hover:bg-primary-500/20 transition-[border-color,background-color,box-shadow,transform] duration-700"></div>
                        
                        {{-- Mockup --}}
                        <div class="relative bg-slate-50 dark:bg-slate-900 rounded-2xl p-5 sm:p-6 shadow-xl border border-slate-200 dark:border-white/10 overflow-hidden transform group-hover:rotate-1 group-hover:scale-[1.02] transition-[border-color,background-color,box-shadow,transform] duration-500">
                            {{-- Minimal Browser UI --}}
                            <div class="flex gap-2 mb-6 items-center">
                                <div class="w-3 h-3 rounded-full bg-red-400/50"></div>
                                <div class="w-3 h-3 rounded-full bg-yellow-400/50"></div>
                                <div class="w-3 h-3 rounded-full bg-green-400/50"></div>
                                <div class="ml-4 h-4 w-1/2 bg-slate-200 dark:bg-white/5 rounded-full"></div>
                            </div>

                            @if($tab['id'] === 'control')
                                {{-- ROOT ACCESS ILLUSTRATION --}}
                                <div class="relative w-full aspect-[4/3] flex items-center justify-center">
                                    <svg viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto">
                                        <rect x="20" y="20" width="360" height="260" rx="15" fill="var(--svg-mid)" />
                                        <rect x="20" y="20" width="360" height="35" rx="15" fill="var(--svg-dark)" />
                                        <circle cx="45" cy="37.5" r="4" fill="#ef4444" />
                                        <circle cx="60" cy="37.5" r="4" fill="#f59e0b" />
                                        <circle cx="75" cy="37.5" r="4" fill="#10b981" />
                                        
                                        <text x="40" y="85" font-family="monospace" font-size="14" fill="#10b981" font-weight="bold">root@server:~#</text>
                                        <text x="160" y="85" font-family="monospace" font-size="14" fill="var(--svg-subtle)" font-weight="bold">apt update && apt upgrade</text>
                                        
                                        <text x="40" y="115" font-family="monospace" font-size="12" fill="var(--svg-muted)">Get:1 http://security.debian.org bullseye-security InRelease [48.4 kB]</text>
                                        <text x="40" y="135" font-family="monospace" font-size="12" fill="var(--svg-muted)">Hit:2 http://deb.debian.org/debian bullseye InRelease</text>
                                        <text x="40" y="155" font-family="monospace" font-size="12" fill="var(--svg-muted)">Fetched 48.4 kB in 1s (41.6 kB/s)</text>
                                        <text x="40" y="175" font-family="monospace" font-size="12" fill="#10b981">Reading package lists... Done</text>
                                        <text x="40" y="205" font-family="monospace" font-size="14" fill="#10b981" font-weight="bold">root@server:~#</text>
                                        <rect x="160" y="190" width="10" height="20" fill="#10b981" class="animate-pulse" />

                                        {{-- Floating Gear --}}
                                        <g transform="translate(320, 220)" class="animate-spin-slow">
                                            <circle r="40" fill="#6366f1" opacity="0.1" />
                                            <path d="M0 -30 L5 -30 L8 -20 L15 -23 L18 -18 L10 -12 L12 -5 L20 -5 L20 5 L12 5 L10 12 L18 18 L15 23 L8 20 L5 30 L-5 30 L-8 20 L-15 23 L-18 18 L-10 12 L-12 5 L-20 5 L-20 -5 L-12 -5 L-10 -12 L-18 -18 L-15 -23 L-8 -20 L-5 -30 Z" fill="#6366f1" />
                                            <circle r="8" fill="var(--svg-mid)" />
                                        </g>
                                    </svg>
                                </div>
                            @elseif($tab['id'] === 'performance')
                                {{-- PERFORMANCE ILLUSTRATION --}}
                                <div class="relative w-full aspect-[4/3] flex items-center justify-center">
                                    <svg viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto">
                                        <defs>
                                            <linearGradient id="gaugeGradient" x1="0%" y1="0%" x2="100%" y2="0%">
                                                <stop offset="0%" stop-color="#3b82f6" />
                                                <stop offset="100%" stop-color="#8b5cf6" />
                                            </linearGradient>
                                        </defs>
                                        
                                        {{-- Central Gauge --}}
                                        <circle cx="200" cy="150" r="100" fill="none" stroke="var(--svg-subtle)" stroke-width="20" stroke-dasharray="314 314" stroke-dashoffset="157" class="dark:stroke-white/5" />
                                        <circle cx="200" cy="150" r="100" fill="none" stroke="url(#gaugeGradient)" stroke-width="20" stroke-dasharray="314 314" stroke-dashoffset="200" stroke-linecap="round" class="animate-pulse" />
                                        
                                        <text x="200" y="140" text-anchor="middle" font-size="40" font-weight="900" fill="var(--svg-mid)" class="dark:fill-white">99.9%</text>
                                        <text x="200" y="170" text-anchor="middle" font-size="14" font-weight="bold" fill="#6366f1" class="uppercase tracking-widest">Uptime Guaranteed</text>
                                        
                                        {{-- Floating Bars --}}
                                        <g transform="translate(50, 200)">
                                            <rect width="60" height="80" rx="10" fill="white" class="dark:fill-slate-800 shadow-xl" />
                                            <rect x="15" y="60" width="30" height="5" rx="2" fill="#3b82f6" />
                                            <rect x="15" y="50" width="20" height="5" rx="2" fill="var(--svg-subtle)" class="dark:fill-white/10" />
                                            <circle cx="30" cy="30" r="15" fill="#3b82f6" opacity="0.1" />
                                            <i class="ph ph-bold ph-cpu text-primary-500" style="position:absolute; top:22px; left:22px;"></i>
                                        </g>
                                        
                                        <g transform="translate(290, 60)">
                                            <rect width="60" height="80" rx="10" fill="white" class="dark:fill-slate-800 shadow-xl" />
                                            <rect x="15" y="60" width="30" height="5" rx="2" fill="#8b5cf6" />
                                            <rect x="15" y="50" width="20" height="5" rx="2" fill="var(--svg-subtle)" class="dark:fill-white/10" />
                                            <circle cx="30" cy="30" r="15" fill="#8b5cf6" opacity="0.1" />
                                        </g>
                                    </svg>
                                </div>
                            @elseif($tab['id'] === 'security')
                                {{-- SECURITY ILLUSTRATION --}}
                                <div class="relative w-full aspect-[4/3] flex items-center justify-center">
                                    <svg viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto">
                                        {{-- Shield --}}
                                        <path d="M200 50 L320 100 V200 C320 250 200 300 200 300 C200 300 80 250 80 200 V100 L200 50Z" fill="#10b981" opacity="0.1" />
                                        <path d="M200 70 L280 110 V180 C280 220 200 250 200 250 C200 250 120 220 120 180 V110 L200 70Z" fill="#10b981" />
                                        
                                        {{-- Checkmark --}}
                                        <path d="M170 160 L195 185 L235 135" fill="none" stroke="white" stroke-width="15" stroke-linecap="round" stroke-linejoin="round" />
                                        
                                        {{-- Floating Nodes --}}
                                        <circle cx="50" cy="80" r="8" fill="#10b981" opacity="0.4" class="animate-pulse" />
                                        <circle cx="350" cy="150" r="12" fill="#10b981" opacity="0.2" class="animate-bounce" style="animation-duration: 3s;" />
                                        <circle cx="100" cy="250" r="10" fill="#10b981" opacity="0.3" class="animate-pulse" style="animation-delay: 1s;" />
                                        
                                        <path d="M50 80 L120 130" stroke="#10b981" stroke-width="2" stroke-dasharray="5 5" opacity="0.3" />
                                        <path d="M350 150 L280 160" stroke="#10b981" stroke-width="2" stroke-dasharray="5 5" opacity="0.3" />
                                    </svg>
                                </div>
                            @elseif($tab['id'] === 'scaling')
                                {{-- SCALING ILLUSTRATION --}}
                                <div class="relative w-full aspect-[4/3] flex items-center justify-center">
                                    <svg viewBox="0 0 400 300" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto">
                                        <rect x="50" y="220" width="60" height="30" rx="5" fill="#f59e0b" opacity="0.3" />
                                        <rect x="130" y="160" width="60" height="90" rx="5" fill="#f59e0b" opacity="0.6" />
                                        <rect x="210" y="100" width="60" height="150" rx="5" fill="#f59e0b" opacity="0.8" />
                                        <rect x="290" y="40" width="60" height="210" rx="5" fill="#f59e0b" />
                                        
                                        <path d="M50 230 L130 170 L210 110 L290 50" fill="none" stroke="white" stroke-width="4" stroke-dasharray="10 10" opacity="0.5" />
                                        
                                        <circle cx="290" cy="50" r="15" fill="#f59e0b" class="animate-ping" />
                                        <circle cx="290" cy="50" r="10" fill="#f59e0b" />
                                        
                                        <text x="50" y="270" font-size="12" font-weight="bold" fill="var(--svg-muted)">Start</text>
                                        <text x="290" y="270" font-size="12" font-weight="bold" fill="#f59e0b">Growth</text>
                                    </svg>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</section>
