@php
    $resellerBanner = getContent('wordpress_hosting_banner.content', true);
    $resellerJson = json_decode(file_get_contents(resource_path('data/reseller-hosting-banner.json')), true);
    $hero = getContent('hero.content', true);
    
    // Fallback logic
    $promoBadge = @$resellerBanner->data_values->promo_badge ?? $resellerJson['promo_badge'];
    $heading = @$resellerBanner->data_values->heading ?? $resellerJson['heading'];
    $headingGradient = @$resellerBanner->data_values->heading_gradient ?? $resellerJson['heading_gradient'];
    $subheading = @$resellerBanner->data_values->subheading ?? $resellerJson['subheading'];
    $buttonText = @$resellerBanner->data_values->button_text ?? $resellerJson['button_text'];
    $buttonUrl = @$resellerBanner->data_values->button_url ?? $resellerJson['button_url'];
    $startsAtText = @$resellerBanner->data_values->starts_at_text ?? $resellerJson['starts_at_text'];
    $priceValue = @$resellerBanner->data_values->price_value ?? $resellerJson['price_value'];
    $priceSuffix = @$resellerBanner->data_values->price_suffix ?? $resellerJson['price_suffix'];
    $trustText = @$resellerBanner->data_values->trust_text ?? $resellerJson['trust_text'];

    $startsAt = $priceValue;

    // Advanced Configurability Tokens
    $accent = @$resellerBanner->data_values->accent_color ?: 'primary';
    $bgStyle = @$resellerBanner->data_values->bg_style ?: 'blobs';
    $illuType = @$resellerBanner->data_values->illustration_type ?: 'svg';
    $imgUrl = @$resellerBanner->data_values->image_url;
    $showPrice = @$resellerBanner->data_values->show_pricing !== 'false' && @$resellerBanner->data_values->price_value !== 'hide';

    // Dynamic Class Mapping
    $accentMap = [
        'primary' => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'bg-primary-500/10'],
        'orange'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'bg-primary-500/10'],
        'rose'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'bg-primary-500/10'],
        'indigo'  => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'bg-primary-500/10'],
        'blue'    => ['bg' => 'bg-primary-500', 'bg-600' => 'bg-primary-600', 'bg-700' => 'bg-primary-700', 'text' => 'text-primary-600', 'border' => 'border-primary-500/20', 'glow' => 'bg-primary-500/10'],
    ];
    $style = $accentMap[$accent] ?? $accentMap['primary'];
@endphp

<section class="relative py-20 lg:py-28 overflow-hidden bg-white dark:bg-slate-950 transition-colors duration-500">
    
    {{-- Background effects shared with other premium sections --}}
    <div class="absolute inset-0 z-0">
        @if($bgStyle === 'blobs')
        <div class="absolute top-0 right-0 w-[60vw] h-[60vw] max-w-[800px] max-h-[800px] rounded-full 
                    bg-gradient-to-br {{ str_replace('bg-','from-',$style['bg']) }}/10 dark:{{ str_replace('bg-','from-',$style['bg']) }}/20 via-primary-600/5 dark:via-primary-600/10 to-transparent 
                    blur-[120px] animate-pulse"></div>
        <div class="absolute bottom-[-10%] left-[-5%] w-[40vw] h-[40vw] max-w-[500px] max-h-[500px] rounded-full 
                    bg-gradient-to-tr from-primary-400/10 dark:from-primary-400/20 via-primary-500/5 dark:via-primary-500/10 to-transparent 
                    blur-[100px] animate-pulse" style="animation-duration: 4s;"></div>
        @endif
        
        {{-- Technical Grid DNA --}}
        @if($bgStyle === 'grid' || $bgStyle === 'blobs')
        <div class="absolute inset-0 bg-[linear-gradient(rgba(0,0,0,.03)_1px,transparent_1px),linear-gradient(90deg,rgba(0,0,0,.03)_1px,transparent_1px)] dark:bg-[linear-gradient(rgba(255,255,255,.02)_1px,transparent_1px),linear-gradient(90deg,rgba(255,255,255,.02)_1px,transparent_1px)] bg-[size:72px_72px] [mask-image:radial-gradient(ellipse_50%_50%_at_50%_50%,black_40%,transparent_100%)]"></div>
        @endif


        <div class="absolute inset-0 bg-[url('{{ @$hero->data_values->link }}')] opacity-[0.03] dark:opacity-10 mix-blend-soft-light"></div>
    </div>

    <div class="container max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-12 gap-12 lg:gap-16 items-center">
            
            {{-- Content Section --}}
            <div class="lg:col-span-7 flex flex-col items-center lg:items-start text-center lg:text-left">
                
                <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full {{ $style['bg'] }}/10 border {{ $style['border'] }} backdrop-blur-sm mb-8">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full {{ str_replace('500','400',$style['bg']) }} opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 {{ $style['bg'] }}"></span>
                    </span>
                    <span class="text-[10px] font-bold uppercase tracking-[0.2em] {{ $style['text'] }}">
                        {{ __($promoBadge) }}
                    </span>
                </div>

                <h2 class="text-3xl sm:text-4xl lg:text-5xl font-extrabold text-slate-900 dark:text-white mb-5 leading-tight tracking-tight">
                    <span>{{ __($heading) }}</span>
                    <br class="hidden sm:block">
                    <span class="{{ $style['text'] }} dark:{{ $style['text'] }}">
                        {{ __($headingGradient) }}
                    </span>
                </h2>
                
                <p class="text-base text-slate-600 dark:text-slate-400 mb-8 leading-relaxed max-w-xl">
                    {{ __($subheading) }}
                </p>

                <div class="flex flex-col sm:flex-row items-center gap-5 mb-8 w-full sm:w-auto">
                    <x-theme.btn-primary href="{{ $buttonUrl }}" class="w-full sm:w-auto">
                        {{ __($buttonText) }}
                    </x-theme.btn-primary>

                    @if($showPrice)
                    <div class="flex flex-col items-center sm:items-start px-6 py-2 rounded-xl bg-white dark:bg-white/5 border border-slate-100 dark:border-white/10 shadow-sm backdrop-blur-md">
                        <span class="text-[10px] font-bold uppercase tracking-widest text-slate-500 dark:text-slate-400 mb-0.5">
                            {{ __($startsAtText) }}
                        </span>
                        <div class="flex items-baseline gap-1">
                            <span class="text-xs font-bold {{ $style['text'] }}">{{ gs('cur_sym') }}</span>
                            <span class="text-2xl font-extrabold text-slate-900 dark:text-white">
                                {{ $startsAt }}
                            </span>
                            <span class="text-slate-500 dark:text-slate-400 text-[10px] font-bold uppercase ml-1">{{ __($priceSuffix) }}</span>
                        </div>
                    </div>
                    @endif
                </div>

                <div class="flex items-center gap-4 text-slate-500 dark:text-slate-400 font-bold text-xs uppercase tracking-[0.2em]">
                    <i class="ph ph-shield-check {{ $style['text'] }} text-lg font-bold"></i>
                    <span class="opacity-80">{{ __($trustText) }}</span>
                </div>
            </div>

            {{-- RESELLER ILLUSTRATION AREA --}}
            <div class="hidden lg:block lg:col-span-5 relative">
                @if($illuType === 'image' && $imgUrl)
                    <div class="relative group">
                        <div class="absolute -inset-10 {{ $style['bg'] }}/10 rounded-full blur-[100px] opacity-40"></div>
                        <img src="{{ getImage(getFilePath('reseller_hosting_banner').'/'.$imgUrl) }}" alt="Reseller Illustration" loading="lazy" width="600" height="400" class="relative z-10 w-full h-auto rounded-2xl shadow-xl">
                    </div>
                @elseif($illuType === 'svg')
                <div class="relative group">
                    {{-- Soft Glow --}}
                    <div class="absolute -inset-10 {{ $style['bg'] }}/10 rounded-full blur-[100px] opacity-60 animate-pulse"></div>
                    
                    <svg viewBox="0 0 500 500" xmlns="http://www.w3.org/2000/svg" class="w-full h-auto relative z-10" id="reseller-illustration" style="--primary: currentColor;" class="{{ $style['text'] }}">
                        <defs>
                            {{-- Professional Gradients --}}
                            <linearGradient id="primaryGrad" x1="0%" y1="0%" x2="100%" y2="100%">
                                <stop offset="0%" stop-color="currentColor" />
                                <stop offset="100%" stop-color="#8B5CF6" />
                            </linearGradient>
                            
                            <filter id="softShadow" x="-20%" y="-20%" width="140%" height="140%">
                                <feDropShadow dx="0" dy="15" stdDeviation="10" flood-opacity="0.1"/>
                            </filter>

                            {{-- Reusable Laptop Node --}}
                            <symbol id="laptop">
                                <path d="M-30 0 L0 -15 L30 0 L0 15 Z" fill="currentColor" />
                                <path d="M-30 0 L-30 6 L0 21 L0 15 Z" fill="currentColor" filter="brightness(0.8)" />
                                <path d="M0 15 L0 21 L30 6 L30 0 Z" fill="currentColor" filter="brightness(0.6)" />
                                <path d="M-22 -4 L-22 -26 L8 -41 L8 -19 Z" fill="white" opacity="0.3" stroke="white" stroke-width="1" />
                            </symbol>
                        </defs>

                        {{-- Ambient Background --}}
                        <circle cx="250" cy="250" r="180" fill="url(#primaryGrad)" opacity="0.05" class="animate-pulse" />

                        {{-- CONNECTION LINES --}}
                        <g stroke="currentColor" stroke-width="1.5" stroke-dasharray="10 6" fill="none" opacity="0.2">
                            <path d="M250 220 L380 120" class="svg-dash" />
                            <path d="M250 280 L400 350" class="svg-dash" />
                            <path d="M250 280 L100 340" class="svg-dash" />
                        </g>

                        {{-- MASTER HUB (Central Server) --}}
                        <g transform="translate(250, 240)" class="svg-float">
                            {{-- Server Block --}}
                            <path d="M-60 0 L0 -30 L60 0 L0 30 Z" fill="var(--svg-mid)" />
                            <path d="M-60 0 L-60 90 L0 120 L0 30 Z" fill="var(--svg-dark)" />
                            <path d="M0 30 L0 120 L60 90 L60 0 Z" fill="var(--svg-light)" />
                            
                            {{-- Hub Icon / Glow --}}
                            <circle cx="0" cy="-10" r="28" fill="url(#primaryGrad)" opacity="0.8" />
                            <path d="M-10 -5 L0 -15 L10 -5 M0 -15 L0 5" stroke="white" stroke-width="3" stroke-linecap="round" fill="none" />
                            
                            {{-- Server Indicators --}}
                            @for($i=0; $i<4; $i++)
                                <rect x="-45" y="{{ 20 + $i*12 }}" width="30" height="3" rx="1.5" fill="currentColor" opacity="0.4" class="svg-pulse" />
                                <circle cx="5" cy="{{ 20 + $i*12 + 1.5 }}" r="1.5" fill="#10B981" />
                            @endfor
                        </g>

                        {{-- BUSINESS ELEMENTS --}}
                        {{-- Management Gear --}}
                        <g transform="translate(140, 130)" class="svg-float-alt">
                            <circle r="30" fill="white" class="dark:fill-slate-800" filter="url(#softShadow)" />
                            <circle r="12" fill="none" stroke="currentColor" stroke-width="4" stroke-dasharray="8 4" class="animate-spin-slow" />
                            <circle r="6" fill="currentColor" />
                        </g>

                        {{-- Security Shield --}}
                        <g transform="translate(420, 230)" class="svg-float">
                            <circle r="25" fill="white" class="dark:fill-slate-800" filter="url(#softShadow)" />
                            <path d="M-8 -10 L0 -14 L8 -10 L8 2 C8 8 0 14 0 14 C0 14 -8 8 -8 2 Z" fill="#3B82F6" opacity="0.8" />
                        </g>

                        {{-- Profit Growth --}}
                        <g transform="translate(350, 420)" class="svg-float-alt">
                            <circle r="35" fill="#10B981" />
                            <path d="M-10 10 L-2 -2 L4 4 L14 -6 M8 -6 L14 -6 L14 0" stroke="white" stroke-width="3" fill="none" stroke-linecap="round" stroke-linejoin="round" />
                            <text y="25" text-anchor="middle" font-size="7" font-weight="900" fill="white" class="uppercase tracking-widest">PROFIT</text>
                        </g>

                        {{-- CLIENT NODES --}}
                        <g class="text-slate-200 dark:text-slate-800">
                             <g transform="translate(380, 120)" class="svg-float">
                                <use href="#laptop" />
                                <text y="-25" text-anchor="middle" font-size="8" font-weight="900" fill="currentColor" class="uppercase opacity-40">Client A</text>
                             </g>
                             <g transform="translate(420, 350)" class="svg-float-alt">
                                <use href="#laptop" />
                                <text y="-25" text-anchor="middle" font-size="8" font-weight="900" fill="#10B981" class="uppercase opacity-40">Client B</text>
                             </g>
                             <g transform="translate(100, 340)" class="svg-float">
                                <use href="#laptop" />
                                <text y="-25" text-anchor="middle" font-size="8" font-weight="900" fill="#F59E0B" class="uppercase opacity-40">Client C</text>
                             </g>
                        </g>
                    </svg>
                </div>
                @endif
            </div>
            </div>

        </div>
    </div>
</section>
