<div>
    @if ($paginator->hasPages())
        <div class="flex items-center gap-2">
            @if ($paginator->onFirstPage())
                <span class="w-10 h-10 flex items-center justify-center rounded-xl bg-primary-light border border-subtle text-dynamic-muted cursor-default">
                    <i class="ph-bold ph-caret-left"></i>
                </span>
            @else
                <button wire:click="previousPage" class="w-10 h-10 flex items-center justify-center rounded-xl bg-primary-light border border-subtle text-dynamic hover:bg-primary-light/80 transition-colors">
                    <i class="ph-bold ph-caret-left"></i>
                </button>
            @endif

            <span class="text-sm font-bold text-dynamic px-2">
                {{ $paginator->currentPage() }} <span class="text-dynamic-muted font-medium">/</span> {{ $paginator->lastPage() }}
            </span>

            @if ($paginator->hasMorePages())
                <button wire:click="nextPage" class="w-10 h-10 flex items-center justify-center rounded-xl bg-primary-light border border-subtle text-dynamic hover:bg-primary-light/80 transition-colors">
                    <i class="ph-bold ph-caret-right"></i>
                </button>
            @else
                <span class="w-10 h-10 flex items-center justify-center rounded-xl bg-primary-light border border-subtle text-dynamic-muted cursor-default">
                    <i class="ph-bold ph-caret-right"></i>
                </span>
            @endif
        </div>
    @endif
</div>
