<div>
    @if ($paginator->hasPages())
        <nav role="navigation" aria-label="Pagination Navigation" class="flex items-center justify-between">
            <div class="flex flex-1 justify-between sm:hidden">
                @if ($paginator->onFirstPage())
                    <span class="relative inline-flex items-center rounded-xl border border-subtle bg-primary-light px-4 py-2 text-sm font-medium text-dynamic-muted">
                        @lang('Previous')
                    </span>
                @else
                    <button wire:click="previousPage" wire:loading.attr="disabled" class="relative inline-flex items-center rounded-xl border border-subtle bg-primary-light px-4 py-2 text-sm font-medium text-dynamic hover:bg-primary-light/80 transition-colors">
                        @lang('Previous')
                    </button>
                @endif

                @if ($paginator->hasMorePages())
                    <button wire:click="nextPage" wire:loading.attr="disabled" class="relative ml-3 inline-flex items-center rounded-xl border border-subtle bg-primary-light px-4 py-2 text-sm font-medium text-dynamic hover:bg-primary-light/80 transition-colors">
                        @lang('Next')
                    </button>
                @else
                    <span class="relative ml-3 inline-flex items-center rounded-xl border border-subtle bg-primary-light px-4 py-2 text-sm font-medium text-dynamic-muted">
                        @lang('Next')
                    </span>
                @endif
            </div>

            <div class="hidden sm:flex sm:flex-1 sm:items-center sm:justify-between">
                <div>
                    <p class="text-sm text-dynamic-secondary">
                        @lang('Showing')
                        <span class="font-bold text-dynamic">{{ $paginator->firstItem() }}</span>
                        @lang('to')
                        <span class="font-bold text-dynamic">{{ $paginator->lastItem() }}</span>
                        @lang('of')
                        <span class="font-bold text-dynamic">{{ $paginator->total() }}</span>
                        @lang('results')
                    </p>
                </div>

                <div>
                    <span class="relative z-0 inline-flex shadow-sm rounded-xl overflow-hidden border border-subtle divide-x divide-subtle">
                        {{-- Previous Page Link --}}
                        @if ($paginator->onFirstPage())
                            <span aria-disabled="true" aria-label="{{ __('pagination.previous') }}">
                                <span class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic-muted cursor-default" aria-hidden="true">
                                    <i class="ph-bold ph-caret-left"></i>
                                </span>
                            </span>
                        @else
                            <button wire:click="previousPage" rel="prev" class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic hover:bg-primary-light/80 transition-colors" aria-label="{{ __('pagination.previous') }}">
                                <i class="ph-bold ph-caret-left"></i>
                            </button>
                        @endif

                        {{-- Pagination Elements --}}
                        @foreach ($elements as $element)
                            {{-- "Three Dots" Separator --}}
                            @if (is_string($element))
                                <span aria-disabled="true">
                                    <span class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic-muted cursor-default">{{ $element }}</span>
                                </span>
                            @endif

                            {{-- Array Of Links --}}
                            @if (is_array($element))
                                @foreach ($element as $page => $url)
                                    @if ($page == $paginator->currentPage())
                                        <span aria-current="page">
                                            <span class="relative inline-flex items-center px-4 py-2 bg-primary text-sm font-bold text-white cursor-default" style="background-color: var(--primary);">{{ $page }}</span>
                                        </span>
                                    @else
                                        <button wire:click="gotoPage({{ $page }})" class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic-secondary hover:bg-primary-light/80 hover:text-dynamic transition-colors">
                                            {{ $page }}
                                        </button>
                                    @endif
                                @endforeach
                            @endif
                        @endforeach

                        {{-- Next Page Link --}}
                        @if ($paginator->hasMorePages())
                            <button wire:click="nextPage" rel="next" class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic hover:bg-primary-light/80 transition-colors" aria-label="{{ __('pagination.next') }}">
                                <i class="ph-bold ph-caret-right"></i>
                            </button>
                        @else
                            <span aria-disabled="true" aria-label="{{ __('pagination.next') }}">
                                <span class="relative inline-flex items-center px-4 py-2 bg-primary-light text-sm font-medium text-dynamic-muted cursor-default" aria-hidden="true">
                                    <i class="ph-bold ph-caret-right"></i>
                                </span>
                            </span>
                        @endif
                    </span>
                </div>
            </div>
        </nav>
    @endif
</div>
