/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.5.29-MariaDB, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: salieno_db
-- ------------------------------------------------------
-- Server version	10.5.29-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addons`
--

DROP TABLE IF EXISTS `addons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `addons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `addons`
--

LOCK TABLES `addons` WRITE;
/*!40000 ALTER TABLE `addons` DISABLE KEYS */;
/*!40000 ALTER TABLE `addons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `api_response` tinyint(1) NOT NULL DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` text DEFAULT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `click_url` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'system',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_password_resets`
--

DROP TABLE IF EXISTS `admin_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_password_resets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(40) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `code` varchar(6) DEFAULT NULL,
  `resend_count` int(11) NOT NULL DEFAULT 0,
  `expires_at` timestamp NULL DEFAULT NULL,
  `last_resend_at` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_password_resets`
--

LOCK TABLES `admin_password_resets` WRITE;
/*!40000 ALTER TABLE `admin_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admins`
--

DROP TABLE IF EXISTS `admins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `admins` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint(20) unsigned DEFAULT NULL COMMENT 'NULL = Super Admin',
  `name` varchar(40) DEFAULT NULL,
  `email` varchar(40) DEFAULT NULL,
  `mobile` varchar(40) DEFAULT NULL,
  `address` text DEFAULT NULL COMMENT 'JSON object with address, state, zip, country, city',
  `username` varchar(40) DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tsc` varchar(255) DEFAULT NULL,
  `ts` tinyint(1) NOT NULL DEFAULT 0,
  `two_factor_recovery_codes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `admins_email_username_unique` (`email`,`username`),
  KEY `admins_role_id_foreign` (`role_id`),
  CONSTRAINT `admins_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admins`
--

LOCK TABLES `admins` WRITE;
/*!40000 ALTER TABLE `admins` DISABLE KEYS */;
/*!40000 ALTER TABLE `admins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `affiliate_commissions`
--

DROP TABLE IF EXISTS `affiliate_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `affiliate_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `referral_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `invoice_id` bigint(20) unsigned DEFAULT NULL,
  `amount` decimal(18,8) NOT NULL DEFAULT 0.00000000 COMMENT 'Commission amount',
  `commission_rate` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Commission rate percentage',
  `status` enum('pending','approved','paid','rejected') NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_commissions_order_id_foreign` (`order_id`),
  KEY `affiliate_commissions_invoice_id_foreign` (`invoice_id`),
  KEY `affiliate_commissions_user_id_status_index` (`user_id`,`status`),
  KEY `affiliate_commissions_referral_id_index` (`referral_id`),
  KEY `affiliate_commissions_status_created_at_index` (`status`,`created_at`),
  CONSTRAINT `affiliate_commissions_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL,
  CONSTRAINT `affiliate_commissions_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL,
  CONSTRAINT `affiliate_commissions_referral_id_foreign` FOREIGN KEY (`referral_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `affiliate_commissions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `affiliate_commissions`
--

LOCK TABLES `affiliate_commissions` WRITE;
/*!40000 ALTER TABLE `affiliate_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `affiliate_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `affiliate_payouts`
--

DROP TABLE IF EXISTS `affiliate_payouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `affiliate_payouts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(18,8) NOT NULL DEFAULT 0.00000000,
  `payment_method` enum('paypal','bank_transfer','account_balance') NOT NULL DEFAULT 'paypal',
  `payment_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'PayPal email, bank details, etc.',
  `status` enum('pending','processing','completed','rejected') NOT NULL DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `processed_by` bigint(20) unsigned DEFAULT NULL,
  `transaction_id` varchar(255) DEFAULT NULL COMMENT 'External transaction reference',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `affiliate_payouts_processed_by_foreign` (`processed_by`),
  KEY `affiliate_payouts_user_id_status_index` (`user_id`,`status`),
  KEY `affiliate_payouts_status_created_at_index` (`status`,`created_at`),
  CONSTRAINT `affiliate_payouts_processed_by_foreign` FOREIGN KEY (`processed_by`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  CONSTRAINT `affiliate_payouts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `affiliate_payouts`
--

LOCK TABLES `affiliate_payouts` WRITE;
/*!40000 ALTER TABLE `affiliate_payouts` DISABLE KEYS */;
/*!40000 ALTER TABLE `affiliate_payouts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `billing_settings`
--

DROP TABLE IF EXISTS `billing_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `billing_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(100) DEFAULT NULL,
  `company_address` varchar(255) DEFAULT NULL,
  `company_city` varchar(100) DEFAULT NULL,
  `company_state` varchar(100) DEFAULT NULL,
  `company_zip` varchar(20) DEFAULT NULL,
  `company_country` varchar(100) DEFAULT NULL,
  `company_phone` varchar(50) DEFAULT NULL,
  `company_email` varchar(100) DEFAULT NULL,
  `company_tax_id` varchar(50) DEFAULT NULL,
  `invoice_footer` text DEFAULT NULL,
  `invoice_prefix` varchar(20) NOT NULL DEFAULT 'INV-',
  `invoice_start_number` int(11) NOT NULL DEFAULT 1000,
  `invoice_due_days` int(11) NOT NULL DEFAULT 7,
  `invoice_late_fee_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=Fixed, 2=Percentage',
  `invoice_late_fee_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `invoice_late_fee_days` int(11) NOT NULL DEFAULT 0,
  `auto_suspend_days` int(11) NOT NULL DEFAULT 3,
  `auto_terminate_days` int(11) NOT NULL DEFAULT 14,
  `first_invoice_days` int(11) NOT NULL DEFAULT 14,
  `renewal_invoice_days` int(11) NOT NULL DEFAULT 14,
  `tax_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `tax_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=Inclusive, 2=Exclusive',
  `tax_rate` decimal(8,2) NOT NULL DEFAULT 0.00,
  `tax_name` varchar(50) NOT NULL DEFAULT 'VAT',
  `credit_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `prorate_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `prorate_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=Full Month, 2=Actual Days',
  `create_default_invoice_days` int(11) DEFAULT 0,
  `create_invoice` text DEFAULT NULL,
  `create_domain_invoice_days` int(11) DEFAULT 0,
  `invoice_send_reminder_days` int(11) DEFAULT 0,
  `invoice_first_over_due_reminder` int(11) DEFAULT 0,
  `invoice_second_over_due_reminder` int(11) DEFAULT 0,
  `invoice_third_over_due_reminder` int(11) DEFAULT 0,
  `invoice_send_reminder` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `domain_grace_days` tinyint(3) unsigned NOT NULL DEFAULT 7,
  `domain_redemption_days` tinyint(3) unsigned NOT NULL DEFAULT 30,
  `fraud_check_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `fraud_check_provider` varchar(50) DEFAULT NULL,
  `fraud_check_api_key` varchar(255) DEFAULT NULL,
  `fraud_auto_reject_score` tinyint(3) unsigned NOT NULL DEFAULT 80,
  `credit_limit` decimal(10,2) NOT NULL DEFAULT 0.00,
  `credit_auto_apply` tinyint(1) NOT NULL DEFAULT 1,
  `refund_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `refund_days` tinyint(3) unsigned NOT NULL DEFAULT 30,
  `refund_type` enum('full','prorated','none') NOT NULL DEFAULT 'prorated',
  `affiliate_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `affiliate_approval_days` tinyint(3) unsigned NOT NULL DEFAULT 30,
  `affiliate_min_payout` decimal(10,2) NOT NULL DEFAULT 50.00,
  `auto_provision_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `auto_provision_on_payment` tinyint(1) NOT NULL DEFAULT 1,
  `auto_unsuspend_on_payment` tinyint(1) NOT NULL DEFAULT 1,
  `auto_billing_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `auto_billing_retry_days` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `auto_billing_max_retries` tinyint(3) unsigned NOT NULL DEFAULT 3,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `billing_settings`
--

LOCK TABLES `billing_settings` WRITE;
/*!40000 ALTER TABLE `billing_settings` DISABLE KEYS */;
INSERT INTO `billing_settings` VALUES (1,'Salieno','Mbezi','Ubungo','Dar Es Salaam','11000','Tanzania','0742552286','support@salieno.com','','Thank You','INV-',1000,7,1,0.00000000,0,3,14,14,14,0,1,0.00,'VAT',1,1,1,0,NULL,0,60,3,2,1,1,'2025-12-19 15:45:03','2026-02-13 01:53:12',7,30,0,'maxmind','',80,0.00,1,0,30,'prorated',1,30,50.00,1,1,1,1,3,3);
/*!40000 ALTER TABLE `billing_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bkash_tokens`
--

DROP TABLE IF EXISTS `bkash_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bkash_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sandbox_mode` tinyint(4) NOT NULL,
  `id_expiry` bigint(20) NOT NULL DEFAULT 0,
  `id_token` varchar(2048) DEFAULT NULL,
  `refresh_expiry` bigint(20) NOT NULL DEFAULT 0,
  `refresh_token` varchar(2048) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bkash_tokens`
--

LOCK TABLES `bkash_tokens` WRITE;
/*!40000 ALTER TABLE `bkash_tokens` DISABLE KEYS */;
INSERT INTO `bkash_tokens` VALUES (1,1,0,'sandbox_id_token',0,'sandbox_refresh_token','2026-02-01 16:49:30','2026-02-01 16:49:30'),(2,0,0,'live_id_token',0,'live_refresh_token','2026-02-01 16:49:30','2026-02-01 16:49:30');
/*!40000 ALTER TABLE `bkash_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cancel_requests`
--

DROP TABLE IF EXISTS `cancel_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cancel_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `hosting_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cancel_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=> Immediate, 2=> End of billing period',
  `reason` text DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=> Pending, 1=> Approved, 2=> Rejected',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cancel_requests`
--

LOCK TABLES `cancel_requests` WRITE;
/*!40000 ALTER TABLE `cancel_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `cancel_requests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `canned_responses`
--

DROP TABLE IF EXISTS `canned_responses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `canned_responses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `shortcut` varchar(255) DEFAULT NULL COMMENT 'Quick insert shortcut like #welcome',
  `content` text NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `usage_count` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `canned_responses_category_id_foreign` (`category_id`),
  KEY `canned_responses_created_by_foreign` (`created_by`),
  KEY `canned_responses_is_active_category_id_index` (`is_active`,`category_id`),
  KEY `canned_responses_shortcut_index` (`shortcut`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `canned_responses`
--

LOCK TABLES `canned_responses` WRITE;
/*!40000 ALTER TABLE `canned_responses` DISABLE KEYS */;
INSERT INTO `canned_responses` VALUES (1,NULL,NULL,'Welcome Message','#welcome','Thank you for contacting our support team!\n\nWe have received your request and will get back to you as soon as possible. Our team is committed to providing you with the best assistance.\n\nIn the meantime, you may find helpful resources in our Knowledge Base.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(2,NULL,NULL,'Request More Information','#moreinfo','Thank you for your message.\n\nTo better assist you, could you please provide us with the following additional information:\n\n1. [Specific information needed]\n2. [Additional details]\n3. [Any relevant screenshots or error messages]\n\nThis will help us investigate and resolve your issue more quickly.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(3,NULL,NULL,'Issue Resolved','#resolved','Great news! The issue you reported has been resolved.\n\nPlease verify that everything is working correctly on your end. If you encounter any further issues or have additional questions, don\'t hesitate to reach out.\n\nWe appreciate your patience and understanding.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(4,NULL,NULL,'Closing Inactive Ticket','#closing','We haven\'t heard back from you regarding this ticket.\n\nAs we haven\'t received a response, we will be closing this ticket. If you still need assistance, please feel free to open a new ticket or reply to this one to reopen it.\n\nThank you for choosing us!\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(5,1,NULL,'Clear Cache Instructions','#clearcache','Please try clearing your browser cache and cookies:\n\n1. Press Ctrl + Shift + Delete (Cmd + Shift + Delete on Mac)\n2. Select \'All time\' for the time range\n3. Check \'Cached images and files\' and \'Cookies\'\n4. Click \'Clear data\'\n5. Refresh the page and try again\n\nIf the issue persists, please let us know.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(6,1,NULL,'Server Under Maintenance','#maintenance','Your server is currently undergoing scheduled maintenance.\n\nExpected completion time: [TIME]\n\nWe apologize for any inconvenience this may cause. Your services will be restored as soon as the maintenance is complete.\n\nThank you for your patience.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(7,2,NULL,'Payment Received','#paymentok','Thank you for your payment!\n\nWe have successfully received your payment and your invoice has been marked as paid. Your services are now active.\n\nYou can view your receipt in your client area under Billing > Invoices.\n\nIf you have any questions, please don\'t hesitate to ask.\n\nBest regards,\nBilling Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(8,2,NULL,'Refund Processed','#refund','Your refund has been processed successfully.\n\nRefund Amount: [AMOUNT]\nRefund Method: [METHOD]\nExpected Arrival: 5-10 business days\n\nPlease note that the exact timing depends on your payment provider.\n\nIf you don\'t see the refund within 10 business days, please contact us.\n\nBest regards,\nBilling Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(9,4,NULL,'DNS Propagation','#dnsprop','Your DNS changes have been submitted successfully.\n\nPlease note that DNS changes can take up to 24-48 hours to fully propagate worldwide. During this time, you may see inconsistent results.\n\nYou can check the propagation status at: https://dnschecker.org\n\nIf you\'re still experiencing issues after 48 hours, please let us know.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35'),(10,4,NULL,'Domain Transfer EPP Code','#epp','To transfer your domain, you will need an EPP/Authorization code from your current registrar.\n\nHere\'s how to proceed:\n1. Contact your current registrar to unlock the domain\n2. Request the EPP/Authorization code\n3. Ensure your WHOIS email is accessible\n4. Initiate the transfer with the code provided\n\nThe transfer typically takes 5-7 days to complete.\n\nBest regards,\nSupport Team',1,0,'2026-02-07 12:57:35','2026-02-07 12:57:35');
/*!40000 ALTER TABLE `canned_responses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `capability_overrides`
--

DROP TABLE IF EXISTS `capability_overrides`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `capability_overrides` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feature_name` varchar(255) NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `override_token` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `capability_overrides`
--

LOCK TABLES `capability_overrides` WRITE;
/*!40000 ALTER TABLE `capability_overrides` DISABLE KEYS */;
/*!40000 ALTER TABLE `capability_overrides` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category_features`
--

DROP TABLE IF EXISTS `category_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `category_features` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `comparison_group` varchar(255) DEFAULT NULL,
  `tooltip_text` text DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_features_category_id_foreign` (`category_id`),
  CONSTRAINT `category_features_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `service_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category_features`
--

LOCK TABLES `category_features` WRITE;
/*!40000 ALTER TABLE `category_features` DISABLE KEYS */;
INSERT INTO `category_features` VALUES (1,1,'NVMe SSD Storage','ph-bold ph-hard-drive','resources','Enterprise-grade NVMe storage for maximum speed.',1,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(2,1,'Bandwidth','ph-bold ph-globe','resources','High-performance unmetered data transfer.',2,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(3,1,'RAM Memory','ph-bold ph-cpu','resources','Dedicated memory allocation for your account.',3,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(4,1,'vCPU Cores','ph-bold ph-microchip','resources','Number of dedicated CPU cores.',4,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(5,1,'Websites Hosted','ph-bold ph-browser','features','Maximum number of websites allowed.',5,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(6,1,'Control Panel','ph-bold ph-layout','features','Industry leading management interface.',6,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(7,1,'Free Domain','ph-bold ph-hash','features','One year free domain registration.',7,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(8,1,'Free Website Migration','ph-bold ph-airplane-tilt','features','Professional site transfer service.',8,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(9,1,'Free SSL Certificates','ph-bold ph-shield-check','security','AutoSSL let\'s encrypt integration.',9,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(10,1,'DDoS Protection','ph-bold ph-shield-plus','security','Real-time global attack mitigation.',10,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(11,1,'Daily Backups','ph-bold ph-stack','security','Automated daily snapshots.',11,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(12,1,'24/7 Premium Support','ph-bold ph-headset','support','Round-the-clock expert technical help.',12,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(13,1,'99.99% Uptime SLA','ph-bold ph-clock','support','Guaranteed availability with SLA.',13,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(14,2,'NVMe Storage','ph-bold ph-hard-drive','resources','Total storage for all sub-accounts.',1,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(15,2,'Monthly Bandwidth','ph-bold ph-globe','resources','High-speed data transfer.',2,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(16,2,'Accounts Allowed','ph-bold ph-users','resources','Max number of cPanel accounts.',3,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(17,2,'White Label Hosting','ph-bold ph-tag','features','Fully customizable branding.',4,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(18,2,'Free WHMCS License','ph-bold ph-receipt','features','Professional billing system.',5,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(19,2,'Private Name Servers','ph-bold ph-dns','features','Custom DNS branding.',6,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(20,2,'Priority Migration Support','ph-bold ph-airplane-tilt','support','Managed migration for all clients.',7,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(21,5,'Optimized SSD Storage','ph-bold ph-hard-drive','resources','WP-optimized storage performance.',1,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(22,5,'Monthly Visits','ph-bold ph-users-three','resources','Estimated traffic capacity.',2,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(23,5,'PHP Memory Limit','ph-bold ph-cpu','resources','Increased memory for WP processes.',3,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(24,5,'WP-CLI & SSH Access','ph-bold ph-terminal-window','features','Advanced command line tools.',4,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(25,5,'Staging Environment','ph-bold ph-copy','features','One-click testing environments.',5,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(26,5,'Smart Auto-Updates','ph-bold ph-arrows-clockwise','features','Intelligent core and plugin updates.',6,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(27,5,'Object Cache (Redis)','ph-bold ph-lightning','performance','Database acceleration.',7,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(28,5,'Free CDN Integration','ph-bold ph-cloud','performance','Global static content delivery.',8,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(29,3,'Dedicated RAM','ph-bold ph-cpu','resources','Fixed memory allocation.',1,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(30,3,'Dedicated CPU Cores','ph-bold ph-microchip','resources','Guaranteed processing power.',2,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(31,3,'Enterprise NVMe','ph-bold ph-hard-drive','resources','Redundant data storage.',3,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(32,3,'Full Root Access','ph-bold ph-terminal-window','features','Total administrative control.',4,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(33,3,'Dedicated IP Address','ph-bold ph-address-book','features','Included static IPv4.',5,'2026-01-21 03:29:37','2026-01-21 03:29:37'),(34,3,'Fully Managed Support','ph-bold ph-wrench','support','Hands-off server management.',6,'2026-01-21 03:29:37','2026-01-21 03:29:37');
/*!40000 ALTER TABLE `category_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configurable_group_options`
--

DROP TABLE IF EXISTS `configurable_group_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `configurable_group_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_type` tinyint(4) NOT NULL DEFAULT 0,
  `configurable_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `order` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurable_group_options`
--

LOCK TABLES `configurable_group_options` WRITE;
/*!40000 ALTER TABLE `configurable_group_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `configurable_group_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configurable_group_sub_options`
--

DROP TABLE IF EXISTS `configurable_group_sub_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `configurable_group_sub_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `configurable_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `configurable_group_option_id` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `order` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurable_group_sub_options`
--

LOCK TABLES `configurable_group_sub_options` WRITE;
/*!40000 ALTER TABLE `configurable_group_sub_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `configurable_group_sub_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `configurable_groups`
--

DROP TABLE IF EXISTS `configurable_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `configurable_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurable_groups`
--

LOCK TABLES `configurable_groups` WRITE;
/*!40000 ALTER TABLE `configurable_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `configurable_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=> Fixed, 2=> Percentage',
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `apply_once` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=> Recurring, 1=> Once',
  `max_uses` int(10) unsigned NOT NULL DEFAULT 0 COMMENT '0 means unlimited',
  `uses` int(10) unsigned NOT NULL DEFAULT 0,
  `start_date` varchar(40) DEFAULT NULL,
  `end_date` varchar(40) DEFAULT NULL,
  `products` text DEFAULT NULL COMMENT 'JSON array of product IDs',
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `coupons`
--

LOCK TABLES `coupons` WRITE;
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
INSERT INTO `coupons` VALUES (1,'Discount for Starter Plan','T6YUHNCT',1,5.00000000,1,100,0,'2026-01-31','2026-08-01','[1]',1,'2026-02-01 18:18:45','2026-02-01 18:20:42'),(2,'Discount for Business Plan','BUSINESS_PLAN_40OFF',2,10.00000000,1,100,0,'2026-01-31','2026-08-01','[2]',1,'2026-02-01 18:18:45','2026-02-01 18:18:45'),(3,'Discount for Enterprise Plan','ENTERPRISE_PLAN_84OFF',1,5.00000000,0,100,0,'2026-01-31','2026-08-01','[3]',1,'2026-02-01 18:18:45','2026-02-01 18:18:45'),(4,'Discount for Reseller Basic','RESELLER_BASIC_89OFF',2,10.00000000,1,100,0,'2026-01-31','2026-08-01','[4]',1,'2026-02-01 18:18:45','2026-02-01 18:18:45'),(5,'Discount for VPS Starter','VPS_STARTER_80OFF',1,5.00000000,0,100,0,'2026-01-31','2026-08-01','[5]',1,'2026-02-01 18:18:45','2026-02-01 18:18:45');
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron_job_logs`
--

DROP TABLE IF EXISTS `cron_job_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_job_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cron_job_id` int(10) unsigned NOT NULL DEFAULT 0,
  `cron_schedule_id` int(10) unsigned NOT NULL DEFAULT 0,
  `start_at` varchar(40) DEFAULT NULL,
  `end_at` varchar(40) DEFAULT NULL,
  `duration` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Duration in seconds',
  `error` text DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `resolved_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron_job_logs`
--

LOCK TABLES `cron_job_logs` WRITE;
/*!40000 ALTER TABLE `cron_job_logs` DISABLE KEYS */;
INSERT INTO `cron_job_logs` VALUES (235,1,0,'2026-02-25 21:59:03','2026-02-25 21:59:03',3,NULL,0,NULL,'2026-02-25 18:59:03','2026-02-25 18:59:03'),(236,2,0,'2026-02-25 21:59:03','2026-02-25 21:59:03',27,NULL,0,NULL,'2026-02-25 18:59:03','2026-02-25 18:59:03'),(237,10,0,'2026-02-25 21:59:03','2026-02-25 21:59:03',18,NULL,0,NULL,'2026-02-25 18:59:03','2026-02-25 18:59:03'),(238,11,0,'2026-02-25 21:59:03','2026-02-25 21:59:03',3,NULL,0,NULL,'2026-02-25 18:59:03','2026-02-25 18:59:03'),(239,12,0,'2026-02-25 21:59:03','2026-02-25 21:59:04',6,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(240,13,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',6,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(241,16,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',10,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(242,17,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',5,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(243,3,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',2,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(244,4,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',4,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(245,5,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',3,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(246,6,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',5,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(247,7,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',2,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(248,8,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',8,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(249,9,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',4,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(250,15,0,'2026-02-25 21:59:04','2026-02-25 21:59:04',5,NULL,0,NULL,'2026-02-25 18:59:04','2026-02-25 18:59:04'),(251,14,0,'2026-02-25 22:00:04','2026-02-25 22:00:04',23,NULL,0,NULL,'2026-02-25 19:00:04','2026-02-25 19:00:04'),(252,19,0,'2026-02-25 22:00:04','2026-02-25 22:00:04',9,NULL,0,NULL,'2026-02-25 19:00:04','2026-02-25 19:00:04'),(253,20,0,'2026-02-25 22:00:04','2026-02-25 22:00:04',13,NULL,0,NULL,'2026-02-25 19:00:04','2026-02-25 19:00:04'),(254,21,0,'2026-02-25 22:00:04','2026-02-25 22:00:04',8,NULL,0,NULL,'2026-02-25 19:00:04','2026-02-25 19:00:04'),(255,22,0,'2026-02-25 22:00:04','2026-02-25 22:00:05',276,NULL,0,NULL,'2026-02-25 19:00:05','2026-02-25 19:00:05'),(256,23,0,'2026-02-25 22:00:05','2026-02-25 22:00:06',1050,NULL,0,NULL,'2026-02-25 19:00:06','2026-02-25 19:00:06'),(257,13,0,'2026-02-25 22:14:04','2026-02-25 22:14:04',5,NULL,0,NULL,'2026-02-25 19:14:04','2026-02-25 19:14:04'),(258,16,0,'2026-02-25 22:14:04','2026-02-25 22:14:04',7,NULL,0,NULL,'2026-02-25 19:14:04','2026-02-25 19:14:04'),(259,17,0,'2026-02-25 22:14:04','2026-02-25 22:14:04',4,NULL,0,NULL,'2026-02-25 19:14:04','2026-02-25 19:14:04'),(260,13,0,'2026-02-25 22:29:04','2026-02-25 22:29:04',7,NULL,0,NULL,'2026-02-25 19:29:04','2026-02-25 19:29:04'),(261,16,0,'2026-02-25 22:29:04','2026-02-25 22:29:04',10,NULL,0,NULL,'2026-02-25 19:29:04','2026-02-25 19:29:04'),(262,17,0,'2026-02-25 22:29:04','2026-02-25 22:29:04',6,NULL,0,NULL,'2026-02-25 19:29:04','2026-02-25 19:29:04'),(263,13,0,'2026-02-25 22:44:04','2026-02-25 22:44:04',5,NULL,0,NULL,'2026-02-25 19:44:04','2026-02-25 19:44:04'),(264,16,0,'2026-02-25 22:44:04','2026-02-25 22:44:04',8,NULL,0,NULL,'2026-02-25 19:44:04','2026-02-25 19:44:04'),(265,17,0,'2026-02-25 22:44:04','2026-02-25 22:44:04',5,NULL,0,NULL,'2026-02-25 19:44:04','2026-02-25 19:44:04'),(266,1,0,'2026-02-25 22:59:03','2026-02-25 22:59:03',3,NULL,0,NULL,'2026-02-25 19:59:03','2026-02-25 19:59:03'),(267,10,0,'2026-02-25 22:59:03','2026-02-25 22:59:03',31,NULL,0,NULL,'2026-02-25 19:59:03','2026-02-25 19:59:03'),(268,12,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',27,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(269,13,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',13,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(270,16,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',18,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(271,17,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',15,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(272,15,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',18,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(273,20,0,'2026-02-25 23:00:06','2026-02-25 23:00:06',9,NULL,0,NULL,'2026-02-25 20:00:06','2026-02-25 20:00:06'),(274,13,0,'2026-02-25 23:16:04','2026-02-25 23:16:04',9,NULL,0,NULL,'2026-02-25 20:16:04','2026-02-25 20:16:04'),(275,16,0,'2026-02-25 23:16:04','2026-02-25 23:16:04',8,NULL,0,NULL,'2026-02-25 20:16:04','2026-02-25 20:16:04'),(276,17,0,'2026-02-25 23:16:04','2026-02-25 23:16:04',9,NULL,0,NULL,'2026-02-25 20:16:04','2026-02-25 20:16:04'),(277,13,0,'2026-02-25 23:31:04','2026-02-25 23:31:04',10,NULL,0,NULL,'2026-02-25 20:31:04','2026-02-25 20:31:04'),(278,16,0,'2026-02-25 23:31:04','2026-02-25 23:31:04',11,NULL,0,NULL,'2026-02-25 20:31:04','2026-02-25 20:31:04'),(279,17,0,'2026-02-25 23:31:04','2026-02-25 23:31:04',10,NULL,0,NULL,'2026-02-25 20:31:04','2026-02-25 20:31:04'),(280,13,0,'2026-02-25 23:46:05','2026-02-25 23:46:05',4,NULL,0,NULL,'2026-02-25 20:46:05','2026-02-25 20:46:05'),(281,16,0,'2026-02-25 23:46:05','2026-02-25 23:46:05',12,NULL,0,NULL,'2026-02-25 20:46:05','2026-02-25 20:46:05'),(282,17,0,'2026-02-25 23:46:05','2026-02-25 23:46:05',8,NULL,0,NULL,'2026-02-25 20:46:05','2026-02-25 20:46:05');
/*!40000 ALTER TABLE `cron_job_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron_jobs`
--

DROP TABLE IF EXISTS `cron_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `action` text DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `cron_schedule_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `next_run` timestamp NULL DEFAULT NULL,
  `last_run` timestamp NULL DEFAULT NULL,
  `is_running` tinyint(1) NOT NULL DEFAULT 1,
  `is_default` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` text DEFAULT NULL,
  `category` varchar(50) NOT NULL DEFAULT 'custom',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `success_count` int(10) unsigned NOT NULL DEFAULT 0,
  `failure_count` int(10) unsigned NOT NULL DEFAULT 0,
  `last_error` text DEFAULT NULL,
  `last_error_at` timestamp NULL DEFAULT NULL,
  `avg_duration` int(10) unsigned NOT NULL DEFAULT 0,
  `depends_on` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `execution_group` varchar(255) DEFAULT NULL,
  `max_retries` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `retry_count` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `retry_delay` int(10) unsigned NOT NULL DEFAULT 60,
  `timeout` int(10) unsigned NOT NULL DEFAULT 300,
  `locked_at` timestamp NULL DEFAULT NULL,
  `locked_by` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cron_jobs_category_index` (`category`),
  KEY `cron_jobs_priority_index` (`priority`),
  KEY `cron_jobs_is_running_next_run_index` (`is_running`,`next_run`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron_jobs`
--

LOCK TABLES `cron_jobs` WRITE;
/*!40000 ALTER TABLE `cron_jobs` DISABLE KEYS */;
INSERT INTO `cron_jobs` VALUES (1,'Invoice Generate','invoice_generate','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"invoiceGenerate\"]',NULL,5,'2026-02-25 20:59:03','2026-02-25 19:59:03',1,1,'2025-12-19 15:45:03','2026-02-25 19:59:03','Generates renewal invoices for hosting and domain services based on billing settings.','billing',1,9,0,NULL,NULL,1,NULL,'billing_core',3,0,60,300,NULL,NULL),(2,'Process Auto-Billing','auto_billing','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"processAutoBilling\"]',NULL,8,'2026-02-26 18:59:03','2026-02-25 18:59:03',1,1,'2025-12-19 15:45:03','2026-02-25 18:59:03','Automatically charges due invoices using stored payment methods.','billing',1,8,0,NULL,NULL,5,NULL,'billing_core',3,0,60,300,NULL,NULL),(3,'Add Late Fee','add_late_fee','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"addLateFee\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:03','2026-02-25 18:59:04','Adds late fees to overdue invoices based on billing settings.','billing',2,8,0,NULL,NULL,0,'[1]',NULL,3,0,60,300,NULL,NULL),(4,'Unpaid Invoice Reminder','unpaid_invoice_reminder','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"unpaidInvoiceReminder\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:03','2026-02-25 18:59:04','Sends payment reminder emails before invoice due date.','notifications',2,8,0,NULL,NULL,0,NULL,'billing_reminders',3,0,60,300,NULL,NULL),(5,'First Overdue Reminder','first_overdue_reminder','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"firstOverdueReminder\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:03','2026-02-25 18:59:04','Sends first overdue notification after invoice due date.','notifications',2,8,0,NULL,NULL,0,NULL,'overdue_reminders',3,0,60,300,NULL,NULL),(6,'Second Overdue Reminder','second_overdue_reminder','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"secondOverdueReminder\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:03','2026-02-25 18:59:04','Sends second overdue notification for outstanding invoices.','notifications',2,8,0,NULL,NULL,0,'[5]','overdue_reminders',3,0,60,300,NULL,NULL),(7,'Third Overdue Reminder','third_overdue_reminder','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"thirdOverdueReminder\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:04','2026-02-25 18:59:04','Sends final overdue notification before service suspension.','notifications',2,8,0,NULL,NULL,0,'[6]','overdue_reminders',3,0,60,300,NULL,NULL),(8,'Domain Expiry Reminders','domain_expiry_reminders','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"domainExpiryReminders\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:04','2026-02-25 18:59:04','Sends domain expiry reminders at 30, 14, 7, 3, and 1 days before expiry.','notifications',2,8,0,NULL,NULL,1,NULL,'billing_reminders',3,0,60,300,NULL,NULL),(9,'Service Expiry Reminders','service_expiry_reminders','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"serviceExpiryReminders\"]',NULL,8,'2026-02-26 18:59:04','2026-02-25 18:59:04',1,1,'2025-12-19 15:45:04','2026-02-25 18:59:04','Sends hosting service expiry reminders at 14, 7, 3, and 1 days before expiry.','notifications',2,8,0,NULL,NULL,1,'[1]','billing_reminders',3,0,60,300,NULL,NULL),(10,'Auto Suspend Services','auto_suspend_services','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"autoSuspendServices\"]',NULL,5,'2026-02-25 20:59:03','2026-02-25 19:59:03',1,1,'2025-12-19 15:45:04','2026-02-25 19:59:03','Automatically suspends services with unpaid invoices past grace period.','services',1,9,0,NULL,NULL,844,'[1]','service_management',3,0,60,300,NULL,NULL),(11,'Auto Terminate Services','auto_terminate_services','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"autoTerminateServices\"]',NULL,8,'2026-02-26 18:59:03','2026-02-25 18:59:03',1,1,'2025-12-19 15:45:04','2026-02-25 18:59:03','Terminates services that have been suspended for too long.','services',1,8,0,NULL,NULL,0,'[10]','service_management',3,0,60,300,NULL,NULL),(12,'Process Cancellation Requests','process_cancellation_requests','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"processCancellationRequests\"]',NULL,5,'2026-02-25 21:00:06','2026-02-25 20:00:06',1,1,'2025-12-19 15:45:04','2026-02-25 20:00:06','Processes approved immediate and end-of-billing cancellation requests.','services',1,9,0,NULL,NULL,3,NULL,'service_management',3,0,60,300,NULL,NULL),(13,'Retry Failed Module Operations','retry_failed_module_operations','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"retryFailedModuleOperations\"]',NULL,3,'2026-02-25 21:01:05','2026-02-25 20:46:05',1,1,'2025-12-19 15:45:04','2026-02-25 20:46:05','Retries failed provisioning, suspension, and termination operations.','services',1,18,0,NULL,NULL,0,NULL,'maintenance',3,0,60,300,NULL,NULL),(14,'Auto Approve Affiliate Commissions','auto_approve_affiliate_commissions','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"autoApproveAffiliateCommissions\"]',NULL,8,'2026-02-26 19:00:04','2026-02-25 19:00:04',1,1,'2025-12-19 15:45:04','2026-02-25 19:00:04','Auto-approves pending affiliate commissions after the approval period.','affiliate',3,8,0,NULL,NULL,2,NULL,NULL,3,0,60,300,NULL,NULL),(15,'Auto Close Tickets','auto_close_tickets','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"autoCloseTickets\"]',NULL,5,'2026-02-25 21:00:06','2026-02-25 20:00:06',1,1,'2025-12-19 15:45:04','2026-02-25 20:00:06','Automatically closes resolved tickets after configured days of inactivity.','support',2,9,0,NULL,NULL,2,NULL,'support_tickets',3,0,60,300,NULL,NULL),(16,'Ticket Escalation','ticket_escalation','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"ticketEscalation\"]',NULL,3,'2026-02-25 21:01:05','2026-02-25 20:46:05',1,1,'2025-12-19 15:45:04','2026-02-25 20:46:05','Escalates tickets based on SLA breach and priority rules.','support',1,18,0,NULL,NULL,912,NULL,'support_tickets',3,0,60,300,NULL,NULL),(17,'SLA Breach Alert','sla_breach_alert','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"slaBreachAlert\"]',NULL,3,'2026-02-25 21:01:05','2026-02-25 20:46:05',1,1,'2025-12-19 15:45:04','2026-02-25 20:46:05','Sends alerts to admins when tickets are about to breach SLA.','support',1,15,0,NULL,NULL,4,NULL,'support_tickets',3,0,60,300,NULL,NULL),(18,'Stale Ticket Reminder','stale_ticket_reminder','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"staleTicketReminder\"]',NULL,5,'2026-02-22 08:31:46','2026-02-22 07:31:46',1,1,'2025-12-19 15:45:04','2026-02-25 20:53:04','Reminds agents about tickets waiting for response.','support',2,7,0,NULL,NULL,0,NULL,'support_tickets',3,0,60,300,'2026-02-25 20:53:04','cron_699f8b6044b427.51479025'),(19,'Ticket Feedback Request','ticket_feedback_request','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"ticketFeedbackRequest\"]',NULL,8,'2026-02-26 19:00:04','2026-02-25 19:00:04',1,1,'2025-12-19 15:45:04','2026-02-25 19:00:04','Sends satisfaction survey requests after ticket resolution.','support',3,8,0,NULL,NULL,1,NULL,'support_tickets',3,0,60,300,NULL,NULL),(20,'Remove Abandoned Shopping Carts','remove_shopping_carts','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"removeShoppingCarts\"]',NULL,5,'2026-02-25 21:00:06','2026-02-25 20:00:06',1,1,'2025-12-19 15:45:04','2026-02-25 20:00:06','Removes guest shopping carts older than 3 hours.','maintenance',3,10,0,NULL,NULL,1,NULL,'maintenance',3,0,60,300,NULL,NULL),(21,'Domain WHOIS Sync','domain_whois_sync','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"domainWhoisSync\"]',NULL,8,'2026-02-26 19:00:04','2026-02-25 19:00:04',1,1,'2025-12-19 15:45:04','2026-02-25 19:00:04','Syncs domain status and expiry dates from registrars.','maintenance',3,8,0,NULL,NULL,1,NULL,'maintenance',3,0,60,300,NULL,NULL),(22,'Update Exchange Rates','update_exchange_rates','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"updateExchangeRates\"]',NULL,8,'2026-02-26 19:00:05','2026-02-25 19:00:05',1,1,'2025-12-24 04:40:58','2026-02-25 19:00:05','Updates currency exchange rates from external API.','maintenance',3,10,0,NULL,NULL,307,NULL,NULL,3,0,60,300,NULL,NULL),(23,'Backup Database','backup_database','[\"App\\\\Http\\\\Controllers\\\\CronController\",\"backupDatabase\"]',NULL,8,'2026-02-26 19:00:06','2026-02-25 19:00:06',1,1,'2025-12-24 04:40:58','2026-02-25 19:00:06','Backs up the SQL database to storage.','maintenance',3,8,0,NULL,NULL,610,NULL,NULL,3,0,60,300,NULL,NULL);
/*!40000 ALTER TABLE `cron_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cron_schedules`
--

DROP TABLE IF EXISTS `cron_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cron_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `interval` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cron_schedules`
--

LOCK TABLES `cron_schedules` WRITE;
/*!40000 ALTER TABLE `cron_schedules` DISABLE KEYS */;
INSERT INTO `cron_schedules` VALUES (1,'1 Minute',60,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(2,'5 Minutes',300,1,'2025-12-19 15:45:03','2026-02-07 14:50:01'),(3,'15 Minutes',900,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(4,'30 Minutes',1800,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(5,'1 Hour',3600,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(6,'6 Hours',21600,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(7,'12 Hours',43200,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(8,'Daily (24 Hours)',86400,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(9,'Weekly',604800,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(10,'Monthly',2592000,1,'2025-12-19 15:45:03','2025-12-19 15:45:03');
/*!40000 ALTER TABLE `cron_schedules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposits`
--

DROP TABLE IF EXISTS `deposits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `deposits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `invoice_id` int(10) unsigned NOT NULL DEFAULT 0,
  `method_code` int(10) unsigned NOT NULL DEFAULT 0,
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `method_currency` varchar(40) DEFAULT NULL,
  `charge` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `rate` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `final_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `detail` text DEFAULT NULL COMMENT 'JSON payment details',
  `btc_amount` varchar(255) DEFAULT NULL,
  `btc_wallet` varchar(255) DEFAULT NULL,
  `trx` varchar(40) DEFAULT NULL COMMENT 'Transaction ID',
  `success_url` varchar(255) DEFAULT NULL,
  `failed_url` varchar(255) DEFAULT NULL,
  `payment_try` tinyint(4) NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '1=> Complete, 2=> Pending, 3=> Cancelled, 0=> Initiated',
  `from_api` tinyint(1) NOT NULL DEFAULT 0,
  `admin_feedback` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_deposits_user_status` (`user_id`,`status`),
  KEY `idx_deposits_status_created` (`status`,`created_at`),
  KEY `idx_deposits_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposits`
--

LOCK TABLES `deposits` WRITE;
/*!40000 ALTER TABLE `deposits` DISABLE KEYS */;
INSERT INTO `deposits` VALUES (5,9,0,0,103,10.00000000,'TZS',0.00000000,2578.95210000,25789.52100000,NULL,'0','','QMX2UNRZUOFQ','https://demo.salieno.com/client/deposits','https://demo.salieno.com/client/deposits/add',0,0,0,NULL,'2026-02-25 18:24:17','2026-02-25 18:24:17',NULL);
/*!40000 ALTER TABLE `deposits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `device_tokens`
--

DROP TABLE IF EXISTS `device_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `is_app` tinyint(1) NOT NULL DEFAULT 0,
  `token` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `device_tokens`
--

LOCK TABLES `device_tokens` WRITE;
/*!40000 ALTER TABLE `device_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domain_categories`
--

DROP TABLE IF EXISTS `domain_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domain_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `slug` varchar(40) NOT NULL,
  `icon` varchar(40) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `domain_categories_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domain_categories`
--

LOCK TABLES `domain_categories` WRITE;
/*!40000 ALTER TABLE `domain_categories` DISABLE KEYS */;
INSERT INTO `domain_categories` VALUES (9,'Popular','popular','ph-bold ph-star',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(10,'Technology','technology','ph-bold ph-cpu',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(11,'Business','business','ph-bold ph-briefcase',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(12,'Geographic','geographic','ph-bold ph-map-trifold',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(13,'Creative','creative','ph-bold ph-palette',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(14,'Shopping','shopping','ph-bold ph-shopping-cart',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(15,'Media','media','ph-bold ph-film-slate',1,'2026-01-22 11:18:11','2026-01-22 11:27:06'),(16,'Professional','professional','ph-bold ph-graduation-cap',1,'2026-01-22 11:18:11','2026-01-22 11:27:06');
/*!40000 ALTER TABLE `domain_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domain_features`
--

DROP TABLE IF EXISTS `domain_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domain_features` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain_setup_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `is_included` tinyint(1) NOT NULL DEFAULT 1,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `domain_features_domain_setup_id_sort_order_index` (`domain_setup_id`,`sort_order`),
  CONSTRAINT `domain_features_domain_setup_id_foreign` FOREIGN KEY (`domain_setup_id`) REFERENCES `domain_setups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domain_features`
--

LOCK TABLES `domain_features` WRITE;
/*!40000 ALTER TABLE `domain_features` DISABLE KEYS */;
/*!40000 ALTER TABLE `domain_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domain_pricings`
--

DROP TABLE IF EXISTS `domain_pricings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domain_pricings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'domain_setups id',
  `one_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `one_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `one_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `two_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `two_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `two_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `three_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `three_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `three_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `four_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `four_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `four_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `five_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `five_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `five_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `six_year_price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `six_year_id_protection` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `six_year_renew` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=191 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domain_pricings`
--

LOCK TABLES `domain_pricings` WRITE;
/*!40000 ALTER TABLE `domain_pricings` DISABLE KEYS */;
INSERT INTO `domain_pricings` VALUES (6,6,9.9900000000000000,2.9900000000000000,12.9900000000000000,18.9810000000000000,5.9800000000000000,24.6810000000000000,26.9730000000000000,8.9700000000000000,35.0730000000000000,35.1648000000000000,11.9600000000000000,45.7248000000000000,42.4575000000000000,14.9500000000000000,55.2075000000000000,49.1508000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(7,7,12.9900000000000000,2.9900000000000000,14.9900000000000000,24.6810000000000000,5.9800000000000000,28.4810000000000000,35.0730000000000000,8.9700000000000000,40.4730000000000000,45.7248000000000000,11.9600000000000000,52.7648000000000000,55.2075000000000000,14.9500000000000000,63.7075000000000000,63.9108000000000000,17.9400000000000000,73.7508000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(8,8,11.9900000000000000,2.9900000000000000,13.9900000000000000,22.7810000000000000,5.9800000000000000,26.5810000000000000,32.3730000000000000,8.9700000000000000,37.7730000000000000,42.2048000000000000,11.9600000000000000,49.2448000000000000,50.9575000000000000,14.9500000000000000,59.4575000000000000,58.9908000000000000,17.9400000000000000,68.8308000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(9,9,8.9900000000000000,2.9900000000000000,10.9900000000000000,17.0810000000000000,5.9800000000000000,20.8810000000000000,24.2730000000000000,8.9700000000000000,29.6730000000000000,31.6448000000000000,11.9600000000000000,38.6848000000000000,38.2075000000000000,14.9500000000000000,46.7075000000000000,44.2308000000000000,17.9400000000000000,54.0708000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(10,10,10.9900000000000000,2.9900000000000000,12.9900000000000000,20.8810000000000000,5.9800000000000000,24.6810000000000000,29.6730000000000000,8.9700000000000000,35.0730000000000000,38.6848000000000000,11.9600000000000000,45.7248000000000000,46.7075000000000000,14.9500000000000000,55.2075000000000000,54.0708000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(11,11,35.0000000000000000,4.9900000000000000,40.0000000000000000,66.5000000000000000,9.9800000000000000,76.0000000000000000,94.5000000000000000,14.9700000000000000,108.0000000000000000,123.2000000000000000,19.9600000000000000,140.8000000000000000,148.7500000000000000,24.9500000000000000,170.0000000000000000,172.2000000000000000,29.9400000000000000,196.8000000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(13,13,14.9900000000000000,2.9900000000000000,16.9900000000000000,28.4810000000000000,5.9800000000000000,32.2810000000000000,40.4730000000000000,8.9700000000000000,45.8730000000000000,52.7648000000000000,11.9600000000000000,59.8048000000000000,63.7075000000000000,14.9500000000000000,72.2075000000000000,73.7508000000000000,17.9400000000000000,83.5908000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(15,15,18.9900000000000000,3.9900000000000000,21.9900000000000000,36.0810000000000000,7.9800000000000000,41.7810000000000000,51.2730000000000000,11.9700000000000000,59.3730000000000000,66.8448000000000000,15.9600000000000000,77.4048000000000000,80.7075000000000000,19.9500000000000000,93.4575000000000000,93.4308000000000000,23.9400000000000000,108.1908000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(16,16,12.9900000000000000,2.9900000000000000,15.9900000000000000,24.6810000000000000,5.9800000000000000,30.3810000000000000,35.0730000000000000,8.9700000000000000,43.1730000000000000,45.7248000000000000,11.9600000000000000,56.2848000000000000,55.2075000000000000,14.9500000000000000,67.9575000000000000,63.9108000000000000,17.9400000000000000,78.6708000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(21,21,19.9900000000000000,3.9900000000000000,24.9900000000000000,37.9810000000000000,7.9800000000000000,47.4810000000000000,53.9730000000000000,11.9700000000000000,67.4730000000000000,70.3648000000000000,15.9600000000000000,87.9648000000000000,84.9575000000000000,19.9500000000000000,106.2075000000000000,98.3508000000000000,23.9400000000000000,122.9508000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(31,31,8.9900000000000000,0.0000000000000000,10.9900000000000000,17.0810000000000000,0.0000000000000000,20.8810000000000000,24.2730000000000000,0.0000000000000000,29.6730000000000000,31.6448000000000000,0.0000000000000000,38.6848000000000000,38.2075000000000000,0.0000000000000000,46.7075000000000000,44.2308000000000000,0.0000000000000000,54.0708000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(50,50,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(51,51,29.9900000000000000,4.9900000000000000,34.9900000000000000,56.9810000000000000,9.9800000000000000,66.4810000000000000,80.9730000000000000,14.9700000000000000,94.4730000000000000,105.5648000000000000,19.9600000000000000,123.1648000000000000,127.4575000000000000,24.9500000000000000,148.7075000000000000,147.5508000000000000,29.9400000000000000,172.1508000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(52,52,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:20:59','2026-01-22 11:20:59'),(75,6,9.9900000000000000,2.9900000000000000,12.9900000000000000,18.9810000000000000,5.9800000000000000,24.6810000000000000,26.9730000000000000,8.9700000000000000,35.0730000000000000,35.1648000000000000,11.9600000000000000,45.7248000000000000,42.4575000000000000,14.9500000000000000,55.2075000000000000,49.1508000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(76,7,12.9900000000000000,2.9900000000000000,14.9900000000000000,24.6810000000000000,5.9800000000000000,28.4810000000000000,35.0730000000000000,8.9700000000000000,40.4730000000000000,45.7248000000000000,11.9600000000000000,52.7648000000000000,55.2075000000000000,14.9500000000000000,63.7075000000000000,63.9108000000000000,17.9400000000000000,73.7508000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(77,8,11.9900000000000000,2.9900000000000000,13.9900000000000000,22.7810000000000000,5.9800000000000000,26.5810000000000000,32.3730000000000000,8.9700000000000000,37.7730000000000000,42.2048000000000000,11.9600000000000000,49.2448000000000000,50.9575000000000000,14.9500000000000000,59.4575000000000000,58.9908000000000000,17.9400000000000000,68.8308000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(78,9,8.9900000000000000,2.9900000000000000,10.9900000000000000,17.0810000000000000,5.9800000000000000,20.8810000000000000,24.2730000000000000,8.9700000000000000,29.6730000000000000,31.6448000000000000,11.9600000000000000,38.6848000000000000,38.2075000000000000,14.9500000000000000,46.7075000000000000,44.2308000000000000,17.9400000000000000,54.0708000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(79,10,10.9900000000000000,2.9900000000000000,12.9900000000000000,20.8810000000000000,5.9800000000000000,24.6810000000000000,29.6730000000000000,8.9700000000000000,35.0730000000000000,38.6848000000000000,11.9600000000000000,45.7248000000000000,46.7075000000000000,14.9500000000000000,55.2075000000000000,54.0708000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(80,11,35.0000000000000000,4.9900000000000000,40.0000000000000000,66.5000000000000000,9.9800000000000000,76.0000000000000000,94.5000000000000000,14.9700000000000000,108.0000000000000000,123.2000000000000000,19.9600000000000000,140.8000000000000000,148.7500000000000000,24.9500000000000000,170.0000000000000000,172.2000000000000000,29.9400000000000000,196.8000000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(82,13,14.9900000000000000,2.9900000000000000,16.9900000000000000,28.4810000000000000,5.9800000000000000,32.2810000000000000,40.4730000000000000,8.9700000000000000,45.8730000000000000,52.7648000000000000,11.9600000000000000,59.8048000000000000,63.7075000000000000,14.9500000000000000,72.2075000000000000,73.7508000000000000,17.9400000000000000,83.5908000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(84,15,18.9900000000000000,3.9900000000000000,21.9900000000000000,36.0810000000000000,7.9800000000000000,41.7810000000000000,51.2730000000000000,11.9700000000000000,59.3730000000000000,66.8448000000000000,15.9600000000000000,77.4048000000000000,80.7075000000000000,19.9500000000000000,93.4575000000000000,93.4308000000000000,23.9400000000000000,108.1908000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(85,16,12.9900000000000000,2.9900000000000000,15.9900000000000000,24.6810000000000000,5.9800000000000000,30.3810000000000000,35.0730000000000000,8.9700000000000000,43.1730000000000000,45.7248000000000000,11.9600000000000000,56.2848000000000000,55.2075000000000000,14.9500000000000000,67.9575000000000000,63.9108000000000000,17.9400000000000000,78.6708000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(90,21,19.9900000000000000,3.9900000000000000,24.9900000000000000,37.9810000000000000,7.9800000000000000,47.4810000000000000,53.9730000000000000,11.9700000000000000,67.4730000000000000,70.3648000000000000,15.9600000000000000,87.9648000000000000,84.9575000000000000,19.9500000000000000,106.2075000000000000,98.3508000000000000,23.9400000000000000,122.9508000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(100,31,8.9900000000000000,0.0000000000000000,10.9900000000000000,17.0810000000000000,0.0000000000000000,20.8810000000000000,24.2730000000000000,0.0000000000000000,29.6730000000000000,31.6448000000000000,0.0000000000000000,38.6848000000000000,38.2075000000000000,0.0000000000000000,46.7075000000000000,44.2308000000000000,0.0000000000000000,54.0708000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(119,50,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(120,51,29.9900000000000000,4.9900000000000000,34.9900000000000000,56.9810000000000000,9.9800000000000000,66.4810000000000000,80.9730000000000000,14.9700000000000000,94.4730000000000000,105.5648000000000000,19.9600000000000000,123.1648000000000000,127.4575000000000000,24.9500000000000000,148.7075000000000000,147.5508000000000000,29.9400000000000000,172.1508000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(121,52,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:23:38','2026-01-22 11:23:38'),(144,6,9.9900000000000000,2.9900000000000000,12.9900000000000000,18.9810000000000000,5.9800000000000000,24.6810000000000000,26.9730000000000000,8.9700000000000000,35.0730000000000000,35.1648000000000000,11.9600000000000000,45.7248000000000000,42.4575000000000000,14.9500000000000000,55.2075000000000000,49.1508000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(145,7,12.9900000000000000,2.9900000000000000,14.9900000000000000,24.6810000000000000,5.9800000000000000,28.4810000000000000,35.0730000000000000,8.9700000000000000,40.4730000000000000,45.7248000000000000,11.9600000000000000,52.7648000000000000,55.2075000000000000,14.9500000000000000,63.7075000000000000,63.9108000000000000,17.9400000000000000,73.7508000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(146,8,11.9900000000000000,2.9900000000000000,13.9900000000000000,22.7810000000000000,5.9800000000000000,26.5810000000000000,32.3730000000000000,8.9700000000000000,37.7730000000000000,42.2048000000000000,11.9600000000000000,49.2448000000000000,50.9575000000000000,14.9500000000000000,59.4575000000000000,58.9908000000000000,17.9400000000000000,68.8308000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(147,9,8.9900000000000000,2.9900000000000000,10.9900000000000000,17.0810000000000000,5.9800000000000000,20.8810000000000000,24.2730000000000000,8.9700000000000000,29.6730000000000000,31.6448000000000000,11.9600000000000000,38.6848000000000000,38.2075000000000000,14.9500000000000000,46.7075000000000000,44.2308000000000000,17.9400000000000000,54.0708000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(148,10,10.9900000000000000,2.9900000000000000,12.9900000000000000,20.8810000000000000,5.9800000000000000,24.6810000000000000,29.6730000000000000,8.9700000000000000,35.0730000000000000,38.6848000000000000,11.9600000000000000,45.7248000000000000,46.7075000000000000,14.9500000000000000,55.2075000000000000,54.0708000000000000,17.9400000000000000,63.9108000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(149,11,35.0000000000000000,4.9900000000000000,40.0000000000000000,66.5000000000000000,9.9800000000000000,76.0000000000000000,94.5000000000000000,14.9700000000000000,108.0000000000000000,123.2000000000000000,19.9600000000000000,140.8000000000000000,148.7500000000000000,24.9500000000000000,170.0000000000000000,172.2000000000000000,29.9400000000000000,196.8000000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(151,13,14.9900000000000000,2.9900000000000000,16.9900000000000000,28.4810000000000000,5.9800000000000000,32.2810000000000000,40.4730000000000000,8.9700000000000000,45.8730000000000000,52.7648000000000000,11.9600000000000000,59.8048000000000000,63.7075000000000000,14.9500000000000000,72.2075000000000000,73.7508000000000000,17.9400000000000000,83.5908000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(153,15,18.9900000000000000,3.9900000000000000,21.9900000000000000,36.0810000000000000,7.9800000000000000,41.7810000000000000,51.2730000000000000,11.9700000000000000,59.3730000000000000,66.8448000000000000,15.9600000000000000,77.4048000000000000,80.7075000000000000,19.9500000000000000,93.4575000000000000,93.4308000000000000,23.9400000000000000,108.1908000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(154,16,12.9900000000000000,2.9900000000000000,15.9900000000000000,24.6810000000000000,5.9800000000000000,30.3810000000000000,35.0730000000000000,8.9700000000000000,43.1730000000000000,45.7248000000000000,11.9600000000000000,56.2848000000000000,55.2075000000000000,14.9500000000000000,67.9575000000000000,63.9108000000000000,17.9400000000000000,78.6708000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(159,21,19.9900000000000000,3.9900000000000000,24.9900000000000000,37.9810000000000000,7.9800000000000000,47.4810000000000000,53.9730000000000000,11.9700000000000000,67.4730000000000000,70.3648000000000000,15.9600000000000000,87.9648000000000000,84.9575000000000000,19.9500000000000000,106.2075000000000000,98.3508000000000000,23.9400000000000000,122.9508000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(169,31,8.9900000000000000,0.0000000000000000,10.9900000000000000,17.0810000000000000,0.0000000000000000,20.8810000000000000,24.2730000000000000,0.0000000000000000,29.6730000000000000,31.6448000000000000,0.0000000000000000,38.6848000000000000,38.2075000000000000,0.0000000000000000,46.7075000000000000,44.2308000000000000,0.0000000000000000,54.0708000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(188,50,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(189,51,29.9900000000000000,4.9900000000000000,34.9900000000000000,56.9810000000000000,9.9800000000000000,66.4810000000000000,80.9730000000000000,14.9700000000000000,94.4730000000000000,105.5648000000000000,19.9600000000000000,123.1648000000000000,127.4575000000000000,24.9500000000000000,148.7075000000000000,147.5508000000000000,29.9400000000000000,172.1508000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06'),(190,52,19.9900000000000000,3.9900000000000000,23.9900000000000000,37.9810000000000000,7.9800000000000000,45.5810000000000000,53.9730000000000000,11.9700000000000000,64.7730000000000000,70.3648000000000000,15.9600000000000000,84.4448000000000000,84.9575000000000000,19.9500000000000000,101.9575000000000000,98.3508000000000000,23.9400000000000000,118.0308000000000000,'2026-01-22 11:27:06','2026-01-22 11:27:06');
/*!40000 ALTER TABLE `domain_pricings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domain_registers`
--

DROP TABLE IF EXISTS `domain_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domain_registers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `alias` varchar(40) NOT NULL,
  `ns1` varchar(255) DEFAULT NULL,
  `ns2` varchar(255) DEFAULT NULL,
  `ns3` varchar(255) DEFAULT NULL,
  `ns4` varchar(255) DEFAULT NULL,
  `params` text NOT NULL COMMENT 'JSON configuration for API credentials',
  `test_mode` tinyint(1) NOT NULL DEFAULT 0,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `setup_done` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'When the admin did first setup',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domain_registers`
--

LOCK TABLES `domain_registers` WRITE;
/*!40000 ALTER TABLE `domain_registers` DISABLE KEYS */;
INSERT INTO `domain_registers` VALUES (1,'Namecheap','Namecheap','ns1.example.com','ns2.example.com',NULL,NULL,'{\"api_user\":{\"title\":\"API User\",\"value\":\"almirfrances0\"},\"api_key\":{\"title\":\"API Key\",\"value\":\"205afb4c67064175a851bd7bdea0d8d1\"},\"username\":{\"title\":\"Username\",\"value\":\"almirfrances0\"},\"client_ip\":{\"title\":\"Whitelisted IP\",\"value\":\"197.186.2.48\"}}',0,1,1,1,'2025-12-19 15:45:04','2026-01-28 06:52:37'),(2,'ResellerClub','Resell','ns1.example.com','ns2.example.com',NULL,NULL,'\"{\\\"reseller_id\\\":{\\\"title\\\":\\\"Reseller ID\\\",\\\"value\\\":\\\"\\\"},\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"value\\\":\\\"\\\"}}\"',1,0,0,0,'2025-12-19 15:45:04','2026-02-01 19:35:59'),(3,'Enom','Enom','ns1.example.com','ns2.example.com',NULL,NULL,'\"{\\\"uid\\\":{\\\"title\\\":\\\"Username\\\",\\\"value\\\":\\\"\\\"},\\\"pw\\\":{\\\"title\\\":\\\"Password\\\",\\\"value\\\":\\\"\\\"}}\"',1,0,0,0,'2025-12-19 15:45:04','2026-02-01 19:35:57');
/*!40000 ALTER TABLE `domain_registers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domain_setups`
--

DROP TABLE IF EXISTS `domain_setups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domain_setups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) NOT NULL COMMENT 'Extension / TLD like .com, .net',
  `tld` varchar(40) DEFAULT NULL,
  `id_protection` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domain_setups`
--

LOCK TABLES `domain_setups` WRITE;
/*!40000 ALTER TABLE `domain_setups` DISABLE KEYS */;
INSERT INTO `domain_setups` VALUES (6,'.com',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',9),(7,'.net',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',9),(8,'.org',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',9),(9,'.info',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',9),(10,'.biz',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',9),(11,'.io',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',10),(13,'.dev',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',10),(15,'.app',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',10),(16,'.cloud',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',10),(21,'.co',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',11),(31,'.us',NULL,0,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',12),(50,'.shop',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',14),(51,'.store',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',14),(52,'.online',NULL,1,1,0,0,'2026-01-22 11:20:59','2026-01-22 11:20:59',14);
/*!40000 ALTER TABLE `domain_setups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `domains`
--

DROP TABLE IF EXISTS `domains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `domains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0=> Empty invoice/allow creating new, 1=> Already created',
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `order_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_setup_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_register_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain` varchar(255) DEFAULT NULL,
  `first_payment_amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `recurring_amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `discount` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `status` tinyint(4) NOT NULL DEFAULT 2 COMMENT '1=> Active, 2=> Pending, 3=> Suspended, 4=> Terminated, 5=> Cancelled',
  `reg_period` tinyint(4) NOT NULL DEFAULT 1 COMMENT 'Registration period in years',
  `id_protection` tinyint(1) NOT NULL DEFAULT 0,
  `is_locked` tinyint(1) NOT NULL DEFAULT 1,
  `auto_renew` tinyint(1) NOT NULL DEFAULT 0,
  `ns1` varchar(255) DEFAULT NULL,
  `ns2` varchar(255) DEFAULT NULL,
  `ns3` varchar(255) DEFAULT NULL,
  `ns4` varchar(255) DEFAULT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'For admin only',
  `suspend_reason` varchar(255) DEFAULT NULL,
  `termination_date` varchar(40) DEFAULT NULL,
  `suspend_date` varchar(40) DEFAULT NULL,
  `next_due_date` varchar(40) DEFAULT NULL,
  `last_sync_at` timestamp NULL DEFAULT NULL,
  `next_invoice_date` varchar(40) DEFAULT NULL,
  `reg_date` varchar(40) DEFAULT NULL COMMENT 'Registration date',
  `expiry_date` varchar(40) DEFAULT NULL,
  `last_cron` varchar(40) DEFAULT NULL,
  `registrar_order_id` varchar(100) DEFAULT NULL,
  `whois_guard` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` int(11) NOT NULL DEFAULT 1 COMMENT '1: Register, 2: Transfer',
  `epp_code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_domains_status_due_date` (`status`,`next_due_date`),
  KEY `idx_domains_last_cron` (`last_cron`),
  KEY `idx_domains_invoice` (`invoice`),
  KEY `idx_domains_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `domains`
--

LOCK TABLES `domains` WRITE;
/*!40000 ALTER TABLE `domains` DISABLE KEYS */;
/*!40000 ALTER TABLE `domains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `forms`
--

DROP TABLE IF EXISTS `forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `forms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `act` varchar(40) DEFAULT NULL COMMENT 'Action code',
  `form_data` text DEFAULT NULL COMMENT 'JSON form fields',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `forms`
--

LOCK TABLES `forms` WRITE;
/*!40000 ALTER TABLE `forms` DISABLE KEYS */;
INSERT INTO `forms` VALUES (1,'kyc','[{\"name\":\"Full Name\",\"label\":\"full_name\",\"type\":\"text\",\"is_required\":\"required\",\"instruction\":\"\",\"width\":\"6\",\"options\":[],\"extensions\":\"jpg,jpeg,png,pdf\"},{\"name\":\"Upload ID\",\"label\":\"upload_id\",\"type\":\"file\",\"is_required\":\"required\",\"instruction\":\"\",\"width\":\"6\",\"options\":[],\"extensions\":\"jpg,jpeg,png,pdf\"}]','2026-01-19 16:47:15','2026-01-19 16:50:59');
/*!40000 ALTER TABLE `forms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frontends`
--

DROP TABLE IF EXISTS `frontends`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `frontends` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `data_keys` varchar(40) DEFAULT NULL,
  `data_values` text DEFAULT NULL COMMENT 'JSON content data',
  `tempname` varchar(40) DEFAULT NULL COMMENT 'Template name',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `frontends`
--

LOCK TABLES `frontends` WRITE;
/*!40000 ALTER TABLE `frontends` DISABLE KEYS */;
INSERT INTO `frontends` VALUES (1,'service.content','{\"heading\":\"Our Services\",\"subheading\":\"We provide the best hosting solutions for your business\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(2,'domain.content','{\"heading\":\"Find Your Perfect Domain\",\"subheading\":\"Search for your ideal domain name\",\"text\":\"Get started with a domain that represents your brand\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(3,'subscribe.content','{\"heading\":\"Subscribe to Our Newsletter\",\"subheading\":\"Stay updated with our latest offers and news\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(4,'contact_us.content','{\"heading\":\"Get in Touch\",\"description\":\"We are here to help you with any questions\",\"email\":\"support@salieno.com\",\"phone\":\"+1 234 567 890\",\"address\":\"123 Business Street, City, Country\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(5,'invoice_address.content','{\"address\":\"Salieno Inc.\\\\n123 Business Street\\\\nCity, State 12345\\\\nCountry\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(6,'footer.content','{\"description\":\"Navigating the digital frontier with high-velocity infrastructure. We provide the propulsion systems for your next big idea. Join the fleet today.\",\"status_tag_text\":\"Systems Operational\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(7,'kyc.content','{\"kyc_required\":\"Please complete your KYC verification to access all features.\",\"kyc_pending\":\"Your KYC verification is pending review.\",\"kyc_reject\":\"Your KYC verification was rejected. Please resubmit.\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(8,'banned.content','{\"heading\":\"Account Suspended\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(9,'seo.data','{\"keywords\":[\"web hosting\",\"domain registration\",\"cloud hosting\",\"vps\"],\"description\":\"Salieno - Professional web hosting and domain registration services.\",\"social_title\":\"Salieno - Web Hosting & Domains\",\"social_description\":\"Get reliable web hosting and domain registration services.\"}','basic','2025-12-19 15:45:04','2025-12-19 15:45:04'),(10,'cookie.data','{\"status\":1,\"description\":\"We use cookies.\"}','basic','2025-12-20 23:55:17','2025-12-20 23:55:17'),(11,'maintenance.data','{\"description\":\"We are currently under maintenance.\",\"image\":null}','basic','2025-12-20 23:55:17','2026-01-26 23:26:38'),(12,'faq.element','{\"question\":\"How to Login to client area\",\"answer\":\"You should move to Login and click login \"}','basic','2025-12-21 00:02:19','2025-12-21 00:02:19'),(13,'service.content','{\"heading\":\"Our Services\",\"subheading\":\"We provide the best hosting solutions for your business\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(14,'domain.content','{\"heading\":\"Find Your Perfect Domain\",\"subheading\":\"Search for your ideal domain name\",\"text\":\"Get started with a domain that represents your brand\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(15,'subscribe.content','{\"heading\":\"Subscribe to Our Newsletter\",\"subheading\":\"Stay updated with our latest offers and news\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(16,'contact_us.content','{\"heading\":\"Get in Touch\",\"description\":\"We are here to help you with any questions\",\"email\":\"support@salieno.com\",\"phone\":\"+1 234 567 890\",\"address\":\"123 Business Street, City, Country\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(17,'invoice_address.content','{\"address\":\"Salieno Inc.\\\\n123 Business Street\\\\nCity, State 12345\\\\nCountry\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(18,'footer.content','{\"description\":\"Navigating the digital frontier with high-velocity infrastructure. We provide the propulsion systems for your next big idea. Join the fleet today.\",\"status_tag_text\":\"Systems Operational\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(19,'kyc.content','{\"kyc_required\":\"Please complete your KYC verification to access all features.\",\"kyc_pending\":\"Your KYC verification is pending review.\",\"kyc_reject\":\"Your KYC verification was rejected. Please resubmit.\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(20,'banned.content','{\"heading\":\"Account Suspended\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(21,'seo.data','{\"keywords\":[\"web hosting\",\"domain registration\",\"cloud hosting\",\"vps\"],\"description\":\"Salieno - Professional web hosting and domain registration services.\",\"social_title\":\"Salieno - Web Hosting & Domains\",\"social_description\":\"Get reliable web hosting and domain registration services.\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(22,'cookie.data','{\"status\":1,\"description\":\"We use cookies.\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(23,'maintenance.data','{\"heading\":\"Maintenance Mode\",\"description\":\"We are currently under maintenance.\"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(24,'faq.element','{\"question\":\"How to Login to client area\",\"answer\":\"You should move to Login and click login \"}','test_theme_modern','2025-12-21 07:32:19','2025-12-21 07:32:19'),(25,'service.content','{\"heading\":\"Our Services\",\"subheading\":\"We provide the best hosting solutions for your business\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(26,'domain.content','{\"heading\":\"Find Your Perfect Domain\",\"subheading\":\"Search for your ideal domain name\",\"text\":\"Get started with a domain that represents your brand\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(27,'subscribe.content','{\"heading\":\"Subscribe to Our Newsletter\",\"subheading\":\"Stay updated with our latest offers and news\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(28,'contact_us.content','{\"heading\":\"Get in Touch\",\"description\":\"We are here to help you with any questions\",\"email\":\"support@salieno.com\",\"phone\":\"+1 234 567 890\",\"address\":\"123 Business Street, City, Country\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(29,'invoice_address.content','{\"address\":\"Salieno Inc.\\\\n123 Business Street\\\\nCity, State 12345\\\\nCountry\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(30,'footer.content','{\"description\":\"Navigating the digital frontier with high-velocity infrastructure. We provide the propulsion systems for your next big idea. Join the fleet today.\",\"status_tag_text\":\"Systems Operational\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(31,'kyc.content','{\"kyc_required\":\"Please complete your KYC verification to access all features.\",\"kyc_pending\":\"Your KYC verification is pending review.\",\"kyc_reject\":\"Your KYC verification was rejected. Please resubmit.\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(32,'banned.content','{\"heading\":\"Account Suspended\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(33,'seo.data','{\"keywords\":[\"web hosting\",\"domain registration\",\"cloud hosting\",\"vps\"],\"description\":\"Salieno - Professional web hosting and domain registration services.\",\"social_title\":\"Salieno - Web Hosting & Domains\",\"social_description\":\"Get reliable web hosting and domain registration services.\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(34,'cookie.data','{\"status\":1,\"description\":\"We use cookies.\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(35,'maintenance.data','{\"heading\":\"Maintenance Mode\",\"description\":\"We are currently under maintenance.\"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(36,'faq.element','{\"question\":\"How to Login to client area\",\"answer\":\"You should move to Login and click login \"}','origin','2025-12-21 19:39:18','2025-12-21 19:39:18'),(37,'testimonial_section.content','{\"quote\":\"\\\"Hello we had nothing but this app mad us great\\\"\",\"author\":\"Nick Canon\"}','basic','2025-12-22 02:42:43','2025-12-22 02:42:43'),(38,'hero.content','{\"heading\":\"Reliable and Cheap Hosting Solution\",\"subheading\":\"subheading\",\"description\":\"description\",\"image\":\"694876cd575811766356685.jpg\"}','basic','2025-12-22 03:38:05','2025-12-22 04:09:42'),(39,'service.content','{\"heading\":\"Our Services\",\"subheading\":\"We provide the best hosting solutions for your business\",\"lowestPrice\":\"lowest_price)\"}','salieno','2025-12-30 04:45:56','2026-01-21 10:36:28'),(40,'domain.content','{\"heading\":\"Find Your Perfect Domain\",\"subheading\":\"Search for your ideal domain name\",\"text\":\"Get started with a domain that represents your brand\"}','salieno','2025-12-30 04:45:56','2025-12-30 04:45:56'),(41,'subscribe.content','{\"heading\":\"Subscribe to Our Newsletter\",\"subheading\":\"Stay updated with our latest offers and news\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(42,'contact_us.content','{\"heading\":\"Get in Touch\",\"description\":\"We are here to help you with any questions\",\"email\":\"support@salieno.com\",\"phone\":\"+1 234 567 890\",\"address\":\"123 Business Street, City, Country\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(43,'invoice_address.content','{\"address\":\"Salieno Inc.\\\\n123 Business Street\\\\nCity, State 12345\\\\nCountry\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(44,'footer.content','{\"description\":\"Navigating the digital frontier with high-velocity infrastructure. We provide the propulsion systems for your next big idea. Join the fleet today.\",\"status_tag_text\":\"Systems Operational\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(45,'kyc.content','{\"kyc_required\":\"Please complete your KYC verification to access all features.\",\"kyc_pending\":\"Your KYC verification is pending review.\",\"kyc_reject\":\"Your KYC verification was rejected. Please resubmit.\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(46,'banned.content','{\"heading\":\"Account Suspended\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(47,'seo.data','{\"meta_title\":\"Salieno\",\"keywords\":[\"web hosting\",\"domain registration\",\"cloud hosting\",\"vps\"],\"meta_robots\":\"\",\"description\":\"Salieno - Professional web hosting and domain registration services.\",\"social_title\":\"Salieno - Web Hosting & Domains\",\"social_description\":\"Get reliable web hosting and domain registration services.\"}','salieno','2025-12-30 04:45:57','2026-02-20 23:57:22'),(48,'cookie.data','{\"status\":1,\"description\":\"We use cookies.\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(49,'maintenance.data','{\"heading\":\"Maintenance Mode\",\"description\":\"We are currently under maintenance.\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(50,'faq.element','{\"question\":\"What\'s the difference between WordPress hosting and shared hosting?\",\"answer\":\"While any hosting plan can run WordPress, the server environment is specifically optimized for WordPress. This means you can enjoy faster page times, a higher level of protection against WordPress-specific threats, and other features such as automatic WordPress updates or WordPress staging.\",\"pages\":[\"about\",\"shared-hosting\"]}','salieno','2025-12-30 04:45:57','2026-02-08 13:44:47'),(51,'testimonial_section.content','{\"quote\":\"\\\"Hello we had nothing but this app mad us great\\\"\",\"author\":\"Nick Canon\"}','salieno','2025-12-30 04:45:57','2025-12-30 04:45:57'),(52,'hero.content','{\"promo_bar_badge\":\"New Year Sale!\",\"promo_bar_text\":\"Save Up to 81% + Get 2 Bonus Months Free\",\"heading\":\"<span class=\\\"text-transparent bg-clip-text bg-gradient-to-r from-indigo-500 via-indigo-400 to-orange-400\\\">Cheap Hosting<\\/span> Solution\",\"description\":\"Premium hosting infrastructure designed for speed, security and reliability. Deploy your applications on our high-frequency NVMe servers today.\",\"feature_1\":\"24\\/7 real human support \\u2014 no AI chatbots\",\"feature_2\":\"Free domain included\",\"feature_3\":\"Easy migration, done for you\",\"offer_text\":\"New Year offer: $2.49\\/mo + 2 extra months!\",\"primary_button_text\":\"View Plans\",\"primary_button_link\":\"\\/pricing\",\"guarantee_text\":\"45-day Money-back guarantee\",\"link\":\"https:\\/\\/grainy-gradients.vercel.app\\/noise.svg\"}','salieno','2025-12-30 04:45:57','2026-01-21 14:26:37'),(53,'test_scanner.content','{\"thisIsAMuchLongerParagraphThat\":\"This is a much longer paragraph that should ideally be detected as a textarea because it exceeds the 100 character threshold that I implemented in the scanner service. It contains multiple sentences and provides more context than a simple label or title would.\"}','salieno','2026-01-21 10:35:55','2026-01-21 10:35:55'),(54,'categories.content','{\"heading\":\"Hosting Plans for <span class=\\\"text-primary-600 \\\">Every Website<\\/span>\",\"subheading\":\"From budget-friendly shared hosting to powerful virtual private servers, there\'s a solution for your website.\\n\",\"take4AsCategory\":\"4\"}','salieno','2026-01-21 10:36:51','2026-02-15 16:01:35'),(55,'blog.content','{\"image\":\"image)\"}','salieno','2026-01-21 10:40:26','2026-01-21 10:40:26'),(56,'why_choose_us.content','{\"main_heading\":\"Why salieno?\",\"tab_1_title\":\"24\\/7 Award-winning Support\",\"tab_2_title\":\"Worldwide Server Locations\",\"content_heading\":\"Get struggle-free support when you need it\",\"content_description\":\"With over 20+ years of experience in hosting, our team is here to help 24 hours a day.\",\"feature_1_title\":\"Support that cares\",\"feature_1_desc\":\"Our skilled and friendly support team will solve even the most complex technical issues that the other guys can\'t.\",\"feature_2_title\":\"Get Your Issue Solved Fast\",\"feature_2_desc\":\"Forget the back and forth of dealing with support. Our team will solve your issue the first time around so you can get back to work fast.\",\"feature_3_title\":\"Forget About Wait Times\",\"feature_3_desc\":\"With instant live chat and first reply times of 10 minutes for tickets, you won\'t have to wait long for answers or help.\",\"link_text\":\"Learn More\",\"link\":\"#\"}','salieno','2026-01-21 14:48:06','2026-01-21 14:48:06'),(57,'migration.content','{\"heading\":\"Migrate Your Website From Any Web Host\",\"description\":\"Migrating your website is easier than you think. Save time and money by taking advantage of salieno\'s free and fast migration service. Kick back with a cold one, and let us do the work. It will take less than an hour with zero downtime.\",\"step_1_title\":\"Sign up\",\"step_1_desc\":\"Head to our Plans & Pricing and choose the hosting plan that suits your needs.\",\"step_2_title\":\"Submit migration request\",\"step_2_desc\":\"Log into your account and submit your free migration request.\",\"step_3_title\":\"Migration ongoing\",\"step_3_desc\":\"From there, one of our Migration experts will move your site(s) to us.\",\"step_4_title\":\"Migration complete\",\"step_4_desc\":\"That\'s it, your site(s) will be migrated right away!\"}','salieno','2026-01-21 15:10:59','2026-01-21 15:13:45'),(58,'testimonials.content','{\"heading\":\"Trusted by the Owners of 150,000+ Websites\",\"subheading\":\"Check out what these customers have to say about us on Twitter\"}','salieno','2026-01-21 15:22:27','2026-01-21 15:22:27'),(62,'testimonials.element','{\"name\":\"Swathi Chakravarthy\",\"designation\":\"@swathichak\",\"quote\":\"The customer service at @salieno is the best I\'ve experienced. They have been invariably responsive, patient, and helpful.\",\"image\":\"https:\\/\\/i.pravatar.cc\\/150?u=swathichak\",\"link\":\"https:\\/\\/twitter.com\\/swathichak\"}','salieno','2026-01-21 15:23:26','2026-01-21 15:23:26'),(63,'testimonials.element','{\"name\":\"Michael Ross\",\"designation\":\"@mikeross_dev\",\"quote\":\"Switching to @salieno was the best decision for my fleet of apps. Low latency and rock solid uptime.\",\"image\":\"https:\\/\\/i.pravatar.cc\\/150?u=mikeross_dev\",\"link\":\"https:\\/\\/twitter.com\\/mikeross_dev\"}','salieno','2026-01-21 15:23:26','2026-01-21 15:23:26'),(64,'testimonials.element','{\"name\":\"Sarah Jenkins\",\"designation\":\"@sarahj_web\",\"quote\":\"Free migration and literally 15 mins to get my shop online. The support team is legendary.\",\"image\":\"https:\\/\\/i.pravatar.cc\\/150?u=sarahj\",\"link\":\"https:\\/\\/twitter.com\\/sarahj_web\"}','salieno','2026-01-21 15:23:26','2026-01-21 15:23:26'),(65,'reasons.content','{\"heading\":\"Need Even More Reasons To Choose salieno?\",\"subheading\":\"You\'ll get a free domain name, along with the best hosting and customer service. Every hosting plan we offer also comes with a money-back guarantee and an uptime guarantee.\"}','salieno','2026-01-21 15:39:44','2026-01-21 15:39:44'),(90,'reasons.element','{\"title\":\"45 Days Money-Back Guarantee\",\"description\":\"If you\'re not completely happy within your first 45 days with us, we\'ll refund your money: no hassle, no questions, no worry.\",\"icon\":\"ph-bold ph-hand-coins\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(91,'reasons.element','{\"title\":\"Easy to Use Hosting\",\"description\":\"Web hosting should be easy to use. Log in to your account, and you\'ll see just how easy it is to get started with many cPanel tools just a click away.\",\"icon\":\"ph-bold ph-cursor-click\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(92,'reasons.element','{\"title\":\"99.99% Uptime Guarantee\",\"description\":\"Uptime is a lot better than downtime. That\'s why you\'ll never have to worry about your website going down again with our 99.99% uptime guarantee.\",\"icon\":\"ph-bold ph-cloud-arrow-up\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(93,'reasons.element','{\"title\":\"Free SSL Certificate\",\"description\":\"Keep your data encrypted, secure, and out of the hands of bad guys. All of our web hosting plans come with a free Let\'s Encrypt SSL certificate.\",\"icon\":\"ph-bold ph-shield-check\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(94,'reasons.element','{\"title\":\"Free Domain\",\"description\":\"Get your first year of domain registration on us when you choose 36-month billing cycle plans. This offer covers the most popular domain extensions.\",\"icon\":\"ph-bold ph-globe\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(95,'reasons.element','{\"title\":\"Reliable Cloud Platform\",\"description\":\"Rest assured that our cloud hosting infrastructure will ensure your information and data is always safely hosted in the cloud against any failure.\",\"icon\":\"ph-bold ph-hard-drives\"}','salieno','2026-01-21 15:57:49','2026-01-21 15:57:49'),(96,'bottom_cta.content','{\"heading\":\"Get Worry-Free Web Hosting Today!\",\"chat_text\":\"Chat with an Expert\",\"chat_link\":\"#\",\"button_text\":\"Get Started\",\"button_link\":\"#\"}','salieno','2026-01-21 16:05:35','2026-01-21 16:05:35'),(97,'comparison.content','{\"heading\":\"Cloud Hosting <span class=\\\"ext-transparent bg-clip-text bg-gradient-to-r from-indigo-400 to-orange-400 \\\"> Plans & Pricing\",\"subheading\":\"Find the perfect match for your needs. Compare features side-by-side.\"}','salieno','2026-01-21 23:46:27','2026-01-23 13:29:46'),(98,'domain_table.content','\"{\\\"heading\\\":\\\"Explore the Possibilities from Our TLD List\\\",\\\"subheading\\\":\\\"Find the perfect domain extension for your website. Compare prices, features, and availability across all our supported TLDs.\\\"}\"',NULL,'2026-01-22 11:31:39','2026-01-22 11:31:39'),(99,'category_detail_1.content','{\"custom_heading\":\"Shareddddd\",\"custom_subheading\":\"\",\"show_products\":\"\",\"cta_text\":\"\",\"cta_url\":\"\"}','salieno','2026-01-23 14:18:04','2026-01-23 14:18:04'),(102,'payment_methods.element','{\"name\":\"Visa\",\"icon\":\"https:\\/\\/upload.wikimedia.org\\/wikipedia\\/commons\\/0\\/04\\/Visa.svg\"}','salieno','2026-01-23 17:07:59','2026-01-23 17:39:38'),(103,'payment_methods.element','{\"name\":\"American Express\",\"icon\":\"https:\\/\\/upload.wikimedia.org\\/wikipedia\\/commons\\/3\\/30\\/American_Express_logo.svg\"}','salieno','2026-01-23 17:07:59','2026-01-23 17:39:38'),(104,'payment_methods.element','{\"name\":\"Mastercard\",\"icon\":\"https:\\/\\/upload.wikimedia.org\\/wikipedia\\/commons\\/2\\/2a\\/Mastercard-logo.svg\"}','salieno','2026-01-23 17:07:59','2026-01-23 17:39:38'),(105,'payment_methods.element','{\"name\":\"PayPal\",\"icon\":\"https:\\/\\/upload.wikimedia.org\\/wikipedia\\/commons\\/b\\/b5\\/PayPal.svg\"}','salieno','2026-01-23 17:07:59','2026-01-23 17:39:38'),(106,'branding.content','{\"show_icon\":\"no\"}','salieno','2026-01-23 19:26:27','2026-01-23 19:33:08'),(107,'reseller_hosting_salieno.content','{\"heading_start\":\"Automate Your Reseller Hosting\",\"heading_end\":\"Business with Salieno\",\"screenshot_1\":\"https:\\/\\/placehold.co\\/600x400?text=Salieno+Dashboard+1\",\"screenshot_2\":\"https:\\/\\/placehold.co\\/600x400?text=Salieno+Dashboard+2\",\"screenshot_3\":\"https:\\/\\/placehold.co\\/600x400?text=Salieno+Dashboard+3\",\"screenshot_4\":\"https:\\/\\/placehold.co\\/600x400?text=Salieno+Dashboard+4\",\"button_text\":\"Explore Salieno Demo\",\"button_url\":\"#\"}','salieno','2026-01-27 18:30:53','2026-02-08 13:59:32'),(108,'dedicated_banner.content','{\"promo_badge\":\"Best Dedcated Servers on Market\",\"heading\":\"Managed\",\"heading_gradient\":\"Dedicated Servers\",\"subheading\":\"Our managed Dedicated Servers eliminates troubleshooting and server management worries and lets you focus on what matters most: growing your business!\",\"promo_text\":\"Get <strong>one month free<\\/strong> on 12-month plans.\",\"button_text\":\"View Plans & Pricing\",\"button_url\":\"#pricing\",\"starts_at_text\":\"Starts at only\",\"price_value\":\"\",\"price_suffix\":\"\\/mo\",\"trust_text\":\"7-Day Money Back Guarantee\",\"bg_style\":\"\",\"accent_color\":\"\",\"illustration_type\":\"\",\"image_url\":\"\",\"show_pricing\":\"\"}','salieno','2026-02-01 17:09:08','2026-02-01 17:18:20'),(109,'shared_hosting_banner.content','{\"enabled\":true,\"promo_badge\":\"Reseller Hosting Elite\",\"heading\":\"Start Your Own Hosting\",\"heading_gradient\":\"Business Today\",\"subheading\":\"Premium white-label hosting solutions that empower you to sell hosting, manage your own clients, and grow your brand with ease.\",\"button_text\":\"View Reseller Plans\",\"button_url\":\"\\/products\\/category\\/reseller\",\"starts_at_text\":\"Starts at only\",\"price_value\":\"19.99\",\"price_suffix\":\"\\/mo\",\"trust_text\":\"100% White-Label & Private Nameservers\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(111,'shared_hosting_features.content','{\"enabled\":true,\"title\":\"Shared Hosting Features\",\"subtitle\":\"Everything you need to build and grow your website\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(112,'reseller_hosting_banner.content','{\"enabled\":true,\"promo_badge\":\"Reseller Hosting Elite\",\"heading\":\"Start Your Own Hosting\",\"heading_gradient\":\"Business Today\",\"subheading\":\"Premium white-label hosting solutions that empower you to sell hosting, manage your own clients, and grow your brand with ease.\",\"button_text\":\"View Reseller Plans\",\"button_url\":\"\\/products\\/category\\/reseller\",\"starts_at_text\":\"Starts at only\",\"price_value\":\"19.99\",\"price_suffix\":\"\\/mo\",\"trust_text\":\"100% White-Label & Private Nameservers\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(113,'reseller_hosting_features.content','{\"heading\":\"Reseller Hosting Features Designed for Growth\",\"platform_heading\":\"Your business, Our Powerful Hosting Platform\",\"platform_description\":\"Build and grow your own web hosting brand with complete control while we manage the infrastructure behind the scenes. You focus on growing your business \\u2014 we\\u2019ll take care of the servers, performance, and 24\\/7 expert support that keep everything running smoothly.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(114,'reseller_hosting_features.element','{\"icon\":\"ph-pencil-line\",\"title\":\"Keep your brand front and center\",\"description\":\"Offer hosting under your own brand with full white-label control while we handle the server management behind the scenes.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(115,'reseller_hosting_features.element','{\"icon\":\"ph-stack\",\"title\":\"Automate your business operations\",\"description\":\"Manage billing, provisioning, and renewals automatically with Salieno or Blesta included in every plan.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(116,'reseller_hosting_features.element','{\"icon\":\"ph-bookmarks\",\"title\":\"Deliver fast, reliable performance\",\"description\":\"LiteSpeed servers and NVMe storage ensure your clients\\u2019 websites load faster, stay secure, and perform consistently.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(117,'reseller_hosting_features.element','{\"icon\":\"ph-cloud\",\"title\":\"Built on cloud infrastructure\",\"description\":\"Our high-availability cloud servers provide enterprise-grade stability, scalability, and uptime for every reseller plan.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(118,'reseller_hosting_features.element','{\"icon\":\"ph-gear-six\",\"title\":\"Manage WordPress with ease\",\"description\":\"Use WordPress Toolkit in WHM to install, update, and manage all your clients\\u2019 sites from one dashboard.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(119,'reseller_hosting_features.element','{\"icon\":\"ph-envelope-simple\",\"title\":\"Protect your brand and emails\",\"description\":\"Private nameservers and MailChannels relay keep your brand invisible and ensure reliable email delivery for your clients.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(120,'reasons_for_reseller.content','{\"heading\":\"Why Resellers Trust Salieno\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(121,'reseller_hosting_setup.content','{\"heading\":\"Start Your Reseller Hosting Business in Minutes \\u2014 No Technical Skills Required\",\"subheading\":\"Get your reseller hosting business up and running fast with our fully managed cloud platform. There\\u2019s no need for server setup or coding \\u2014 just choose your plan, install Salieno or Blesta with one click, and start managing clients instantly. We\\u2019ll handle the infrastructure, performance, and 24\\/7 expert support while you focus on growth.\",\"button_text\":\"Get Started\",\"button_url\":\"\\/pricing\"}','salieno','2026-02-01 17:14:37','2026-02-08 13:57:44'),(122,'reseller_hosting_setup.element','{\"number\":\"01\",\"title\":\"Purchase Your Reseller Account\",\"description\":\"Choose the hosting plan that fits your business needs and get access to our secure reseller platform.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(123,'reseller_hosting_setup.element','{\"number\":\"02\",\"title\":\"Install Salieno or Blesta\",\"description\":\"Set up your billing and automation system in one click. We\\u2019ll guide you through every step of the process.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(124,'reseller_hosting_setup.element','{\"number\":\"03\",\"title\":\"Configure Your Business Details\",\"description\":\"Add your brand name, pricing, and client settings \\u2014 all through an easy-to-use interface.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(125,'reseller_hosting_setup.element','{\"number\":\"04\",\"title\":\"Start Reselling\",\"description\":\"That\\u2019s it! Your hosting business is live and ready to grow \\u2014 with Salieno powering everything behind the scenes.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(126,'reseller_hosting_salieno.element','{\"icon\":\"ph-cursor-click\",\"title\":\"1-Click Setup\",\"description\":\"Get started instantly with 1-click installation via Softaculous in cPanel. No manual setup, no coding \\u2014 just install and start automating.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(127,'reseller_hosting_salieno.element','{\"icon\":\"ph-clock\",\"title\":\"Complete Automation\",\"description\":\"Salieno manages billing, invoices, renewals, and client communications automatically. Spend less time on admin work and more on growth.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(128,'reseller_hosting_salieno.element','{\"icon\":\"ph-gear\",\"title\":\"Save Time & Money\",\"description\":\"Automation means fewer repetitive tasks and lower operational costs. Scale your reseller business efficiently without hiring extra staff.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(129,'reseller_hosting_salieno.element','{\"icon\":\"ph-smiley\",\"title\":\"User-Friendly for Every Skill Level\",\"description\":\"Even if you\'re new to reselling, Salieno makes management simple. Its intuitive dashboard helps you monitor accounts, sales, and performance.\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(130,'why_choose_vps_hosting.content','{\"enabled\":true,\"title\":\"Why Choose VPS Hosting From :site_name?\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(131,'vps_addons.content','{\"enabled\":true,\"title\":\"Take Your VPS Hosting to a Whole New Level\",\"subtitle\":\"With various options available, you can easily find an add-on that fits your needs and supercharges your account.\",\"button_text\":\"View All Add-ons\",\"button_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(132,'vps_addons.element','{\"id\":\"cloudlinux\",\"title\":\"CloudLinux OS Pro\",\"icon\":\"ph-bold ph-cloud\",\"description\":\"All our VPS Hosting plans come by default with AlmaLinux v8 as the operating system. If you want to take your operating system to a whole new level, CloudLinux is the perfect solution.\",\"link_text\":\"Learn More\",\"link_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(133,'vps_addons.element','{\"id\":\"litespeed\",\"title\":\"LiteSpeed Web Server License\",\"icon\":\"ph-bold ph-lightning\",\"description\":\"Replace Apache with LiteSpeed to increase performance and security. LiteSpeed is up to 6 times faster than Apache and supports HTTP\\/3.\",\"link_text\":\"Learn More\",\"link_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(134,'vps_addons.element','{\"id\":\"imunify360\",\"title\":\"Imunify360 Server Security\",\"icon\":\"ph-bold ph-shield-check\",\"description\":\"Advanced automated security solution for Linux servers. It includes a firewall, malware scanner, and proactive defense.\",\"link_text\":\"Learn More\",\"link_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(135,'vps_addons.element','{\"id\":\"jetbackup\",\"title\":\"Cloud Remote Backup\",\"icon\":\"ph-bold ph-cloud-arrow-up\",\"description\":\"Reliable remote backup solution to keep your data safe. Restore files, databases, and emails with ease.\",\"link_text\":\"Learn More\",\"link_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(136,'vps_addons.element','{\"id\":\"cpanel\",\"title\":\"cPanel License\",\"icon\":\"ph-bold ph-layout\",\"description\":\"The industry standard control panel. Manage your website, email, and files with a user-friendly interface.\",\"link_text\":\"Learn More\",\"link_url\":\"#\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(137,'vps_comparison.content','{\"enabled\":true,\"title\":\"Save up to $188.99 Per Month +\",\"subtitle\":\"Precious time by taking advantage of :site_name\'s Managed VPS Hosting\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:14:37'),(138,'vps_banner.content','{\"promo_badge\":\"VPS Hosting Live\",\"heading\":\"Managed\",\"heading_gradient\":\"VPS Hosting\",\"subheading\":\"Our managed VPS Hosting solution eliminates troubleshooting and server management worries and lets you focus on what matters most: growing your business!\",\"promo_text\":\"Get <strong>one month free<\\/strong> on 12-month plans.\",\"button_text\":\"View Plans & Pricing\",\"button_url\":\"#pricing\",\"starts_at_text\":\"Starts at only\",\"price_value\":\"\",\"price_suffix\":\"\\/mo\",\"trust_text\":\"7-Day Money Back Guarantee\",\"bg_style\":\"\",\"accent_color\":\"\",\"illustration_type\":\"\",\"image_url\":\"\",\"show_pricing\":\"\"}','salieno','2026-02-01 17:14:37','2026-02-01 17:18:16'),(141,'wordpress_banner.content','{\"promo_badge\":\"Wordpress Hosting\",\"heading\":\"Start Your Own Hosting\",\"heading_gradient\":\"Business Today\",\"subheading\":\"Premium white-label hosting solutions that empower you to sell hosting, manage your own clients, and grow your brand with ease.\",\"button_text\":\"View Reseller Plans\",\"button_url\":\"\\/products\\/category\\/reseller\",\"starts_at_text\":\"Starts at only\",\"price_value\":\"19.99\",\"price_suffix\":\"\\/mo\",\"trust_text\":\"100% White-Label & Private Nameservers\",\"bg_style\":\"\",\"accent_color\":\"\",\"illustration_type\":\"\",\"image_url\":\"\",\"show_pricing\":\"\"}','salieno','2026-02-01 20:11:23','2026-02-01 20:11:43'),(142,'faq.element','{\"question\":\"What is Shared Hosting?\",\"answer\":\"Shared web hosting is the most affordable and common option for hosting because it allows multiple websites to use the resources of a single server.\",\"pages\":[\"shared-hosting\"]}','salieno','2026-02-08 13:10:49','2026-02-08 13:43:57'),(143,'faq.element','{\"question\":\"What is cPanel for hosting?\",\"answer\":\"cPanel is the industry\\u2019s control panel that allows you to manage your domains, organize your files, publish websites, create email accounts, and much more. cPanel is one of the most popular control panels because it simplifies website and server management.\",\"pages\":[\"shared-hosting\"]}','salieno','2026-02-08 13:46:48','2026-02-08 13:46:48'),(144,'faq.element','{\"question\":\"What is reseller hosting?\",\"answer\":\"Reseller hosting lets you start your own web hosting business by selling hosting services under your own brand. With ChemiCloud, you manage your clients through WHM and cPanel, while we handle the servers, uptime, and infrastructure behind the scenes.\",\"pages\":[\"reseller-hosting\"]}','salieno','2026-02-08 14:01:18','2026-02-08 14:01:18'),(145,'faq.element','{\"question\":\"How does reseller hosting work?\",\"answer\":\"You purchase a reseller plan that includes disk space, bandwidth, and client accounts. You then create individual hosting packages for your customers and set your own prices. ChemiCloud takes care of server maintenance, security, and performance so you can focus on growing your business.\",\"pages\":[\"reseller-hosting\"]}','salieno','2026-02-08 14:02:12','2026-02-08 14:02:12'),(146,'faq.element','{\"question\":\"How do I make money with reseller hosting?\",\"answer\":\"You earn profit by charging your clients more than your reseller plan costs. For example, you might pay $25\\/month for your plan and sell 10 accounts at $10 each \\u2014 that\'s $100 in revenue with minimal overhead. Because you control pricing, your income scales as your client base grows.\",\"pages\":[\"reseller-hosting\"]}','salieno','2026-02-08 14:02:49','2026-02-08 14:02:49');
/*!40000 ALTER TABLE `frontends` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gateway_currencies`
--

DROP TABLE IF EXISTS `gateway_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gateway_currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `currency` varchar(40) DEFAULT NULL,
  `symbol` varchar(40) DEFAULT NULL,
  `method_code` int(10) unsigned NOT NULL DEFAULT 0,
  `gateway_alias` varchar(40) DEFAULT NULL,
  `min_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `max_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `percent_charge` decimal(5,2) NOT NULL DEFAULT 0.00,
  `fixed_charge` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `rate` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `image` varchar(255) DEFAULT NULL,
  `gateway_parameter` text DEFAULT NULL COMMENT 'JSON configuration',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gateway_currencies`
--

LOCK TABLES `gateway_currencies` WRITE;
/*!40000 ALTER TABLE `gateway_currencies` DISABLE KEYS */;
INSERT INTO `gateway_currencies` VALUES (1,'Bank Transfer USD','USD','$',1000,'BankTransfer',1.00000000,10000.00000000,0.00,0.00000000,1.00000000,NULL,'\"{\\\"bank_name\\\":{\\\"title\\\":\\\"Bank Name\\\",\\\"value\\\":\\\"Demo Bank\\\"},\\\"account_name\\\":{\\\"title\\\":\\\"Account Name\\\",\\\"value\\\":\\\"Salieno Inc.\\\"},\\\"account_number\\\":{\\\"title\\\":\\\"Account Number\\\",\\\"value\\\":\\\"1234567890\\\"},\\\"routing_number\\\":{\\\"title\\\":\\\"Routing Number\\\",\\\"value\\\":\\\"021000021\\\"},\\\"swift_code\\\":{\\\"title\\\":\\\"SWIFT Code\\\",\\\"value\\\":\\\"DEMOBANK\\\"}}\"','2025-12-19 15:45:04','2026-02-22 07:31:48'),(5,'Stripe Hosted@TZS','TZS','TZS',103,'Stripe',1.00000000,10000.00000000,0.00,0.00000000,2554.38090000,NULL,'\"{\\\"secret_key\\\":\\\"\\\",\\\"publishable_key\\\":\\\"\\\",\\\"webhook_secret\\\":\\\"\\\",\\\"stripe_public_key\\\":\\\"pk_live_51S1NANDBTxE400kWXkVILwv2M2pKDSrkgTg6uaiuZHVV7HfA5INVaXggb1Vzvr1dkGi2sfDLbHWEkXIzW0zMDllO001y9UKzCo\\\",\\\"stripe_secret_key\\\":\\\"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\\\",\\\"stripe_webhook_secret\\\":\\\"whsec_uBII73cDycAdCOqKNgt4lTwZFAVrgU9V\\\",\\\"sandbox\\\":\\\"live\\\"}\"','2026-01-28 20:17:05','2026-02-25 19:00:05'),(6,'Stripe Hosted@USD','USD','$',103,'Stripe',1.00000000,10000.00000000,0.00,0.00000000,1.00000000,NULL,'\"{\\\"secret_key\\\":\\\"\\\",\\\"publishable_key\\\":\\\"\\\",\\\"webhook_secret\\\":\\\"\\\",\\\"stripe_public_key\\\":\\\"pk_live_51S1NANDBTxE400kWXkVILwv2M2pKDSrkgTg6uaiuZHVV7HfA5INVaXggb1Vzvr1dkGi2sfDLbHWEkXIzW0zMDllO001y9UKzCo\\\",\\\"stripe_secret_key\\\":\\\"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\\\",\\\"stripe_webhook_secret\\\":\\\"whsec_uBII73cDycAdCOqKNgt4lTwZFAVrgU9V\\\",\\\"sandbox\\\":\\\"live\\\"}\"','2026-01-29 13:08:05','2026-02-22 07:31:48'),(7,'Authorize.net USD','USD','$',120,'Authorize',1.00000000,10000.00000000,0.00,0.00000000,1.00000000,NULL,'\"{\\\"login_id\\\":\\\"\\\",\\\"transaction_key\\\":\\\"\\\",\\\"sandbox\\\":\\\"sandbox\\\"}\"','2026-01-30 21:01:24','2026-02-22 07:31:48'),(8,'NMI AED','AED','AED',121,'NMI',1.00000000,10000.00000000,0.00,0.00000000,3.67250000,NULL,'\"{\\\"api_key\\\":\\\"\\\"}\"','2026-01-30 22:17:18','2026-02-22 07:31:48');
/*!40000 ALTER TABLE `gateway_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gateways`
--

DROP TABLE IF EXISTS `gateways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gateways` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(10) unsigned NOT NULL DEFAULT 0,
  `code` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(40) DEFAULT NULL,
  `alias` varchar(40) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `image` varchar(255) DEFAULT NULL,
  `gateway_parameters` text DEFAULT NULL COMMENT 'JSON configuration for API credentials',
  `supported_currencies` text DEFAULT NULL COMMENT 'JSON array of supported currencies',
  `crypto` text DEFAULT NULL COMMENT '1=> crypto, 2=> fiat',
  `extra` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gateways`
--

LOCK TABLES `gateways` WRITE;
/*!40000 ALTER TABLE `gateways` DISABLE KEYS */;
INSERT INTO `gateways` VALUES (1,0,101,'PayPal','Paypal',0,'697ce4de470451769792734.png','\"{\\\"clientId\\\":{\\\"title\\\":\\\"Client ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"clientSecret\\\":{\\\"title\\\":\\\"Client Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"INR\\\":\\\"INR\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"THB\\\":\\\"THB\\\",\\\"USD\\\":\\\"$\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:39:35'),(2,0,102,'Perfect Money','PerfectMoney',0,'697ce545124251769792837.png','\"{\\\"passphrase\\\":{\\\"title\\\":\\\"Alternate Passphrase\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"wallet_id\\\":{\\\"title\\\":\\\"PM Wallet ID\\\",\\\"global\\\":false,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:46:22'),(3,0,103,'Stripe Hosted','Stripe',1,'697ce482b98681769792642.png','\"{\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"publishable_key\\\":{\\\"title\\\":\\\"Publishable Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"webhook_secret\\\":{\\\"title\\\":\\\"Webhook Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"live\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"INR\\\":\\\"INR\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-07 14:55:05'),(4,0,104,'Skrill','Skrill',0,'697ce49ddb2111769792669.png','\"{\\\"pay_to_email\\\":{\\\"title\\\":\\\"Skrill Email\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AED\\\":\\\"AED\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BGN\\\":\\\"BGN\\\",\\\"BHD\\\":\\\"BHD\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HRK\\\":\\\"HRK\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"INR\\\":\\\"INR\\\",\\\"ISK\\\":\\\"ISK\\\",\\\"JOD\\\":\\\"JOD\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"KWD\\\":\\\"KWD\\\",\\\"MAD\\\":\\\"MAD\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"OMR\\\":\\\"OMR\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"QAR\\\":\\\"QAR\\\",\\\"RON\\\":\\\"RON\\\",\\\"RSD\\\":\\\"RSD\\\",\\\"SAR\\\":\\\"SAR\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"THB\\\":\\\"THB\\\",\\\"TND\\\":\\\"TND\\\",\\\"TRY\\\":\\\"TRY\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"USD\\\":\\\"USD\\\",\\\"ZAR\\\":\\\"ZAR\\\",\\\"COP\\\":\\\"COP\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:49:10'),(5,0,105,'PayTM','Paytm',0,'697ce50899ab81769792776.png','\"{\\\"MID\\\":{\\\"title\\\":\\\"Merchant ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"merchant_key\\\":{\\\"title\\\":\\\"Merchant Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"WEBSITE\\\":{\\\"title\\\":\\\"Paytm Website\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"INDUSTRY_TYPE_ID\\\":{\\\"title\\\":\\\"Industry Type\\\",\\\"global\\\":true,\\\"value\\\":\\\"Retail\\\"},\\\"CHANNEL_ID\\\":{\\\"title\\\":\\\"Channel ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"WEB\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AUD\\\":\\\"AUD\\\",\\\"ARS\\\":\\\"ARS\\\",\\\"BDT\\\":\\\"BDT\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"BGN\\\":\\\"BGN\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CLP\\\":\\\"CLP\\\",\\\"CNY\\\":\\\"CNY\\\",\\\"COP\\\":\\\"COP\\\",\\\"HRK\\\":\\\"HRK\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EGP\\\":\\\"EGP\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GEL\\\":\\\"GEL\\\",\\\"GHS\\\":\\\"GHS\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"INR\\\":\\\"INR\\\",\\\"IDR\\\":\\\"IDR\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"KES\\\":\\\"KES\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MAD\\\":\\\"MAD\\\",\\\"NPR\\\":\\\"NPR\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"NGN\\\":\\\"NGN\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PKR\\\":\\\"PKR\\\",\\\"PEN\\\":\\\"PEN\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"RON\\\":\\\"RON\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"ZAR\\\":\\\"ZAR\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"LKR\\\":\\\"LKR\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"THB\\\":\\\"THB\\\",\\\"TRY\\\":\\\"TRY\\\",\\\"UGX\\\":\\\"UGX\\\",\\\"UAH\\\":\\\"UAH\\\",\\\"AED\\\":\\\"AED\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"USD\\\":\\\"USD\\\",\\\"VND\\\":\\\"VND\\\",\\\"XOF\\\":\\\"XOF\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:43:31'),(6,0,106,'Payeer','Payeer',0,'697ce5171d2721769792791.png','\"{\\\"merchant_code\\\":{\\\"title\\\":\\\"Merchant Code\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key (Buy Link Secret Word)\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_word\\\":{\\\"title\\\":\\\"Secret Word (INS Secret Word)\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"RUB\\\":\\\"RUB\\\"}\"','0','\"{\\\"status\\\":{\\\"title\\\":\\\"Status URL\\\",\\\"value\\\":\\\"ipn.Payeer\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 22:06:31'),(7,0,107,'PayStack','Paystack',0,'697ce4c26af541769792706.png','\"{\\\"public_key\\\":{\\\"title\\\":\\\"Public Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"NGN\\\":\\\"NGN\\\",\\\"GHS\\\":\\\"GHS\\\",\\\"ZAR\\\":\\\"ZAR\\\",\\\"KES\\\":\\\"KES\\\"}\"','0','\"{\\\"callback\\\":{\\\"title\\\":\\\"Callback URL\\\",\\\"value\\\":\\\"ipn.Paystack\\\"},\\\"webhook\\\":{\\\"title\\\":\\\"Webhook URL\\\",\\\"value\\\":\\\"ipn.Paystack\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-02-01 16:36:34'),(8,0,109,'Flutterwave','Flutterwave',0,'697ce3e95259c1769792489.png','\"{\\\"public_key\\\":{\\\"title\\\":\\\"Public Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"encryption_key\\\":{\\\"title\\\":\\\"Encryption Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"webhook_hash\\\":{\\\"title\\\":\\\"Webhook Hash\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"BIF\\\":\\\"BIF\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CDF\\\":\\\"CDF\\\",\\\"CVE\\\":\\\"CVE\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"GHS\\\":\\\"GHS\\\",\\\"GMD\\\":\\\"GMD\\\",\\\"GNF\\\":\\\"GNF\\\",\\\"KES\\\":\\\"KES\\\",\\\"LRD\\\":\\\"LRD\\\",\\\"MWK\\\":\\\"MWK\\\",\\\"MZN\\\":\\\"MZN\\\",\\\"NGN\\\":\\\"NGN\\\",\\\"RWF\\\":\\\"RWF\\\",\\\"SLL\\\":\\\"SLL\\\",\\\"STD\\\":\\\"STD\\\",\\\"TZS\\\":\\\"TZS\\\",\\\"UGX\\\":\\\"UGX\\\",\\\"USD\\\":\\\"USD\\\",\\\"XAF\\\":\\\"XAF\\\",\\\"XOF\\\":\\\"XOF\\\",\\\"ZMK\\\":\\\"ZMK\\\",\\\"ZMW\\\":\\\"ZMW\\\",\\\"ZWD\\\":\\\"ZWD\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:15:32'),(9,0,110,'RazorPay','Razorpay',0,'697ce4ae55c751769792686.png','\"{\\\"key_id\\\":{\\\"title\\\":\\\"Key ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"key_secret\\\":{\\\"title\\\":\\\"Key Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"INR\\\":\\\"INR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:04:46'),(11,0,112,'Instamojo','Instamojo',0,'697ce4365105b1769792566.png','\"{\\\"client_id\\\":{\\\"title\\\":\\\"Client ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"client_secret\\\":{\\\"title\\\":\\\"Client Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"salt\\\":{\\\"title\\\":\\\"Salt\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"INR\\\":\\\"INR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:19:35'),(12,0,113,'PayPal Express','PaypalSdk',0,'697ce4f12ed9d1769792753.png','\"{\\\"clientId\\\":{\\\"title\\\":\\\"PayPal Client ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"clientSecret\\\":{\\\"title\\\":\\\"Client Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"INR\\\":\\\"INR\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"THB\\\":\\\"THB\\\",\\\"USD\\\":\\\"$\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:39:35'),(14,0,115,'Mollie','Mollie',0,'697ce466a6fc61769792614.png','\"{\\\"mollie_email\\\":{\\\"title\\\":\\\"Mollie Email\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AED\\\":\\\"AED\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BGN\\\":\\\"BGN\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HRK\\\":\\\"HRK\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"ISK\\\":\\\"ISK\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"RON\\\":\\\"RON\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"THB\\\":\\\"THB\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"USD\\\":\\\"USD\\\",\\\"ZAR\\\":\\\"ZAR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:36:34'),(15,0,116,'Cashmaal','Cashmaal',0,'697ce5f8141c61769793016.png','\"{\\\"web_id\\\":{\\\"title\\\":\\\"Web ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"ipn_key\\\":{\\\"title\\\":\\\"IPN Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"PKR\\\":\\\"PKR\\\",\\\"USD\\\":\\\"USD\\\"}\"','0','\"{\\\"webhook\\\":{\\\"title\\\":\\\"IPN URL\\\",\\\"value\\\":\\\"ipn.Cashmaal\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 22:10:16'),(16,0,119,'Mercado Pago','MercadoPago',0,'697ce5cb6da741769792971.png','\"{\\\"access_token\\\":{\\\"title\\\":\\\"Access Token\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"ARS\\\":\\\"ARS\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CLP\\\":\\\"CLP\\\",\\\"COP\\\":\\\"COP\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"PEN\\\":\\\"PEN\\\",\\\"UYU\\\":\\\"UYU\\\",\\\"VEF\\\":\\\"VEF\\\",\\\"BOB\\\":\\\"BOB\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:36:34'),(17,0,120,'Authorize.net','Authorize',0,'697c92bbe08461769771707.png','\"{\\\"login_id\\\":{\\\"title\\\":\\\"Login ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"transaction_key\\\":{\\\"title\\\":\\\"Transaction Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"NZD\\\":\\\"NZD\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 21:01:29'),(18,0,121,'NMI','NMI',0,'697ce5b254c851769792946.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"AED\\\":\\\"AED\\\",\\\"ARS\\\":\\\"ARS\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BOB\\\":\\\"BOB\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"CLP\\\":\\\"CLP\\\",\\\"CNY\\\":\\\"CNY\\\",\\\"COP\\\":\\\"COP\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"IDR\\\":\\\"IDR\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"INR\\\":\\\"INR\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PEN\\\":\\\"PEN\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"PYG\\\":\\\"PYG\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SEC\\\":\\\"SEC\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"THB\\\":\\\"THB\\\",\\\"TRY\\\":\\\"TRY\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"USD\\\":\\\"USD\\\",\\\"ZAR\\\":\\\"ZAR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:36:34'),(19,0,122,'2Checkout','TwoCheckout',0,'697c8fcd43fee1769770957.png','\"{\\\"merchant_code\\\":{\\\"title\\\":\\\"Merchant Code\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key (Buy Link Secret Word)\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_word\\\":{\\\"title\\\":\\\"Secret Word (INS Secret Word)\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"AFN\\\":\\\"AFN\\\",\\\"ALL\\\":\\\"ALL\\\",\\\"DZD\\\":\\\"DZD\\\",\\\"ARS\\\":\\\"ARS\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"AZN\\\":\\\"AZN\\\",\\\"BSD\\\":\\\"BSD\\\",\\\"BDT\\\":\\\"BDT\\\",\\\"BBD\\\":\\\"BBD\\\",\\\"BZD\\\":\\\"BZD\\\",\\\"BMD\\\":\\\"BMD\\\",\\\"BOB\\\":\\\"BOB\\\",\\\"BWP\\\":\\\"BWP\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"BND\\\":\\\"BND\\\",\\\"BGN\\\":\\\"BGN\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CLP\\\":\\\"CLP\\\",\\\"CNY\\\":\\\"CNY\\\",\\\"COP\\\":\\\"COP\\\",\\\"CRC\\\":\\\"CRC\\\",\\\"HRK\\\":\\\"HRK\\\",\\\"CZK\\\":\\\"CZK\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"DOP\\\":\\\"DOP\\\",\\\"XCD\\\":\\\"XCD\\\",\\\"EGP\\\":\\\"EGP\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"FJD\\\":\\\"FJD\\\",\\\"GTQ\\\":\\\"GTQ\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"HNL\\\":\\\"HNL\\\",\\\"HUF\\\":\\\"HUF\\\",\\\"INR\\\":\\\"INR\\\",\\\"IDR\\\":\\\"IDR\\\",\\\"ILS\\\":\\\"ILS\\\",\\\"JMD\\\":\\\"JMD\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"KZT\\\":\\\"KZT\\\",\\\"KES\\\":\\\"KES\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MAD\\\":\\\"MAD\\\",\\\"NPR\\\":\\\"NPR\\\",\\\"TWD\\\":\\\"TWD\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"NIO\\\":\\\"NIO\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"PKR\\\":\\\"PKR\\\",\\\"PEN\\\":\\\"PEN\\\",\\\"PHP\\\":\\\"PHP\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"QAR\\\":\\\"QAR\\\",\\\"RON\\\":\\\"RON\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SAR\\\":\\\"SAR\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"ZAR\\\":\\\"ZAR\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"LKR\\\":\\\"LKR\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"THB\\\":\\\"THB\\\",\\\"TRY\\\":\\\"TRY\\\",\\\"UAH\\\":\\\"UAH\\\",\\\"AED\\\":\\\"AED\\\",\\\"USD\\\":\\\"USD\\\",\\\"VND\\\":\\\"VND\\\",\\\"YER\\\":\\\"YER\\\"}\"','0','\"{\\\"approved_url\\\":{\\\"title\\\":\\\"Approved URL\\\",\\\"value\\\":\\\"ipn.TwoCheckout\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 16:06:39'),(20,0,123,'Checkout','Checkout',0,'697ce60b1e2441769793035.png','\"{\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"public_key\\\":{\\\"title\\\":\\\"Public Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"processing_channel_id\\\":{\\\"title\\\":\\\"Processing Channel\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"CAN\\\":\\\"CAN\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"NZD\\\":\\\"NZD\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:10:35'),(21,0,124,'SSLCommerz','SslCommerz',0,'697ce5379b6491769792823.png','\"{\\\"store_id\\\":{\\\"title\\\":\\\"Store ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"store_password\\\":{\\\"title\\\":\\\"Store Password\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"BDT\\\":\\\"BDT\\\",\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"INR\\\":\\\"INR\\\",\\\"MYR\\\":\\\"MYR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:07:03'),(22,0,125,'Aamarpay','Aamarpay',0,'697c91b20786b1769771442.png','\"{\\\"store_id\\\":{\\\"title\\\":\\\"Store ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"signature_key\\\":{\\\"title\\\":\\\"Signature Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"BDT\\\":\\\"BDT\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 16:17:35'),(23,0,126,'bKash','BKash',0,'697ce5278f5e61769792807.png','\"{\\\"username\\\":{\\\"title\\\":\\\"Username\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"password\\\":{\\\"title\\\":\\\"Password\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"app_key\\\":{\\\"title\\\":\\\"App Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"app_secret\\\":{\\\"title\\\":\\\"App Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"BDT\\\":\\\"BDT\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-02-01 16:49:10'),(24,0,501,'Blockchain','Blockchain',0,'697cd78b64e561769789323.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"xpub_code\\\":{\\\"title\\\":\\\"XPUB Code\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"BTC\\\":\\\"BTC\\\"}\"','1',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 21:08:43'),(25,0,503,'CoinPayments','Coinpayments',0,'697ce3c266a501769792450.png','\"{\\\"public_key\\\":{\\\"title\\\":\\\"Public Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"private_key\\\":{\\\"title\\\":\\\"Private Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"merchant_id\\\":{\\\"title\\\":\\\"Merchant ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"ipn_secret\\\":{\\\"title\\\":\\\"IPN Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"BTC\\\":\\\"Bitcoin\\\",\\\"BTC.LN\\\":\\\"Bitcoin (Lightning)\\\",\\\"LTC\\\":\\\"Litecoin\\\",\\\"ETH\\\":\\\"Ethereum\\\",\\\"BCH\\\":\\\"Bitcoin Cash\\\",\\\"DOGE\\\":\\\"Dogecoin\\\",\\\"DASH\\\":\\\"DASH\\\",\\\"XMR\\\":\\\"Monero\\\",\\\"XRP\\\":\\\"Ripple\\\",\\\"TRX\\\":\\\"TRON\\\",\\\"USDT\\\":\\\"Tether USD (Omni)\\\",\\\"USDT.ERC20\\\":\\\"Tether USD (ERC20)\\\",\\\"USDT.TRC20\\\":\\\"Tether USD (TRC20)\\\",\\\"USDT.BEP20\\\":\\\"Tether USD (BSC)\\\",\\\"BNB\\\":\\\"Binance Coin\\\",\\\"ADA\\\":\\\"Cardano\\\",\\\"DOT\\\":\\\"Polkadot\\\",\\\"SOL\\\":\\\"Solana\\\",\\\"MATIC\\\":\\\"Polygon\\\",\\\"LINK\\\":\\\"Chainlink\\\",\\\"XLM\\\":\\\"Stellar\\\",\\\"ATOM\\\":\\\"Cosmos\\\",\\\"VET\\\":\\\"VeChain\\\",\\\"ZEC\\\":\\\"ZCash\\\",\\\"NEO\\\":\\\"NEO\\\",\\\"EOS\\\":\\\"EOS\\\"}\"','1',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:00:50'),(26,0,504,'CoinPayments Fiat','CoinpaymentsFiat',0,'697ce3b47e89b1769792436.png','\"{\\\"merchant_id\\\":{\\\"title\\\":\\\"Merchant ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"ipn_secret\\\":{\\\"title\\\":\\\"IPN Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"CLP\\\":\\\"CLP\\\",\\\"CNY\\\":\\\"CNY\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"INR\\\":\\\"INR\\\",\\\"ISK\\\":\\\"ISK\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"THB\\\":\\\"THB\\\",\\\"TWD\\\":\\\"TWD\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:00:36'),(27,0,505,'Coingate','Coingate',0,'697ce387c78331769792391.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\"}\"','0',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 21:59:51'),(28,0,506,'Coinbase Commerce','CoinbaseCommerce',0,'697ce3a0456121769792416.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret\\\":{\\\"title\\\":\\\"Webhook Shared Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"CNY\\\":\\\"CNY\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"SGD\\\":\\\"SGD\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"KRW\\\":\\\"KRW\\\",\\\"TRY\\\":\\\"TRY\\\",\\\"RUB\\\":\\\"RUB\\\",\\\"INR\\\":\\\"INR\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"ZAR\\\":\\\"ZAR\\\"}\"','0','\"{\\\"endpoint\\\":{\\\"title\\\":\\\"Webhook Endpoint\\\",\\\"value\\\":\\\"ipn.CoinbaseCommerce\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 22:00:16'),(29,0,507,'BTCPay','BTCPay',0,'697c9435a859d1769772085.png','\"{\\\"store_id\\\":{\\\"title\\\":\\\"Store ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"server_name\\\":{\\\"title\\\":\\\"BTCPay Server URL\\\",\\\"global\\\":true,\\\"value\\\":\\\"https:\\\\\\/\\\\\\/mainnet.demo.btcpayserver.org\\\"},\\\"secret_code\\\":{\\\"title\\\":\\\"Webhook Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"BTC\\\":\\\"Bitcoin\\\",\\\"LTC\\\":\\\"Litecoin\\\"}\"','1','\"{\\\"webhook\\\":{\\\"title\\\":\\\"IPN URL\\\",\\\"value\\\":\\\"ipn.BTCPay\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 21:23:22'),(30,0,508,'NowPayments Hosted','NowPaymentsHosted',0,'697ce58e27ef31769792910.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"BTC\\\":\\\"BTC\\\",\\\"ETH\\\":\\\"ETH\\\",\\\"LTC\\\":\\\"LTC\\\",\\\"BCH\\\":\\\"BCH\\\",\\\"DOGE\\\":\\\"DOGE\\\",\\\"DASH\\\":\\\"DASH\\\",\\\"XMR\\\":\\\"XMR\\\",\\\"ZEC\\\":\\\"ZEC\\\",\\\"XRP\\\":\\\"XRP\\\",\\\"TRX\\\":\\\"TRX\\\",\\\"BNB\\\":\\\"BNB\\\",\\\"USDT\\\":\\\"USDT\\\",\\\"USDC\\\":\\\"USDC\\\",\\\"DAI\\\":\\\"DAI\\\",\\\"USDTERC20\\\":\\\"USDTERC20\\\",\\\"USDTTRC20\\\":\\\"USDTTRC20\\\"}\"','1',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:08:30'),(31,0,509,'NowPayments Checkout','NowPaymentsCheckout',0,'697ce59e39cd61769792926.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\"}\"','1',NULL,NULL,'2025-12-19 15:45:04','2026-01-30 22:08:46'),(32,0,510,'Binance Pay','Binance',0,'697cd6a8df6771769789096.png','\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"}}\"','\"{\\\"USDT\\\":\\\"Tether\\\",\\\"BTC\\\":\\\"Bitcoin\\\",\\\"BNB\\\":\\\"Binance Coin\\\",\\\"ETH\\\":\\\"Ethereum\\\",\\\"BUSD\\\":\\\"Binance USD\\\"}\"','1','\"{\\\"cron\\\":{\\\"title\\\":\\\"Cron Job URL\\\",\\\"value\\\":\\\"ipn.Binance\\\"}}\"',NULL,'2025-12-19 15:45:04','2026-01-30 21:23:22'),(33,0,1000,'Bank Transfer','BankTransfer',1,NULL,'\"{\\\"bank_name\\\":{\\\"title\\\":\\\"Bank Name\\\",\\\"value\\\":\\\"Demo Bank\\\"},\\\"account_name\\\":{\\\"title\\\":\\\"Account Name\\\",\\\"value\\\":\\\"Salieno Inc.\\\"},\\\"account_number\\\":{\\\"title\\\":\\\"Account Number\\\",\\\"value\\\":\\\"1234567890\\\"},\\\"routing_number\\\":{\\\"title\\\":\\\"Routing Number\\\",\\\"value\\\":\\\"021000021\\\"},\\\"swift_code\\\":{\\\"title\\\":\\\"SWIFT Code\\\",\\\"value\\\":\\\"DEMOBANK\\\"}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\"}\"','0',NULL,'Transfer funds directly to our bank account. Processing time: 1-3 business days.','2025-12-19 15:45:04','2025-12-19 15:45:04'),(38,0,111,'Stripe Storefront','StripeJs',0,'697ce476e5e0a1769792630.png','\"{\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"publishable_key\\\":{\\\"title\\\":\\\"Publishable Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"webhook_secret\\\":{\\\"title\\\":\\\"Webhook Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"INR\\\":\\\"INR\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\"}\"','0',NULL,NULL,'2026-01-30 16:06:39','2026-02-01 16:55:15'),(39,0,114,'Stripe Checkout','StripeV3',0,'697ce48e0241f1769792654.png','\"{\\\"secret_key\\\":{\\\"title\\\":\\\"Secret Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"publishable_key\\\":{\\\"title\\\":\\\"Publishable Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"webhook_secret\\\":{\\\"title\\\":\\\"Webhook Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"USD\\\":\\\"USD\\\",\\\"AUD\\\":\\\"AUD\\\",\\\"BRL\\\":\\\"BRL\\\",\\\"CAD\\\":\\\"CAD\\\",\\\"CHF\\\":\\\"CHF\\\",\\\"DKK\\\":\\\"DKK\\\",\\\"EUR\\\":\\\"EUR\\\",\\\"GBP\\\":\\\"GBP\\\",\\\"HKD\\\":\\\"HKD\\\",\\\"INR\\\":\\\"INR\\\",\\\"JPY\\\":\\\"JPY\\\",\\\"MXN\\\":\\\"MXN\\\",\\\"MYR\\\":\\\"MYR\\\",\\\"NOK\\\":\\\"NOK\\\",\\\"NZD\\\":\\\"NZD\\\",\\\"PLN\\\":\\\"PLN\\\",\\\"SEK\\\":\\\"SEK\\\",\\\"SGD\\\":\\\"SGD\\\"}\"','0','\"{\\\"webhook\\\":{\\\"title\\\":\\\"Webhook Endpoint\\\",\\\"value\\\":\\\"ipn.StripeV3\\\"}}\"',NULL,'2026-01-30 16:06:39','2026-02-01 16:55:15'),(40,0,117,'Pesapal','Pesapal',0,'697f48552496b1769949269.png','\"{\\\"consumer_key\\\":{\\\"title\\\":\\\"Consumer Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"consumer_secret\\\":{\\\"title\\\":\\\"Consumer Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"KES\\\":\\\"KES\\\",\\\"USD\\\":\\\"USD\\\",\\\"UGX\\\":\\\"UGX\\\",\\\"TZS\\\":\\\"TZS\\\"}\"','0',NULL,NULL,'2026-02-01 17:21:56','2026-02-01 17:34:29'),(41,0,118,'Selcom','Selcom',0,NULL,'\"{\\\"vendor_id\\\":{\\\"title\\\":\\\"Vendor ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"api_secret\\\":{\\\"title\\\":\\\"API Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"TZS\\\":\\\"TZS\\\",\\\"USD\\\":\\\"USD\\\"}\"','0',NULL,NULL,'2026-02-01 17:34:09','2026-02-01 17:34:09'),(42,0,127,'AzamPay','AzamPay',0,NULL,'\"{\\\"app_name\\\":{\\\"title\\\":\\\"App Name\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"client_id\\\":{\\\"title\\\":\\\"Client ID\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"client_secret\\\":{\\\"title\\\":\\\"Client Secret\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"TZS\\\":\\\"TZS\\\"}\"','0',NULL,NULL,'2026-02-01 17:42:27','2026-02-01 17:42:27'),(43,0,128,'M-Pesa Tanzania','MpesaTanzania',0,NULL,'\"{\\\"api_key\\\":{\\\"title\\\":\\\"API Key\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"public_key\\\":{\\\"title\\\":\\\"Public Key (Vodacom)\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"service_provider_code\\\":{\\\"title\\\":\\\"Service Provider Code\\\",\\\"global\\\":true,\\\"value\\\":\\\"\\\"},\\\"sandbox\\\":{\\\"title\\\":\\\"Sandbox Mode\\\",\\\"global\\\":true,\\\"value\\\":\\\"sandbox\\\",\\\"options\\\":{\\\"sandbox\\\":\\\"Sandbox\\\",\\\"live\\\":\\\"Live\\\"}}}\"','\"{\\\"TZS\\\":\\\"TZS\\\"}\"','0',NULL,NULL,'2026-02-01 18:08:15','2026-02-01 18:08:15');
/*!40000 ALTER TABLE `gateways` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `general_settings`
--

DROP TABLE IF EXISTS `general_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `general_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Tax percentage',
  `site_name` varchar(40) NOT NULL DEFAULT 'Salieno',
  `invoice_start` int(10) unsigned NOT NULL DEFAULT 1,
  `invoice_increment` int(10) unsigned NOT NULL DEFAULT 1,
  `deposit_module` tinyint(1) NOT NULL DEFAULT 1,
  `auto_domain_register` tinyint(1) NOT NULL DEFAULT 1,
  `last_cron` varchar(40) DEFAULT NULL,
  `available_version` varchar(40) NOT NULL DEFAULT '1.0',
  `cur_text` varchar(40) DEFAULT NULL COMMENT 'currency text',
  `cur_sym` varchar(40) DEFAULT NULL COMMENT 'currency symbol',
  `email_from` varchar(40) DEFAULT NULL,
  `email_from_name` varchar(255) DEFAULT NULL,
  `email_template` text DEFAULT NULL,
  `sms_template` varchar(255) DEFAULT NULL,
  `sms_from` varchar(255) DEFAULT NULL,
  `push_title` varchar(255) DEFAULT NULL,
  `push_template` varchar(255) DEFAULT NULL,
  `base_color` varchar(40) DEFAULT NULL,
  `mail_config` text DEFAULT NULL COMMENT 'email configuration JSON',
  `sms_config` text DEFAULT NULL COMMENT 'SMS configuration JSON',
  `firebase_config` text DEFAULT NULL COMMENT 'Firebase configuration JSON',
  `global_shortcodes` text DEFAULT NULL,
  `kv` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'KYC verification required',
  `ev` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'email verification, 0 - dont check, 1 - check',
  `en` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'email notification, 0 - dont send, 1 - send',
  `sv` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'mobile verification, 0 - dont check, 1 - check',
  `sn` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'sms notification, 0 - dont send, 1 - send',
  `pn` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'push notification',
  `force_ssl` tinyint(1) NOT NULL DEFAULT 0,
  `maintenance_mode` tinyint(1) NOT NULL DEFAULT 0,
  `secure_password` tinyint(1) NOT NULL DEFAULT 0,
  `agree` tinyint(1) NOT NULL DEFAULT 0,
  `multi_language` tinyint(1) NOT NULL DEFAULT 1,
  `registration` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0: Off, 1: On',
  `active_template` varchar(40) DEFAULT NULL,
  `socialite_credentials` text DEFAULT NULL,
  `system_customized` tinyint(1) NOT NULL DEFAULT 0,
  `paginate_number` int(10) unsigned NOT NULL DEFAULT 20,
  `currency_format` tinyint(4) NOT NULL DEFAULT 0 COMMENT '1=>Both, 2=>Text Only, 3=>Symbol Only',
  `update_exchange_rate` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate_api_key` varchar(255) DEFAULT NULL,
  `client_area_settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `store_base_path` varchar(100) NOT NULL DEFAULT 'products',
  `store_index_disabled` tinyint(1) NOT NULL DEFAULT 1,
  `store_default_category_id` bigint(20) unsigned DEFAULT NULL,
  `store_pricing_display` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`store_pricing_display`)),
  `store_compare_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `store_guest_checkout` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `affiliate_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `affiliate_commission_rate` decimal(5,2) NOT NULL DEFAULT 10.00 COMMENT 'Commission rate percentage',
  `affiliate_commission_type` enum('percentage','fixed') NOT NULL DEFAULT 'percentage',
  `affiliate_min_payout` decimal(18,2) NOT NULL DEFAULT 50.00 COMMENT 'Minimum payout amount',
  `affiliate_hold_days` int(11) NOT NULL DEFAULT 30 COMMENT 'Days to hold commission before approval',
  `affiliate_auto_approve` tinyint(1) NOT NULL DEFAULT 1,
  `affiliate_cookie_days` int(11) NOT NULL DEFAULT 30,
  `affiliate_payout_methods` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `tax_country_rates` tinyint(1) NOT NULL DEFAULT 0,
  `tax_use_eu_vat` tinyint(1) NOT NULL DEFAULT 0,
  `tax_country_rates_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `kyc_required_for_orders` tinyint(1) NOT NULL DEFAULT 0,
  `kyc_required_level` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1: basic, 2: enhanced, 3: premium',
  `kyc_auto_approve` tinyint(1) NOT NULL DEFAULT 0,
  `kyc_document_types` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `ticket_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_auto_close_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_auto_close_days` int(11) NOT NULL DEFAULT 7 COMMENT 'Days of inactivity before auto-close',
  `ticket_auto_close_notify` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Send notification before auto-close',
  `ticket_auto_close_warning_hours` int(11) NOT NULL DEFAULT 24 COMMENT 'Hours before closure to send warning',
  `ticket_sla_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_default_sla_response_hours` int(11) NOT NULL DEFAULT 4 COMMENT 'Default hours for first response',
  `ticket_default_sla_resolution_hours` int(11) NOT NULL DEFAULT 48 COMMENT 'Default hours for resolution',
  `ticket_escalate_on_sla_breach` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_escalation_email` varchar(255) DEFAULT NULL,
  `ticket_auto_assign_method` varchar(255) NOT NULL DEFAULT 'none' COMMENT 'none, round_robin, least_busy, category_based',
  `ticket_notify_on_assignment` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_feedback_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_feedback_delay_hours` int(11) NOT NULL DEFAULT 2 COMMENT 'Hours after resolution to send feedback request',
  `ticket_attachments_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_max_attachments` int(11) NOT NULL DEFAULT 5,
  `ticket_max_attachment_size` int(11) NOT NULL DEFAULT 10 COMMENT 'Max size in MB',
  `ticket_allowed_extensions` varchar(255) NOT NULL DEFAULT 'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',
  `ticket_notify_admin_new` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_notify_admin_reply` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_notify_customer_reply` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_notify_customer_closed` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_allow_guest_tickets` tinyint(1) NOT NULL DEFAULT 0,
  `ticket_require_category` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_show_related_articles` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_max_open_per_user` int(11) NOT NULL DEFAULT 0 COMMENT '0 = unlimited',
  `ticket_livechat_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_livechat_title` varchar(255) NOT NULL DEFAULT 'Support Chat',
  `ticket_livechat_welcome_msg` text DEFAULT NULL,
  `ticket_livechat_color` varchar(255) NOT NULL DEFAULT '#CC2628',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `general_settings`
--

LOCK TABLES `general_settings` WRITE;
/*!40000 ALTER TABLE `general_settings` DISABLE KEYS */;
INSERT INTO `general_settings` VALUES (1,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0.0','USD','$','support@salieno.net','Salieno','<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><title>{{site_name}}</title><body style=\"background-color:#f5f5f5;font-family:Arial,sans-serif;padding:20px\"><div style=\"max-width:600px;margin:0 auto;background:#fff;padding:30px;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,.1)\"><div style=\"text-align:center;margin-bottom:30px\"><h1 style=\"color:#333;margin:0\">{{site_name}}</h1></div><div style=\"color:#555;line-height:1.6\">{{message}}</div><div style=\"margin-top:30px;padding-top:20px;border-top:1px solid #eee;text-align:center;color:#999;font-size:12px\"><p>&copy; {{year}} {{site_name}}. All rights reserved.</p></div></div></body>','{{message}}','Salieno','{{site_name}}','{{message}}','6366f1','{\"name\":\"php\"}','\"{\\\"name\\\":\\\"\\\"}\"','\"{\\\"name\\\":\\\"\\\",\\\"serverKey\\\":\\\"\\\"}\"','\"{\\\"site_name\\\":\\\"Site Name\\\",\\\"site_currency\\\":\\\"Site Currency\\\",\\\"currency_symbol\\\":\\\"Currency Symbol\\\"}\"',0,1,1,0,0,0,0,0,0,0,1,1,'salieno','{\"google\":{\"status\":true,\"client_id\":\" almirfrances1@gmail.com\",\"client_secret\":\"tanzahost\"},\"facebook\":{\"status\":true,\"client_id\":\"\",\"client_secret\":\"\"},\"linkedin\":{\"status\":true,\"client_id\":\"\",\"client_secret\":\"\"}}',0,20,1,1,'96074f46dd849ea57b6cd300','{\"two_factor_enabled\":true,\"layout_style\":\"topnav\",\"sidebar_position\":\"left\",\"sidebar_width\":\"260\",\"sidebar_collapsible\":true,\"show_sidebar_balance\":true,\"show_quick_actions\":true,\"mobile_menu_style\":\"hamburger\",\"header_sticky\":true,\"show_breadcrumbs\":true,\"show_notification_bell\":true,\"show_user_balance\":true,\"show_cart_icon\":true,\"show_search\":true,\"header_style\":\"default\",\"menu_dashboard\":true,\"menu_services\":true,\"menu_domains\":true,\"menu_invoices\":true,\"menu_transactions\":true,\"menu_deposits\":true,\"menu_support\":true,\"menu_profile\":true,\"menu_security\":true,\"menu_email_history\":true,\"menu_kyc\":true,\"menu_announcements\":true,\"menu_login_history\":true,\"deposit_module\":true,\"support_module\":true,\"kyc_required\":false,\"email_history_enabled\":true,\"domain_module\":true,\"service_cancellation\":true,\"invoice_download\":true,\"invoice_preview\":true,\"announcement_module\":true,\"login_history_enabled\":true,\"font_family\":\"Inter\",\"font_url\":\"https:\\/\\/fonts.googleapis.com\\/css2?family=Inter:wght@300;400;500;600;700;800&display=swap\",\"heading_font\":\"Inter\",\"base_font_size\":\"16\",\"border_radius\":\"12\",\"shadow_intensity\":\"medium\",\"button_radius\":\"10\",\"button_shadow\":\"true\",\"button_style\":\"rounded\",\"button_hover_effect\":\"lift\",\"card_shadow\":\"medium\",\"card_border_style\":\"subtle\",\"card_hover_effect\":\"lift\",\"enable_glassmorphism\":true,\"dark_mode_enabled\":false,\"enable_animations\":true,\"show_footer\":true,\"footer_text\":\"\",\"show_social_links\":true,\"custom_css\":\"\",\"welcome_title\":\"Welcome back, :name!\",\"welcome_subtitle\":\"Here\'s what\'s happening with your account today.\"}','products',1,NULL,'{\"show_monthly_equivalent\":true,\"show_savings_badge\":true,\"show_discount_percentage\":true,\"default_billing_cycle\":\"annually\",\"compare_max_products\":4}',1,1,'2025-12-19 15:45:03','2026-02-22 07:03:46',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,2,0,'[\"passport\",\"id_card\",\"drivers_license\",\"residence_permit\",\"utility_bill\",\"bank_statement\"]',1,1,7,1,24,1,4,48,1,'escalation@test.com','none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,1,1,1,0,1,'Support Chat','Hello! Welcome to our premium live chat service!','#CC2628'),(2,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:16:38','2025-12-21 07:16:38',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628'),(3,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:17:06','2025-12-21 07:17:06',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628'),(4,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:17:13','2025-12-21 07:17:13',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628'),(5,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:32:19','2025-12-21 07:32:19',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628'),(6,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:32:26','2025-12-21 07:32:26',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628'),(7,0.00,'Salieno',1,1,1,1,'2026-02-25 23:56:05','1.0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,1,0,0,0,0,1,0,NULL,NULL,0,20,0,0,NULL,NULL,'products',1,NULL,NULL,1,1,'2025-12-21 07:33:32','2025-12-21 07:33:32',1,10.00,'percentage',50.00,30,1,30,NULL,0,0,NULL,0,1,0,NULL,1,1,7,1,24,1,4,48,1,NULL,'none',1,1,2,1,5,10,'jpg,jpeg,png,gif,pdf,doc,docx,txt,zip',1,1,1,1,0,1,1,0,1,'Support Chat',NULL,'#CC2628');
/*!40000 ALTER TABLE `general_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hosting_addons`
--

DROP TABLE IF EXISTS `hosting_addons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hosting_addons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hosting_id` bigint(20) unsigned NOT NULL,
  `addon_id` bigint(20) unsigned NOT NULL,
  `billing_cycle` int(11) DEFAULT NULL,
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `reg_date` date DEFAULT NULL,
  `next_due_date` date DEFAULT NULL,
  `next_invoice_date` date DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hosting_addons_hosting_id_foreign` (`hosting_id`),
  KEY `hosting_addons_addon_id_foreign` (`addon_id`),
  CONSTRAINT `hosting_addons_addon_id_foreign` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hosting_addons_hosting_id_foreign` FOREIGN KEY (`hosting_id`) REFERENCES `hostings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hosting_addons`
--

LOCK TABLES `hosting_addons` WRITE;
/*!40000 ALTER TABLE `hosting_addons` DISABLE KEYS */;
/*!40000 ALTER TABLE `hosting_addons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hosting_configs`
--

DROP TABLE IF EXISTS `hosting_configs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hosting_configs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hosting_id` int(10) unsigned NOT NULL DEFAULT 0,
  `configurable_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `configurable_group_option_id` int(10) unsigned NOT NULL DEFAULT 0,
  `configurable_group_sub_option_id` int(10) unsigned NOT NULL DEFAULT 0,
  `price` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hosting_configs`
--

LOCK TABLES `hosting_configs` WRITE;
/*!40000 ALTER TABLE `hosting_configs` DISABLE KEYS */;
/*!40000 ALTER TABLE `hosting_configs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hostings`
--

DROP TABLE IF EXISTS `hostings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hostings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0=> Empty invoice/allow creating new, 1=> Already created',
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `order_id` int(10) unsigned NOT NULL DEFAULT 0,
  `product_id` int(10) unsigned NOT NULL DEFAULT 0,
  `server_id` int(10) unsigned NOT NULL DEFAULT 0,
  `deposit_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_setup_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'TLD / Domain setup id',
  `domain` varchar(255) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL COMMENT 'From WHM API',
  `first_payment_amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `recurring_amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000 COMMENT 'Additional price / amount',
  `discount` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `status` tinyint(4) NOT NULL DEFAULT 2 COMMENT '1=> Active, 2=> Pending, 3=> Suspended, 4=> Terminated, 5=> Cancelled',
  `billing_cycle` varchar(40) DEFAULT NULL,
  `stock_control` tinyint(1) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` text DEFAULT NULL,
  `ns1` varchar(255) DEFAULT NULL,
  `ns2` varchar(255) DEFAULT NULL,
  `ns3` varchar(255) DEFAULT NULL,
  `ns4` varchar(255) DEFAULT NULL,
  `ns1_ip` varchar(255) DEFAULT NULL,
  `ns2_ip` varchar(255) DEFAULT NULL,
  `ns3_ip` varchar(255) DEFAULT NULL,
  `ns4_ip` varchar(255) DEFAULT NULL,
  `dedicated_ip` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `assigned_ips` text DEFAULT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'For admin only',
  `suspend_reason` varchar(255) DEFAULT NULL,
  `termination_date` varchar(40) DEFAULT NULL,
  `suspend_date` varchar(40) DEFAULT NULL,
  `next_due_date` varchar(40) DEFAULT NULL,
  `next_invoice_date` varchar(40) DEFAULT NULL,
  `reg_date` varchar(40) DEFAULT NULL COMMENT 'Registration date',
  `last_cron` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `plesk_customer_id` varchar(255) DEFAULT NULL,
  `plesk_webspace_id` varchar(255) DEFAULT NULL,
  `coupon_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_hostings_status_due_date` (`status`,`next_due_date`),
  KEY `idx_hostings_last_cron` (`last_cron`),
  KEY `idx_hostings_invoice` (`invoice`),
  KEY `idx_hostings_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hostings`
--

LOCK TABLES `hostings` WRITE;
/*!40000 ALTER TABLE `hostings` DISABLE KEYS */;
/*!40000 ALTER TABLE `hostings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoice_items`
--

DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `hosting_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_id` int(10) unsigned NOT NULL DEFAULT 0,
  `item_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=> Hosting, 1=> Domain',
  `description` text DEFAULT NULL,
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `tax` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Tax percentage',
  `reg_period` int(11) NOT NULL DEFAULT 0 COMMENT 'For renew domain',
  `trx_type` varchar(40) DEFAULT NULL COMMENT '+ or -',
  `recurring_amount` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `next_due_date` varchar(40) DEFAULT NULL COMMENT 'For renew domain',
  `taxed` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_index` (`invoice_id`),
  KEY `invoice_items_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoice_items`
--

LOCK TABLES `invoice_items` WRITE;
/*!40000 ALTER TABLE `invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(40) DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `hosting_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_id` int(10) unsigned NOT NULL DEFAULT 0,
  `amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `late_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `tax` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `discount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `paid_amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=> Unpaid, 1=> Paid, 2=> Cancelled, 3=> Refunded',
  `due_date` varchar(40) DEFAULT NULL,
  `date_paid` varchar(40) DEFAULT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'For admin only',
  `upgrade_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Stores upgrade/downgrade info for processing after payment',
  `reminder` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `last_cron` timestamp NULL DEFAULT NULL,
  `created` date DEFAULT NULL,
  `next_due_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_invoices_status_due_date` (`status`,`due_date`),
  KEY `idx_invoices_user_status` (`user_id`,`status`),
  KEY `idx_invoices_last_cron` (`last_cron`),
  KEY `idx_invoices_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kb_articles`
--

DROP TABLE IF EXISTS `kb_articles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kb_articles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint(20) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  `is_popular` tinyint(1) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `helpful_count` int(10) unsigned NOT NULL DEFAULT 0,
  `not_helpful_count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `kb_articles_slug_unique` (`slug`),
  KEY `kb_articles_category_id_foreign` (`category_id`),
  CONSTRAINT `kb_articles_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `kb_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kb_articles`
--

LOCK TABLES `kb_articles` WRITE;
/*!40000 ALTER TABLE `kb_articles` DISABLE KEYS */;
INSERT INTO `kb_articles` VALUES (1,1,'What is Salieno?','what-is-salieno','<h1>Welcome to Salieno</h1><p>Salieno is a powerful, integrated hosting and service management platform designed to streamline your business operations. Whether you are managing clients, servers, or billing, Salieno offers a premium, all-in-one solution with a modern design and robust feature set.</p><h2>Key Features</h2><ul><li>Comprehensive Client Management</li><li>Automated Billing & Invoicing</li><li>Seamless Server Integration</li><li>Integrated Knowledge Base & Support Tickets</li></ul>',27,1,1,'What is Salieno? - Introduction and Features','Discover how Salieno can transform your service management with automated billing, server integration, and a premium administrative experience.','2026-01-27 00:01:49','2026-02-25 09:23:36',2,0);
/*!40000 ALTER TABLE `kb_articles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `kb_categories`
--

DROP TABLE IF EXISTS `kb_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `kb_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `kb_categories_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `kb_categories`
--

LOCK TABLES `kb_categories` WRITE;
/*!40000 ALTER TABLE `kb_categories` DISABLE KEYS */;
INSERT INTO `kb_categories` VALUES (1,'General','general','General information about Salieno',NULL,1,0,'2026-01-27 00:01:41','2026-01-27 00:01:41');
/*!40000 ALTER TABLE `kb_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `code` varchar(40) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `languages_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en',NULL,1,'2025-12-19 15:45:04','2025-12-19 15:45:04');
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_items`
--

DROP TABLE IF EXISTS `menu_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL,
  `type` enum('link','page','page_link','route','divider','dropdown','heading') NOT NULL DEFAULT 'link',
  `label` varchar(100) DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `page_key` varchar(100) DEFAULT NULL,
  `route_name` varchar(150) DEFAULT NULL,
  `route_params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `url` varchar(500) DEFAULT NULL,
  `page_id` bigint(20) unsigned DEFAULT NULL,
  `target` enum('_self','_blank') NOT NULL DEFAULT '_self',
  `css_class` varchar(200) DEFAULT NULL,
  `visibility` enum('all','guest','auth') NOT NULL DEFAULT 'all',
  `required_permission` varchar(100) DEFAULT NULL,
  `feature_gate` varchar(100) DEFAULT NULL,
  `category` varchar(50) DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `badge_text` varchar(50) DEFAULT NULL,
  `badge_color` varchar(50) DEFAULT NULL,
  `badge_source` varchar(200) DEFAULT NULL,
  `visibility_rules` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_items_page_id_foreign` (`page_id`),
  KEY `menu_items_menu_id_is_active_order_index` (`menu_id`,`is_active`,`order`),
  KEY `menu_items_parent_id_index` (`parent_id`),
  KEY `menu_items_visibility_index` (`visibility`),
  KEY `menu_items_page_key_index` (`page_key`),
  KEY `menu_items_feature_gate_index` (`feature_gate`),
  KEY `menu_items_category_index` (`category`),
  CONSTRAINT `menu_items_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `menus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `menu_items_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE SET NULL,
  CONSTRAINT `menu_items_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_items`
--

LOCK TABLES `menu_items` WRITE;
/*!40000 ALTER TABLE `menu_items` DISABLE KEYS */;
INSERT INTO `menu_items` VALUES (84,15,NULL,'page_link','Dashboard','ph-squares-four','dashboard',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,'main',1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(85,15,NULL,'page_link','Services','ph-cube','services',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,'main',2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(86,15,NULL,'page_link','Domains','ph-globe','domains',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'domains','main',3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(87,15,NULL,'page_link','Invoices','ph-receipt','invoices',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,'main',4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(88,15,NULL,'page_link','Support','ph-chat-circle-dots','tickets',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'support','main',5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(89,15,NULL,'page_link','Announcements','ph-megaphone','announcements',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'announcements','main',6,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(90,15,NULL,'divider','Account',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(91,15,NULL,'page_link','Profile','ph-user-circle','profile',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,'account',8,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(92,15,NULL,'page_link','Security','ph-shield-check','security',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'security','account',9,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(93,15,NULL,'page_link','Add Funds','ph-wallet','deposits',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'deposits','account',10,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(94,15,NULL,'page_link','Transactions','ph-arrows-left-right','transactions',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,'account',11,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(95,16,NULL,'page_link','Dashboard','ph-squares-four','dashboard',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(96,16,NULL,'page_link','Services','ph-cube','services',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(97,16,NULL,'page_link','Domains','ph-globe','domains',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'domains',NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(98,16,NULL,'page_link','Billing','ph-receipt','invoices',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(99,16,NULL,'page_link','Support','ph-chat-circle-dots','tickets',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'support',NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(100,17,NULL,'page_link','Profile','ph-user-circle','profile',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(101,17,NULL,'page_link','Security','ph-shield-check','security',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'security',NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(102,17,NULL,'page_link','Transactions','ph-arrows-left-right','transactions',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(103,17,NULL,'page_link','Email History','ph-envelope','emails',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'email_history',NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(104,17,NULL,'page_link','Add Funds','ph-wallet','deposits',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'deposits',NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(105,18,NULL,'link','Terms of Service',NULL,NULL,NULL,NULL,'/terms',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(106,18,NULL,'link','Privacy Policy',NULL,NULL,NULL,NULL,'/privacy',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(107,18,NULL,'page_link','Contact Support',NULL,'tickets',NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,'support',NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(108,19,NULL,'page_link','Home','ph-house','dashboard',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(109,19,NULL,'page_link','Services','ph-cube','services',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(110,19,NULL,'page_link','Billing','ph-receipt','invoices',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(111,19,NULL,'page_link','Support','ph-chat-circle-dots','tickets',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,'support',NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(112,19,NULL,'page_link','Account','ph-user-circle','profile',NULL,NULL,NULL,NULL,'_self',NULL,'auth',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(122,22,NULL,'page_link','Support','ph-chat-circle-dots','tickets',NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,'support','main',1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-21 18:26:06','2026-01-21 18:31:36'),(123,22,NULL,'divider','---',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-21 18:32:46','2026-01-21 18:32:46'),(124,21,NULL,'heading','Services',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(125,21,124,'link','Buy Domains',NULL,NULL,NULL,NULL,'/domain',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(126,21,124,'link','Shared Hosting',NULL,NULL,NULL,NULL,'/products/shared-hosting',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(127,21,124,'link','WordPress Hosting',NULL,NULL,NULL,NULL,'/products/wordpress-hosting',NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(128,21,124,'link','Managed WordPress',NULL,NULL,NULL,NULL,'/products/managed-wordpress',NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(129,21,124,'link','Reseller Hosting',NULL,NULL,NULL,NULL,'/products/reseller-hosting',NULL,'_self',NULL,'all',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(130,21,124,'link','VPS Hosting',NULL,NULL,NULL,NULL,'/products/vps-hosting',NULL,'_self',NULL,'all',NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(131,21,124,'link','Email Hosting',NULL,NULL,NULL,NULL,'/products/email-hosting',NULL,'_self',NULL,'all',NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(132,21,124,'link','Hosting Add-Ons',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,8,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(133,21,NULL,'heading','Company',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(134,21,133,'link','About Us',NULL,NULL,NULL,NULL,'/about-us',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(135,21,133,'link','Contact Us',NULL,NULL,NULL,NULL,'/contact',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(136,21,133,'link','Clients',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(137,21,133,'link','Partners',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(138,21,133,'link','Blog',NULL,NULL,NULL,NULL,'/blog',NULL,'_self',NULL,'all',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(139,21,133,'link','Careers (We\'re hiring!)',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(140,21,133,'link','Affiliate Program',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(141,21,NULL,'heading','Get Help',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(142,21,141,'link','Sales Questions?',NULL,NULL,NULL,NULL,'/contact',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(143,21,141,'link','Open a Ticket',NULL,NULL,NULL,NULL,'/ticket/new',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(144,21,141,'link','Self-Support Center',NULL,NULL,NULL,NULL,'/support',NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(145,21,141,'link','Status Page',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(146,21,141,'link','Domains Glossary',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(147,21,141,'link','Hosting Glossary',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(148,21,141,'link','Video Tutorials',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,7,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(149,21,NULL,'heading','Why Salieno',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:54:15'),(150,21,149,'link','Features & Technology',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(151,21,149,'link','Industry Leading Support',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(152,21,149,'link','Service Uptime',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(153,21,149,'link','Worldwide Server Locations',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(154,21,149,'link','Easy Website Management',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(155,21,NULL,'heading','Hosted Applications',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(156,21,155,'link','Node.js Hosting',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(157,21,155,'link','Python Hosting',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(158,21,155,'link','WordPress Hosting',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(159,21,155,'link','WooCommerce Hosting',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(160,21,NULL,'heading','Blog Hosting',NULL,NULL,NULL,NULL,NULL,NULL,'_self',NULL,'all',NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57'),(161,21,160,'link','Blog Hosting Details',NULL,NULL,NULL,NULL,'#',NULL,'_self',NULL,'all',NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,'2026-01-23 16:46:57','2026-01-23 16:46:57');
/*!40000 ALTER TABLE `menu_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_versions`
--

DROP TABLE IF EXISTS `menu_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_versions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint(20) unsigned NOT NULL,
  `version_number` int(10) unsigned NOT NULL,
  `snapshot` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `change_summary` varchar(255) DEFAULT NULL,
  `changed_by` varchar(100) DEFAULT NULL,
  `changed_by_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_versions_menu_id_version_number_index` (`menu_id`,`version_number`),
  KEY `menu_versions_menu_id_created_at_index` (`menu_id`,`created_at`),
  CONSTRAINT `menu_versions_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_versions`
--

LOCK TABLES `menu_versions` WRITE;
/*!40000 ALTER TABLE `menu_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `menu_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `slug` varchar(100) NOT NULL,
  `location` enum('client_sidebar','client_topnav','client_avatar_dropdown','client_footer','client_mobile_bottom','frontend_header','frontend_footer','frontend_footer_legal','frontend_footer_company','frontend_footer_resources') NOT NULL,
  `description` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `order` int(11) NOT NULL DEFAULT 0,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`),
  KEY `menus_location_is_active_index` (`location`,`is_active`),
  KEY `menus_location_index` (`location`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (15,'Client Sidebar','client-sidebar','client_sidebar','Main navigation menu for client area sidebar',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(16,'Client Top Navigation','client-topnav','client_topnav','Horizontal navigation for client area top bar',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(17,'User Avatar Dropdown','client-avatar-dropdown','client_avatar_dropdown','Dropdown menu when clicking user avatar',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(18,'Client Footer','client-footer','client_footer','Footer links in client area',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(19,'Mobile Bottom Navigation','client-mobile-bottom','client_mobile_bottom','Fixed bottom navigation bar for mobile devices',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(20,'Main Navigation','main-navigation','frontend_header','Main navigation menu for public website',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(21,'Frontend Footer','frontend-footer','frontend_footer','Footer navigation for public website',1,0,1,NULL,'2026-01-20 15:15:49','2026-01-20 15:15:49'),(22,'Footer Menu Links','footer-menu-links','frontend_footer_company',NULL,1,0,2,NULL,'2026-01-21 18:25:42','2026-01-21 18:25:42');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'0001_01_01_000002_create_jobs_table',1),(3,'2024_01_01_000001_create_roles_table',1),(4,'2024_01_01_000002_create_permissions_table',1),(5,'2024_01_01_000003_create_permission_role_table',1),(6,'2024_01_01_000004_create_admins_table',1),(7,'2024_01_01_000005_create_admin_notifications_table',1),(8,'2024_01_01_000006_create_admin_password_resets_table',1),(9,'2024_01_01_000007_create_users_table',1),(10,'2024_01_01_000008_create_user_logins_table',1),(11,'2024_01_01_000009_create_password_resets_table',1),(12,'2024_01_01_000010_create_general_settings_table',1),(13,'2024_01_01_000011_create_billing_settings_table',1),(14,'2024_01_01_000012_create_service_categories_table',1),(15,'2024_01_01_000013_create_server_groups_table',1),(16,'2024_01_01_000014_create_servers_table',1),(17,'2024_01_01_000015_create_products_table',1),(18,'2024_01_01_000016_create_pricings_table',1),(19,'2024_01_01_000017_create_configurable_groups_table',1),(20,'2024_01_01_000018_create_configurable_group_options_table',1),(21,'2024_01_01_000019_create_configurable_group_sub_options_table',1),(22,'2024_01_01_000020_create_product_configurations_table',1),(23,'2024_01_01_000021_create_domain_registers_table',1),(24,'2024_01_01_000022_create_domain_setups_table',1),(25,'2024_01_01_000023_create_domain_pricings_table',1),(26,'2024_01_01_000024_create_orders_table',1),(27,'2024_01_01_000025_create_invoices_table',1),(28,'2024_01_01_000026_create_invoice_items_table',1),(29,'2024_01_01_000027_create_hostings_table',1),(30,'2024_01_01_000028_create_hosting_configs_table',1),(31,'2024_01_01_000029_create_domains_table',1),(32,'2024_01_01_000030_create_gateways_table',1),(33,'2024_01_01_000031_create_gateway_currencies_table',1),(34,'2024_01_01_000032_create_deposits_table',1),(35,'2024_01_01_000033_create_transactions_table',1),(36,'2024_01_01_000034_create_coupons_table',1),(37,'2024_01_01_000035_create_shopping_carts_table',1),(38,'2024_01_01_000036_create_support_tickets_table',1),(39,'2024_01_01_000037_create_support_messages_table',1),(40,'2024_01_01_000038_create_support_attachments_table',1),(41,'2024_01_01_000039_create_notification_templates_table',1),(42,'2024_01_01_000040_create_notification_logs_table',1),(43,'2024_01_01_000041_create_device_tokens_table',1),(44,'2024_01_01_000042_create_languages_table',1),(45,'2024_01_01_000043_create_frontends_table',1),(46,'2024_01_01_000044_create_pages_table',1),(47,'2024_01_01_000046_create_forms_table',1),(48,'2024_01_01_000047_create_cron_jobs_table',1),(49,'2024_01_01_000048_create_cron_schedules_table',1),(50,'2024_01_01_000049_create_cron_job_logs_table',1),(51,'2024_01_01_000050_create_cancel_requests_table',1),(52,'2024_01_01_000051_create_subscribers_table',1),(53,'2024_01_01_000052_create_update_logs_table',1),(54,'2024_01_01_000053_create_sessions_table',1),(55,'2024_12_03_000001_add_registrar_fields_to_domains_table',1),(56,'2025_12_02_232200_add_image_to_gateways_table',1),(57,'2025_12_03_000001_add_sent_from_fields_to_notification_templates_table',1),(58,'2025_12_03_170311_add_image_to_languages_table',1),(59,'2025_12_04_000001_update_cron_tables_for_automation',1),(60,'2025_12_04_100001_add_resolved_columns_to_cron_job_logs',1),(61,'2025_12_04_103727_add_client_area_settings_to_general_settings_table',1),(62,'2025_12_04_173351_add_social_login_fields_to_users_table',1),(63,'2025_12_05_033509_fix_users_without_username',1),(64,'2025_12_05_100001_add_hosting_id_to_shopping_carts_table',1),(65,'2025_12_05_100002_add_is_locked_to_domains_table',1),(66,'2025_12_05_120001_add_upgrade_group_to_products_table',1),(67,'2025_12_05_120002_add_upgrade_data_to_invoices_table',1),(68,'2025_12_05_191901_add_missing_columns_to_deposits_table',1),(69,'2025_12_05_205510_add_company_details_to_billing_settings_table',1),(70,'2025_12_06_100001_add_enhanced_fields_to_service_categories_table',1),(71,'2025_12_06_100002_add_enhanced_fields_to_products_table',1),(72,'2025_12_06_100003_create_product_features_table',1),(73,'2025_12_06_100004_add_performance_indexes',1),(74,'2025_12_06_100008_create_domain_features_table',1),(75,'2025_12_06_150001_add_discount_fields_to_pricings_table',1),(76,'2025_12_06_150002_add_plan_enhancement_fields_to_products_table',1),(77,'2025_12_06_150003_enhance_product_features_table',1),(78,'2025_12_07_000001_create_affiliate_commissions_table',1),(79,'2025_12_07_000001_drop_theme_engine_tables',1),(80,'2025_12_07_000002_add_affiliate_settings_to_general_settings_table',1),(81,'2025_12_07_000003_create_affiliate_payouts_table',1),(82,'2025_12_07_100001_add_additional_affiliate_settings_to_general_settings_table',1),(83,'2025_12_07_100002_add_tax_settings_to_general_settings_table',1),(84,'2025_12_07_200001_fix_notification_tables',1),(85,'2025_12_07_200002_create_module_logs_table',1),(86,'2025_12_07_200003_add_automation_fields_to_billing_settings',1),(87,'2025_12_07_200004_add_fraud_fields_to_orders',1),(88,'2025_12_07_200005_create_payment_methods_table',1),(89,'2025_12_07_300001_add_kyc_fields_to_users_table',1),(90,'2025_12_07_400001_add_advanced_fields_to_cron_jobs_table',1),(91,'2025_12_07_500001_add_dependencies_to_cron_jobs_table',1),(92,'2025_12_07_600001_create_ticket_categories_table',1),(93,'2025_12_07_600002_create_canned_responses_table',1),(94,'2025_12_07_600003_enhance_support_tickets_table',1),(95,'2025_12_07_600004_enhance_support_messages_table',1),(96,'2025_12_07_600005_enhance_support_attachments_table',1),(97,'2025_12_07_600006_add_ticket_settings_to_general_settings_table',1),(98,'2025_12_08_000001_create_user_notifications_table',1),(99,'2025_12_09_000001_create_menus_table',1),(100,'2025_12_09_000002_create_menu_items_table',1),(101,'2025_12_09_000003_create_social_links_table',1),(102,'2025_12_09_000004_populate_default_menus',1),(103,'2025_12_09_100001_create_menu_versions_table',1),(104,'2025_12_24_010518_create_kb_categories_table',1),(105,'2025_12_24_010521_create_kb_articles_table',1),(106,'2025_12_24_011500_create_addons_table',1),(107,'2025_12_24_011500_create_product_addons_table',1),(108,'2025_12_24_011501_create_hosting_addons_table',1),(109,'2025_12_24_011550_add_addon_id_to_pricing_table',1),(110,'2025_12_24_034859_add_features_to_service_categories_table',1),(111,'2026_01_19_102001_add_retry_fields_to_notification_logs_table',1),(112,'2026_01_19_102759_add_code_column_to_admin_password_resets_table',1),(113,'2026_01_19_104112_add_tracking_fields_to_admin_password_resets_table',1),(114,'2026_01_19_113744_add_two_factor_fields_to_admins_table',1),(115,'2026_01_19_130138_change_welcome_email_to_string_in_products_table',1),(116,'2026_01_19_155510_add_assigned_accounts_to_servers_table',1),(117,'2026_01_20_215443_create_category_features_table',1),(118,'2026_01_20_215455_add_category_feature_id_to_product_features_table',1),(119,'2026_01_21_204129_create_domain_categories_table',1),(120,'2026_01_21_204130_add_category_id_to_domain_setups_table',1),(121,'2026_01_23_085420_add_page_id_to_service_categories_table',1),(122,'2026_01_23_090624_add_auto_created_to_pages_table',1),(123,'2026_01_23_090652_add_auto_created_to_pages_table',1),(124,'2026_01_26_190535_create_default_kb_page',1),(125,'2026_01_26_191632_add_feedback_counts_to_kb_articles_table',1),(126,'2026_01_26_211142_add_livechat_settings_to_general_settings',1),(127,'2026_01_27_104323_add_livechat_color_to_general_settings',1),(128,'2026_01_28_010050_add_transfer_fields_to_domains_table',1),(129,'2026_01_28_094618_add_plesk_ids_to_hostings_table',1),(130,'2026_01_28_141922_add_load_balancing_fields_to_servers_table',1),(131,'2026_02_01_114911_create_bkash_tokens_table',1),(132,'2026_02_01_131545_add_coupon_id_to_hostings_table',1),(133,'2026_02_01_134352_drop_extensions_table',1),(134,'2026_02_03_091135_create_system_registrations_table',1),(135,'2026_02_03_103345_add_degradation_columns_to_system_registrations',1),(136,'2026_02_03_103749_create_license_overrides_table',1),(137,'2026_02_03_104835_add_secret_key_to_system_registrations',1),(138,'2026_02_04_112553_rename_license_tables_to_capabilities',1),(139,'2026_02_04_131355_add_expires_at_to_system_registrations_table',1),(140,'2026_02_07_080820_create_settings_table',2),(142,'2026_02_07_094905_add_last_sync_at_to_domains_table',3),(143,'2026_02_07_add_performance_indexes',3),(144,'2026_02_12_073249_add_session_id_to_shopping_carts_table',4),(145,'2026_02_12_073739_normalize_support_messages_admin_id',5),(146,'2026_02_12_150535_add_exchange_rate_settings_to_general_settings',6),(147,'2026_02_21_224500_add_store_settings_to_general_settings',7),(149,'2026_02_25_220000_add_soft_deletes_to_financial_models',8),(150,'2026_02_25_221000_add_missing_indexes_to_financial_tables',8);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `module_logs`
--

DROP TABLE IF EXISTS `module_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `module_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `hosting_id` bigint(20) unsigned DEFAULT NULL,
  `domain_id` bigint(20) unsigned DEFAULT NULL,
  `module_type` varchar(50) NOT NULL,
  `module_name` varchar(100) DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `status` enum('pending','success','failed','retrying') NOT NULL DEFAULT 'pending',
  `request_data` text DEFAULT NULL,
  `response_data` text DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `retry_count` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `max_retries` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `next_retry_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module_logs_user_id_index` (`user_id`),
  KEY `module_logs_hosting_id_index` (`hosting_id`),
  KEY `module_logs_domain_id_index` (`domain_id`),
  KEY `module_logs_status_index` (`status`),
  KEY `module_logs_module_type_index` (`module_type`),
  KEY `module_logs_next_retry_at_index` (`next_retry_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `module_logs`
--

LOCK TABLES `module_logs` WRITE;
/*!40000 ALTER TABLE `module_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `module_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification_logs`
--

DROP TABLE IF EXISTS `notification_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `sender` varchar(40) DEFAULT NULL,
  `sent_to` varchar(40) DEFAULT NULL,
  `sent_from` varchar(40) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `notification_type` varchar(40) DEFAULT NULL COMMENT 'email, sms, push',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `template_code` varchar(50) DEFAULT NULL,
  `is_sent` tinyint(1) NOT NULL DEFAULT 1,
  `error_message` text DEFAULT NULL,
  `retry_count` int(11) NOT NULL DEFAULT 0,
  `last_retry_at` timestamp NULL DEFAULT NULL,
  `queued_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notification_logs_is_sent_index` (`is_sent`),
  KEY `notification_logs_template_code_index` (`template_code`),
  KEY `idx_notification_logs_created_at` (`created_at`),
  KEY `idx_notification_logs_user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification_logs`
--

LOCK TABLES `notification_logs` WRITE;
/*!40000 ALTER TABLE `notification_logs` DISABLE KEYS */;
INSERT INTO `notification_logs` VALUES (1,9,NULL,NULL,NULL,'Your Account has been Credited','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>$1,000.00 USD</strong> has been added to your account.</p>\n<p><strong>Transaction Number:</strong> V1M1GK6Q18YC</p>\n<p><strong>Your Current Balance:</strong> $1,000.00 USD</p>\n<p><strong>Admin Note:</strong> admin</p>\n</div>','email','2026-02-13 00:56:04','2026-02-13 00:56:04','BAL_ADD',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(4,9,NULL,NULL,NULL,'New Invoice #2','<div style=\"font-family: Arial, sans-serif;\">\n<p>A new invoice has been generated for your account.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #2</li>\n<li><strong>Amount:</strong> $107.78 USD</li>\n<li><strong>Due Date:</strong> 19/02/2026</li>\n</ul>\n<p>View and pay your invoice: <a href=\"http://127.0.0.1:8000/client/invoices/2\">http://127.0.0.1:8000/client/invoices/2</a></p>\n</div>','email','2026-02-13 01:01:21','2026-02-13 01:01:21','INVOICE_CREATED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(5,9,NULL,NULL,NULL,'Payment Received - Invoice #2','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you! Your payment has been received.</p>\n<h4>Payment Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #2</li>\n<li><strong>Amount Paid:</strong> $107.78 USD</li>\n<li><strong>Payment Method:</strong> Account Balance</li>\n<li><strong>Transaction ID:</strong> INV-2</li>\n</ul>\n</div>','email','2026-02-13 01:01:21','2026-02-13 01:01:21','INVOICE_PAID',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(6,9,NULL,NULL,NULL,'New Order Notification #4','<div style=\"font-family: Arial, sans-serif;\">\n<h4>Order Information</h4>\n<ul>\n<li><strong>Order ID:</strong> #4</li>\n<li><strong>Date/Time:</strong> 2026-02-12 08:01 PM</li>\n<li><strong>Invoice Id:</strong> #2</li>\n<li><strong>Amount:</strong> $107.78 USD</li>\n</ul>\n\n<h4>Customer Information</h4>\n<ul>\n<li><strong>Name:</strong> NICK DOMINICK</li>\n<li><strong>Email:</strong> mpanduji.dominicK@gmail.com</li>\n<li><strong>Address:</strong> </li>\n<li><strong>City:</strong> </li>\n<li><strong>State:</strong> </li>\n<li><strong>Postcode:</strong> </li>\n<li><strong>Country:</strong> </li>\n<li><strong>Phone:</strong> 745982704</li>\n</ul>\n\n<h4>Order Items</h4>\n<div></div>\n\n<p><strong>Client IP:</strong> 127.0.0.1</p>\n</div>','email','2026-02-13 01:01:21','2026-02-13 01:01:21','ORDER_NOTIFICATION',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(7,9,NULL,NULL,NULL,'New Invoice #3','<div style=\"font-family: Arial, sans-serif;\">\n<p>A new invoice has been generated for your account.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #3</li>\n<li><strong>Amount:</strong> $3.99 USD</li>\n<li><strong>Due Date:</strong> 19/02/2026</li>\n</ul>\n<p>View and pay your invoice: <a href=\"http://127.0.0.1:8000/client/invoices/3\">http://127.0.0.1:8000/client/invoices/3</a></p>\n</div>','email','2026-02-13 02:23:14','2026-02-13 02:23:14','INVOICE_CREATED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(8,9,NULL,NULL,NULL,'Payment Received - Invoice #3','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you! Your payment has been received.</p>\n<h4>Payment Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #3</li>\n<li><strong>Amount Paid:</strong> $3.99 USD</li>\n<li><strong>Payment Method:</strong> Account Balance</li>\n<li><strong>Transaction ID:</strong> INV-3</li>\n</ul>\n</div>','email','2026-02-13 02:23:14','2026-02-13 02:23:14','INVOICE_PAID',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(9,9,NULL,NULL,NULL,'New Order Notification #5','<div style=\"font-family: Arial, sans-serif;\">\n<h4>Order Information</h4>\n<ul>\n<li><strong>Order ID:</strong> #5</li>\n<li><strong>Date/Time:</strong> 2026-02-12 09:23 PM</li>\n<li><strong>Invoice Id:</strong> #3</li>\n<li><strong>Amount:</strong> $3.99 USD</li>\n</ul>\n\n<h4>Customer Information</h4>\n<ul>\n<li><strong>Name:</strong> NICK DOMINICK</li>\n<li><strong>Email:</strong> mpanduji.dominicK@gmail.com</li>\n<li><strong>Address:</strong> </li>\n<li><strong>City:</strong> </li>\n<li><strong>State:</strong> </li>\n<li><strong>Postcode:</strong> </li>\n<li><strong>Country:</strong> </li>\n<li><strong>Phone:</strong> 745982704</li>\n</ul>\n\n<h4>Order Items</h4>\n<div></div>\n\n<p><strong>Client IP:</strong> 127.0.0.1</p>\n</div>','email','2026-02-13 02:23:14','2026-02-13 02:23:14','ORDER_NOTIFICATION',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(10,9,NULL,NULL,NULL,'New Invoice #4','<div style=\"font-family: Arial, sans-serif;\">\n<p>A new invoice has been generated for your account.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #4</li>\n<li><strong>Amount:</strong> TSh134.73 TZS</li>\n<li><strong>Due Date:</strong> 28/02/2026</li>\n</ul>\n<p>View and pay your invoice: <a href=\"http://127.0.0.1:8000/client/invoices/4\">http://127.0.0.1:8000/client/invoices/4</a></p>\n</div>','email','2026-02-21 12:34:30','2026-02-21 12:34:30','INVOICE_CREATED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(11,9,NULL,NULL,NULL,'Payment Received - Invoice #4','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you! Your payment has been received.</p>\n<h4>Payment Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #4</li>\n<li><strong>Amount Paid:</strong> TSh134.73 TZS</li>\n<li><strong>Payment Method:</strong> Account Balance</li>\n<li><strong>Transaction ID:</strong> INV-4</li>\n</ul>\n</div>','email','2026-02-21 12:34:30','2026-02-21 12:34:30','INVOICE_PAID',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(12,9,NULL,NULL,NULL,'New Order Notification #6','<div style=\"font-family: Arial, sans-serif;\">\n<h4>Order Information</h4>\n<ul>\n<li><strong>Order ID:</strong> #6</li>\n<li><strong>Date/Time:</strong> 2026-02-21 07:34 AM</li>\n<li><strong>Invoice Id:</strong> #4</li>\n<li><strong>Amount:</strong> TSh134.73 TZS</li>\n</ul>\n\n<h4>Customer Information</h4>\n<ul>\n<li><strong>Name:</strong> NICK DOMINICK</li>\n<li><strong>Email:</strong> mpanduji.dominicK@gmail.com</li>\n<li><strong>Address:</strong> </li>\n<li><strong>City:</strong> </li>\n<li><strong>State:</strong> </li>\n<li><strong>Postcode:</strong> </li>\n<li><strong>Country:</strong> </li>\n<li><strong>Phone:</strong> 745982704</li>\n</ul>\n\n<h4>Order Items</h4>\n<div></div>\n\n<p><strong>Client IP:</strong> 127.0.0.1</p>\n</div>','email','2026-02-21 12:34:30','2026-02-21 12:34:30','ORDER_NOTIFICATION',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(13,9,NULL,NULL,NULL,'[Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>Thank you for contacting our support team. Your ticket has been created successfully.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Category:</strong> General Support</li>\n</ul>\n<p>Our support team will review your request and respond as soon as possible.</p>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket</a></p>\n</div>','email','2026-02-21 12:39:05','2026-02-21 12:39:05','TICKET_CREATED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(14,9,NULL,NULL,NULL,'Re: [Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #474909] hello</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\nWe haven\'t heard back from you regarding this ticket.\n\nAs we haven\'t received a response, we will be closing this ticket. If you still need assistance, please feel free to open a new ticket or reply to this one to reopen it.\n\nThank you for choosing us!\n\nBest regards,\nSupport Team\n</div>\n<hr>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>','email','2026-02-21 12:40:01','2026-02-21 12:40:01','ADMIN_SUPPORT_REPLY',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(15,9,NULL,NULL,NULL,'Re: [Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #474909] hello</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\nPlease try clearing your browser cache and cookies:\n\n1. Press Ctrl + Shift + Delete (Cmd + Shift + Delete on Mac)\n2. Select \'All time\' for the time range\n3. Check \'Cached images and files\' and \'Cookies\'\n4. Click \'Clear data\'\n5. Refresh the page and try again\n\nIf the issue persists, please let us know.\n\nBest regards,\nSupport Team\n</div>\n<hr>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>','email','2026-02-21 12:46:19','2026-02-21 12:46:19','ADMIN_SUPPORT_REPLY',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(16,9,NULL,NULL,NULL,'[Ticket #474909] Ticket Closed','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>Your support ticket has been closed.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Closed By:</strong> Super</li>\n</ul>\n<p>If you need further assistance, you can reopen this ticket or create a new one.</p>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket</a></p>\n</div>','email','2026-02-21 12:51:07','2026-02-21 12:51:07','TICKET_CLOSED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(17,9,NULL,NULL,NULL,'[Ticket #474909] Ticket Closed','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>Your support ticket has been closed.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Closed By:</strong> Super</li>\n</ul>\n<p>If you need further assistance, you can reopen this ticket or create a new one.</p>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket</a></p>\n</div>','email','2026-02-21 12:51:15','2026-02-21 12:51:15','TICKET_CLOSED',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(18,9,NULL,NULL,NULL,'Re: [Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #474909] hello</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\nabout what my client\n\n</div>\n<hr>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>','email','2026-02-21 12:52:09','2026-02-21 12:52:09','ADMIN_SUPPORT_REPLY',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(19,9,NULL,NULL,NULL,'Re: [Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #474909] hello</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\nGreat news! The issue you reported has been resolved.\n\nPlease verify that everything is working correctly on your end. If you encounter any further issues or have additional questions, don\'t hesitate to reach out.\n\nWe appreciate your patience and understanding.\n\nBest regards,\nSupport Team\n</div>\n<hr>\n<p><a href=\"http://127.0.0.1:8000/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>','email','2026-02-21 12:52:46','2026-02-21 12:52:46','ADMIN_SUPPORT_REPLY',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(20,9,NULL,NULL,NULL,'Re: [Ticket #474909] hello','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear NICK DOMINICK,</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #474909] hello</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\nPlease try clearing your browser cache and cookies:\n\n1. Press Ctrl + Shift + Delete (Cmd + Shift + Delete on Mac)\n2. Select \'All time\' for the time range\n3. Check \'Cached images and files\' and \'Cookies\'\n4. Click \'Clear data\'\n5. Refresh the page and try again\n\nIf the issue persists, please let us know.\n\nBest regards,\nSupport Team\n</div>\n<hr>\n<p><a href=\"https://salieno.test/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>','email','2026-02-22 05:59:54','2026-02-22 05:59:54','ADMIN_SUPPORT_REPLY',1,NULL,0,NULL,NULL),(21,9,NULL,NULL,NULL,'Deposit Request Submitted Successfully','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit request of <strong>10.00 USD</strong> via <strong>Bank Transfer USD</strong> has been submitted successfully.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Amount:</strong> 10.00 USD</li>\n<li><strong>Charge:</strong> 0.00 USD</li>\n<li><strong>Conversion Rate:</strong> 1 USD = 0.00 USD</li>\n<li><strong>Payable:</strong> 0.00 USD</li>\n<li><strong>Pay via:</strong> Bank Transfer USD</li>\n<li><strong>Transaction Number:</strong> G6TC1O8XNYNZ</li>\n</ul>\n<p>Please wait for admin approval.</p>\n</div>','email','2026-02-22 07:21:57','2026-02-22 07:21:57','DEPOSIT_REQUEST',1,NULL,0,NULL,NULL),(22,9,NULL,NULL,NULL,'Deposit Request Submitted Successfully','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit request of <strong>100.00 USD</strong> via <strong>Bank Transfer USD</strong> has been submitted successfully.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Amount:</strong> 100.00 USD</li>\n<li><strong>Charge:</strong> 0.00 USD</li>\n<li><strong>Conversion Rate:</strong> 1 USD = 0.00 USD</li>\n<li><strong>Payable:</strong> 0.04 USD</li>\n<li><strong>Pay via:</strong> Bank Transfer USD</li>\n<li><strong>Transaction Number:</strong> R2V9NA6YCS9R</li>\n</ul>\n<p>Please wait for admin approval.</p>\n</div>','email','2026-02-22 07:24:12','2026-02-22 07:24:12','DEPOSIT_REQUEST',1,NULL,0,NULL,NULL),(23,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 18:59:04','2026-02-25 18:59:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(24,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:05:04','2026-02-25 19:05:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(25,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:12:03','2026-02-25 19:12:03','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(26,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:18:04','2026-02-25 19:18:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(27,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:24:04','2026-02-25 19:24:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(28,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:30:05','2026-02-25 19:30:05','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(29,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:37:04','2026-02-25 19:37:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(30,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:43:04','2026-02-25 19:43:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(31,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:50:04','2026-02-25 19:50:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(32,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 19:57:03','2026-02-25 19:57:03','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(33,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:03:03','2026-02-25 20:03:03','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(34,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:09:04','2026-02-25 20:09:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(35,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:15:04','2026-02-25 20:15:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(36,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:21:04','2026-02-25 20:21:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(37,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:28:04','2026-02-25 20:28:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(38,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:34:04','2026-02-25 20:34:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(39,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:40:04','2026-02-25 20:40:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(40,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:46:05','2026-02-25 20:46:05','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL),(41,9,NULL,NULL,NULL,'[Reminder] Ticket #474909 Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #474909</li>\n<li><strong>Subject:</strong> hello</li>\n<li><strong>Priority:</strong> Medium</li>\n<li><strong>Customer:</strong> NICK DOMINICK</li>\n<li><strong>Waiting Since:</strong> 3 days ago</li>\n</ul>\n<p><a href=\"https://demo.salieno.com/client/tickets/474909\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>','email','2026-02-25 20:53:04','2026-02-25 20:53:04','TICKET_STALE_REMINDER',0,'Connection to \"process /usr/sbin/sendmail -bs -i\" has been closed unexpectedly.',0,NULL,NULL);
/*!40000 ALTER TABLE `notification_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notification_templates`
--

DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `act` varchar(40) DEFAULT NULL COMMENT 'Action code',
  `name` varchar(40) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `email_sent_from_name` varchar(255) DEFAULT NULL,
  `email_sent_from_address` varchar(255) DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sms_sent_from` varchar(40) DEFAULT NULL,
  `push_body` text DEFAULT NULL,
  `push_title` varchar(255) DEFAULT NULL,
  `shortcodes` text DEFAULT NULL COMMENT 'JSON available shortcodes',
  `email_status` tinyint(1) NOT NULL DEFAULT 1,
  `sms_status` tinyint(1) NOT NULL DEFAULT 0,
  `push_status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notification_templates`
--

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,'BAL_ADD','Balance - Added','Your Account has been Credited','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>{{amount}} {{site_currency}}</strong> has been added to your account.</p>\n<p><strong>Transaction Number:</strong> {{trx}}</p>\n<p><strong>Your Current Balance:</strong> {{post_balance}} {{site_currency}}</p>\n<p><strong>Admin Note:</strong> {{remark}}</p>\n</div>',NULL,NULL,'{{amount}} {{site_currency}} credited to your account. Balance: {{post_balance}} {{site_currency}}. Trx: #{{trx}}. Note: {{remark}}',NULL,'{{amount}} {{site_currency}} added to your account','Balance Added','{\"trx\":\"Transaction number\",\"amount\":\"Amount added by admin\",\"remark\":\"Remark by admin\",\"post_balance\":\"Balance after transaction\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(2,'BAL_SUB','Balance - Subtracted','Your Account has been Debited','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>{{amount}} {{site_currency}}</strong> has been subtracted from your account.</p>\n<p><strong>Transaction Number:</strong> {{trx}}</p>\n<p><strong>Your Current Balance:</strong> {{post_balance}} {{site_currency}}</p>\n<p><strong>Admin Note:</strong> {{remark}}</p>\n</div>',NULL,NULL,'{{amount}} {{site_currency}} debited from your account. Balance: {{post_balance}} {{site_currency}}. Trx: #{{trx}}. Note: {{remark}}',NULL,'{{amount}} {{site_currency}} deducted from your account','Balance Deducted','{\"trx\":\"Transaction number\",\"amount\":\"Amount subtracted by admin\",\"remark\":\"Remark by admin\",\"post_balance\":\"Balance after transaction\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(3,'DEPOSIT_COMPLETE','Deposit - Automated - Successful','Deposit Completed Successfully','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit of <strong>{{amount}} {{site_currency}}</strong> via <strong>{{method_name}}</strong> has been completed successfully.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Charge:</strong> {{charge}} {{site_currency}}</li>\n<li><strong>Conversion Rate:</strong> 1 {{site_currency}} = {{rate}} {{method_currency}}</li>\n<li><strong>Received:</strong> {{method_amount}} {{method_currency}}</li>\n<li><strong>Paid via:</strong> {{method_name}}</li>\n<li><strong>Transaction Number:</strong> {{trx}}</li>\n</ul>\n<p style=\"font-size: 18px;\"><strong>Your current balance is {{post_balance}} {{site_currency}}</strong></p>\n</div>',NULL,NULL,'{{amount}} {{site_currency}} deposited successfully via {{method_name}}. Balance: {{post_balance}} {{site_currency}}. Trx: {{trx}}',NULL,'Deposit of {{amount}} {{site_currency}} completed','Deposit Successful','{\"trx\":\"Transaction number\",\"amount\":\"Deposit amount\",\"charge\":\"Gateway charge\",\"rate\":\"Conversion rate\",\"method_name\":\"Payment method name\",\"method_currency\":\"Payment method currency\",\"method_amount\":\"Amount in method currency\",\"post_balance\":\"Balance after deposit\"}',1,1,0,'2025-12-19 15:45:03','2026-01-20 12:48:56'),(4,'DEPOSIT_APPROVE','Deposit - Manual - Approved','Your Deposit is Approved','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit request of <strong>{{amount}} {{site_currency}}</strong> via <strong>{{method_name}}</strong> has been approved.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Charge:</strong> {{charge}} {{site_currency}}</li>\n<li><strong>Conversion Rate:</strong> 1 {{site_currency}} = {{rate}} {{method_currency}}</li>\n<li><strong>Received:</strong> {{method_amount}} {{method_currency}}</li>\n<li><strong>Paid via:</strong> {{method_name}}</li>\n<li><strong>Transaction Number:</strong> {{trx}}</li>\n</ul>\n<p style=\"font-size: 18px;\"><strong>Your current balance is {{post_balance}} {{site_currency}}</strong></p>\n</div>',NULL,NULL,'Admin approved your {{amount}} {{site_currency}} deposit via {{method_name}}. Trx: {{trx}}',NULL,'Deposit of {{amount}} {{site_currency}} approved','Deposit Approved','{\"trx\":\"Transaction number\",\"amount\":\"Deposit amount\",\"charge\":\"Gateway charge\",\"rate\":\"Conversion rate\",\"method_name\":\"Payment method name\",\"method_currency\":\"Payment method currency\",\"method_amount\":\"Amount in method currency\",\"post_balance\":\"Balance after deposit\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(5,'DEPOSIT_REJECT','Deposit - Manual - Rejected','Your Deposit Request is Rejected','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit request of <strong>{{amount}} {{site_currency}}</strong> via <strong>{{method_name}}</strong> has been rejected.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Conversion Rate:</strong> 1 {{site_currency}} = {{rate}} {{method_currency}}</li>\n<li><strong>Amount:</strong> {{method_amount}} {{method_currency}}</li>\n<li><strong>Paid via:</strong> {{method_name}}</li>\n<li><strong>Charge:</strong> {{charge}} {{site_currency}}</li>\n<li><strong>Transaction Number:</strong> {{trx}}</li>\n</ul>\n<p style=\"color: #dc2626;\"><strong>Rejection Reason:</strong> {{rejection_message}}</p>\n<p>If you have any queries, feel free to contact us.</p>\n</div>',NULL,NULL,'Admin rejected your {{amount}} {{site_currency}} deposit via {{method_name}}. Reason: {{rejection_message}}',NULL,'Deposit request rejected','Deposit Rejected','{\"trx\":\"Transaction number\",\"amount\":\"Deposit amount\",\"charge\":\"Gateway charge\",\"rate\":\"Conversion rate\",\"method_name\":\"Payment method name\",\"method_currency\":\"Payment method currency\",\"method_amount\":\"Amount in method currency\",\"rejection_message\":\"Rejection reason by admin\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(6,'DEPOSIT_REQUEST','Deposit - Manual - Requested','Deposit Request Submitted Successfully','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your deposit request of <strong>{{amount}} {{site_currency}}</strong> via <strong>{{method_name}}</strong> has been submitted successfully.</p>\n<h4>Deposit Details:</h4>\n<ul>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Charge:</strong> {{charge}} {{site_currency}}</li>\n<li><strong>Conversion Rate:</strong> 1 {{site_currency}} = {{rate}} {{method_currency}}</li>\n<li><strong>Payable:</strong> {{method_amount}} {{method_currency}}</li>\n<li><strong>Pay via:</strong> {{method_name}}</li>\n<li><strong>Transaction Number:</strong> {{trx}}</li>\n</ul>\n<p>Please wait for admin approval.</p>\n</div>',NULL,NULL,'{{amount}} {{site_currency}} deposit requested via {{method_name}}. Charge: {{charge}}. Trx: {{trx}}',NULL,'Deposit request submitted','Deposit Requested','{\"trx\":\"Transaction number\",\"amount\":\"Deposit amount\",\"charge\":\"Gateway charge\",\"rate\":\"Conversion rate\",\"method_name\":\"Payment method name\",\"method_currency\":\"Payment method currency\",\"method_amount\":\"Amount in method currency\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(7,'PASS_RESET_CODE','Password - Reset - Code','Password Reset Request','<div style=\"font-family: Arial, sans-serif;\">\n<p>We have received a request to reset the password for your account on <strong>{{time}}</strong>.</p>\n<p><strong>Requested From IP:</strong> {{ip}} using <strong>{{browser}}</strong> on <strong>{{operating_system}}</strong>.</p>\n<p style=\"font-size: 18px;\">Your account recovery code is: <strong style=\"font-size: 24px;\">{{code}}</strong></p>\n<p style=\"color: #dc2626;\"><strong>If you did not request this, please disregard this message.</strong></p>\n</div>',NULL,NULL,'Your password reset code is: {{code}}',NULL,'Password reset code: {{code}}','Password Reset','{\"code\":\"Verification code for password reset\",\"ip\":\"IP address of the user\",\"browser\":\"Browser of the user\",\"operating_system\":\"Operating system of the user\",\"time\":\"Time of the request\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(8,'PASS_RESET_DONE','Password - Reset - Confirmation','You have reset your password','<div style=\"font-family: Arial, sans-serif;\">\n<p>You have successfully reset your password.</p>\n<p>You changed from IP: <strong>{{ip}}</strong> using <strong>{{browser}}</strong> on <strong>{{operating_system}}</strong> at <strong>{{time}}</strong>.</p>\n<p style=\"color: #dc2626;\"><strong>If you did not make this change, please contact us immediately.</strong></p>\n</div>',NULL,NULL,'Your password has been changed successfully.',NULL,'Password changed successfully','Password Changed','{\"ip\":\"IP address of the user\",\"browser\":\"Browser of the user\",\"operating_system\":\"Operating system of the user\",\"time\":\"Time of the request\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(9,'EVER_CODE','Verification - Email','Please verify your email address','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thanks for joining us!</p>\n<p>Please use the code below to verify your email address:</p>\n<p style=\"font-size: 24px; font-weight: bold; color: #4f46e5;\">{{code}}</p>\n</div>',NULL,NULL,'---',NULL,NULL,NULL,'{\"code\":\"Email verification code\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(10,'SVER_CODE','Verification - SMS','Verify Your Mobile Number','---',NULL,NULL,'Your phone verification code is: {{code}}',NULL,NULL,NULL,'{\"code\":\"SMS Verification Code\"}',0,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(11,'TICKET_CREATED','Support Ticket Created','[Ticket #{{ticket_id}}] {{ticket_subject}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>Thank you for contacting our support team. Your ticket has been created successfully.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Priority:</strong> {{ticket_priority}}</li>\n<li><strong>Category:</strong> {{ticket_category}}</li>\n</ul>\n<p>Our support team will review your request and respond as soon as possible.</p>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket</a></p>\n</div>',NULL,NULL,'Ticket #{{ticket_id}} created: {{ticket_subject}}. We will respond shortly.',NULL,'Ticket #{{ticket_id}} created successfully','Support Ticket Created','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"ticket_priority\":\"Priority level (Low, Medium, High, Critical)\",\"ticket_category\":\"Category of the ticket\",\"ticket_link\":\"URL to view the ticket\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(12,'ADMIN_SUPPORT_REPLY','Support - Reply','Re: [Ticket #{{ticket_id}}] {{ticket_subject}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>A member from our support team has replied to your ticket:</p>\n<p><strong>[Ticket #{{ticket_id}}] {{ticket_subject}}</strong></p>\n<hr>\n<div style=\"background-color: #f5f5f5; padding: 15px; border-radius: 5px; margin: 15px 0;\">\n{{reply}}\n</div>\n<hr>\n<p><a href=\"{{link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View & Reply</a></p>\n</div>',NULL,NULL,'Your Ticket #{{ticket_id}}: {{ticket_subject}} has been replied.',NULL,'New reply on ticket #{{ticket_id}}','Support Ticket Reply','{\"ticket_id\":\"ID of the support ticket\",\"ticket_subject\":\"Subject of the support ticket\",\"reply\":\"Reply made by the admin\",\"link\":\"URL to view the support ticket\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(13,'TICKET_CLOSED','Support Ticket Closed','[Ticket #{{ticket_id}}] Ticket Closed','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>Your support ticket has been closed.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Closed By:</strong> {{closed_by}}</li>\n</ul>\n<p>If you need further assistance, you can reopen this ticket or create a new one.</p>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket</a></p>\n</div>',NULL,NULL,'Ticket #{{ticket_id}} has been closed.',NULL,'Ticket #{{ticket_id}} closed','Ticket Closed','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"closed_by\":\"Who closed the ticket\",\"ticket_link\":\"URL to view the ticket\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(14,'TICKET_ESCALATED','Support Ticket Escalated','[Ticket #{{ticket_id}}] Ticket Escalated - Level {{escalation_level}}','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong style=\"color: #dc2626;\">URGENT: Ticket Escalation Alert</strong></p>\n<p>A support ticket has been escalated due to SLA breach.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Priority:</strong> {{ticket_priority}}</li>\n<li><strong>Escalation Level:</strong> {{escalation_level}}</li>\n<li><strong>Customer:</strong> {{customer_name}} ({{customer_email}})</li>\n<li><strong>Waiting Since:</strong> {{waiting_time}}</li>\n</ul>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #dc2626; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">View Ticket Now</a></p>\n</div>',NULL,NULL,'URGENT: Ticket #{{ticket_id}} escalated to level {{escalation_level}}. Immediate attention required.',NULL,'Ticket #{{ticket_id}} escalated to level {{escalation_level}}','Ticket Escalated','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"ticket_priority\":\"Priority level\",\"escalation_level\":\"Current escalation level\",\"customer_name\":\"Customer name\",\"customer_email\":\"Customer email\",\"waiting_time\":\"How long the ticket has been waiting\",\"ticket_link\":\"URL to view the ticket\"}',1,1,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(15,'TICKET_SLA_WARNING','SLA Breach Warning','[Warning] Ticket #{{ticket_id}} - SLA Breach Imminent','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong style=\"color: #f59e0b;\">⚠️ SLA Breach Warning</strong></p>\n<p>A support ticket is about to breach its SLA.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Priority:</strong> {{ticket_priority}}</li>\n<li><strong>SLA Due:</strong> {{sla_due_time}}</li>\n<li><strong>Time Remaining:</strong> {{time_remaining}}</li>\n</ul>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #f59e0b; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>',NULL,NULL,'Warning: Ticket #{{ticket_id}} SLA breach in {{time_remaining}}.',NULL,'SLA warning: Ticket #{{ticket_id}}','SLA Warning','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"ticket_priority\":\"Priority level\",\"sla_due_time\":\"When SLA is due\",\"time_remaining\":\"Time remaining before breach\",\"ticket_link\":\"URL to view the ticket\"}',1,0,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(16,'TICKET_FEEDBACK_REQUEST','Ticket Feedback Request','How was your support experience? [Ticket #{{ticket_id}}]','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>Your support ticket has been resolved. We would love to hear about your experience!</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n</ul>\n<p>Please take a moment to rate your experience:</p>\n<p style=\"text-align: center; font-size: 24px;\">\n<a href=\"{{rating_link_1}}\" style=\"text-decoration: none;\">⭐</a>\n<a href=\"{{rating_link_2}}\" style=\"text-decoration: none;\">⭐</a>\n<a href=\"{{rating_link_3}}\" style=\"text-decoration: none;\">⭐</a>\n<a href=\"{{rating_link_4}}\" style=\"text-decoration: none;\">⭐</a>\n<a href=\"{{rating_link_5}}\" style=\"text-decoration: none;\">⭐</a>\n</p>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Rate Your Experience</a></p>\n<p style=\"color: #666; font-size: 12px;\">Your feedback helps us improve our support quality.</p>\n</div>',NULL,NULL,'How was your support experience for Ticket #{{ticket_id}}? Rate us: {{ticket_link}}',NULL,'Rate your support experience','Feedback Request','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"ticket_link\":\"URL to rate the ticket\",\"rating_link_1\":\"Direct link to rate 1 star\",\"rating_link_2\":\"Direct link to rate 2 stars\",\"rating_link_3\":\"Direct link to rate 3 stars\",\"rating_link_4\":\"Direct link to rate 4 stars\",\"rating_link_5\":\"Direct link to rate 5 stars\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(17,'TICKET_STALE_REMINDER','Stale Ticket Reminder','[Reminder] Ticket #{{ticket_id}} Awaiting Response','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>Ticket Awaiting Response</strong></p>\n<p>The following ticket has been waiting for a response:</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Priority:</strong> {{ticket_priority}}</li>\n<li><strong>Customer:</strong> {{customer_name}}</li>\n<li><strong>Waiting Since:</strong> {{waiting_time}}</li>\n</ul>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Respond Now</a></p>\n</div>',NULL,NULL,'Reminder: Ticket #{{ticket_id}} waiting for response since {{waiting_time}}.',NULL,'Ticket #{{ticket_id}} awaiting response','Stale Ticket','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"ticket_priority\":\"Priority level\",\"customer_name\":\"Customer name\",\"waiting_time\":\"How long the ticket has been waiting\",\"ticket_link\":\"URL to view the ticket\"}',1,0,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(18,'TICKET_AUTO_CLOSED','Ticket Auto-Closed','[Ticket #{{ticket_id}}] Ticket Automatically Closed','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>Your support ticket has been automatically closed due to inactivity.</p>\n<h4>Ticket Details:</h4>\n<ul>\n<li><strong>Ticket ID:</strong> #{{ticket_id}}</li>\n<li><strong>Subject:</strong> {{ticket_subject}}</li>\n<li><strong>Last Activity:</strong> {{last_activity}}</li>\n</ul>\n<p>If you still need assistance, you can reopen this ticket or create a new one.</p>\n<p><a href=\"{{ticket_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Reopen Ticket</a></p>\n</div>',NULL,NULL,'Ticket #{{ticket_id}} has been auto-closed due to inactivity.',NULL,'Ticket #{{ticket_id}} auto-closed','Ticket Auto-Closed','{\"ticket_id\":\"Ticket ID\\/Number\",\"ticket_subject\":\"Subject of the ticket\",\"last_activity\":\"Date of last activity\",\"ticket_link\":\"URL to view the ticket\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(19,'KYC_APPROVE','KYC Approved','KYC Verification Approved','<div style=\"font-family: Arial, sans-serif;\">\n<p>Congratulations! Your KYC verification has been <strong style=\"color: #16a34a;\">approved</strong>.</p>\n<p>You now have full access to all features of your account.</p>\n</div>',NULL,NULL,'Your KYC verification has been approved.',NULL,'KYC verification approved','KYC Approved','{}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(20,'KYC_REJECT','KYC Rejected','KYC Verification Rejected','<div style=\"font-family: Arial, sans-serif;\">\n<p>Unfortunately, your KYC verification has been <strong style=\"color: #dc2626;\">rejected</strong>.</p>\n<p><strong>Reason:</strong> {{reason}}</p>\n<p>Please submit your documents again with correct information.</p>\n</div>',NULL,NULL,'Your KYC verification has been rejected. Reason: {{reason}}',NULL,'KYC verification rejected','KYC Rejected','{\"reason\":\"Rejection Reason\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(21,'SERVICE_SUSPEND','Service Suspension Notification','Service Suspension Notification','<div style=\"font-family: Arial, sans-serif;\">\n<p>This is a notification that your service has now been <strong style=\"color: #dc2626;\">suspended</strong>.</p>\n<h4>Suspension Details:</h4>\n<ul>\n<li><strong>Product/Service:</strong> {{service_name}}</li>\n<li><strong>Due Date:</strong> {{service_next_due_date}}</li>\n<li><strong>Suspension Reason:</strong> {{service_suspension_reason}}</li>\n</ul>\n<p>Please contact us as soon as possible to get your service reactivated.</p>\n</div>',NULL,NULL,'Your service {{service_name}} has been suspended. Reason: {{service_suspension_reason}}. Due: {{service_next_due_date}}',NULL,'Service {{service_name}} suspended','Service Suspended','{\"service_name\":\"Service\\/Product Name\",\"service_next_due_date\":\"Next Due Date\",\"service_suspension_reason\":\"Reason of suspension\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(22,'SERVICE_UNSUSPEND','Service Unsuspension Notification','Service Unsuspension Notification','<div style=\"font-family: Arial, sans-serif;\">\n<p>This is a notification that your service has now been <strong style=\"color: #16a34a;\">unsuspended</strong>.</p>\n<h4>Service Details:</h4>\n<ul>\n<li><strong>Product/Service:</strong> {{service_name}}</li>\n<li><strong>Due Date:</strong> {{service_next_due_date}}</li>\n</ul>\n<p>Your service is now active and accessible.</p>\n</div>',NULL,NULL,'Your service {{service_name}} has been unsuspended. Due: {{service_next_due_date}}',NULL,'Service {{service_name}} unsuspended','Service Activated','{\"service_name\":\"Service\\/Product Name\",\"service_next_due_date\":\"Next Due Date\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(23,'SERVICE_TERMINATE','Service Termination Notification','Service Termination Notification','<div style=\"font-family: Arial, sans-serif;\">\n<p>This is a notification that your service has been <strong style=\"color: #dc2626;\">terminated</strong>.</p>\n<h4>Service Details:</h4>\n<ul>\n<li><strong>Product/Service:</strong> {{service_name}}</li>\n<li><strong>Termination Date:</strong> {{termination_date}}</li>\n<li><strong>Reason:</strong> {{termination_reason}}</li>\n</ul>\n<p>All data associated with this service has been removed. If you have any questions, please contact support.</p>\n</div>',NULL,NULL,'Your service {{service_name}} has been terminated. Reason: {{termination_reason}}',NULL,'Service {{service_name}} terminated','Service Terminated','{\"service_name\":\"Service\\/Product Name\",\"termination_date\":\"Date of termination\",\"termination_reason\":\"Reason for termination\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(24,'HOSTING_ACCOUNT','Hosting Account Welcome Email','🎉 Your Hosting Account is Ready - {{service_domain}}','<div style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, \'Helvetica Neue\', Arial, sans-serif; max-width: 600px; margin: 0 auto; background-color: #f8fafc;\">\n    <!-- Header Banner -->\n    <div style=\"background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%); padding: 40px 20px; text-align: center; border-radius: 8px 8px 0 0;\">\n        <h1 style=\"color: #ffffff; margin: 0; font-size: 28px; font-weight: 700;\">🎉 Welcome to Your New Hosting Account!</h1>\n        <p style=\"color: #e0e7ff; margin: 10px 0 0 0; font-size: 16px;\">Your account has been successfully set up and is ready to use</p>\n    </div>\n\n    <!-- Main Content -->\n    <div style=\"background-color: #ffffff; padding: 30px; border-radius: 0 0 8px 8px;\">\n        \n        <!-- Quick Start Guide -->\n        <div style=\"background-color: #f0f9ff; border-left: 4px solid #0ea5e9; padding: 20px; margin-bottom: 30px; border-radius: 4px;\">\n            <h2 style=\"color: #0c4a6e; margin: 0 0 15px 0; font-size: 18px;\">🚀 Quick Start Guide</h2>\n            <ol style=\"color: #0f172a; margin: 0; padding-left: 20px; line-height: 1.8;\">\n                <li><strong>Log in to cPanel</strong> using the credentials below</li>\n                <li><strong>Upload your website</strong> files via File Manager or FTP</li>\n                <li><strong>Set up email accounts</strong> for your domain</li>\n            </ol>\n        </div>\n\n        <!-- Account Information -->\n        <h3 style=\"color: #1e293b; margin: 0 0 15px 0; font-size: 20px; border-bottom: 2px solid #e2e8f0; padding-bottom: 10px;\">📋 Account Information</h3>\n        <table style=\"width: 100%; border-collapse: collapse; margin-bottom: 25px;\">\n            <tr>\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600; width: 40%;\">Hosting Package:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_product_name}}</td>\n            </tr>\n            <tr style=\"background-color: #f8fafc;\">\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600;\">Domain:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_domain}}</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600;\">Billing Cycle:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_billing_cycle}}</td>\n            </tr>\n            <tr style=\"background-color: #f8fafc;\">\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600;\">Next Due Date:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_next_due_date}}</td>\n            </tr>\n        </table>\n\n        <!-- Login Credentials -->\n        <div style=\"background: linear-gradient(135deg, #10b981 0%, #059669 100%); padding: 25px; border-radius: 8px; margin-bottom: 25px;\">\n            <h3 style=\"color: #ffffff; margin: 0 0 20px 0; font-size: 18px;\">🔐 Your Login Credentials</h3>\n            <div style=\"background-color: rgba(255, 255, 255, 0.95); padding: 20px; border-radius: 6px;\">\n                <table style=\"width: 100%;\">\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #064e3b; font-weight: 600;\">Control Panel URL:</td>\n                        <td style=\"padding: 8px 0;\"><a href=\"http://{{service_server_ip}}:2082/\" style=\"color: #0ea5e9; text-decoration: none; font-weight: 500;\">http://{{service_server_ip}}:2082/</a></td>\n                    </tr>\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #064e3b; font-weight: 600;\">Username:</td>\n                        <td style=\"padding: 8px 0; color: #0f172a; font-family: monospace; font-size: 14px; background-color: #f1f5f9; padding: 4px 8px; border-radius: 4px;\">{{service_username}}</td>\n                    </tr>\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #064e3b; font-weight: 600;\">Password:</td>\n                        <td style=\"padding: 8px 0; color: #0f172a; font-family: monospace; font-size: 14px; background-color: #f1f5f9; padding: 4px 8px; border-radius: 4px;\">{{service_password}}</td>\n                    </tr>\n                </table>\n                <p style=\"margin: 15px 0 0 0; color: #dc2626; font-size: 13px; font-weight: 500;\">⚠️ Keep these credentials secure. We recommend changing your password after first login.</p>\n            </div>\n        </div>\n\n        <!-- Server Information -->\n        <h3 style=\"color: #1e293b; margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #e2e8f0; padding-bottom: 10px;\">🖥️ Server Information</h3>\n        <table style=\"width: 100%; border-collapse: collapse; margin-bottom: 25px;\">\n            <tr>\n                <td style=\"padding: 10px 0; color: #64748b; font-weight: 600; width: 40%;\">Server IP:</td>\n                <td style=\"padding: 10px 0; color: #0f172a; font-family: monospace;\">{{service_server_ip}}</td>\n            </tr>\n            <tr style=\"background-color: #f8fafc;\">\n                <td style=\"padding: 10px 0; color: #64748b; font-weight: 600;\">Nameserver 1:</td>\n                <td style=\"padding: 10px 0; color: #0f172a; font-family: monospace;\">{{ns1}}</td>\n            </tr>\n            <tr>\n                <td style=\"padding: 10px 0; color: #64748b; font-weight: 600;\">Nameserver 2:</td>\n                <td style=\"padding: 10px 0; color: #0f172a; font-family: monospace;\">{{ns2}}</td>\n            </tr>\n        </table>\n\n        <!-- FTP & Email Settings -->\n        <div style=\"background-color: #fef3c7; border-left: 4px solid #f59e0b; padding: 20px; margin-bottom: 25px; border-radius: 4px;\">\n            <h3 style=\"color: #78350f; margin: 0 0 15px 0; font-size: 16px;\">📧 Email & FTP Settings</h3>\n            <table style=\"width: 100%; font-size: 14px;\">\n                <tr>\n                    <td style=\"padding: 6px 0; color: #78350f; font-weight: 600; width: 40%;\">Incoming Mail (POP3/IMAP):</td>\n                    <td style=\"padding: 6px 0; color: #0f172a; font-family: monospace;\">mail.{{service_domain}}</td>\n                </tr>\n                <tr>\n                    <td style=\"padding: 6px 0; color: #78350f; font-weight: 600;\">Outgoing Mail (SMTP):</td>\n                    <td style=\"padding: 6px 0; color: #0f172a; font-family: monospace;\">mail.{{service_domain}}</td>\n                </tr>\n                <tr>\n                    <td style=\"padding: 6px 0; color: #78350f; font-weight: 600;\">FTP Hostname:</td>\n                    <td style=\"padding: 6px 0; color: #0f172a; font-family: monospace;\">{{service_domain}}</td>\n                </tr>\n            </table>\n        </div>\n\n        <!-- Important Notes -->\n        <div style=\"background-color: #eff6ff; border-left: 4px solid #3b82f6; padding: 20px; margin-bottom: 25px; border-radius: 4px;\">\n            <h3 style=\"color: #1e40af; margin: 0 0 10px 0; font-size: 16px;\">💡 Important Notes</h3>\n            <ul style=\"color: #1e293b; margin: 0; padding-left: 20px; line-height: 1.8; font-size: 14px;\">\n                <li><strong>DNS Propagation:</strong> If you registered a new domain, it may take up to 48 hours to become fully accessible worldwide.</li>\n                <li><strong>SSL Certificate:</strong> Free SSL certificates are automatically installed within 24 hours.</li>\n                <li><strong>Backups:</strong> We perform daily backups, but we recommend keeping your own copies as well.</li>\n            </ul>\n        </div>\n\n        <!-- CTA Button -->\n        <div style=\"text-align: center; margin: 30px 0;\">\n            <a href=\"http://{{service_server_ip}}:2082/\" style=\"display: inline-block; background: linear-gradient(135deg, #4f46e5 0%, #7c3aed 100%); color: #ffffff; padding: 14px 32px; text-decoration: none; border-radius: 6px; font-weight: 600; font-size: 16px;\">Access cPanel Now →</a>\n        </div>\n\n        <!-- Support Section -->\n        <div style=\"background-color: #f8fafc; padding: 20px; border-radius: 6px; text-align: center; margin-top: 30px;\">\n            <p style=\"color: #64748b; margin: 0 0 10px 0; font-size: 14px;\">Need help getting started?</p>\n            <p style=\"color: #0f172a; margin: 0; font-weight: 600;\">Our support team is here 24/7 to assist you!</p>\n        </div>\n    </div>\n</div>',NULL,NULL,'Your hosting account for {{service_domain}} is ready. Username: {{service_username}}. Login: http://{{service_server_ip}}:2082/',NULL,'Hosting account ready for {{service_domain}}','Hosting Ready','{\"service_product_name\":\"Service Name\",\"service_domain\":\"Domain\",\"service_first_payment_amount\":\"First Payment Amount\",\"service_recurring_amount\":\"Recurring Amount\",\"service_billing_cycle\":\"Billing Cycle\",\"service_next_due_date\":\"Next Due Date\",\"service_username\":\"Username\",\"service_password\":\"Password\",\"ns1\":\"Nameserver 1\",\"ns2\":\"Nameserver 2\",\"ns1_ip\":\"Nameserver 1 IP\",\"ns2_ip\":\"Nameserver 2 IP\",\"service_server_ip\":\"Server IP\"}',1,1,0,'2025-12-19 15:45:03','2026-01-20 12:49:13'),(25,'VPS_SERVER','Dedicated/VPS Server Welcome Email','New Dedicated Server Information','<div style=\"font-family: Arial, sans-serif;\">\n<p><strong>PLEASE PRINT THIS MESSAGE FOR YOUR RECORDS</strong></p>\n<p>We are pleased to tell you that the server you ordered has now been set up and is operational.</p>\n\n<h4>Server Details</h4>\n<ul>\n<li><strong>Product:</strong> {{service_product_name}}</li>\n<li><strong>Main IP:</strong> {{service_dedicated_ip}}</li>\n<li><strong>Root Password:</strong> {{service_password}}</li>\n<li><strong>Assigned IPs:</strong> {{service_assigned_ips}}</li>\n<li><strong>ServerName:</strong> {{service_domain}}</li>\n</ul>\n\n<h4>WHM Access</h4>\n<p>URL: <a href=\"http://{{service_dedicated_ip}}:2086\">http://{{service_dedicated_ip}}:2086</a></p>\n<ul>\n<li><strong>Username:</strong> root</li>\n<li><strong>Password:</strong> {{service_password}}</li>\n</ul>\n\n<h4>Custom DNS Server Addresses</h4>\n<ul>\n<li><strong>Primary DNS:</strong> {{ns1}}</li>\n<li><strong>Secondary DNS:</strong> {{ns2}}</li>\n</ul>\n\n<h4>SSH Access Information</h4>\n<ul>\n<li><strong>Main IP Address:</strong> {{service_dedicated_ip}}</li>\n<li><strong>Server Name:</strong> {{service_domain}}</li>\n<li><strong>Root Password:</strong> {{service_password}}</li>\n</ul>\n</div>',NULL,NULL,'Your VPS/Dedicated server is ready. IP: {{service_dedicated_ip}}. SSH Password: {{service_password}}',NULL,'VPS/Dedicated server ready','Server Ready','{\"service_product_name\":\"Service Name\",\"service_dedicated_ip\":\"Dedicated IP\",\"service_password\":\"Root Password\",\"service_assigned_ips\":\"Assigned IPs\",\"service_domain\":\"Domain\",\"ns1\":\"Nameserver 1\",\"ns2\":\"Nameserver 2\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(26,'RESELLER_ACCOUNT','Reseller Account Welcome Email','🚀 Your Reseller Hosting Account is Active - {{service_domain}}','<div style=\"font-family: -apple-system, BlinkMacSystemFont, \'Segoe UI\', Roboto, \'Helvetica Neue\', Arial, sans-serif; max-width: 600px; margin: 0 auto; background-color: #f8fafc;\">\n    <!-- Header Banner -->\n    <div style=\"background: linear-gradient(135deg, #7c3aed 0%, #a855f7 100%); padding: 40px 20px; text-align: center; border-radius: 8px 8px 0 0;\">\n        <h1 style=\"color: #ffffff; margin: 0; font-size: 28px; font-weight: 700;\">🚀 Welcome to Your Reseller Account!</h1>\n        <p style=\"color: #f3e8ff; margin: 10px 0 0 0; font-size: 16px;\">Start creating and managing client accounts today</p>\n    </div>\n\n    <!-- Main Content -->\n    <div style=\"background-color: #ffffff; padding: 30px; border-radius: 0 0 8px 8px;\">\n        \n        <!-- Quick Start Guide -->\n        <div style=\"background-color: #fef3c7; border-left: 4px solid #f59e0b; padding: 20px; margin-bottom: 30px; border-radius: 4px;\">\n            <h2 style=\"color: #78350f; margin: 0 0 15px 0; font-size: 18px;\">⚡ Reseller Quick Start</h2>\n            <ol style=\"color: #0f172a; margin: 0; padding-left: 20px; line-height: 1.8;\">\n                <li><strong>Access WHM</strong> to manage your reseller account</li>\n                <li><strong>Create hosting packages</strong> for your clients</li>\n                <li><strong>Add client accounts</strong> and start billing</li>\n                <li><strong>Brand your services</strong> with custom nameservers</li>\n            </ol>\n        </div>\n\n        <!-- Account Information -->\n        <h3 style=\"color: #1e293b; margin: 0 0 15px 0; font-size: 20px; border-bottom: 2px solid #e2e8f0; padding-bottom: 10px;\">📋 Account Information</h3>\n        <table style=\"width: 100%; border-collapse: collapse; margin-bottom: 25px;\">\n            <tr>\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600; width: 40%;\">Reseller Package:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_product_name}}</td>\n            </tr>\n            <tr style=\"background-color: #f8fafc;\">\n                <td style=\"padding: 12px 0; color: #64748b; font-weight: 600;\">Primary Domain:</td>\n                <td style=\"padding: 12px 0; color: #0f172a; font-weight: 500;\">{{service_domain}}</td>\n            </tr>\n        </table>\n\n        <!-- WHM Access (Primary) -->\n        <div style=\"background: linear-gradient(135deg, #7c3aed 0%, #a855f7 100%); padding: 25px; border-radius: 8px; margin-bottom: 20px;\">\n            <h3 style=\"color: #ffffff; margin: 0 0 20px 0; font-size: 18px;\">👑 WHM Access (Reseller Control)</h3>\n            <div style=\"background-color: rgba(255, 255, 255, 0.95); padding: 20px; border-radius: 6px;\">\n                <table style=\"width: 100%;\">\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #581c87; font-weight: 600;\">WHM URL:</td>\n                        <td style=\"padding: 8px 0;\"><a href=\"http://{{service_server_ip}}:2086/\" style=\"color: #7c3aed; text-decoration: none; font-weight: 500;\">http://{{service_server_ip}}:2086/</a></td>\n                    </tr>\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #581c87; font-weight: 600;\">Username:</td>\n                        <td style=\"padding: 8px 0; color: #0f172a; font-family: monospace; font-size: 14px; background-color: #f1f5f9; padding: 4px 8px; border-radius: 4px;\">{{service_username}}</td>\n                    </tr>\n                    <tr>\n                        <td style=\"padding: 8px 0; color: #581c87; font-weight: 600;\">Password:</td>\n                        <td style=\"padding: 8px 0; color: #0f172a; font-family: monospace; font-size: 14px; background-color: #f1f5f9; padding: 4px 8px; border-radius: 4px;\">{{service_password}}</td>\n                    </tr>\n                </table>\n                <p style=\"margin: 15px 0 0 0; color: #dc2626; font-size: 13px; font-weight: 500;\">⚠️ WHM gives you full reseller control. Keep these credentials secure!</p>\n            </div>\n        </div>\n\n        <!-- cPanel Access (Secondary) -->\n        <div style=\"background-color: #eff6ff; border: 2px solid #3b82f6; padding: 20px; border-radius: 8px; margin-bottom: 25px;\">\n            <h3 style=\"color: #1e40af; margin: 0 0 15px 0; font-size: 16px;\">🔧 cPanel Access (Your Hosting)</h3>\n            <p style=\"color: #1e293b; margin: 0 0 10px 0; font-size: 14px;\">Use cPanel to manage your own website and emails:</p>\n            <p style=\"margin: 0;\"><a href=\"http://{{service_server_ip}}:2082/\" style=\"color: #3b82f6; text-decoration: none; font-weight: 500;\">http://{{service_server_ip}}:2082/</a></p>\n            <p style=\"margin: 10px 0 0 0; color: #64748b; font-size: 13px;\">Login with the same username and password above</p>\n        </div>\n\n        <!-- Reseller Features -->\n        <div style=\"background-color: #f0fdf4; border-left: 4px solid #10b981; padding: 20px; margin-bottom: 25px; border-radius: 4px;\">\n            <h3 style=\"color: #065f46; margin: 0 0 15px 0; font-size: 16px;\">✨ What You Can Do</h3>\n            <ul style=\"color: #0f172a; margin: 0; padding-left: 20px; line-height: 1.8; font-size: 14px;\">\n                <li><strong>Create Packages:</strong> Define hosting plans with custom resources</li>\n                <li><strong>Manage Clients:</strong> Add, suspend, or terminate client accounts</li>\n                <li><strong>White Label:</strong> Brand services with your company name</li>\n                <li><strong>Monitor Resources:</strong> Track bandwidth and disk usage</li>\n                <li><strong>Billing Integration:</strong> Set your own pricing and payment terms</li>\n            </ul>\n        </div>\n\n        <!-- Email Settings -->\n        <h3 style=\"color: #1e293b; margin: 0 0 15px 0; font-size: 18px; border-bottom: 2px solid #e2e8f0; padding-bottom: 10px;\">📧 Email Configuration</h3>\n        <table style=\"width: 100%; border-collapse: collapse; margin-bottom: 25px; font-size: 14px;\">\n            <tr>\n                <td style=\"padding: 10px 0; color: #64748b; font-weight: 600; width: 40%;\">Incoming (POP3/IMAP):</td>\n                <td style=\"padding: 10px 0; color: #0f172a; font-family: monospace;\">mail.{{service_domain}}</td>\n            </tr>\n            <tr style=\"background-color: #f8fafc;\">\n                <td style=\"padding: 10px 0; color: #64748b; font-weight: 600;\">Outgoing (SMTP):</td>\n                <td style=\"padding: 10px 0; color: #0f172a; font-family: monospace;\">mail.{{service_domain}}</td>\n            </tr>\n        </table>\n\n        <!-- CTA Buttons -->\n        <div style=\"text-align: center; margin: 30px 0;\">\n            <a href=\"http://{{service_server_ip}}:2086/\" style=\"display: inline-block; background: linear-gradient(135deg, #7c3aed 0%, #a855f7 100%); color: #ffffff; padding: 14px 32px; text-decoration: none; border-radius: 6px; font-weight: 600; font-size: 16px; margin: 0 5px;\">Access WHM →</a>\n            <a href=\"http://{{service_server_ip}}:2082/\" style=\"display: inline-block; background-color: #3b82f6; color: #ffffff; padding: 14px 32px; text-decoration: none; border-radius: 6px; font-weight: 600; font-size: 16px; margin: 0 5px;\">Access cPanel →</a>\n        </div>\n\n        <!-- Support Section -->\n        <div style=\"background-color: #f8fafc; padding: 20px; border-radius: 6px; text-align: center; margin-top: 30px;\">\n            <p style=\"color: #64748b; margin: 0 0 10px 0; font-size: 14px;\">Questions about reseller features?</p>\n            <p style=\"color: #0f172a; margin: 0; font-weight: 600;\">Our reseller support team is ready to help 24/7!</p>\n        </div>\n    </div>\n</div>',NULL,NULL,'Your reseller account for {{service_domain}} is ready. Username: {{service_username}}. WHM: http://{{service_server_ip}}:2086/',NULL,'Reseller account ready','Reseller Ready','{\"service_domain\":\"Domain\",\"service_username\":\"Username\",\"service_password\":\"Password\",\"service_product_name\":\"Service Name\",\"service_server_ip\":\"Server IP\"}',1,1,0,'2025-12-19 15:45:03','2026-01-20 12:49:13'),(27,'OTHER_PRODUCT','Other Product/Service Welcome Email','New Product Information','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your order for <strong>{{service_product_name}}</strong> has now been activated.</p>\n<h4>Order Details:</h4>\n<ul>\n<li><strong>Product/Service:</strong> {{service_product_name}}</li>\n<li><strong>Amount:</strong> {{service_recurring_amount}} {{site_currency}}</li>\n<li><strong>Billing Cycle:</strong> {{service_billing_cycle}}</li>\n<li><strong>Next Due Date:</strong> {{service_next_due_date}}</li>\n</ul>\n</div>',NULL,NULL,'Your order for {{service_product_name}} has been activated.',NULL,'Order activated: {{service_product_name}}','Order Activated','{\"service_product_name\":\"Service Name\",\"service_recurring_amount\":\"Recurring Amount\",\"service_billing_cycle\":\"Billing Cycle\",\"service_next_due_date\":\"Next Due Date\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(28,'DOMAIN_REGISTER','Domain Registration','Domain Registration Confirmation','<div style=\"font-family: Arial, sans-serif;\">\n<p>This message is to confirm that your domain purchase has been successful.</p>\n<h4>Domain Details:</h4>\n<ul>\n<li><strong>Registration Date:</strong> {{domain_reg_date}}</li>\n<li><strong>Domain:</strong> {{domain_name}}</li>\n<li><strong>Registration Period:</strong> {{domain_reg_period}} Years</li>\n<li><strong>Amount:</strong> {{first_payment_amount}} {{site_currency}}</li>\n<li><strong>Next Due Date:</strong> {{next_due_date}}</li>\n</ul>\n</div>',NULL,NULL,'Domain {{domain_name}} registered for {{domain_reg_period}} years. Due: {{next_due_date}}',NULL,'Domain {{domain_name}} registered','Domain Registered','{\"domain_reg_date\":\"Domain registration date\",\"domain_name\":\"Domain Name\",\"domain_reg_period\":\"Registration period\",\"first_payment_amount\":\"First payment amount\",\"next_due_date\":\"Next due date\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(29,'DOMAIN_RENEW_NOTIFICATION','Domain Renewal Notification','Domain Renewal Notification','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you for your domain renewal order. Your domain renewal request has been completed.</p>\n<h4>Renewal Details:</h4>\n<ul>\n<li><strong>Domain:</strong> {{domain}}</li>\n<li><strong>Renewal Length:</strong> {{reg_period}} Years</li>\n<li><strong>Renewal Price:</strong> {{recurring_amount}} {{site_currency}}</li>\n<li><strong>Next Due Date:</strong> {{next_due_date}}</li>\n</ul>\n</div>',NULL,NULL,'Domain {{domain}} renewed for {{reg_period}} years. Due: {{next_due_date}}',NULL,'Domain {{domain}} renewed','Domain Renewed','{\"domain\":\"Domain Name\",\"reg_period\":\"Registration Period\",\"recurring_amount\":\"Recurring Amount\",\"next_due_date\":\"Next Due Date\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(30,'DOMAIN_TRANSFER','Domain Transfer Notification','Domain Transfer Initiated','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your domain transfer request has been initiated.</p>\n<h4>Transfer Details:</h4>\n<ul>\n<li><strong>Domain:</strong> {{domain_name}}</li>\n<li><strong>Transfer Status:</strong> {{transfer_status}}</li>\n<li><strong>Amount:</strong> {{transfer_amount}} {{site_currency}}</li>\n</ul>\n<p>Domain transfers typically take 5-7 days to complete. You may receive an authorization email from the current registrar.</p>\n</div>',NULL,NULL,'Domain transfer initiated for {{domain_name}}. Status: {{transfer_status}}',NULL,'Domain transfer initiated: {{domain_name}}','Domain Transfer','{\"domain_name\":\"Domain Name\",\"transfer_status\":\"Transfer Status\",\"transfer_amount\":\"Transfer Amount\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(31,'INVOICE_CREATED','Invoice Created','New Invoice #{{invoice_number}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>A new invoice has been generated for your account.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #{{invoice_number}}</li>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Due Date:</strong> {{due_date}}</li>\n</ul>\n<p>View and pay your invoice: <a href=\"{{invoice_link}}\">{{invoice_link}}</a></p>\n</div>',NULL,NULL,'Invoice #{{invoice_number}} created. Amount: {{amount}} {{site_currency}}. Due: {{due_date}}',NULL,'New invoice #{{invoice_number}} - {{amount}} {{site_currency}}','New Invoice','{\"invoice_number\":\"Invoice Number\",\"amount\":\"Invoice Amount\",\"due_date\":\"Due Date\",\"invoice_link\":\"Invoice Link\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(32,'INVOICE_PAID','Invoice Paid','Payment Received - Invoice #{{invoice_number}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you! Your payment has been received.</p>\n<h4>Payment Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #{{invoice_number}}</li>\n<li><strong>Amount Paid:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Payment Method:</strong> {{payment_method}}</li>\n<li><strong>Transaction ID:</strong> {{transaction_id}}</li>\n</ul>\n</div>',NULL,NULL,'Payment received for invoice #{{invoice_number}}. Amount: {{amount}} {{site_currency}}',NULL,'Payment received: {{amount}} {{site_currency}}','Payment Received','{\"invoice_number\":\"Invoice Number\",\"amount\":\"Payment Amount\",\"payment_method\":\"Payment Method\",\"transaction_id\":\"Transaction ID\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(33,'INVOICE_PAYMENT_REMINDER','Invoice Payment Reminder','Invoice Payment Reminder','<div style=\"font-family: Arial, sans-serif;\">\n<p>This is a billing reminder that your invoice is due soon.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice Number:</strong> #{{invoice_number}}</li>\n<li><strong>Created:</strong> {{invoice_created}}</li>\n<li><strong>Due Date:</strong> {{invoice_due_date}}</li>\n</ul>\n<p>You can log in to your client area to view and pay the invoice: <a href=\"{{invoice_link}}\">{{invoice_link}}</a></p>\n</div>',NULL,NULL,'Invoice #{{invoice_number}} is due on {{invoice_due_date}}. Please make payment.',NULL,'Invoice #{{invoice_number}} due: {{invoice_due_date}}','Payment Reminder','{\"invoice_number\":\"Invoice Number\",\"invoice_created\":\"Invoice Created Date\",\"invoice_due_date\":\"Invoice Due Date\",\"invoice_link\":\"Invoice Link\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(34,'FIRST_INVOICE_OVERDUE_NOTICE','First Invoice Overdue Notice','First Invoice Overdue Notice','<div style=\"font-family: Arial, sans-serif;\">\n<p style=\"color: #dc2626;\"><strong>This is the first billing notice</strong></p>\n<p>Your invoice #{{invoice_number}} which was generated on {{invoice_created}} is now overdue.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice:</strong> #{{invoice_number}}</li>\n<li><strong>Due Date:</strong> {{invoice_due_date}}</li>\n</ul>\n<p>Please pay immediately to avoid service interruption: <a href=\"{{invoice_link}}\">{{invoice_link}}</a></p>\n</div>',NULL,NULL,'FIRST NOTICE: Invoice #{{invoice_number}} is overdue. Due: {{invoice_due_date}}. Pay now to avoid interruption.',NULL,'Invoice overdue: #{{invoice_number}}','First Overdue Notice','{\"invoice_number\":\"Invoice Number\",\"invoice_created\":\"Invoice Created Date\",\"invoice_due_date\":\"Invoice Due Date\",\"invoice_link\":\"Invoice Link\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(35,'SECOND_INVOICE_OVERDUE_NOTICE','Second Invoice Overdue Notice','Second Invoice Overdue Notice','<div style=\"font-family: Arial, sans-serif;\">\n<p style=\"color: #dc2626;\"><strong>This is the second billing notice</strong></p>\n<p>Your invoice #{{invoice_number}} which was generated on {{invoice_created}} is now overdue.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice:</strong> #{{invoice_number}}</li>\n<li><strong>Due Date:</strong> {{invoice_due_date}}</li>\n</ul>\n<p>Please pay immediately to avoid service suspension: <a href=\"{{invoice_link}}\">{{invoice_link}}</a></p>\n</div>',NULL,NULL,'SECOND NOTICE: Invoice #{{invoice_number}} is overdue. Pay now to avoid suspension.',NULL,'Invoice overdue: #{{invoice_number}}','Second Overdue Notice','{\"invoice_number\":\"Invoice Number\",\"invoice_created\":\"Invoice Created Date\",\"invoice_due_date\":\"Invoice Due Date\",\"invoice_link\":\"Invoice Link\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(36,'THIRD_INVOICE_OVERDUE_NOTICE','Third Invoice Overdue Notice','Third Invoice Overdue Notice - Final Warning','<div style=\"font-family: Arial, sans-serif;\">\n<p style=\"color: #dc2626;\"><strong>This is the third and final billing notice</strong></p>\n<p>Your invoice #{{invoice_number}} which was generated on {{invoice_created}} is now overdue.</p>\n<h4>Invoice Details:</h4>\n<ul>\n<li><strong>Invoice:</strong> #{{invoice_number}}</li>\n<li><strong>Due Date:</strong> {{invoice_due_date}}</li>\n</ul>\n<p style=\"color: #dc2626;\"><strong>Your services will be terminated if payment is not received immediately.</strong></p>\n<p>Pay now: <a href=\"{{invoice_link}}\">{{invoice_link}}</a></p>\n</div>',NULL,NULL,'FINAL NOTICE: Invoice #{{invoice_number}} overdue. Services will be terminated if not paid.',NULL,'FINAL: Invoice #{{invoice_number}} overdue','Final Overdue Notice','{\"invoice_number\":\"Invoice Number\",\"invoice_created\":\"Invoice Created Date\",\"invoice_due_date\":\"Invoice Due Date\",\"invoice_link\":\"Invoice Link\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(37,'INVOICE_REFUND_NOTIFICATION','Invoice Refund Notification','Invoice Refund Notification','<div style=\"font-family: Arial, sans-serif;\">\n<p>This is confirmation that a refund has been processed for Invoice #{{invoice_id}}.</p>\n<p>The refund has been credited to your account balance.</p>\n<h4>Refund Details:</h4>\n<ul>\n<li><strong>Amount Refunded:</strong> {{refund_amount}} {{site_currency}}</li>\n<li><strong>Transaction #:</strong> {{trx_id}}</li>\n</ul>\n<p>You may review your invoice history at any time by logging in to your client area.</p>\n</div>',NULL,NULL,'Refund of {{refund_amount}} {{site_currency}} processed for Invoice #{{invoice_id}}. Trx: {{trx_id}}',NULL,'Refund processed: {{refund_amount}} {{site_currency}}','Refund Processed','{\"invoice_id\":\"Invoice ID\",\"refund_amount\":\"Refunded Amount\",\"trx_id\":\"Transaction ID\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(38,'ORDER_NOTIFICATION','New Order Notification','New Order Notification #{{order_id}}','<div style=\"font-family: Arial, sans-serif;\">\n<h4>Order Information</h4>\n<ul>\n<li><strong>Order ID:</strong> #{{order_id}}</li>\n<li><strong>Date/Time:</strong> {{created_at}}</li>\n<li><strong>Invoice Id:</strong> #{{invoice_id}}</li>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n</ul>\n\n<h4>Customer Information</h4>\n<ul>\n<li><strong>Name:</strong> {{name}}</li>\n<li><strong>Email:</strong> {{email}}</li>\n<li><strong>Address:</strong> {{address}}</li>\n<li><strong>City:</strong> {{city}}</li>\n<li><strong>State:</strong> {{state}}</li>\n<li><strong>Postcode:</strong> {{zip}}</li>\n<li><strong>Country:</strong> {{country}}</li>\n<li><strong>Phone:</strong> {{phone}}</li>\n</ul>\n\n<h4>Order Items</h4>\n<div>{{order_items}}</div>\n\n<p><strong>Client IP:</strong> {{client_ip}}</p>\n</div>',NULL,NULL,'New order #{{order_id}} from {{name}}. Amount: {{amount}} {{site_currency}}',NULL,'New order #{{order_id}} - {{amount}} {{site_currency}}','New Order','{\"order_id\":\"Order ID\",\"created_at\":\"Order Created Date\",\"invoice_id\":\"Invoice ID\",\"amount\":\"Order Amount\",\"name\":\"Customer Name\",\"email\":\"Customer Email\",\"address\":\"Customer Address\",\"city\":\"Customer City\",\"state\":\"Customer State\",\"zip\":\"Customer Zip Code\",\"country\":\"Customer Country\",\"phone\":\"Customer Phone\",\"order_items\":\"Order Items HTML\",\"client_ip\":\"Client IP Address\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(39,'ORDER_CONFIRMATION','Order Confirmation','Order Confirmation #{{order_id}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Thank you for your order!</p>\n<h4>Order Details:</h4>\n<ul>\n<li><strong>Order ID:</strong> #{{order_id}}</li>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Status:</strong> {{status}}</li>\n</ul>\n<p>Your order is being processed. You will receive an email notification once it is ready.</p>\n</div>',NULL,NULL,'Order #{{order_id}} confirmed. Amount: {{amount}} {{site_currency}}',NULL,'Order #{{order_id}} confirmed','Order Confirmed','{\"order_id\":\"Order ID\",\"amount\":\"Order Amount\",\"status\":\"Order Status\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(40,'ORDER_ACCEPTED','Order Accepted','Order Accepted #{{order_id}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your order #{{order_id}} has been <strong style=\"color: #16a34a;\">accepted</strong> and is now being processed.</p>\n<h4>Order Details:</h4>\n<ul>\n<li><strong>Order ID:</strong> #{{order_id}}</li>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n</ul>\n<p>You will receive further notifications as your services are activated.</p>\n</div>',NULL,NULL,'Order #{{order_id}} has been accepted. Services are being activated.',NULL,'Order #{{order_id}} accepted','Order Accepted','{\"order_id\":\"Order ID\",\"amount\":\"Order Amount\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(41,'ORDER_CANCELLED','Order Cancelled','Order Cancelled #{{order_id}}','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your order #{{order_id}} has been <strong style=\"color: #dc2626;\">cancelled</strong>.</p>\n<h4>Order Details:</h4>\n<ul>\n<li><strong>Order ID:</strong> #{{order_id}}</li>\n<li><strong>Amount:</strong> {{amount}} {{site_currency}}</li>\n<li><strong>Reason:</strong> {{cancellation_reason}}</li>\n</ul>\n<p>If you have any questions, please contact our support team.</p>\n</div>',NULL,NULL,'Order #{{order_id}} cancelled. Reason: {{cancellation_reason}}',NULL,'Order #{{order_id}} cancelled','Order Cancelled','{\"order_id\":\"Order ID\",\"amount\":\"Order Amount\",\"cancellation_reason\":\"Cancellation Reason\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(42,'DEFAULT','Default Template','{{subject}}','{{message}}',NULL,NULL,'{{message}}',NULL,'{{message}}','{{subject}}','{\"subject\":\"Email Subject\",\"message\":\"Email Message\"}',1,1,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(43,'2FA_ENABLE','Two-Factor Authentication Enabled','Two-Factor Authentication Enabled','<div style=\"font-family: Arial, sans-serif;\">\n<p>Two-Factor Authentication has been <strong style=\"color: #16a34a;\">enabled</strong> on your account.</p>\n<p>From now on, you will need to enter a verification code from your authenticator app when logging in.</p>\n<p style=\"color: #dc2626;\"><strong>If you did not make this change, please contact support immediately.</strong></p>\n</div>',NULL,NULL,'2FA has been enabled on your account.',NULL,'2FA enabled on your account','2FA Enabled','{}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(44,'2FA_DISABLE','Two-Factor Authentication Disabled','Two-Factor Authentication Disabled','<div style=\"font-family: Arial, sans-serif;\">\n<p>Two-Factor Authentication has been <strong style=\"color: #dc2626;\">disabled</strong> on your account.</p>\n<p style=\"color: #dc2626;\"><strong>If you did not make this change, please contact support immediately and secure your account.</strong></p>\n</div>',NULL,NULL,'2FA has been disabled on your account.',NULL,'2FA disabled on your account','2FA Disabled','{}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(45,'CANCEL_REQUEST_SUBMITTED','Cancellation Request Submitted','Cancellation Request Submitted','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your cancellation request has been submitted.</p>\n<h4>Request Details:</h4>\n<ul>\n<li><strong>Service:</strong> {{service_name}}</li>\n<li><strong>Cancellation Type:</strong> {{cancellation_type}}</li>\n<li><strong>Reason:</strong> {{cancellation_reason}}</li>\n</ul>\n<p>We will process your request and notify you once it has been reviewed.</p>\n</div>',NULL,NULL,'Cancellation request submitted for {{service_name}}.',NULL,'Cancellation request submitted','Cancellation Request','{\"service_name\":\"Service Name\",\"cancellation_type\":\"Cancellation Type (Immediate\\/End of Billing)\",\"cancellation_reason\":\"Cancellation Reason\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(46,'CANCEL_REQUEST_APPROVED','Cancellation Request Approved','Cancellation Request Approved','<div style=\"font-family: Arial, sans-serif;\">\n<p>Your cancellation request has been <strong style=\"color: #16a34a;\">approved</strong>.</p>\n<h4>Service Details:</h4>\n<ul>\n<li><strong>Service:</strong> {{service_name}}</li>\n<li><strong>Cancellation Date:</strong> {{cancellation_date}}</li>\n</ul>\n<p>Thank you for using our services. We hope to serve you again in the future.</p>\n</div>',NULL,NULL,'Cancellation approved for {{service_name}}. Effective: {{cancellation_date}}',NULL,'Cancellation request approved','Cancellation Approved','{\"service_name\":\"Service Name\",\"cancellation_date\":\"Cancellation Date\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(47,'WELCOME','Welcome Email','Welcome to {{site_name}}!','<div style=\"font-family: Arial, sans-serif;\">\n<p>Welcome to <strong>{{site_name}}</strong>!</p>\n<p>Thank you for registering. Your account has been created successfully.</p>\n<h4>Your Account Details:</h4>\n<ul>\n<li><strong>Username:</strong> {{username}}</li>\n<li><strong>Email:</strong> {{email}}</li>\n</ul>\n<p>You can now log in to your client area and start using our services.</p>\n<p>If you have any questions, feel free to contact our support team.</p>\n</div>',NULL,NULL,'Welcome to {{site_name}}! Your account has been created. Username: {{username}}',NULL,'Welcome to {{site_name}}!','Welcome!','{\"username\":\"User username\",\"email\":\"User email\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(48,'DOMAIN_EXPIRY_REMINDER','Domain Expiry Reminder','Your Domain {{domain_name}} Expires in {{days_remaining}} Days','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>This is a reminder that your domain <strong>{{domain_name}}</strong> will expire on <strong>{{expiry_date}}</strong>.</p>\n<p>You have <strong>{{days_remaining}} days</strong> remaining to renew your domain.</p>\n<p>To avoid losing your domain, please renew it before the expiry date.</p>\n<p><a href=\"{{renewal_link}}\" style=\"background-color: #4CAF50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;\">Renew Now</a></p>\n<p>If you have any questions, please contact our support team.</p>\n</div>',NULL,NULL,'Your domain {{domain_name}} expires in {{days_remaining}} days on {{expiry_date}}. Renew now to avoid losing it.',NULL,'Domain {{domain_name}} expires in {{days_remaining}} days','Domain Expiry Reminder','{\"domain_name\":\"Domain name\",\"expiry_date\":\"Expiry date\",\"days_remaining\":\"Days until expiry\",\"renewal_link\":\"Link to renew domain\"}',1,1,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(49,'SERVICE_EXPIRY_REMINDER','Service Expiry Reminder','Your Service {{service_name}} Expires in {{days_remaining}} Days','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>This is a reminder that your service <strong>{{service_name}}</strong> for <strong>{{service_domain}}</strong> will expire on <strong>{{expiry_date}}</strong>.</p>\n<p>You have <strong>{{days_remaining}} days</strong> remaining.</p>\n<p><strong>Renewal Amount:</strong> {{recurring_amount}} {{site_currency}}</p>\n<p>To ensure uninterrupted service, please ensure your invoice is paid before the due date.</p>\n<p>If you have any questions, please contact our support team.</p>\n</div>',NULL,NULL,'Your service {{service_name}} expires in {{days_remaining}} days. Amount due: {{recurring_amount}}',NULL,'Service {{service_name}} expires in {{days_remaining}} days','Service Expiry Reminder','{\"service_name\":\"Service\\/product name\",\"service_domain\":\"Service domain\",\"expiry_date\":\"Expiry date\",\"days_remaining\":\"Days until expiry\",\"recurring_amount\":\"Renewal amount\"}',1,1,1,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(50,'CANCELLATION_PROCESSED','Cancellation Processed','Your Service Cancellation Has Been Processed','<div style=\"font-family: Arial, sans-serif;\">\n<p>Dear {{fullname}},</p>\n<p>Your cancellation request for <strong>{{service_name}}</strong> ({{service_domain}}) has been processed.</p>\n<p><strong>Cancellation Date:</strong> {{cancellation_date}}</p>\n<p>Thank you for being our customer. If you have any questions or would like to return in the future, please don\'t hesitate to contact us.</p>\n</div>',NULL,NULL,'Your service {{service_name}} has been cancelled as requested.',NULL,'Service {{service_name}} has been cancelled','Service Cancelled','{\"service_name\":\"Service\\/product name\",\"service_domain\":\"Service domain\",\"cancellation_date\":\"Date of cancellation\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(51,'SERVICE_ACTIVATED','Service Activated','Your Service Has Been Activated','Your service has been activated!<br><br><b>Product:</b> {{product}}<br><b>Domain:</b> {{domain}}<br><br>You can now access your service from your client area.',NULL,NULL,'Your service {{product}} has been activated.',NULL,'Service {{product}} activated',NULL,'{\"product\":\"Product name\",\"domain\":\"Domain name\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(52,'SERVICE_SUSPENDED','Service Suspended','Your Service Has Been Suspended','Your service has been suspended.<br><br><b>Product:</b> {{product}}<br><b>Domain:</b> {{domain}}<br><b>Reason:</b> {{reason}}<br><br>Please contact support for assistance.',NULL,NULL,'Your service {{product}} has been suspended.',NULL,'Service {{product}} suspended',NULL,'{\"product\":\"Product name\",\"domain\":\"Domain name\",\"reason\":\"Suspension reason\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(53,'SERVICE_UNSUSPENDED','Service Unsuspended','Your Service Has Been Reactivated','Your service has been reactivated!<br><br><b>Product:</b> {{product}}<br><b>Domain:</b> {{domain}}<br><br>You can now access your service.',NULL,NULL,'Your service {{product}} has been reactivated.',NULL,'Service {{product}} reactivated',NULL,'{\"product\":\"Product name\",\"domain\":\"Domain name\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(54,'SERVICE_TERMINATED','Service Terminated','Your Service Has Been Terminated','Your service has been terminated.<br><br><b>Product:</b> {{product}}<br><b>Domain:</b> {{domain}}<br><br>All data has been removed.',NULL,NULL,'Your service {{product}} has been terminated.',NULL,'Service {{product}} terminated',NULL,'{\"product\":\"Product name\",\"domain\":\"Domain name\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(55,'DOMAIN_REGISTERED','Domain Registered','Domain Registration Successful','Your domain has been registered!<br><br><b>Domain:</b> {{domain}}<br><b>Expiry Date:</b> {{expiry_date}}<br><br>You can manage your domain from your client area.',NULL,NULL,'Domain {{domain}} registered successfully.',NULL,'Domain {{domain}} registered',NULL,'{\"domain\":\"Domain name\",\"expiry_date\":\"Expiry date\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(56,'DOMAIN_RENEWAL_REMINDER','Domain Renewal Reminder','Domain Renewal Reminder - {{domain}}','Your domain is expiring soon!<br><br><b>Domain:</b> {{domain}}<br><b>Expiry Date:</b> {{expiry_date}}<br><br>Please renew your domain to avoid losing it.',NULL,NULL,'Domain {{domain}} expires on {{expiry_date}}. Renew now!',NULL,'Domain {{domain}} expiring soon',NULL,'{\"domain\":\"Domain name\",\"expiry_date\":\"Expiry date\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(57,'DEPOSIT_PENDING','Deposit Pending','Deposit Pending Approval','Your deposit is pending approval.<br><br><b>Amount:</b> {{amount}}<br><b>Method:</b> {{method}}<br><b>Transaction ID:</b> {{trx}}<br><br>We will notify you once approved.',NULL,NULL,'Deposit of {{amount}} pending approval. TRX: {{trx}}',NULL,'Deposit of {{amount}} pending',NULL,'{\"amount\":\"Deposit amount\",\"method\":\"Payment method\",\"trx\":\"Transaction ID\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(58,'DEPOSIT_REJECTED','Deposit Rejected','Deposit Rejected','Your deposit has been rejected.<br><br><b>Amount:</b> {{amount}}<br><b>Method:</b> {{method}}<br><b>Transaction ID:</b> {{trx}}<br><b>Reason:</b> {{reason}}',NULL,NULL,'Deposit of {{amount}} rejected. TRX: {{trx}}',NULL,'Deposit of {{amount}} rejected',NULL,'{\"amount\":\"Deposit amount\",\"method\":\"Payment method\",\"trx\":\"Transaction ID\",\"reason\":\"Rejection reason\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(59,'KYC_APPROVED','KYC Approved','KYC Verification Approved','Your KYC verification has been approved!<br><br>You now have full access to all features.',NULL,NULL,'Your KYC verification has been approved.',NULL,'KYC verification approved',NULL,'{}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03'),(60,'KYC_REJECTED','KYC Rejected','KYC Verification Rejected','Your KYC verification has been rejected.<br><br><b>Reason:</b> {{reason}}<br><br>Please resubmit with correct documents.',NULL,NULL,'Your KYC verification has been rejected.',NULL,'KYC verification rejected',NULL,'{\"reason\":\"Rejection reason\"}',1,0,0,'2025-12-19 15:45:03','2025-12-19 15:45:03');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `orders`
--

DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int(10) unsigned NOT NULL DEFAULT 0,
  `coupon_id` int(10) unsigned DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `amount` decimal(28,18) NOT NULL DEFAULT 0.000000000000000000,
  `discount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `after_discount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `ip_address` text NOT NULL,
  `admin_notes` text DEFAULT NULL COMMENT 'For admin only',
  `status` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=> Active, 2=> Pending, 3=> Cancelled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `fraud_score` tinyint(3) unsigned DEFAULT NULL,
  `fraud_status` enum('pending','passed','review','rejected') DEFAULT NULL,
  `fraud_details` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_orders_user_status` (`user_id`,`status`),
  KEY `idx_orders_status_created` (`status`,`created_at`),
  KEY `idx_orders_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `orders`
--

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `slug` varchar(40) DEFAULT NULL,
  `tempname` varchar(40) DEFAULT NULL COMMENT 'Template name',
  `secs` text DEFAULT NULL COMMENT 'JSON sections',
  `seo_content` text DEFAULT NULL COMMENT 'JSON SEO data',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `auto_created` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'True if page was auto-created by system (e.g., category pages)',
  PRIMARY KEY (`id`),
  KEY `pages_auto_created_index` (`auto_created`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','/','basic','[\"hero\",\"faq\",\"domain\",\"service\"]',NULL,1,'2025-12-19 15:45:04','2025-12-22 03:48:22',0),(2,'About Us','about','basic','[\"faq\"]',NULL,0,'2025-12-19 15:45:04','2025-12-19 15:53:54',0),(3,'Contact','contact','basic',NULL,NULL,0,'2025-12-19 15:45:04','2025-12-19 15:45:04',0),(4,'Home','/','test_theme_modern','[\"service\",\"domain\",\"faq\"]',NULL,1,'2025-12-21 07:32:19','2025-12-21 07:32:19',0),(5,'About Us','about','test_theme_modern','[\"faq\"]',NULL,0,'2025-12-21 07:32:19','2025-12-21 07:32:19',0),(6,'Contact','contact','test_theme_modern',NULL,NULL,0,'2025-12-21 07:32:19','2025-12-21 07:32:19',0),(7,'Home','/','origin','[\"domain\",\"hero\",\"faq\",\"service\"]',NULL,1,'2025-12-21 19:39:18','2025-12-22 02:21:18',0),(8,'About Us','about','origin','[\"faq\"]',NULL,0,'2025-12-21 19:39:18','2025-12-21 19:39:18',0),(9,'Contact','contact','origin',NULL,NULL,0,'2025-12-21 19:39:18','2025-12-21 19:39:18',0),(10,'Support','support','basic','[\"faq\",\"testimonial_section\"]',NULL,0,'2025-12-22 01:55:00','2025-12-22 02:43:16',0),(11,'Home','/','salieno','[\"hero_1\",\"categories\",\"why_choose_us\",\"migration\",\"testimonials\",\"reasons\",\"bottom_cta\"]','{\"meta_title\":\"Home\",\"keywords\":[\"test\",\"1\",\"2\"],\"meta_robots\":\"\",\"description\":\"testing tescription\",\"social_title\":\"Test Social title\",\"social_description\":\"testing social description\"}',1,'2025-12-30 04:45:56','2026-02-21 00:00:40',0),(12,'About Us','about','salieno','[\"faq\"]',NULL,0,'2025-12-30 04:45:56','2025-12-30 04:45:56',0),(13,'Contact','contact','salieno',NULL,NULL,0,'2025-12-30 04:45:56','2025-12-30 04:45:56',0),(15,'Pricing','pricing','salieno','[\"comparison\",\"support_cta\",\"bottom_cta\"]',NULL,1,'2026-01-21 23:40:06','2026-01-22 01:29:58',0),(16,'Domain Registration','domains','salieno','[\"domain\",\"domain_tips\",\"domain_table\",\"domain_features\",\"faq\",\"bottom_cta\"]',NULL,1,'2026-01-22 01:29:58','2026-01-22 20:16:46',0),(17,'Domain Transfer','domains/transfer','salieno','[\"domain_transfer\",\"domain_features\",\"domain_table\",\"bottom_cta\"]',NULL,1,'2026-01-22 01:29:58','2026-01-22 13:30:45',0),(18,'Shared Hosting','shared-hosting','salieno','[\"shared_hosting_banner\",\"category_pricing\",\"category_comparison\",\"shared_hosting_features\",\"why_choose_shared\",\"faq\"]','{\"meta_title\":\"Shared Hosting\",\"meta_description\":\"Affordable web hosting solutions for small to medium websites.\",\"meta_keywords\":null,\"social_title\":\"Shared Hosting\",\"social_description\":\"Affordable web hosting solutions for small to medium websites.\"}',0,'2026-01-23 14:01:24','2026-01-27 02:59:43',1),(19,'Reseller Hosting','reseller-hosting','salieno','[\"reseller_hosting_banner\",\"category_pricing\",\"category_comparison\",\"reseller_hosting_features\",\"reasons_for_reseller\",\"reseller_hosting_setup\",\"reseller_hosting_salieno\",\"faq\"]','{\"meta_title\":\"Reseller Hosting\",\"meta_description\":\"Start your own hosting business with our reseller packages.\",\"meta_keywords\":null,\"social_title\":\"Reseller Hosting\",\"social_description\":\"Start your own hosting business with our reseller packages.\"}',0,'2026-01-23 14:01:24','2026-02-08 14:00:35',1),(20,'VPS Hosting','vps-hosting','salieno','[\"vps_banner\",\"vps_comparison\",\"category_pricing\",\"category_comparison\",\"why_choose_vps_hosting\",\"vps_addons\"]','{\"meta_title\":\"VPS Hosting\",\"meta_description\":\"Virtual private servers with dedicated resources and full root access.\",\"meta_keywords\":null,\"social_title\":\"VPS Hosting\",\"social_description\":\"Virtual private servers with dedicated resources and full root access.\"}',0,'2026-01-23 14:01:24','2026-02-01 15:50:26',1),(21,'Dedicated Servers','dedicated-servers','salieno','[\"category_pricing\",\"category_comparison\"]','{\"meta_title\":\"Dedicated Servers\",\"meta_description\":\"High-performance dedicated servers for enterprise applications.\",\"meta_keywords\":null,\"social_title\":\"Dedicated Servers\",\"social_description\":\"High-performance dedicated servers for enterprise applications.\"}',0,'2026-01-23 14:01:24','2026-01-23 16:01:01',1),(22,'WordPress Hosting','wordpress-hosting','salieno','[\"category_comparison\",\"category_pricing\"]','{\"meta_title\":\"WordPress Hosting\",\"meta_description\":\"Optimized hosting specifically designed for WordPress websites.\",\"meta_keywords\":null,\"social_title\":\"WordPress Hosting\",\"social_description\":\"Optimized hosting specifically designed for WordPress websites.\"}',0,'2026-01-23 14:01:24','2026-01-23 16:01:45',1),(23,'Knowledge Base','kb','salieno','[\"kb\"]',NULL,1,'2026-01-27 00:05:44','2026-01-27 00:05:44',1);
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(40) DEFAULT NULL,
  `token` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_methods`
--

DROP TABLE IF EXISTS `payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `gateway` varchar(50) NOT NULL,
  `gateway_customer_id` varchar(255) DEFAULT NULL,
  `gateway_payment_method_id` varchar(255) DEFAULT NULL,
  `card_brand` varchar(20) DEFAULT NULL,
  `card_last_four` varchar(4) DEFAULT NULL,
  `card_exp_month` tinyint(3) unsigned DEFAULT NULL,
  `card_exp_year` smallint(5) unsigned DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payment_methods_user_id_index` (`user_id`),
  KEY `payment_methods_user_id_is_default_index` (`user_id`,`is_default`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_methods`
--

LOCK TABLES `payment_methods` WRITE;
/*!40000 ALTER TABLE `payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permission_role`
--

DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_role` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permission_role_permission_id_role_id_unique` (`permission_id`,`role_id`),
  KEY `permission_role_role_id_foreign` (`role_id`),
  CONSTRAINT `permission_role_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `permission_role_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permission_role`
--

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` VALUES (1,1,1),(12,1,2),(37,1,3),(71,1,4),(84,1,5),(2,2,1),(13,2,2),(85,2,5),(3,3,1),(14,3,2),(4,9,1),(15,9,2),(86,9,5),(16,10,2),(87,11,5),(38,25,3),(39,26,3),(40,27,3),(41,37,3),(42,38,3),(43,39,3),(44,41,3),(45,42,3),(46,43,3),(47,45,3),(48,46,3),(49,48,3),(50,49,3),(51,50,3),(52,54,3),(53,55,3),(54,56,3),(55,57,3),(56,58,3),(57,60,3),(58,61,3),(59,62,3),(60,63,3),(61,64,3),(62,65,3),(63,66,3),(64,67,3),(65,68,3),(66,72,3),(67,73,3),(17,75,2),(18,76,2),(19,77,2),(20,78,2),(21,79,2),(22,80,2),(23,81,2),(24,82,2),(88,82,5),(25,83,2),(89,83,5),(26,84,2),(90,84,5),(91,85,5),(92,86,5),(27,87,2),(93,87,5),(94,88,5),(95,89,5),(96,90,5),(97,91,5),(98,92,5),(99,93,5),(100,97,5),(28,102,2),(101,102,5),(29,103,2),(102,103,5),(103,104,5),(104,105,5),(30,107,2),(105,107,5),(31,108,2),(106,108,5),(32,109,2),(107,109,5),(33,110,2),(108,110,5),(34,111,2),(35,112,2),(36,113,2),(5,115,1),(6,116,1),(7,117,1),(8,118,1),(68,118,3),(9,119,1),(69,119,3),(10,120,1),(70,120,3),(11,121,1),(109,123,5),(72,149,4),(73,153,4),(74,155,4),(75,156,4),(76,161,4),(77,162,4),(78,163,4),(79,164,4),(80,165,4),(81,167,4),(82,168,4),(83,169,4);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `group` varchar(40) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'View Dashboard','Dashboard','admin.dashboard'),(2,'View All Users','User Management','admin.users.all'),(3,'View Active Users','User Management','admin.users.active'),(4,'View Banned Users','User Management','admin.users.banned'),(5,'View Email Unverified','User Management','admin.users.email.unverified'),(6,'View Mobile Unverified','User Management','admin.users.mobile.unverified'),(7,'View KYC Unverified','User Management','admin.users.kyc.unverified'),(8,'View KYC Pending','User Management','admin.users.kyc.pending'),(9,'View User Details','User Management','admin.users.detail'),(10,'Update User','User Management','admin.users.update'),(11,'Add/Subtract Balance','User Management','admin.users.add.sub.balance'),(12,'Login As User','User Management','admin.users.login'),(13,'Send Notification','User Management','admin.users.notification.single'),(14,'Send Notification All','User Management','admin.users.notification.all'),(15,'View KYC Pending','KYC Management','admin.kyc.pending'),(16,'View KYC Approved','KYC Management','admin.kyc.approved'),(17,'View KYC Rejected','KYC Management','admin.kyc.rejected'),(18,'View KYC Details','KYC Management','admin.kyc.details'),(19,'Approve KYC','KYC Management','admin.kyc.approve'),(20,'Reject KYC','KYC Management','admin.kyc.reject'),(21,'View Categories','Product Management','admin.category.index'),(22,'Create Category','Product Management','admin.category.store'),(23,'Update Category','Product Management','admin.category.update'),(24,'Delete Category','Product Management','admin.category.delete'),(25,'View Products','Product Management','admin.product.index'),(26,'Create Product','Product Management','admin.product.store'),(27,'Update Product','Product Management','admin.product.update'),(28,'Delete Product','Product Management','admin.product.delete'),(29,'View Groups','Configurable Options','admin.configurable.group.index'),(30,'Create Group','Configurable Options','admin.configurable.group.store'),(31,'Update Group','Configurable Options','admin.configurable.group.update'),(32,'Delete Group','Configurable Options','admin.configurable.group.delete'),(33,'View Options','Configurable Options','admin.configurable.option.index'),(34,'Create Option','Configurable Options','admin.configurable.option.store'),(35,'Update Option','Configurable Options','admin.configurable.option.update'),(36,'Delete Option','Configurable Options','admin.configurable.option.delete'),(37,'View Server Groups','Server Management','admin.server.group.index'),(38,'Create Server Group','Server Management','admin.server.group.store'),(39,'Update Server Group','Server Management','admin.server.group.update'),(40,'Delete Server Group','Server Management','admin.server.group.delete'),(41,'View Servers','Server Management','admin.server.index'),(42,'Create Server','Server Management','admin.server.store'),(43,'Update Server','Server Management','admin.server.update'),(44,'Delete Server','Server Management','admin.server.delete'),(45,'Test Server Connection','Server Management','admin.server.test'),(46,'View Domain Registrars','Domain Management','admin.domain.registrar.index'),(47,'Configure Registrar','Domain Management','admin.domain.registrar.configure'),(48,'View Domain Setups','Domain Management','admin.domain.setup.index'),(49,'Create Domain Setup','Domain Management','admin.domain.setup.store'),(50,'Update Domain Setup','Domain Management','admin.domain.setup.update'),(51,'Delete Domain Setup','Domain Management','admin.domain.setup.delete'),(52,'View Domain Pricing','Domain Management','admin.domain.pricing.index'),(53,'Update Domain Pricing','Domain Management','admin.domain.pricing.update'),(54,'View All Hostings','Hosting Management','admin.hosting.all'),(55,'View Active Hostings','Hosting Management','admin.hosting.active'),(56,'View Pending Hostings','Hosting Management','admin.hosting.pending'),(57,'View Suspended Hostings','Hosting Management','admin.hosting.suspended'),(58,'View Terminated Hostings','Hosting Management','admin.hosting.terminated'),(59,'View Cancelled Hostings','Hosting Management','admin.hosting.cancelled'),(60,'View Hosting Details','Hosting Management','admin.hosting.detail'),(61,'Update Hosting','Hosting Management','admin.hosting.update'),(62,'Create Hosting Account','Hosting Management','admin.hosting.create.account'),(63,'Suspend Hosting','Hosting Management','admin.hosting.suspend'),(64,'Unsuspend Hosting','Hosting Management','admin.hosting.unsuspend'),(65,'Terminate Hosting','Hosting Management','admin.hosting.terminate'),(66,'View All Domains','Domain Services','admin.domain.all'),(67,'View Active Domains','Domain Services','admin.domain.active'),(68,'View Pending Domains','Domain Services','admin.domain.pending'),(69,'View Suspended Domains','Domain Services','admin.domain.suspended'),(70,'View Terminated Domains','Domain Services','admin.domain.terminated'),(71,'View Cancelled Domains','Domain Services','admin.domain.cancelled'),(72,'View Domain Details','Domain Services','admin.domain.detail'),(73,'Update Domain','Domain Services','admin.domain.update'),(74,'Register Domain','Domain Services','admin.domain.register'),(75,'View All Orders','Order Management','admin.order.all'),(76,'View Pending Orders','Order Management','admin.order.pending'),(77,'View Active Orders','Order Management','admin.order.active'),(78,'View Cancelled Orders','Order Management','admin.order.cancelled'),(79,'View Order Details','Order Management','admin.order.detail'),(80,'Accept Order','Order Management','admin.order.accept'),(81,'Cancel Order','Order Management','admin.order.cancel'),(82,'View All Invoices','Invoice Management','admin.invoice.all'),(83,'View Unpaid Invoices','Invoice Management','admin.invoice.unpaid'),(84,'View Paid Invoices','Invoice Management','admin.invoice.paid'),(85,'View Cancelled Invoices','Invoice Management','admin.invoice.cancelled'),(86,'View Refunded Invoices','Invoice Management','admin.invoice.refunded'),(87,'View Invoice Details','Invoice Management','admin.invoice.detail'),(88,'Create Invoice','Invoice Management','admin.invoice.create'),(89,'Update Invoice','Invoice Management','admin.invoice.update'),(90,'Mark Invoice Paid','Invoice Management','admin.invoice.mark.paid'),(91,'Cancel Invoice','Invoice Management','admin.invoice.cancel'),(92,'Refund Invoice','Invoice Management','admin.invoice.refund'),(93,'View Automatic Gateways','Payment Gateways','admin.gateway.automatic.index'),(94,'Update Automatic Gateway','Payment Gateways','admin.gateway.automatic.update'),(95,'Activate Automatic Gateway','Payment Gateways','admin.gateway.automatic.activate'),(96,'Deactivate Automatic Gateway','Payment Gateways','admin.gateway.automatic.deactivate'),(97,'View Manual Gateways','Payment Gateways','admin.gateway.manual.index'),(98,'Create Manual Gateway','Payment Gateways','admin.gateway.manual.store'),(99,'Update Manual Gateway','Payment Gateways','admin.gateway.manual.update'),(100,'Activate Manual Gateway','Payment Gateways','admin.gateway.manual.activate'),(101,'Deactivate Manual Gateway','Payment Gateways','admin.gateway.manual.deactivate'),(102,'View Pending Deposits','Deposits','admin.deposit.pending'),(103,'View Approved Deposits','Deposits','admin.deposit.approved'),(104,'View Successful Deposits','Deposits','admin.deposit.successful'),(105,'View Rejected Deposits','Deposits','admin.deposit.rejected'),(106,'View Initiated Deposits','Deposits','admin.deposit.initiated'),(107,'View All Deposits','Deposits','admin.deposit.all'),(108,'View Deposit Details','Deposits','admin.deposit.details'),(109,'Approve Deposit','Deposits','admin.deposit.approve'),(110,'Reject Deposit','Deposits','admin.deposit.reject'),(111,'View Coupons','Coupons','admin.coupon.index'),(112,'Create Coupon','Coupons','admin.coupon.store'),(113,'Update Coupon','Coupons','admin.coupon.update'),(114,'Delete Coupon','Coupons','admin.coupon.delete'),(115,'View Pending Tickets','Support Tickets','admin.ticket.pending'),(116,'View Closed Tickets','Support Tickets','admin.ticket.closed'),(117,'View Answered Tickets','Support Tickets','admin.ticket.answered'),(118,'View All Tickets','Support Tickets','admin.ticket.index'),(119,'View Ticket Details','Support Tickets','admin.ticket.view'),(120,'Reply to Ticket','Support Tickets','admin.ticket.reply'),(121,'Close Ticket','Support Tickets','admin.ticket.close'),(122,'Delete Ticket','Support Tickets','admin.ticket.delete'),(123,'View Transaction Report','Reports','admin.report.transaction'),(124,'View Login History','Reports','admin.report.login.history'),(125,'View Notification Log','Reports','admin.report.notification.history'),(126,'View Subscribers','Subscribers','admin.subscriber.index'),(127,'Send Email to Subscribers','Subscribers','admin.subscriber.send.email'),(128,'Delete Subscriber','Subscribers','admin.subscriber.delete'),(129,'View General Settings','General Settings','admin.setting.general'),(130,'Update General Settings','General Settings','admin.setting.general.update'),(131,'View System Configuration','General Settings','admin.setting.system.configuration'),(132,'Update System Configuration','General Settings','admin.setting.system.configuration.update'),(133,'View Logo Favicon','General Settings','admin.setting.logo.icon'),(134,'Update Logo Favicon','General Settings','admin.setting.logo.icon.update'),(135,'View Billing Settings','Billing Settings','admin.billing.setting'),(136,'Update Billing Settings','Billing Settings','admin.billing.setting.update'),(137,'View Invoice Settings','Billing Settings','admin.invoice.setting'),(138,'Update Invoice Settings','Billing Settings','admin.invoice.setting.update'),(139,'View Global Template','Notification Settings','admin.setting.notification.global'),(140,'Update Global Template','Notification Settings','admin.setting.notification.global.update'),(141,'View Email Setting','Notification Settings','admin.setting.notification.email'),(142,'Update Email Setting','Notification Settings','admin.setting.notification.email.update'),(143,'View SMS Setting','Notification Settings','admin.setting.notification.sms'),(144,'Update SMS Setting','Notification Settings','admin.setting.notification.sms.update'),(145,'View Push Setting','Notification Settings','admin.setting.notification.push'),(146,'Update Push Setting','Notification Settings','admin.setting.notification.push.update'),(147,'View Templates','Notification Settings','admin.setting.notification.templates'),(148,'Update Template','Notification Settings','admin.setting.notification.template.update'),(149,'View Languages','Language Management','admin.language.manage'),(150,'Create Language','Language Management','admin.language.manage.store'),(151,'Update Language','Language Management','admin.language.manage.update'),(152,'Delete Language','Language Management','admin.language.manage.delete'),(153,'Edit Language Keys','Language Management','admin.language.key'),(154,'Import Language Keys','Language Management','admin.language.import.lang'),(155,'View SEO Settings','SEO Settings','admin.seo'),(156,'Update SEO Settings','SEO Settings','admin.seo.update'),(157,'View Extensions','Extensions','admin.extensions.index'),(158,'Update Extension','Extensions','admin.extensions.update'),(159,'Activate Extension','Extensions','admin.extensions.activate'),(160,'Deactivate Extension','Extensions','admin.extensions.deactivate'),(161,'Manage Templates','Frontend Management','admin.frontend.templates'),(162,'Manage Frontend Sections','Frontend Management','admin.frontend.sections'),(163,'Manage Pages','Frontend Management','admin.frontend.manage.pages'),(164,'Create Page','Frontend Management','admin.frontend.manage.pages.store'),(165,'Update Page','Frontend Management','admin.frontend.manage.pages.update'),(166,'Delete Page','Frontend Management','admin.frontend.manage.pages.delete'),(167,'Manage Blog','Frontend Management','admin.frontend.blog'),(168,'Create Blog','Frontend Management','admin.frontend.blog.store'),(169,'Update Blog','Frontend Management','admin.frontend.blog.update'),(170,'Delete Blog','Frontend Management','admin.frontend.blog.delete'),(171,'View Cron Jobs','Cron Jobs','admin.cron.index'),(172,'Run Cron Job','Cron Jobs','admin.cron.run'),(173,'View Cron Logs','Cron Jobs','admin.cron.logs'),(174,'View Cron Schedules','Cron Jobs','admin.cron.schedules'),(175,'Update Cron Schedule','Cron Jobs','admin.cron.schedule.update'),(176,'View Pending Requests','Cancel Requests','admin.cancel.request.pending'),(177,'View Approved Requests','Cancel Requests','admin.cancel.request.approved'),(178,'View Rejected Requests','Cancel Requests','admin.cancel.request.rejected'),(179,'View All Requests','Cancel Requests','admin.cancel.request.all'),(180,'Approve Request','Cancel Requests','admin.cancel.request.approve'),(181,'Reject Request','Cancel Requests','admin.cancel.request.reject'),(182,'View Staff','Staff Management','admin.staff.index'),(183,'Create Staff','Staff Management','admin.staff.store'),(184,'Update Staff','Staff Management','admin.staff.update'),(185,'Delete Staff','Staff Management','admin.staff.delete'),(186,'Login As Staff','Staff Management','admin.staff.login'),(187,'View Roles','Role Management','admin.roles.index'),(188,'Create Role','Role Management','admin.roles.store'),(189,'Update Role','Role Management','admin.roles.update'),(190,'Delete Role','Role Management','admin.roles.delete'),(191,'View System Info','System','admin.system.info'),(192,'Clear Cache','System','admin.system.cache.clear'),(193,'View Update Logs','System','admin.system.update.log'),(194,'Request Report','System','admin.request.report'),(195,'View Maintenance Mode','Maintenance Mode','admin.maintenance.mode'),(196,'Update Maintenance Mode','Maintenance Mode','admin.maintenance.mode.update'),(197,'View GDPR Cookie','GDPR Cookie','admin.setting.cookie'),(198,'Update GDPR Cookie','GDPR Cookie','admin.setting.cookie.update'),(199,'View Custom CSS','Custom CSS','admin.setting.custom.css'),(200,'Update Custom CSS','Custom CSS','admin.setting.custom.css.update'),(201,'View Sitemap','Sitemap','admin.setting.sitemap'),(202,'Generate Sitemap','Sitemap','admin.setting.sitemap.generate'),(203,'View Robots.txt','Robots.txt','admin.setting.robot'),(204,'Update Robots.txt','Robots.txt','admin.setting.robot.update'),(205,'View Support Categories','Support Management','admin.support.categories'),(206,'View Canned Responses','Support Management','admin.support.canned'),(207,'View KB Categories','Knowledge Base','admin.kb.categories'),(208,'Create KB Category','Knowledge Base','admin.kb.category.store'),(209,'Update KB Category','Knowledge Base','admin.kb.category.update'),(210,'Delete KB Category','Knowledge Base','admin.kb.category.delete'),(211,'View KB Articles','Knowledge Base','admin.kb.articles'),(212,'Create KB Article','Knowledge Base','admin.kb.articles.create'),(213,'Update KB Article','Knowledge Base','admin.kb.articles.edit');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pricings`
--

DROP TABLE IF EXISTS `pricings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pricings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL COMMENT 'product or configurable_option',
  `product_id` int(10) unsigned NOT NULL DEFAULT 0,
  `configurable_group_sub_option_id` int(10) unsigned NOT NULL DEFAULT 0,
  `monthly_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `quarterly_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `semi_annually_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `annually_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `biennially_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `triennially_setup_fee` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `monthly` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `quarterly` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `semi_annually` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `annually` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `biennially` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `triennially` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `discount_type` tinyint(4) DEFAULT NULL,
  `discount_value` decimal(10,2) DEFAULT NULL,
  `discount_monthly` decimal(10,2) DEFAULT NULL,
  `discount_quarterly` decimal(10,2) DEFAULT NULL,
  `discount_semi_annually` decimal(10,2) DEFAULT NULL,
  `discount_annually` decimal(10,2) DEFAULT NULL,
  `discount_biennially` decimal(10,2) DEFAULT NULL,
  `discount_triennially` decimal(10,2) DEFAULT NULL,
  `discount_start_date` timestamp NULL DEFAULT NULL,
  `discount_end_date` timestamp NULL DEFAULT NULL,
  `promo_badge_text` varchar(50) DEFAULT NULL,
  `promo_badge_color` varchar(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `addon_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pricings_discount_dates_index` (`discount_start_date`,`discount_end_date`),
  KEY `pricings_addon_id_foreign` (`addon_id`),
  CONSTRAINT `pricings_addon_id_foreign` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pricings`
--

LOCK TABLES `pricings` WRITE;
/*!40000 ALTER TABLE `pricings` DISABLE KEYS */;
INSERT INTO `pricings` VALUES (1,'product',1,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,4.99000000,14.22150000,26.94600000,50.89800000,95.80800000,134.73000000,1,20.00,NULL,NULL,NULL,NULL,NULL,NULL,'2026-01-20 00:33:11','2026-02-20 00:33:11',NULL,NULL,'2025-12-19 15:45:08','2026-01-21 00:33:11',NULL),(2,'product',2,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,9.99000000,28.47000000,53.95000000,101.90000000,-1.00000000,-1.00000000,1,15.00,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'10% OFF','red','2025-12-19 15:45:08','2026-01-25 18:20:24',NULL),(3,'product',3,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,10.99000000,56.97000000,90.95000000,203.90000000,370.81000000,539.73000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-19 15:45:08','2026-01-19 18:09:08',NULL),(4,'product',4,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,24.99000000,71.22150000,134.94600000,254.89800000,479.80800000,674.73000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-19 15:45:08','2025-12-24 22:42:14',NULL),(5,'product',5,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,29.99000000,85.47150000,161.94600000,305.89800000,575.80800000,809.73000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-12-19 15:45:08','2025-12-24 22:42:14',NULL),(6,'product',6,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-08 14:18:54','2026-02-08 14:18:54',NULL),(7,'product',7,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,59.99000000,18.00000000,20.00000000,20.00000000,400.00000000,16.00000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-08 15:03:44','2026-02-08 15:08:30',NULL),(8,'product',8,0,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,99.99000000,0.00000000,0.00000000,0.00000000,0.00000000,0.00000000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2026-02-08 15:08:30','2026-02-08 15:08:30',NULL);
/*!40000 ALTER TABLE `pricings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_addons`
--

DROP TABLE IF EXISTS `product_addons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_addons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `addon_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_addons_product_id_foreign` (`product_id`),
  KEY `product_addons_addon_id_foreign` (`addon_id`),
  CONSTRAINT `product_addons_addon_id_foreign` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_addons_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_addons`
--

LOCK TABLES `product_addons` WRITE;
/*!40000 ALTER TABLE `product_addons` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_addons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_configurations`
--

DROP TABLE IF EXISTS `product_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_configurations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `configurable_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `product_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_configurations`
--

LOCK TABLES `product_configurations` WRITE;
/*!40000 ALTER TABLE `product_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_configurations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_features`
--

DROP TABLE IF EXISTS `product_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_features` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `type` enum('included','limited','unlimited','custom','excluded') NOT NULL DEFAULT 'included',
  `icon` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `comparison_group` varchar(100) DEFAULT NULL,
  `tooltip_text` text DEFAULT NULL,
  `display_in_pricing` tinyint(1) NOT NULL DEFAULT 1,
  `display_in_comparison` tinyint(1) NOT NULL DEFAULT 1,
  `category` varchar(100) DEFAULT NULL,
  `badge_text` varchar(30) DEFAULT NULL,
  `badge_color` varchar(20) DEFAULT NULL,
  `is_highlighted` tinyint(1) NOT NULL DEFAULT 0,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_feature_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_features_product_id_sort_order_index` (`product_id`,`sort_order`),
  KEY `product_features_pricing_index` (`product_id`,`display_in_pricing`),
  KEY `product_features_comparison_index` (`product_id`,`display_in_comparison`),
  KEY `product_features_group_index` (`product_id`,`comparison_group`),
  KEY `product_features_category_feature_id_foreign` (`category_feature_id`),
  CONSTRAINT `product_features_category_feature_id_foreign` FOREIGN KEY (`category_feature_id`) REFERENCES `category_features` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_features_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_features`
--

LOCK TABLES `product_features` WRITE;
/*!40000 ALTER TABLE `product_features` DISABLE KEYS */;
INSERT INTO `product_features` VALUES (1,1,'10 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,1,'2026-01-21 03:29:37','2026-01-21 03:29:37',1),(2,2,'25 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,'NEW','red',0,1,'2026-01-21 03:29:37','2026-01-21 13:29:20',1),(3,3,'50 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,1,'2026-01-21 03:29:37','2026-01-21 03:29:37',1),(4,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,2,'2026-01-21 03:29:37','2026-01-21 03:29:37',2),(5,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,2,'2026-01-21 03:29:37','2026-01-21 03:29:37',2),(6,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,2,'2026-01-21 03:29:37','2026-01-21 03:29:37',2),(7,1,'1 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,3,'2026-01-21 03:29:37','2026-01-21 03:29:37',3),(8,2,'2 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,3,'2026-01-21 03:29:37','2026-01-21 03:29:37',3),(9,3,'4 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,3,'2026-01-21 03:29:37','2026-01-21 03:29:37',3),(10,1,'1',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,4,'2026-01-21 03:29:37','2026-01-21 03:29:37',4),(11,2,'2',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,4,'2026-01-21 03:29:37','2026-01-21 03:29:37',4),(12,3,'4',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,4,'2026-01-21 03:29:37','2026-01-21 03:29:37',4),(13,1,'1',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,5,'2026-01-21 03:29:37','2026-01-21 03:29:37',5),(14,2,'5',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,5,'2026-01-21 03:29:37','2026-01-21 03:29:37',5),(15,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,5,'2026-01-21 03:29:37','2026-01-21 03:29:37',5),(16,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,6,'2026-01-21 03:29:37','2026-01-21 03:29:37',6),(17,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,6,'2026-01-21 03:29:37','2026-01-21 03:29:37',6),(18,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,6,'2026-01-21 03:29:37','2026-01-21 03:29:37',6),(19,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,7,'2026-01-21 03:29:37','2026-01-21 03:29:37',7),(20,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,7,'2026-01-21 03:29:37','2026-01-21 03:29:37',7),(21,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,7,'2026-01-21 03:29:37','2026-01-21 03:29:37',7),(22,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,8,'2026-01-21 03:29:37','2026-01-21 03:29:37',8),(23,2,'Unlimited',NULL,'excluded',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,8,'2026-01-21 03:29:37','2026-01-21 03:39:19',8),(24,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,8,'2026-01-21 03:29:37','2026-01-21 03:29:37',8),(25,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,9,'2026-01-21 03:29:37','2026-01-21 03:29:37',9),(26,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,9,'2026-01-21 03:29:37','2026-01-21 03:29:37',9),(27,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,9,'2026-01-21 03:29:37','2026-01-21 03:29:37',9),(28,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,10,'2026-01-21 03:29:37','2026-01-21 03:29:37',10),(29,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,10,'2026-01-21 03:29:37','2026-01-21 03:29:37',10),(30,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,10,'2026-01-21 03:29:37','2026-01-21 03:29:37',10),(31,1,'No',NULL,'excluded',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,11,'2026-01-21 03:29:37','2026-01-21 03:29:37',11),(32,2,'Yes',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,11,'2026-01-21 03:29:37','2026-01-21 03:29:37',11),(33,3,'Yes',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,11,'2026-01-21 03:29:37','2026-01-21 03:29:37',11),(34,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,12,'2026-01-21 03:29:37','2026-01-21 03:29:37',12),(35,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,12,'2026-01-21 03:29:37','2026-01-21 03:29:37',12),(36,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,12,'2026-01-21 03:29:37','2026-01-21 03:29:37',12),(37,1,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,13,'2026-01-21 03:29:37','2026-01-21 03:29:37',13),(38,2,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,13,'2026-01-21 03:29:37','2026-01-21 03:29:37',13),(39,3,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,13,'2026-01-21 03:29:37','2026-01-21 03:29:37',13),(40,4,'50 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,1,'2026-01-21 03:29:37','2026-01-21 03:29:37',14),(41,4,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,2,'2026-01-21 03:29:37','2026-01-21 03:29:37',15),(42,4,'10',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,3,'2026-01-21 03:29:37','2026-01-21 03:29:37',16),(43,4,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,4,'2026-01-21 03:29:37','2026-01-21 03:29:37',17),(44,4,'No',NULL,'excluded',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,5,'2026-01-21 03:29:37','2026-01-21 03:29:37',18),(45,4,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,6,'2026-01-21 03:29:37','2026-01-21 03:29:37',19),(46,4,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,7,'2026-01-21 03:29:37','2026-01-21 03:29:37',20),(47,5,'2 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,1,'2026-01-21 03:29:37','2026-01-21 03:29:37',29),(48,5,'2',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,2,'2026-01-21 03:29:37','2026-01-21 03:29:37',30),(49,5,'50 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,3,'2026-01-21 03:29:37','2026-01-21 03:29:37',31),(50,5,'No',NULL,'excluded',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,4,'2026-01-21 03:29:37','2026-01-21 03:29:37',32),(51,5,'No',NULL,'excluded',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,5,'2026-01-21 03:29:37','2026-01-21 03:29:37',33),(52,5,'Unlimited',NULL,'unlimited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,6,'2026-01-21 03:29:37','2026-01-21 03:29:37',34),(54,7,'16 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',29),(55,7,'8',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',30),(56,7,'400 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',31),(57,7,'Yes',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',32),(58,7,'1 IPv4',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',33),(59,7,'Yes',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',34),(60,8,'32 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',29),(61,8,'16',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',30),(62,8,'800 GB',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',31),(63,8,'Yes',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',32),(64,8,'2 IPv4',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',33),(65,8,'VIP Managed',NULL,'limited',NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,0,0,'2026-02-08 15:08:30','2026-02-08 15:08:30',34);
/*!40000 ALTER TABLE `product_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT 0,
  `upgrade_group_id` int(10) unsigned DEFAULT NULL COMMENT 'Products with same upgrade_group_id can be upgraded/downgraded between each other',
  `server_group_id` int(10) unsigned DEFAULT 0,
  `server_id` int(10) unsigned NOT NULL DEFAULT 0,
  `package_name` varchar(255) DEFAULT NULL COMMENT 'From WHM API',
  `product_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1 => Shared Hosting, 2 => Reseller Hosting, 3 => Server/VPS, 4 => Other',
  `payment_type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=> One Time, 2=> Recurring',
  `module_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0 => None, 1 => cPanel, 2 => DirectAdmin, 3 => Plesk',
  `module_option` tinyint(4) NOT NULL DEFAULT 3 COMMENT '1 => Auto setup on payment, 2 => Auto setup on order accept, 3 => No auto setup',
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `welcome_email` varchar(255) DEFAULT NULL,
  `domain_register` tinyint(1) NOT NULL DEFAULT 0,
  `stock_control` tinyint(1) NOT NULL DEFAULT 0,
  `stock_quantity` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_featured` tinyint(1) NOT NULL DEFAULT 0,
  `is_popular` tinyint(1) NOT NULL DEFAULT 0,
  `badge_text` varchar(50) DEFAULT NULL,
  `badge_color` varchar(20) DEFAULT NULL,
  `tagline` varchar(255) DEFAULT NULL,
  `ribbon_text` varchar(50) DEFAULT NULL,
  `ribbon_color` varchar(20) DEFAULT NULL,
  `ribbon_position` varchar(20) NOT NULL DEFAULT 'top-right',
  `is_recommended` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(20) DEFAULT NULL,
  `highlight_border_color` varchar(20) DEFAULT NULL,
  `comparison_order` int(11) NOT NULL DEFAULT 0,
  `show_in_comparison` tinyint(1) NOT NULL DEFAULT 1,
  `price_prefix` varchar(20) DEFAULT NULL,
  `price_suffix` varchar(50) DEFAULT NULL,
  `cta_text` varchar(50) DEFAULT NULL,
  `cta_color` varchar(20) DEFAULT NULL,
  `features_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `allow_upgrade` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Whether this product allows upgrades/downgrades',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_status_category_sort_index` (`status`,`category_id`,`sort_order`),
  KEY `products_is_featured_status_index` (`is_featured`,`status`),
  KEY `products_slug_status_index` (`slug`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,1,2,1,0,'starter_plan',1,2,1,3,'Starter Plan','starter-plan','Perfect for personal websites and blogs. Includes 5GB SSD storage, 1 website, and free SSL.','0',1,0,0,1,0,0,NULL,NULL,NULL,NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2025-12-19 15:45:08','2026-02-01 19:40:23'),(2,1,2,1,1,'salienonet_salienoplan',1,2,1,1,'Business Plan','business-plan','Ideal for small businesses. Includes 25GB SSD storage, 10 websites, and free SSL.','1',1,0,0,1,0,1,'HOT',NULL,NULL,'BEST VALUE','red','top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2025-12-19 15:45:08','2026-01-21 00:25:50'),(3,1,2,1,1,'salienonet_salienoplan',1,2,1,3,'Enterprise Plan','enterprise-plan','For high-traffic websites. Includes 100GB SSD storage, unlimited websites, and priority support.',NULL,0,0,0,1,1,0,NULL,NULL,NULL,NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2025-12-19 15:45:08','2026-02-01 19:40:23'),(4,2,1,1,0,'reseller_basic',2,2,1,3,'Reseller Basic','reseller-basic','Start your hosting business with 50GB SSD storage and 25 cPanel accounts.','0',0,0,0,1,0,0,NULL,NULL,NULL,NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2025-12-19 15:45:08','2026-01-20 16:20:01'),(5,3,NULL,1,0,'vps_starter',3,2,1,3,'VPS Starter','vps-starter','2 vCPU, 4GB RAM, 80GB SSD, 2TB bandwidth. Full root access included.','0',0,1,10,1,0,0,NULL,NULL,NULL,NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2025-12-19 15:45:08','2026-02-08 14:13:10'),(7,3,NULL,5,0,NULL,3,2,1,1,'VPS Master','vps-master','Unleash high-performance computing with dedicated resources and enterprise NVMe storage tailored for demanding applications.','3',0,0,0,1,1,0,NULL,NULL,'Professional Infrastructure for Scale',NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'2026-02-08 15:03:44','2026-02-08 15:08:30'),(8,3,NULL,4,5,NULL,3,2,1,1,'VPS Ultra','vps-ultra','The ultimate VPS experience. Massive processing power, double the RAM, and VIP managed support for mission-critical workloads.',NULL,0,0,0,1,0,0,'RECOMMENDED','indigo','Maximum Performance Unleashed',NULL,NULL,'top-right',0,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,1,'2026-02-08 15:08:30','2026-02-08 15:11:03');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Support Agent','2025-12-19 15:45:05','2025-12-19 15:45:05'),(2,'Sales Manager','2025-12-19 15:45:05','2025-12-19 15:45:05'),(3,'Technical Admin','2025-12-19 15:45:05','2025-12-19 15:45:05'),(4,'Content Manager','2025-12-19 15:45:05','2025-12-19 15:45:05'),(5,'Finance Manager','2025-12-19 15:45:05','2025-12-19 15:45:05');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `server_groups`
--

DROP TABLE IF EXISTS `server_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `server_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=cPanel, 2=DirectAdmin, 3=Plesk',
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `server_groups`
--

LOCK TABLES `server_groups` WRITE;
/*!40000 ALTER TABLE `server_groups` DISABLE KEYS */;
INSERT INTO `server_groups` VALUES (1,'cPanel US Servers',1,1,'2025-12-19 15:45:08','2025-12-19 15:45:08'),(2,'cPanel EU Servers',1,1,'2025-12-19 15:45:08','2025-12-19 15:45:08'),(3,'DirectAdmin Servers',2,1,'2025-12-19 15:45:08','2025-12-19 15:45:08'),(4,'Plesk Windows Servers',3,1,'2025-12-19 15:45:08','2025-12-19 15:45:08'),(5,'VPS Servers',1,0,'2025-12-19 15:45:08','2025-12-19 15:45:08');
/*!40000 ALTER TABLE `server_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers`
--

DROP TABLE IF EXISTS `servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `servers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `server_group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL COMMENT 'cpanel, directadmin, plesk',
  `hostname` varchar(255) NOT NULL,
  `protocol` varchar(45) DEFAULT NULL,
  `port` varchar(45) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `ip_address` varchar(255) DEFAULT NULL,
  `api_token` text NOT NULL,
  `security_token` varchar(255) NOT NULL,
  `ns1` varchar(255) NOT NULL,
  `ns1_ip` varchar(255) NOT NULL,
  `ns2` varchar(255) NOT NULL,
  `ns2_ip` varchar(255) NOT NULL,
  `ns3` varchar(255) DEFAULT NULL,
  `ns3_ip` varchar(255) DEFAULT NULL,
  `ns4` varchar(255) DEFAULT NULL,
  `ns4_ip` varchar(255) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `assigned_accounts` int(10) unsigned NOT NULL DEFAULT 0,
  `max_accounts` int(10) unsigned NOT NULL DEFAULT 100,
  `resource_weight` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Current total resource weight of assigned accounts',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers`
--

LOCK TABLES `servers` WRITE;
/*!40000 ALTER TABLE `servers` DISABLE KEYS */;
INSERT INTO `servers` VALUES (2,1,'US-WEB-02','1','us-web-02.salieno.com','https','2087','us-web-02.salieno.com','root','eyJpdiI6Im0yVmFHc205S2txV2hqRzdiMFpKS0E9PSIsInZhbHVlIjoiT0dtbWhCMlJ2OC9lT0l5dzg3ajBZV3BqeXF1WGxTZ0JaZVNIUGVwSzlXQT0iLCJtYWMiOiIzM2EyZTIyOTI0M2QyNzAzYzlhMDAzNWUxODhiMjA1OWI2NTcwYzRiZTIyYjdlYzQxNjRjZmU1OGM5YjM4M2Y5IiwidGFnIjoiIn0=','192.168.1.102','eyJpdiI6IjdUVUQxQ1RFOFlCK2JoT1YwTENMRXc9PSIsInZhbHVlIjoidG9rQS9aUTRqRk5YQU4rSytCU2xjSll2QUFwQi9RYTQxWWQvZFlpS1hqaz0iLCJtYWMiOiI3MmRlMzRhZTIzOWM3NGM0ZWIwOTAxOGE2NjIxMDhlYTBlMGQwMjRjN2I1Yzc2YTdlZmQxYWIxNzcwNGQ3ZTc3IiwidGFnIjoiIn0=','sec_token_us02_b5dc0f4ad01c491889df0855aedf19ff','ns1.salieno.com','192.168.1.10','ns2.salieno.com','192.168.1.11',NULL,NULL,NULL,NULL,1,'2025-12-19 15:45:08','2025-12-19 15:45:08',0,100,0),(3,2,'EU-WEB-01','1','eu-web-01.salieno.com','https','2087','eu-web-01.salieno.com','root','eyJpdiI6InZyR1MxZ28xOHU5QXBxZUVkbVFjRnc9PSIsInZhbHVlIjoiWkd3Y2ZaV1Z6QlEvcndNdWpwNFcyVnd3M3BXbDFKME1LQlpSTXlWbXJXcz0iLCJtYWMiOiI4OGRkZGIzYmRkMmIzYTYxMGZiZmI4ZjgwZWMxMzQ0MGIyMDVhYjNjNzQyNzQ1Yjk0MjllNzI4MmM4NmUxNmEwIiwidGFnIjoiIn0=','192.168.2.101','eyJpdiI6IlZCaUY2bzhvMlBGR0dNb3NMZzVtSUE9PSIsInZhbHVlIjoiNjFwQ2N3OHdZWVNBRHd6cE1QZzUweitKUVZNQ3NBM3BYMFYxTi92ZWd0Zz0iLCJtYWMiOiI3ZTY4MmE3MDQyMmRkYzMyYzg3NjVmOGMxM2YwMjBiNDgwZjZjZmY5MDM0Y2ExOGE3NjgwMjc2NDFmYzk0NzgyIiwidGFnIjoiIn0=','sec_token_eu01_231abe3a85c0627ae3e5123683e8972f','ns3.salieno.com','192.168.2.10','ns4.salieno.com','192.168.2.11',NULL,NULL,NULL,NULL,1,'2025-12-19 15:45:08','2025-12-19 15:45:08',0,100,0),(4,3,'DA-WEB-01','2','da-web-01.salieno.com','https','2222','da-web-01.salieno.com','admin','eyJpdiI6Im9vaHRxZStjWFJ0ZitJcUxaZE9HbVE9PSIsInZhbHVlIjoiY2hWZmFaNWtRdktJejBXNmhTMGxKNGkxSDVCa3pMUFN2Z2d4TC9QSnNUbz0iLCJtYWMiOiI5YzI4N2MxNGM1MWY2NjhhZjU2MGZlNWVkYWU3MzRkM2E1YmNiYmE1ODc5N2FhN2YxZWM0Y2MxMTNjYTY3ZWExIiwidGFnIjoiIn0=','192.168.3.101','eyJpdiI6Im1hdDJ3TDh2TlZNdks1SVhnSkVNSGc9PSIsInZhbHVlIjoidW4xMnZ3bjNaYU1uWDVybWFhak14SmlrbThhazV1TkxMRGpsZ2RsL041Yz0iLCJtYWMiOiIzOTMyNDA2NDZhNWQwYzJlNGY4MWY4N2IzNWMxNGYwMzk0YjgzNWU2NmE5NTIxOWEyMzI4ZGU0MTA1NjA3MmI3IiwidGFnIjoiIn0=','sec_token_da01_6d36e7b6c58e3a00189d4b9028db0f8f','ns1.salieno.com','192.168.1.10','ns2.salieno.com','192.168.1.11',NULL,NULL,NULL,NULL,1,'2025-12-19 15:45:08','2025-12-19 15:45:08',0,100,0),(5,4,'PLESK-WIN-01','3','plesk-win-01.salieno.com','https','8443','plesk-win-01.salieno.com','admin','eyJpdiI6IlE0OWJraStQbHZ5RnQrL0V0QzJtaWc9PSIsInZhbHVlIjoiTlI3YWdsRzBXbU5lNHVIQTZtYUp5V3lpTlh0OXVNN0U3WlZDdXE4VGs0VT0iLCJtYWMiOiIzMDc4ZjhhYWYxMzViYzBkMjY5ZWIyMGM1MWRkNWUwNjY4ODRlNDQxZDUzZmVjNDdkNzFkOWVmNGI4ZTRjYzA2IiwidGFnIjoiIn0=','192.168.4.101','eyJpdiI6Iit6dDd1bGIvRFdFTFVkemJabUlaTkE9PSIsInZhbHVlIjoiNmo2SVQ3aTZmd1R0TmFRTDlwNGhseHdxK09BYmFINzVneU5ZZ04zWEUxOD0iLCJtYWMiOiIzNzhhZjg5ODRmYzcyZTU0NDNlMWNjNDMxMjlmYTI3M2EwZjgyYTQ1ZTEzNTg2NjEzYmYwZjk4YTMyNzI5YWMzIiwidGFnIjoiIn0=','sec_token_plesk01_c9299bbece7fe92db71bc8bf6a8cb33a','ns1.salieno.com','192.168.1.10','ns2.salieno.com','192.168.1.11',NULL,NULL,NULL,NULL,1,'2025-12-19 15:45:08','2025-12-19 15:45:08',0,100,0);
/*!40000 ALTER TABLE `servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `service_categories`
--

DROP TABLE IF EXISTS `service_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `service_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `short_description` text DEFAULT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `long_description` text DEFAULT NULL,
  `banner_image` varchar(500) DEFAULT NULL,
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `meta_keywords` varchar(500) DEFAULT NULL,
  `color` varchar(20) DEFAULT '#6366f1',
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `features` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `page_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `service_categories_status_sort_index` (`status`,`sort_order`),
  KEY `service_categories_page_id_index` (`page_id`),
  CONSTRAINT `service_categories_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `service_categories`
--

LOCK TABLES `service_categories` WRITE;
/*!40000 ALTER TABLE `service_categories` DISABLE KEYS */;
INSERT INTO `service_categories` VALUES (1,'Shared Hosting','shared-hosting','Affordable web hosting solutions for small to medium websites.','ph-cloud',NULL,NULL,NULL,NULL,NULL,'#6366f1',0,1,'2025-12-19 15:45:08','2026-02-13 15:44:22','[\"Websites Hosted\",\"NVME Disk Space\",\"Bandwidth\",\"Email Accounts\",\"Addon Domains\",\"Subdomains\",\"Parked Domains\",\"Free domain registration\",\"Free Website Transfer\",\"Free Daily Backups\",\"Free SSL Certificates\",\"Immediate Account Activation\",\"24\\/7 WordPress Support\",\"Softaculous 1-Click Install\",\"Multiple Server Locations\",\"45 Days MoneyBack Guarantee\"]',18),(2,'Reseller Hosting','reseller-hosting','Start your own hosting business with our reseller packages.','ph-users',NULL,NULL,NULL,NULL,NULL,'#6366f1',0,1,'2025-12-19 15:45:08','2026-02-13 15:44:01','[\"Websites Hosted\",\"NVME Disk Space\",\"Bandwidth\",\"Email Accounts\",\"Addon Domains\",\"Subdomains\",\"Parked Domains\",\"Free domain registration\",\"Free Website Transfer\",\"Free Daily Backups\",\"Free SSL Certificates\",\"Immediate Account Activation\",\"24\\/7 WordPress Support\",\"Softaculous 1-Click Install\",\"Multiple Server Locations\",\"45 Days MoneyBack Guarantee\"]',19),(3,'VPS Hosting','vps-hosting','Virtual private servers with dedicated resources and full root access.','ph-shield-check',NULL,NULL,NULL,NULL,NULL,'#6366f1',0,1,'2025-12-19 15:45:08','2026-02-13 15:44:46','[\"Websites Hosted\",\"NVME Disk Space\",\"Bandwidth\",\"Email Accounts\",\"Addon Domains\",\"Subdomains\",\"Parked Domains\",\"Free domain registration\",\"Free Website Transfer\",\"Free Daily Backups\",\"Free SSL Certificates\",\"Immediate Account Activation\",\"24\\/7 WordPress Support\",\"Softaculous 1-Click Install\",\"Multiple Server Locations\",\"45 Days MoneyBack Guarantee\"]',20),(4,'Dedicated Servers','dedicated-servers','High-performance dedicated servers for enterprise applications.','ph-cpu',NULL,NULL,NULL,NULL,NULL,'#6366f1',0,1,'2025-12-19 15:45:08','2026-02-13 15:43:33','[\"Websites Hosted\",\"NVME Disk Space\",\"Bandwidth\",\"Email Accounts\",\"Addon Domains\",\"Subdomains\",\"Parked Domains\",\"Free domain registration\",\"Free Website Transfer\",\"Free Daily Backups\",\"Free SSL Certificates\",\"Immediate Account Activation\",\"24\\/7 WordPress Support\",\"Softaculous 1-Click Install\",\"Multiple Server Locations\",\"45 Days MoneyBack Guarantee\"]',21),(5,'WordPress Hosting','wordpress-hosting','Optimized hosting specifically designed for WordPress websites.','ph-layout',NULL,NULL,NULL,NULL,NULL,'#6366f1',0,1,'2025-12-19 15:45:08','2026-02-13 15:45:17','[\"Websites Hosted\",\"NVME Disk Space\",\"Bandwidth\",\"Email Accounts\",\"Addon Domains\",\"Subdomains\",\"Parked Domains\",\"Free domain registration\",\"Free Website Transfer\",\"Free Daily Backups\",\"Free SSL Certificates\",\"Immediate Account Activation\",\"24\\/7 WordPress Support\",\"Softaculous 1-Click Install\",\"Multiple Server Locations\",\"45 Days MoneyBack Guarantee\"]',22);
/*!40000 ALTER TABLE `service_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES ('4ZO9cF1pSMlP2Y2tC5S4gMOYZ7Hont3PDoPhjsxD',NULL,'127.0.0.1','Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:147.0) Gecko/20100101 Firefox/147.0','YTo2OntzOjY6Il90b2tlbiI7czo0MDoiQll6aldLdTJZRkpkb2dSZmZFcnhUc2p2THhIQVNxeHpuaklPVklkeSI7czo0OiJsYW5nIjtzOjI6ImVuIjtzOjE0OiJjYXJ0X3JhbmRvbV9pZCI7czozODoiZ3Vlc3RfbVEyNUxlcEJsRHlhc1I1QkN6UUZzbE9oQ0dJek9COW4iO3M6OToiX3ByZXZpb3VzIjthOjI6e3M6MzoidXJsIjtzOjI5OiJodHRwOi8vMTI3LjAuMC4xOjgwMDAvcHJpY2luZyI7czo1OiJyb3V0ZSI7czo3OiJwcmljaW5nIjt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo1MjoibG9naW5fYWRtaW5fNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxO30=',1771846254);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'license_db_marker','7c2eb2504344c39816a27fe3de689ccd9583d89c6764f386df29e15ee979979b',NULL,'2026-02-25 20:41:20');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shopping_carts`
--

DROP TABLE IF EXISTS `shopping_carts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shopping_carts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(64) DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `domain_register_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'When renew domain',
  `hosting_id` bigint(20) unsigned NOT NULL DEFAULT 0 COMMENT 'When renew hosting',
  `product_id` int(10) unsigned NOT NULL DEFAULT 0,
  `domain_setup_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Domain setup / TLD id',
  `coupon_id` int(10) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(4) NOT NULL DEFAULT 1 COMMENT '1=Only Hosting, 2=Hosting+Domain, 3=Only Domain, 4=Domain Renew',
  `id_protection` tinyint(4) NOT NULL DEFAULT 0,
  `reg_period` int(11) NOT NULL DEFAULT 0 COMMENT 'For domain registration years',
  `billing_cycle` tinyint(4) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `hostname` varchar(40) DEFAULT NULL,
  `ns1` varchar(255) DEFAULT NULL,
  `ns2` varchar(255) DEFAULT NULL,
  `ns3` varchar(255) DEFAULT NULL,
  `ns4` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `price` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000 COMMENT 'Basic amount / price',
  `setup_fee` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000 COMMENT 'Additional amount / price',
  `discount_applied` tinyint(4) NOT NULL DEFAULT 0,
  `coupon_type` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Discount type: 0=%, 1=Fixed',
  `coupon_discount` decimal(28,8) NOT NULL DEFAULT 0.00000000 COMMENT 'Discount rate/amount of coupon',
  `discount` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000 COMMENT 'Discount amount',
  `total` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000 COMMENT '(Price + setup)',
  `after_discount` decimal(28,16) NOT NULL DEFAULT 0.0000000000000000,
  `config_options` varchar(255) DEFAULT NULL COMMENT 'For service/hosting configurable options',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shopping_carts_user_id_index` (`user_id`),
  KEY `shopping_carts_product_id_index` (`product_id`),
  KEY `shopping_carts_domain_setup_id_index` (`domain_setup_id`),
  KEY `shopping_carts_session_id_index` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shopping_carts`
--

LOCK TABLES `shopping_carts` WRITE;
/*!40000 ALTER TABLE `shopping_carts` DISABLE KEYS */;
/*!40000 ALTER TABLE `shopping_carts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_links`
--

DROP TABLE IF EXISTS `social_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `platform` varchar(50) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  `url` varchar(500) NOT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `color` varchar(50) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `order` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `social_links_is_active_order_index` (`is_active`,`order`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_links`
--

LOCK TABLES `social_links` WRITE;
/*!40000 ALTER TABLE `social_links` DISABLE KEYS */;
INSERT INTO `social_links` VALUES (7,'twitter','X','https://x.com/salieno','https://upload.wikimedia.org/wikipedia/commons/c/ce/X_logo_2023.svg','#ffffff',1,1,'2026-01-23 17:07:59','2026-01-23 18:41:21'),(8,'facebook','Facebook','https://facebook.com/salieno','https://upload.wikimedia.org/wikipedia/commons/b/b8/2021_Facebook_icon.svg','#ffffff',1,2,'2026-01-23 17:07:59','2026-01-23 18:41:21'),(9,'youtube','YouTube','https://youtube.com/salieno','https://upload.wikimedia.org/wikipedia/commons/0/09/YouTube_full-color_icon_%282017%29.svg','#ffffff',1,3,'2026-01-23 17:07:59','2026-01-23 18:41:21'),(10,'linkedin','LinkedIn','https://linkedin.com/company/salieno','https://upload.wikimedia.org/wikipedia/commons/8/81/LinkedIn_icon.svg','#ffffff',1,4,'2026-01-23 17:07:59','2026-01-23 18:41:21'),(12,'instagram','Instagram','https://instagram.com/salieno','https://upload.wikimedia.org/wikipedia/commons/e/e7/Instagram_logo_2016.svg','#ffffff',1,6,'2026-01-23 17:07:59','2026-01-23 18:41:21');
/*!40000 ALTER TABLE `social_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscribers`
--

DROP TABLE IF EXISTS `subscribers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscribers`
--

LOCK TABLES `subscribers` WRITE;
/*!40000 ALTER TABLE `subscribers` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscribers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `support_attachments`
--

DROP TABLE IF EXISTS `support_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_attachments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `support_message_id` int(10) unsigned NOT NULL DEFAULT 0,
  `attachment` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `support_ticket_id` bigint(20) unsigned DEFAULT NULL,
  `original_name` varchar(255) DEFAULT NULL,
  `mime_type` varchar(255) DEFAULT NULL,
  `file_size` bigint(20) DEFAULT NULL,
  `thumbnail` varchar(255) DEFAULT NULL,
  `download_count` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `support_attachments_support_ticket_id_index` (`support_ticket_id`),
  CONSTRAINT `support_attachments_support_ticket_id_foreign` FOREIGN KEY (`support_ticket_id`) REFERENCES `support_tickets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `support_attachments`
--

LOCK TABLES `support_attachments` WRITE;
/*!40000 ALTER TABLE `support_attachments` DISABLE KEYS */;
INSERT INTO `support_attachments` VALUES (1,12,'COSSDyQmzvp6GDC36r1QI8EAHOLSH2kcvIBp2jJf.png','2026-02-21 12:57:36','2026-02-21 12:57:36',6,'Screenshot 2026-02-21 at 02-43-23 Dashboard Salieno.png','application/octet-stream',91677,NULL,0);
/*!40000 ALTER TABLE `support_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `support_messages`
--

DROP TABLE IF EXISTS `support_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `support_ticket_id` int(10) unsigned NOT NULL DEFAULT 0,
  `admin_id` bigint(20) unsigned DEFAULT NULL,
  `message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `is_internal_note` tinyint(1) NOT NULL DEFAULT 0,
  `is_auto_reply` tinyint(1) NOT NULL DEFAULT 0,
  `canned_response_id` bigint(20) unsigned DEFAULT NULL,
  `signature` text DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `support_messages_user_id_foreign` (`user_id`),
  KEY `support_messages_canned_response_id_foreign` (`canned_response_id`),
  KEY `support_messages_support_ticket_id_is_internal_note_index` (`support_ticket_id`,`is_internal_note`),
  KEY `support_messages_support_ticket_id_created_at_index` (`support_ticket_id`,`created_at`),
  CONSTRAINT `support_messages_canned_response_id_foreign` FOREIGN KEY (`canned_response_id`) REFERENCES `canned_responses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_messages_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `support_messages`
--

LOCK TABLES `support_messages` WRITE;
/*!40000 ALTER TABLE `support_messages` DISABLE KEYS */;
INSERT INTO `support_messages` VALUES (1,6,NULL,'hi suport team','2026-02-21 12:39:05','2026-02-21 12:39:05',NULL,0,0,NULL,NULL,NULL,NULL),(2,6,1,'We haven\'t heard back from you regarding this ticket.\n\nAs we haven\'t received a response, we will be closing this ticket. If you still need assistance, please feel free to open a new ticket or reply to this one to reopen it.\n\nThank you for choosing us!\n\nBest regards,\nSupport Team','2026-02-21 12:40:01','2026-02-21 12:40:01',NULL,0,0,NULL,NULL,NULL,NULL),(4,6,NULL,'okay sir','2026-02-21 12:46:02','2026-02-21 12:46:02',NULL,0,0,NULL,NULL,NULL,NULL),(5,6,1,'Please try clearing your browser cache and cookies:\n\n1. Press Ctrl + Shift + Delete (Cmd + Shift + Delete on Mac)\n2. Select \'All time\' for the time range\n3. Check \'Cached images and files\' and \'Cookies\'\n4. Click \'Clear data\'\n5. Refresh the page and try again\n\nIf the issue persists, please let us know.\n\nBest regards,\nSupport Team','2026-02-21 12:46:19','2026-02-21 12:46:19',NULL,0,0,NULL,NULL,NULL,NULL),(6,6,NULL,'so what','2026-02-21 12:51:47','2026-02-21 12:51:47',NULL,0,0,NULL,NULL,NULL,NULL),(7,6,1,'about what my client\n','2026-02-21 12:52:09','2026-02-21 12:52:09',NULL,0,0,NULL,NULL,NULL,NULL),(8,6,NULL,'mhm','2026-02-21 12:52:21','2026-02-21 12:52:21',NULL,0,0,NULL,NULL,NULL,NULL),(9,6,1,'Great news! The issue you reported has been resolved.\n\nPlease verify that everything is working correctly on your end. If you encounter any further issues or have additional questions, don\'t hesitate to reach out.\n\nWe appreciate your patience and understanding.\n\nBest regards,\nSupport Team','2026-02-21 12:52:46','2026-02-21 12:52:46',NULL,0,0,NULL,NULL,NULL,NULL),(12,6,NULL,'check it','2026-02-21 12:57:36','2026-02-21 12:57:36',NULL,0,0,NULL,NULL,NULL,NULL),(13,6,NULL,'hi, how are u doing today','2026-02-22 05:57:15','2026-02-22 05:57:15',NULL,0,0,NULL,NULL,NULL,NULL),(14,6,1,'Please try clearing your browser cache and cookies:\n\n1. Press Ctrl + Shift + Delete (Cmd + Shift + Delete on Mac)\n2. Select \'All time\' for the time range\n3. Check \'Cached images and files\' and \'Cookies\'\n4. Click \'Clear data\'\n5. Refresh the page and try again\n\nIf the issue persists, please let us know.\n\nBest regards,\nSupport Team','2026-02-22 05:59:53','2026-02-22 05:59:53',NULL,0,0,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `support_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `support_tickets`
--

DROP TABLE IF EXISTS `support_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `support_tickets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(40) DEFAULT NULL,
  `email` varchar(40) DEFAULT NULL,
  `ticket` varchar(255) DEFAULT NULL COMMENT 'Ticket number',
  `subject` varchar(255) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0=> Open, 1=> Answered, 2=> Customer Reply, 3=> Closed',
  `priority` tinyint(4) NOT NULL DEFAULT 2,
  `last_reply` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `hosting_id` bigint(20) unsigned DEFAULT NULL,
  `domain_id` bigint(20) unsigned DEFAULT NULL,
  `assigned_to` bigint(20) unsigned DEFAULT NULL,
  `first_response_at` timestamp NULL DEFAULT NULL,
  `resolved_at` timestamp NULL DEFAULT NULL,
  `closed_at` timestamp NULL DEFAULT NULL,
  `sla_response_due_at` timestamp NULL DEFAULT NULL,
  `sla_resolution_due_at` timestamp NULL DEFAULT NULL,
  `sla_response_breached` tinyint(1) NOT NULL DEFAULT 0,
  `sla_resolution_breached` tinyint(1) NOT NULL DEFAULT 0,
  `escalated_at` timestamp NULL DEFAULT NULL,
  `escalation_level` tinyint(4) NOT NULL DEFAULT 0,
  `satisfaction_rating` tinyint(4) DEFAULT NULL COMMENT '1-5 stars',
  `satisfaction_comment` text DEFAULT NULL,
  `rated_at` timestamp NULL DEFAULT NULL,
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `custom_fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  `source` varchar(255) NOT NULL DEFAULT 'web' COMMENT 'web, email, api, admin',
  `reply_count` int(11) NOT NULL DEFAULT 0,
  `internal_note_count` int(11) NOT NULL DEFAULT 0,
  `last_customer_reply_at` timestamp NULL DEFAULT NULL,
  `last_staff_reply_at` timestamp NULL DEFAULT NULL,
  `auto_close_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `support_tickets_hosting_id_foreign` (`hosting_id`),
  KEY `support_tickets_domain_id_foreign` (`domain_id`),
  KEY `support_tickets_status_priority_index` (`status`,`priority`),
  KEY `support_tickets_assigned_to_status_index` (`assigned_to`,`status`),
  KEY `support_tickets_category_id_status_index` (`category_id`,`status`),
  KEY `support_tickets_sla_response_due_at_index` (`sla_response_due_at`),
  KEY `support_tickets_sla_resolution_due_at_index` (`sla_resolution_due_at`),
  KEY `support_tickets_auto_close_at_index` (`auto_close_at`),
  KEY `idx_support_tickets_status_priority` (`status`,`priority`),
  KEY `idx_support_tickets_user_status` (`user_id`,`status`),
  KEY `idx_support_tickets_created_at` (`created_at`),
  CONSTRAINT `support_tickets_assigned_to_foreign` FOREIGN KEY (`assigned_to`) REFERENCES `admins` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `ticket_categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_domain_id_foreign` FOREIGN KEY (`domain_id`) REFERENCES `domains` (`id`) ON DELETE SET NULL,
  CONSTRAINT `support_tickets_hosting_id_foreign` FOREIGN KEY (`hosting_id`) REFERENCES `hostings` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `support_tickets`
--

LOCK TABLES `support_tickets` WRITE;
/*!40000 ALTER TABLE `support_tickets` DISABLE KEYS */;
INSERT INTO `support_tickets` VALUES (5,0,'Test User','test@example.com','JE0-28476','Test Subject',0,2,NULL,'2026-02-20 22:54:26','2026-02-20 22:54:26',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'web',0,0,NULL,NULL,NULL),(6,9,'NICK DOMINICK','mpanduji.dominicK@gmail.com','474909','hello',0,2,'2026-02-22 08:59:53','2026-02-21 12:39:05','2026-02-22 07:31:46',1,NULL,NULL,NULL,NULL,'2026-02-21 12:51:07','2026-02-21 12:51:15','2026-02-21 16:39:05','2026-02-23 12:39:05',1,0,'2026-02-21 12:50:12',17,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'web',0,0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `support_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `system_registrations`
--

DROP TABLE IF EXISTS `system_registrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system_registrations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `installation_hash` varchar(64) NOT NULL,
  `activated_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `first_failure_at` timestamp NULL DEFAULT NULL,
  `grace_period_ends_at` timestamp NULL DEFAULT NULL,
  `degradation_stage` int(11) NOT NULL DEFAULT 0,
  `secret_key` varchar(64) DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `system_registrations_installation_hash_unique` (`installation_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `system_registrations`
--

LOCK TABLES `system_registrations` WRITE;
/*!40000 ALTER TABLE `system_registrations` DISABLE KEYS */;
/*!40000 ALTER TABLE `system_registrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ticket_categories`
--

DROP TABLE IF EXISTS `ticket_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ticket_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT 'ph-duotone ph-folder',
  `color` varchar(255) DEFAULT '#6366f1',
  `order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `requires_service` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Require user to select a service',
  `default_priority` tinyint(4) NOT NULL DEFAULT 2 COMMENT '1=Low, 2=Medium, 3=High, 4=Critical',
  `sla_response_hours` int(11) DEFAULT NULL COMMENT 'Hours to first response',
  `sla_resolution_hours` int(11) DEFAULT NULL COMMENT 'Hours to resolution',
  `auto_assign_admin_id` bigint(20) unsigned DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ticket_categories_slug_unique` (`slug`),
  KEY `ticket_categories_auto_assign_admin_id_foreign` (`auto_assign_admin_id`),
  KEY `ticket_categories_is_active_order_index` (`is_active`,`order`),
  CONSTRAINT `ticket_categories_auto_assign_admin_id_foreign` FOREIGN KEY (`auto_assign_admin_id`) REFERENCES `admins` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ticket_categories`
--

LOCK TABLES `ticket_categories` WRITE;
/*!40000 ALTER TABLE `ticket_categories` DISABLE KEYS */;
INSERT INTO `ticket_categories` VALUES (1,'General Support','general-supportgeneral-support',NULL,'ph-folderph-folder','indigo',1,1,0,2,NULL,NULL,NULL,NULL,'2026-01-27 01:27:09','2026-01-27 01:27:09');
/*!40000 ALTER TABLE `ticket_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `amount` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `charge` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `post_balance` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `trx_type` varchar(40) DEFAULT NULL COMMENT '+ or -',
  `trx` varchar(40) DEFAULT NULL COMMENT 'Transaction ID',
  `details` varchar(255) DEFAULT NULL,
  `remark` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_transactions_user_created` (`user_id`,`created_at`),
  KEY `idx_transactions_trx_type` (`trx_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `update_logs`
--

DROP TABLE IF EXISTS `update_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `update_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(40) DEFAULT NULL,
  `update_log` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `update_logs`
--

LOCK TABLES `update_logs` WRITE;
/*!40000 ALTER TABLE `update_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `update_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_logins`
--

DROP TABLE IF EXISTS `user_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_logins` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `user_ip` varchar(40) DEFAULT NULL,
  `city` varchar(40) DEFAULT NULL,
  `country` varchar(40) DEFAULT NULL,
  `country_code` varchar(40) DEFAULT NULL,
  `longitude` varchar(40) DEFAULT NULL,
  `latitude` varchar(40) DEFAULT NULL,
  `browser` varchar(40) DEFAULT NULL,
  `os` varchar(40) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_logins`
--

LOCK TABLES `user_logins` WRITE;
/*!40000 ALTER TABLE `user_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_notifications`
--

DROP TABLE IF EXISTS `user_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `type` varchar(50) NOT NULL DEFAULT 'system',
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `action_url` varchar(255) DEFAULT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_notifications_user_id_read_at_index` (`user_id`,`read_at`),
  KEY `user_notifications_type_index` (`type`),
  CONSTRAINT `user_notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_notifications`
--

LOCK TABLES `user_notifications` WRITE;
/*!40000 ALTER TABLE `user_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(40) DEFAULT NULL,
  `lastname` varchar(40) DEFAULT NULL,
  `username` varchar(40) DEFAULT NULL,
  `email` varchar(40) NOT NULL,
  `dial_code` varchar(40) DEFAULT NULL,
  `country_code` varchar(40) DEFAULT NULL,
  `mobile` varchar(40) DEFAULT NULL,
  `ref_by` int(10) unsigned NOT NULL DEFAULT 0,
  `balance` decimal(28,8) NOT NULL DEFAULT 0.00000000,
  `password` varchar(255) NOT NULL,
  `country_name` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0: banned, 1: active',
  `kyc_data` text DEFAULT NULL,
  `kyc_rejection_reason` varchar(255) DEFAULT NULL,
  `kv` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0: KYC Unverified, 2: KYC pending, 1: KYC verified',
  `ev` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0: email unverified, 1: email verified',
  `sv` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0: mobile unverified, 1: mobile verified',
  `profile_complete` tinyint(1) NOT NULL DEFAULT 0,
  `ver_code` varchar(40) DEFAULT NULL COMMENT 'stores verification code',
  `ver_code_send_at` datetime DEFAULT NULL COMMENT 'verification send time',
  `ts` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0: 2fa off, 1: 2fa on',
  `tv` tinyint(1) NOT NULL DEFAULT 1 COMMENT '0: 2fa unverified, 1: 2fa verified',
  `tsc` varchar(255) DEFAULT NULL,
  `ban_reason` varchar(255) DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `provider` varchar(40) DEFAULT NULL,
  `provider_id` varchar(255) DEFAULT NULL,
  `google_id` varchar(255) DEFAULT NULL,
  `facebook_id` varchar(255) DEFAULT NULL,
  `linkedin_id` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `auto_pay_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `default_payment_method_id` bigint(20) unsigned DEFAULT NULL,
  `kyc_submitted_at` timestamp NULL DEFAULT NULL,
  `kyc_verified_at` timestamp NULL DEFAULT NULL,
  `kyc_reviewed_by` bigint(20) unsigned DEFAULT NULL,
  `kyc_level` tinyint(4) NOT NULL DEFAULT 0 COMMENT '0: none, 1: basic, 2: enhanced, 3: premium',
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_email_unique` (`username`,`email`),
  KEY `users_google_id_index` (`google_id`),
  KEY `users_facebook_id_index` (`facebook_id`),
  KEY `users_linkedin_id_index` (`linkedin_id`),
  KEY `idx_users_email` (`email`),
  KEY `idx_users_status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-02-26  2:56:24
