<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRedis;

class RegionalCertChain extends \Google\Collection
{
  protected $collection_key = 'certificates';
  /**
   * The certificates that form the CA chain, from leaf to root order.
   *
   * @var string[]
   */
  public $certificates;

  /**
   * The certificates that form the CA chain, from leaf to root order.
   *
   * @param string[] $certificates
   */
  public function setCertificates($certificates)
  {
    $this->certificates = $certificates;
  }
  /**
   * @return string[]
   */
  public function getCertificates()
  {
    return $this->certificates;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RegionalCertChain::class, 'Google_Service_CloudRedis_RegionalCertChain');
