<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Serverless
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\Serverless\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Stream;
use Twilio\Values;
use Twilio\Version;
use Twilio\Http\Response;
use Twilio\Metadata\ArrayMetadata;
use Twilio\Metadata\PageMetadata;
use Twilio\Metadata\ResourceMetadata;
use Twilio\Metadata\StreamMetadata;
use Twilio\Serialize;


class ServiceList extends ListResource
    {
    /**
     * Construct the ServiceList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(
        Version $version
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        ];

        $this->uri = '/Services';
    }

    /**
     * Helper function for Create
     *
     * @param string $uniqueName A user-defined string that uniquely identifies the Service resource. It can be used as an alternative to the `sid` in the URL path to address the Service resource. This value must be 50 characters or less in length and be unique.
     * @param string $friendlyName A descriptive string that you create to describe the Service resource. It can be a maximum of 255 characters.
     * @param array|Options $options Optional Arguments
     * @return Response Created Response
     * @throws TwilioException When an HTTP error occurs.
     */
    private function _create(string $uniqueName, string $friendlyName, array $options = []): Response
    {
        $options = new Values($options);

        $data = Values::of([
            'UniqueName' =>
                $uniqueName,
            'FriendlyName' =>
                $friendlyName,
            'IncludeCredentials' =>
                Serialize::booleanToString($options['includeCredentials']),
            'UiEditable' =>
                Serialize::booleanToString($options['uiEditable']),
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json' ]);
        return $this->version->handleRequest('POST', $this->uri, [], $data, $headers, "create");
    }

    /**
     * Create the ServiceInstance
     *
     * @param string $uniqueName A user-defined string that uniquely identifies the Service resource. It can be used as an alternative to the `sid` in the URL path to address the Service resource. This value must be 50 characters or less in length and be unique.
     * @param string $friendlyName A descriptive string that you create to describe the Service resource. It can be a maximum of 255 characters.
     * @param array|Options $options Optional Arguments
     * @return ServiceInstance Created ServiceInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $uniqueName, string $friendlyName, array $options = []): ServiceInstance
    {
        $response = $this->_create( $uniqueName,  $friendlyName, $options);
        return new ServiceInstance(
            $this->version,
            $response->getContent()
        );
        
    }

    /**
     * Create the ServiceInstance with Metadata
     *
     * @param string $uniqueName A user-defined string that uniquely identifies the Service resource. It can be used as an alternative to the `sid` in the URL path to address the Service resource. This value must be 50 characters or less in length and be unique.
     * @param string $friendlyName A descriptive string that you create to describe the Service resource. It can be a maximum of 255 characters.
     * @param array|Options $options Optional Arguments
     * @return ResourceMetadata The Created Resource with Metadata
     * @throws TwilioException When an HTTP error occurs.
     */
    public function createWithMetadata(string $uniqueName, string $friendlyName, array $options = []): ResourceMetadata
    {
        $response = $this->_create( $uniqueName,  $friendlyName, $options);
        $resource = new ServiceInstance(
                        $this->version,
                        $response->getContent()
                    );
        return new ResourceMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }


    /**
     * Reads ServiceInstance records from the API as a list.
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ServiceInstance[] Array of results
     */
    public function read(?int $limit = null, $pageSize = null): array
    {
        return \iterator_to_array($this->stream($limit, $pageSize), false);
    }

    /**
     * Reads ServiceInstance records from the API as a list
     * Unlike stream(), this operation is eager and will load `limit` records into
     * memory before returning.
     *
     * @param int $limit Upper limit for the number of records to return. read()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, read()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return ArrayMetadata Array of results along with metadata
     */
    public function readWithMetadata(?int $limit = null, $pageSize = null): ArrayMetadata
    {
        $streamWithMetadata = $this->streamWithMetadata($limit, $pageSize);
        $readResponse = \iterator_to_array($streamWithMetadata, false);
        return new ArrayMetadata(
            $readResponse,
            $streamWithMetadata->getStatusCode(),
            $streamWithMetadata->getHeaders()
        );
    }

    /**
     * Streams ServiceInstance records from the API as a generator stream.
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return Stream stream of results
     */
    public function stream(?int $limit = null, $pageSize = null): Stream
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $page = $this->page($limits['pageSize']);

        return $this->version->stream($page, $limits['limit'], $limits['pageLimit']);
    }

    /**
     * Streams ServiceInstance records from the API as a generator stream and returns result with Metadata
     * This operation lazily loads records as efficiently as possible until the
     * limit
     * is reached.
     * The results are returned as a generator, so this operation is memory
     * efficient.
     *
     * @param int $limit Upper limit for the number of records to return. stream()
     *                   guarantees to never return more than limit.  Default is no
     *                   limit
     * @param mixed $pageSize Number of records to fetch per request, when not set
     *                        will use the default value of 50 records.  If no
     *                        page_size is defined but a limit is defined, stream()
     *                        will attempt to read the limit with the most
     *                        efficient page size, i.e. min(limit, 1000)
     * @return StreamMetadata stream of results with metadata
     */
    public function streamWithMetadata(?int $limit = null, $pageSize = null): StreamMetadata
    {
        $limits = $this->version->readLimits($limit, $pageSize);

        $pageWithMetadata = $this->pageWithMetadata($limits['pageSize']);

        $stream = $this->version->stream($pageWithMetadata->getPage(), $limits['limit'], $limits['pageLimit']);

        return new StreamMetadata(
            $stream,
            $pageWithMetadata->getStatusCode(),
            $pageWithMetadata->getHeaders()
        );
    }

    /**
     * Helper function for Page
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return Response Paged Response
     */
    private function _page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): Response
    {

        $params = Values::of([
            'PageToken' => $pageToken,
            'Page' => $pageNumber,
            'PageSize' => $pageSize,
        ]);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded', 'Accept' => 'application/json']);
        return $this->version->page('GET', $this->uri, $params, [], $headers);
    }

    /**
     * Retrieve a single page of ServiceInstance records from the API.
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return ServicePage Page of ServiceInstance
     */
    public function page(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): ServicePage
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        return new ServicePage($this->version, $response, $this->solution);
    }

    /**
     * Retrieve a single page of ServiceInstance records with metadata
     * Request is executed immediately
     *
     * @param mixed $pageSize Number of records to return, defaults to 50
     * @param string $pageToken PageToken provided by the API
     * @param mixed $pageNumber Page Number, this value is simply for client state
     * @return PageMetadata of ServiceInstance
     */
    public function pageWithMetadata(
        $pageSize = Values::NONE,
        string $pageToken = Values::NONE,
        $pageNumber = Values::NONE
    ): PageMetadata
    {
        $response = $this->_page( $pageSize, $pageToken, $pageNumber);

        $resource =  new ServicePage($this->version, $response, $this->solution);

        return new PageMetadata(
            $resource,
            $response->getStatusCode(),
            $response->getHeaders()
        );
    }

    /**
     * Retrieve a specific page of ServiceInstance records from the API.
     * Request is executed immediately
     *
     * @param string $targetUrl API-generated URL for the requested results page
     * @return ServicePage Page of ServiceInstance
     */
    public function getPage(string $targetUrl): ServicePage
    {
        $response = $this->version->getDomain()->getClient()->request(
            'GET',
            $targetUrl
        );

        return new ServicePage($this->version, $response, $this->solution);
    }


    /**
     * Constructs a ServiceContext
     *
     * @param string $sid The `sid` or `unique_name` of the Service resource to delete.
     */
    public function getContext(
        string $sid
        
    ): ServiceContext
    {
        return new ServiceContext(
            $this->version,
            $sid
        );
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Serverless.V1.ServiceList]';
    }
}
