import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import { glob } from 'glob';

// Dynamically find template entry points (now supporting custom filenames like novahost.css)
const templateAssets = glob.sync('resources/views/templates/*/assets/{css,js}/*.{css,js}');

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/css/admin.css',
                'resources/css/client-area.css',
                'resources/css/installer.css',
                'resources/js/app.js',
                'resources/js/client-area.js',
                ...templateAssets,
            ],
            refresh: true,
        }),
        tailwindcss(),
    ],
    server: {
        host: '0.0.0.0',
        cors: true,
        hmr: {
            host: 'https://salieno.test/',
        },
    },
    build: {
        minify: 'esbuild',
        cssCodeSplit: true,
        sourcemap: 'hidden',
        assetsInlineLimit: 4096,
        chunkSizeWarningLimit: 500,
    },
});
